<main class="page-content">

    <div class="card">

        <div class="card-header py-3">
            <div class="row align-items-center m-0">
                <div class="col-md-4 col-12 me-auto mb-md-0 mb-3">
                     <a href="<?= base_url('admin/pb_user_form/') ?>">
                        <button type="button" class="btn btn-outline-primary radius-30">Add Applicant</button>
                    </a> 
                   <!-- <button type="button" class="btn btn-outline-primary radius-30" data-bs-toggle="modal" data-bs-target="#applicantFormModal">Add Applicant</button>-->
                </div>
            </div>
        </div>

        <div class="card-body">
            <form id="filterForm" action="<?php echo base_url('admin/manage_pb_users_nonverified'); ?>" method="post">
                <div class="row">
                    <div class="col-md-2 mb-3">
                        <label for="start_date">Start Date:</label>
                        <input class="form-control" type="date" id="start_date" name="start_date" value="<?php echo isset($_POST['start_date']) ? $_POST['start_date'] : ''; ?>">
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="end_date">End Date:</label>
                        <input class="form-control" type="date" id="end_date" name="end_date" value="<?php echo isset($_POST['end_date']) ? $_POST['end_date'] : ''; ?>">
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="branch">Branch</label>
                        <select class="single-select" id="branch" name="branch">
                            <option value="">Select Branch</option>
                            <?php foreach ($branch as $branchItem) : ?>
                                <option value="<?= $branchItem['id']; ?>" <?php echo isset($_POST['branch']) && $_POST['branch'] === $branchItem['id'] ? 'selected' : ''; ?>><?= $branchItem['branch_name']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <?php if($_SESSION['staff_type']==0){ ?>
                    <div class="col-md-2 mb-3">
                        <label for="connector">Partner</label>
                        <select class="single-select" id="connector" name="connector">
                            <option value="">Select Partner</option>
                            <?php foreach ($connector as $connectorItem) : ?>
                                <option value="<?= $connectorItem['staff_id']; ?>" <?php echo isset($_POST['connector']) && $_POST['connector'] === $connectorItem['staff_id'] ? 'selected' : ''; ?>><?= $connectorItem['staff_fullname']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <?php } ?>

                    <div class="col-md-2 mb-3">
                        <label for="status">Status</label>
                        <select name="status" id="status" class="form-control">
                            <option value="">--Select--</option>
                            <option value="Login Case" <?php echo isset($_POST['status']) && $_POST['status'] === 'Login Case' ? 'selected' : ''; ?>>Login Case</option>
                            <option value="Disb Case" <?php echo isset($_POST['status']) && $_POST['status'] === 'Disb Case' ? 'selected' : ''; ?>>Disb Case</option>
                            <option value="Sanction" <?php echo isset($_POST['status']) && $_POST['status'] === 'Sanction' ? 'selected' : ''; ?>>Sanction</option>
                            <option value="Reject" <?php echo isset($_POST['status']) && $_POST['status'] === 'Reject' ? 'selected' : ''; ?>>Reject</option>
                        </select>
                    </div>
                    
                    <div class="col-md-2 mb-3">
                        <label for="hlc_status">Payment Partner Status</label>
                        <select name="hlc_status[]" id="hlc_status" class="multiple-select select2-hidden-accessible" multiple data-placeholder="--Select--">
                           
                            <option value="paid" <?php echo (isset($_POST['hlc_status']) && in_array('paid', $_POST['hlc_status'])) ? 'selected' : ''; ?>>Paid</option>
                            <option value="unpaid" <?php echo (isset($_POST['hlc_status']) && in_array('unpaid', $_POST['hlc_status'])) ? 'selected' : ''; ?>>Unpaid</option>
                            <option value="partly paid" <?php echo (isset($_POST['hlc_status']) && in_array('partly paid', $_POST['hlc_status'])) ? 'selected' : ''; ?>>Partly Paid</option>
                            <option value="excess paid" <?php echo (isset($_POST['hlc_status']) && in_array('excess paid', $_POST['hlc_status'])) ? 'selected' : ''; ?>>Excess paid</option>
                        </select>
                    </div>
                    
                    <!--
                    <div class="col-md-2 mb-3">
                        <label for="hlc_status">Payment Partner Status</label>
                        <select name="hlc_status" id="hlc_status" class="form-control">
                            <option value="">--Select--</option>
                            <option value="paid" <?php echo isset($_POST['hlc_status']) && $_POST['hlc_status'] === 'paid' ? 'selected' : ''; ?>>Paid</option>
                            <option value="unpaid" <?php echo isset($_POST['hlc_status']) && $_POST['hlc_status'] === 'unpaid' ? 'selected' : ''; ?>>Unpaid</option>
                            <option value="partly paid" <?php echo isset($_POST['hlc_status']) && $_POST['hlc_status'] === 'partly paid' ? 'selected' : ''; ?>>Partly Paid</option>
                            <option value="excess paid" <?php echo isset($_POST['hlc_status']) && $_POST['hlc_status'] === 'excess paid' ? 'selected' : ''; ?>>Excess paid</option>
                        </select>
                    </div>-->
                    <div class="col-md-2 mb-3">
                        <label for="partner_generated">Partner Generated</label>
                        <select name="partner_generated" id="partner_generated" class="form-control">
                            <option value="">--Select--</option>
                            <option value="Yes" <?php echo isset($_POST['partner_generated']) && $_POST['partner_generated'] === 'Yes' ? 'selected' : ''; ?>>Yes</option>
                            <option value="No" <?php echo isset($_POST['partner_generated']) && $_POST['partner_generated'] === 'No' ? 'selected' : ''; ?>>No</option>
                        </select>
                    </div>
                    <?php if($_SESSION['staff_type']==0){ ?>
                    <!--<div class="col-md-2 mb-3">
                        <label for="branch_generated">Branch Generated</label>
                        <select name="branch_generated" id="branch_generated" class="form-control">
                            <option value="">--Select--</option>
                            <option value="Yes" <?php echo isset($_POST['branch_generated']) && $_POST['branch_generated'] === 'Yes' ? 'selected' : ''; ?>>Yes</option>
                            <option value="No" <?php echo isset($_POST['branch_generated']) && $_POST['branch_generated'] === 'No' ? 'selected' : ''; ?>>No</option>
                        </select>
                    </div>
                     <div class="col-md-2 mb-3">
                        <label for="sbi_generated">SBI Generated</label>
                        <select name="sbi_generated" id="sbi_generated" class="form-control">
                            <option value="">--Select--</option>
                            <option value="Yes" <?php echo isset($_POST['sbi_generated']) && $_POST['sbi_generated'] === 'Yes' ? 'selected' : ''; ?>>Yes</option>
                            <option value="No" <?php echo isset($_POST['sbi_generated']) && $_POST['sbi_generated'] === 'No' ? 'selected' : ''; ?>>No</option>
                        </select>
                    </div>-->
                  <!--  <div class="col-md-2 mb-3">
                        <label for="sbi_payment_status">Payment SBI Status</label>
                        <select name="sbi_payment_status" id="sbi_payment_status" class="form-control">
                            <option value="">--Select--</option>
                            <option value="paid" <?php echo isset($_POST['sbi_payment_status']) && $_POST['sbi_payment_status'] === 'paid' ? 'selected' : ''; ?>>Paid</option>
                            <option value="unpaid" <?php echo isset($_POST['sbi_payment_status']) && $_POST['sbi_payment_status'] === 'unpaid' ? 'selected' : ''; ?>>Unpaid</option>
                            <option value="partly paid" <?php echo isset($_POST['sbi_payment_status']) && $_POST['sbi_payment_status'] === 'partly paid' ? 'selected' : ''; ?>>Partly Paid</option>
                            <option value="excess paid" <?php echo isset($_POST['sbi_payment_status']) && $_POST['sbi_payment_status'] === 'excess paid' ? 'selected' : ''; ?>>Excess paid</option>
                        </select>
                    </div>-->
                    <?php } ?>

                    <div class="col-md-2 mb-3">
                        <label for="state_id">State</label>
                        <select name="state_id" id="state_id" class="single-select">
                            <option value="">-Select-</option>
                            <?php foreach ($state as $value) { ?>
                                <option value="<?= $value['id']; ?>" <?php echo isset($_POST['state_id']) && $_POST['state_id'] === $value['id'] ? 'selected' : ''; ?>><?= $value['state_name']; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="city_id">City</label>
                        <select name="city_id[]" id="city_id" class="single-select" multiple>
                            <option value="">-Select-</option>
                        </select>
                    </div>
                    <!--
                    <div class="col-md-2 mb-3">
                        <label for="city_id">City</label>
                        <select name="city_id" id="city_id" class="single-select">
                            <option value="">-Select-</option>
                        </select>
                    </div>
                    -->
                    <div class="col-md-2 mb-3">
                        <label for="month">Month</label>
                        <input type="month" name="month" id="month" class="form-control" value="<?php echo isset($_POST['month']) ? $_POST['month'] : ''; ?>">
                    </div>

                    <div class="col-md-3 mb-3">
                        <br>
                        <button type="button" class="btn btn-success" id="filterSubmit">Filter</button>
                        <button class="btn btn-info" type="button" id="resetButton">Reset</button>
                    </div>
                </div>
            </form>
           
            <div class="table-responsive">
                <table class="table align-middle table-striped" id="userTable">
                     <thead>
                        <tr>
                            <th>Sr.No</th>
                            <th>Partner Name</th>
                            <th>Partner Code</th>
                            <th>Applicant Name</th>
                            <th>State</th>
                            <th>City</th>
                            <th>RLMS ID</th>
                            <th>CBS Account No</th>
                            <th>Branch Name</th>
                            <th>RBO</th>
                            <th>Loan Type</th>
                            <th>Sanction Loan Amt</th>
                            <th>Partner Payout %</th>
                            <th>Partner Payout Amt</th>
                         <!--   <th>SBI %</th>
                            <th>SBI Commi. Amt</th>
                            <th>SBI 10%</th>
                            <th>SBI 90% Commi</th>-->
                            <th>Disb Date</th>
                            <th>Status</th>
                            <th>Partner Generated</th>
                            <th>Partner Payment Status</th>
                          <!--  <th>Branch Generated</th>-->
                          <!--  <th>SBI Generated</th>
                            <th>SBI Payment Status</th>-->
                            <th>Add Date</th>
                            <th>Created By</th>
                            <th>Verify</th>
                            <th>Verified By</th>
                            <th>Remark</th>
                            <th>Appraisal</th>
                           <!-- <th>FSL</th>-->
                            <th>Proof Disb</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>          
                             
                   </tbody>
                  
                </div>
  </div>
</main>

<script>
$(document).ready(function () {
    var staffType = <?php echo $_SESSION['staff_type']; ?>;
    var staffId = <?php echo $_SESSION['staff_id']; ?>;
    var columns = [
        { "data": "sr_no" },        
        { "data": "hlc_name", "visible": (staffType == 0) },
        { "data": "hlc_code", "visible": (staffType == 0) },
        { "data": "applicant_name" },
        { "data": "state" },
        { "data": "city" },
        { "data": "rlms_id" },
        { "data": "cbs_account_no" },
        { "data": "branch_name" },
        { "data": "rbo" },
        { "data": "loan_type" },
        { "data": "sanction_loan_amt" },
        { "data": "conn_commision", "visible": (staffId == 1 || staffId == 14) },
        { "data": "conn_payout_amt", "visible": (staffId == 1 || staffId == 14) },
       /* { "data": "sbi_payout", "visible": (staffId == 1 || staffId == 14) },
        { "data": "sbi_commi_amt", "visible": (staffId == 1 || staffId == 14) },
        { "data": "sbi_ten_per", "visible": (staffId == 1 || staffId == 14) },
        { "data": "sbi_ninety_per", "visible": (staffId == 1 || staffId == 14) },*/
        { "data": "disb_date" },
        { "data": "status" },
        { "data": "hlc_generated" },
        { "data": "hlc_payment_status" },
      /*  { "data": "branch_generated", "visible": (staffType == 0) },*/
       /* { "data": "sbi_generated", "visible": (staffType == 0) },
        { "data": "sbi_payment_status", "visible": (staffType == 0) },*/
        { "data": "add_date" },
        { "data": "created_by", "visible": (staffId == 14) },
        { "data": "is_verify", "visible": (staffId == 13 || staffId == 28 || staffId == 538 || staffId == 651 || staffId == 889) },
        { "data": "verify_by", "visible": (staffId == 498 || staffId == 1 || staffId == 14 || staffId == 194 || staffId == 13 || staffId == 889 || staffId == 28 || staffId == 12 || staffId == 538)},
        { "data": "remark", "orderable": false },
        { "data": "appraisal_letter", "exportable": true },       
        /*{ "data": "final_sanction_letter", "exportable": true }, */      
        { "data": "proof_disb", "exportable": true },       
        { "data": "edit" }
    ];

    var table = $('#userTable').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?php echo base_url('admin/fetch_pb_user_nonverified'); ?>",
            "type": "POST",
            "data": function (d) {
                d.start_date = $('#start_date').val();
                d.end_date = $('#end_date').val();
                d.status = $('#status').val();
                d.connector = $('#connector').val();
                d.branch = $('#branch').val();
                d.hlc_status = $('#hlc_status').val();
                d.sbi_payment_status = $('#sbi_payment_status').val();
                d.state_id = $('#state_id').val();
                d.city_id = $('#city_id').val();
                d.month = $('#month').val();
                d.sbi_generated = $('#sbi_generated').val();
                d.branch_generated = $('#branch_generated').val();
                d.partner_generated = $('#partner_generated').val();
            },
            "error": function (jqXHR, textStatus, errorThrown) {
                console.error("Error loading data: ", textStatus, errorThrown);
            }
        },
        "columns": columns,
        "lengthChange": true,
        "lengthMenu": [[100, 400, 600, 1000, -1], [100, 400, 600, 1000, "All"]],
        "pageLength": 100,
        "order": [[0, 'desc']],
        "dom": 'lBfrtip',
        "scrollX": true,
        "fixedColumns": {
          leftColumns: 0,
          rightColumns: 4,
        },
        "buttons": [
        { extend: 'copy', text: 'Copy' },
        { 
            extend: 'excelHtml5', 
            text: 'Excel',
            exportOptions: {
                columns: ':visible', // Include all visible columns
                format: {
                     body: function (data, row, column, node) {
                        // Extract value from input fields if present
                        if ($(node).find('input').length) {
                            return $(node).find('input').val();
                        }
                        if ($(node).find('select').length) {
                            return $(node).find('select option:selected').text();
                        }
                        if ($(node).find('.badge').length) {
                            return $(node).find('.badge').text().trim();
                        }
                        /* if ($(node).find('a').length) {
                            var link = $(node).find('a').attr('href');
                            return link ? link : 'N/A';
                        }*/
                        // Remove any HTML tags and return only plain text
                        return $('<div>').html(data).text();
                    }
                }
            }
        }
    ],
     "drawCallback": function(settings) {
     
      // Adjust the height of the fixed columns to match the scrollable columns
      setTimeout(function() {
        var scrollBodyHeight = $('.dataTables_scrollBody').height();
        $('.DTFC_LeftBodyWrapper').height(scrollBodyHeight);
        $('.DTFC_RightBodyWrapper').height(scrollBodyHeight);

        // Adjust the row heights to match
        $('#userTable tbody tr').each(function(index) {
          var rowHeight = $(this).height();
          $('.DTFC_LeftBodyWrapper tbody tr').eq(index).height(rowHeight);
          $('.DTFC_RightBodyWrapper tbody tr').eq(index).height(rowHeight);
        });
      }, 10);
      
        calculateAndDisplaySanctionLoanTotal();
     },
        "footerCallback": function (row, data, start, end, display) {
            calculateAndDisplaySanctionLoanTotal();
        }
    });

    $('#filterSubmit').click(function() {
        table.draw();
    });
    
    $('#resetButton').on('click', function() {
     $('.single-select,.multiple-select').each(function() {
            $(this).val('').trigger('change'); // Works for select2 or similar plugins
        });
    $('#filterForm')[0].reset();
    table.ajax.reload();
  });

    $('#state_id').change(function() {
        var stateId = $(this).val();
        if(stateId !== '') {
            $.ajax({
                url: '<?= base_url('Admin/get_cities') ?>',
                type: 'POST',
                data: { state_id: stateId },
                dataType: 'json',
                success: function(data) {
                    $('#city_id').empty().append('<option value="">-Select-</option>');
                    $.each(data, function(key, value) {
                        $('#city_id').append('<option value="' + value.id + '">' + value.city_name + '</option>');
                    });
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        } else {
            $('#city_id').empty().append('<option value="">-Select-</option>');
        }
    });

    $('#state_id').trigger('change');
    
   $('.dataTables_scrollBody').on('scroll', function() {
    var $scrollBody = $(this);
    var $fixedColumnsRight = $('.DTFC_RightBodyWrapper');
    var scrollLeft = $scrollBody.scrollLeft();
    var scrollWidth = $scrollBody[0].scrollWidth;
    var clientWidth = $scrollBody[0].clientWidth;
    
    var isScrolledToEnd = scrollLeft + clientWidth >= scrollWidth - 1; // -1 to account for rounding issues
    
    if (isScrolledToEnd) {
        $fixedColumnsRight.hide();
    } else {
        $fixedColumnsRight.show();
    }
  });

    $(document).on('click', '.delete', function () {
        var element = $(this);
        var id = element.attr('data-id'); // Use data-id attribute to get the ID
        var action = element.attr('action');

        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to delete this account?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    url: base_url + 'admin/' + action + '/' + id,
                    dataType: 'json',
                    success: function (res) {
                        if (res.success == '1') {
                            notify(res.type, res.message);
                            table.ajax.reload(null, false);  // Reload the table data without resetting pagination
                        } else {
                            notify(res.type, res.message);
                        }
                    },
                    error: function (xhr, status, error) {
                        console.log(xhr.responseText);
                        alert('Error occurred while deleting data. Please try again.');
                    }
                });
            }
        });
    });
    
    
    $(document).on('click', '.commoon_active', function (e) {
    var element = $(this);
    var status = element.attr('active'); // Get the current status
    var id = element.parent('a').data('id'); // Get the data-id directly from the 'a' tag
    var action = element.attr('action'); // Get the action

    console.log("ID: " + id);
    $.ajax({
        type: 'POST',
        url: base_url + 'Admin/' + action + '/' + id + '/' + status,
    }).done(function (response) {
        var res = $.parseJSON(response);
        console.log(res);
        if (res.success == '1') {
            notify(res.type, res.message);
            table.ajax.reload(null, false);
            if (status == '0') { // If current status is 0, change to 1 (Non-verified to Verified)
                element.attr('active', '1'); // Update status attribute to 1
                element.html('Non-verified'); // Update text
                element.addClass('bg-danger').removeClass('bg-success');
                
            } else { // If current status is 1, change to 0 (Verified to Non-verified)
                element.attr('active', '0'); // Update status attribute to 0
                element.html('Verified'); // Update text
                element.addClass('bg-success').removeClass('bg-danger');
               
            }
        } else {
            notify(res.type, res.message);
             table.ajax.reload(null, false);
        }
    }).fail(function () {
        alert("Error in updating status. Please try again.");
    });
});

});


function calculateAndDisplaySanctionLoanTotal() {
    var totalSanctionLoanAmt = 0;
    var columnIndex = <?php echo ($_SESSION['staff_type'] == 0) ? 11 : 9; ?>;

    $('#userTable tbody tr').each(function() {
        var sanctionLoanAmt = parseFloat($(this).find('td').eq(columnIndex).text().replace(/[^0-9.-]+/g, ""));
        if (!isNaN(sanctionLoanAmt)) totalSanctionLoanAmt += sanctionLoanAmt;
    });

    $('#userTable tfoot').remove(); // Remove existing tfoot if any

    var tfootHtml = `
      <tfoot>
        <tr>
          <th colspan="${columnIndex}" style="text-align:right">Total</th>
          <th>${totalSanctionLoanAmt.toFixed(2)}</th>
          <th colspan="10"></th>
        </tr>
      </tfoot>
    `;

    $('#userTable').append(tfootHtml);
}




function appLetterUpload(userId, fileInputId) {
    var fileInput = document.getElementById(fileInputId); // Use the passed ID

    // Check if file input exists
    if (!fileInput) {
        alert('File input not found');
        return;
    }

    // Get the selected file
    var file = fileInput.files[0];

    // Check if a file is selected
    if (!file) {
        alert('No file selected');
        return;
    }

    // Create a FormData object to send the file data
    var formData = new FormData();
    formData.append('apprisal_letter', file);
    formData.append('user_id', userId);

    // Send an Ajax request to the CodeIgniter controller
    $.ajax({
        url: 'admin/upload_apprisal_file', // Update the URL to match your CodeIgniter controller method
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function(response) {
            // Handle success response
            alert('File uploaded successfully');
        },
        error: function(xhr, status, error) {
            // Handle error
            alert('Error uploading file: ' + error);
        }
    });
}



$(document).on('change', '.remark-input', function() {
    var element = $(this);
    var userId = element.data('id'); // Get the user ID from data-id attribute
    var remark = element.val(); // Get the updated remark value

    $.ajax({
        type: 'POST',
        url: '<?= base_url('admin/update_remark'); ?>',  // Define the appropriate URL for updating remark
        data: { user_id: userId, remark: remark },
        success: function(response) {
            var res = JSON.parse(response);
            if (res.success) {
                notify('success', 'Remark updated successfully.');
            } else {
                notify('error', 'Error updating remark.');
            }
        },
        error: function(xhr, status, error) {
            alert('Error occurred: ' + error);
        }
    });
});

</script>

<style>
   .dataTables_length {
      margin-bottom: 13px;
  }
  .dataTables_filter {
      margin-top: 12px;
  }
    
    .DTFC_RightBodyWrapper table,
  .DTFC_LeftBodyWrapper table {
      width: 100% !important;
  }

  .dataTables_scrollBody {
      overflow: auto;
  }

  .DTFC_LeftBodyLiner,
  .DTFC_RightBodyLiner {
      overflow: hidden !important;
  }

  .DTFC_LeftBodyWrapper,
  .DTFC_RightBodyWrapper {
      top: 0 !important;
  }

  .DTFC_RightBodyWrapper {
      right: 0 !important;
  }

  .DTFC_RightBodyLiner {
      overflow: hidden;
      position: absolute;
      right: 0;
      top: -11px !important;
      background-color: white !important;
  }

  .DTFC_LeftBodyLiner {
      overflow: hidden;
      position: absolute;
      left: 0;
  }

  .dataTables_scrollHeadInner, .dataTables_scrollHead, .dataTables_scrollBody {
      margin-bottom: 0 !important;
  }

  .dataTables_wrapper .dataTables_scroll div.dataTables_scrollBody {
      background: white;
  }


  table.dataTable tr:nth-child(even) {
      background-color: #ffff;
  }

  table.dataTable tr:nth-child(odd) {
      background-color: #ffffff;
  }

</style>




<!-- Modal -->
<div class="modal fade" id="applicantFormModal" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="applicantFormModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="applicantFormModalLabel">Select Login Code</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form id="formSelection" class="d-flex justify-content-around">
          <div class="form-check custom-card">
            <input class="form-check-input" type="radio" name="formType" id="paisabazar" value="Paisabazaar" required>
            <label class="form-check-label custom-label" for="paisabazar">
             Paisabazzar
            </label>
          </div>
          <div class="form-check custom-card">
            <input class="form-check-input" type="radio" name="formType" id="mortgagebuddy" value="Mortgagebuddy" required>
            <label class="form-check-label custom-label" for="mortgagebuddy">
              Mortgagebuddy
            </label>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        
        <button type="button" class="btn btn-primary" id="redirectBtn">Proceed</button>
      </div>
    </div>
  </div>
</div>

<script>
// Handle the "Proceed" button click
document.getElementById('redirectBtn').addEventListener('click', function() {
    // Get the selected radio button
    var selectedRadio = document.querySelector('input[name="formType"]:checked');
    
    // Check if any radio button is selected
    if (selectedRadio) {
        var selectedFormType = selectedRadio.value;

        // Create a hidden form element
        var form = document.createElement('form');
        form.method = 'POST';
        form.action = "<?php echo base_url('admin/applicant_form'); ?>";  // Your target form URL

        // Create a hidden input field for the selected form type
        var input = document.createElement('input');
        input.type = 'hidden';
        input.name = 'selectedFormType';
        input.value = selectedFormType;

        // Append the input to the form and submit it
        form.appendChild(input);
        document.body.appendChild(form);
        form.submit();
    } else {
        alert('Please select a Login Code.');
    }
});


// Handle modal close event to unselect radio buttons
$('#applicantFormModal').on('hide.bs.modal', function () {
    // Unselect any selected radio button
    var selectedRadio = document.querySelector('input[name="formType"]:checked');
    if (selectedRadio) {
        selectedRadio.checked = false;
    }
    
    // Optionally reset the form if you have more fields
    document.getElementById('formSelection').reset();
});




 


</script>



<style>
/* Hide default radio button appearance */
.form-check-input {
    position: absolute;
    opacity: 0;
   
}
.form-check {
    display: block;
    min-height: 1.5rem;
    padding-left: 0px !important;
    margin-bottom: .125rem;
}

/* Style the card as selectable */
.custom-card {
    cursor: pointer;
    width: 150px;
    margin-bottom: 20px;
    border: 2px solid #ccc;
    border-radius: 5px;
    transition: all 0.3s ease;
    display: inline-block;
    text-align: center;
}

/* Change border color and background when selected */
.form-check-input:checked + .custom-label {
    border-color: green;
    background-color: green;
    color: white;
    padding: 10px;
    border-radius: 5px;
    display: inline-block;
}

/* Style for the label to appear like a card */
.custom-label {
    display: inline-block;
    padding: 10px;
    border-radius: 5px;
    border: 2px solid #ccc;
    transition: all 0.3s ease;
    width: 100%;
}

/* Hover effect for the card */
.custom-card:hover .custom-label {
    border-color: green;
}
</style>
