<link href="<?= base_url() ?>admin_assets/css/new_style.css" rel="stylesheet" />

<main class="page-content">
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"><?= $title ?></div>
    </div>

   <style>
/* Layout */
.permissions-wrap {
    overflow: auto;          /* horizontal + vertical */
    border-radius: 6px;
    border: 1px solid #e1e1e6;
    margin-top: 10px;
    position: relative;      /* sticky ke liye important */
}



table.permissions-grid {
    border-collapse: collapse;
    width: 100%;
    min-width: 1200px;
}

/* HEADER (top row) */
table.permissions-grid thead th {
    position: sticky;
    top: 0;
    z-index: 3;
    color: #fff;
    text-align: left;
    vertical-align: middle;
    padding: 8px 10px;
    font-weight: 600;
    font-size: 12px;
    background: linear-gradient(183deg, #1A5CFF 0%, #0035b9 60%) !important;
    background-image: url('/mnt/data/4f024c94-80cb-410d-9bd7-03d32020ab1b.png');
    background-size: cover;
    background-position: center;
    border-right: 1px solid rgba(255,255,255,0.06);
    white-space: nowrap;
}

/* first header (Permissions) – top + left sticky */
table.permissions-grid thead th:first-child {
    background: transparent; 
    position: sticky;
    left: 0;
    z-index: 4;
    background-color: #fff;
    font-size: 13px;
    font-weight: 700;
}

/* LEFT COLUMN (permissions names) */
table.permissions-grid tbody td:first-child {
    position: sticky;
    left: 0;
    z-index: 2;
    background: #fff;
    padding: 10px 14px;
    min-width: 260px;
    border-right: 1px solid #eee;
    font-weight: 500;
}


/* normal cells */
table.permissions-grid tbody td {
    padding: 8px 10px;
    border-bottom: 1px solid #eee;
    vertical-align: middle;
}

/* Role header cell style (top columns) */
.role-header {
    padding: 6px 8px;
    text-align: center;
    min-width: 150px;
    border-left: 1px solid rgba(255,255,255,0.06);
}
.role-title {
    display: block;
    margin-bottom: 2px;
    line-height: 1.2;
}
.role-sub {
    display: block;
    font-weight: 400;
    font-size: 13px;
    opacity: 1.9;
    line-height: 1.2;
}

/* Checkbox grid */
.perm-cell { text-align: center; }
.perm-cell input[type="checkbox"] { transform: scale(1.05); }

/* Top controls */
.top-controls {
    display:flex;
    justify-content:space-between;
    align-items:center;
    margin-top:5px;
    margin-bottom:8px;
}
.top-controls .right-area {
    display:flex;
    align-items:center;
    gap:10px;
}
.role-btn {
    display:inline-block;
    background:#2563eb;
    color:#fff !important;
    font-size:13px;
    text-decoration:none;
    border:1px solid #1d4ed8;
}
.role-btn:hover { background:#1d4ed8; }

/* Responsive */
@media (max-width:900px) {
    table.permissions-grid { min-width: 900px; }
    .role-header { min-width: 130px; padding:6px; }
}

/* SECTION HEADER FULL ROW */
.section-row td {
    padding: 0 !important;
    background: #f5f5f5;
    border-top: 1px solid #ddd;
}

/* FIXED LEFT BLOCK INSIDE SECTION ROW */
.section-title {
    position: sticky;
    left: 0;
    z-index: 6;
    display: block;
    padding: 10px 14px;
    background: #f5f5f5;
    font-weight: 700;
    border-right: 1px solid #ddd;
    width: 260px;  /* SAME width as your left column */
}


</style>


    <div class="top-controls">
        <div class="left-area"></div>
        <div class="right-area">
            <input type="text" class="search-box" id="tableSearch" placeholder="🔍 Search">
            <a href="<?= base_url('admin/role_form/') ?>" class="role-btn">+ Add Role</a>
        </div>
    </div>

    <div class="permissions-wrap">
        <table class="permissions-grid">
            <thead>
                <tr>
                    <th>Permissions</th>
                    <?php foreach ($roles as $role_id => $role): ?>
                        <th class="role-header" data-staff-id="<?= $role->staff_id ?>">
                            <span class="role-title"><?= htmlspecialchars($role->role_name) ?></span>
                            <span class="role-sub">
                                <?= htmlspecialchars($role->staff_fullname) . " [{$role->staff_id}]" ?>
                            </span>
                        </th>
                    <?php endforeach; ?>
                </tr>
            </thead>

            <tbody>
                <?php
                // Group menus by heading
                $groupedMenus = [];
                foreach ($menus as $menu) {
                    $groupedMenus[$menu->heading][] = $menu;
                }

                foreach ($groupedMenus as $heading => $menuItems):
                ?>
                    <!-- Section header row -->
                    <tr class="section-row">
                        <td colspan="<?= count($roles) + 1 ?>">
                            <span class="section-title"><?= $heading ?></span>
                        </td>
                    </tr>


                    <?php foreach ($menuItems as $menu): ?>
                        <tr data-menu-id="<?= $menu->id ?>">
                            <td><?= $menu->menu_name ?></td>

                            <?php foreach ($roles as $role_id => $role): ?>
                                <?php
                                $has = false;
                                if (!empty($role->permissions)) {
                                    foreach ($role->permissions as $p) {
                                        if ($p->menu_name == $menu->menu_name) { $has = true; break; }
                                    }
                                }
                                ?>
                                <td class="perm-cell">
                                    <input type="checkbox"
                                           class="permission-checkbox"
                                           data-role-id="<?= $role_id ?>"
                                           data-staff-id="<?= $role->staff_id ?>"
                                           data-menu-id="<?= $menu->id ?>"
                                           <?= $has ? 'checked' : '' ?>>
                                </td>
                            <?php endforeach; ?>
                        </tr>
                    <?php endforeach; ?>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <script>
    document.getElementById('tableSearch').addEventListener('keyup', function () {
        let query = this.value.toLowerCase();
        let rows = document.querySelectorAll('.permissions-grid tbody tr');

        rows.forEach(row => {
            if (row.classList.contains('section-row')) {
                row.style.display = '';
                return;
            }
            let text = row.innerText.toLowerCase();
            row.style.display = text.includes(query) ? '' : 'none';
        });
    });
    </script>

    <script>
    (function($){
        $(function(){
            $(document).on('change', '.permission-checkbox', function(e){
                var $cb = $(this);
                var roleId   = $cb.data('role-id');
                var staffId  = $cb.data('staff-id') || '';
                var menuId   = $cb.data('menu-id');
                var isChecked = $cb.is(':checked') ? 1 : 0;

                $cb.prop('disabled', true);

                $.ajax({
                    url: '<?= base_url("admin/update_permission_menue"); ?>',
                    method: 'POST',
                    dataType: 'json',
                    data: {
                        role_id: roleId,
                        staff_id: staffId,
                        menu_id: menuId,
                        has_permission: isChecked
                    },
                    success: function(resp){
                        if (resp && resp.success) {
                            $cb.closest('td').css('background','#e6fff0');
                            setTimeout(function(){ $cb.closest('td').css('background',''); }, 600);
                        } else {
                            $cb.prop('checked', !isChecked);
                            alert('Server error: ' + (resp && resp.message ? resp.message : 'unknown'));
                        }
                    },
                    error: function(xhr, status, err){
                        $cb.prop('checked', !isChecked);
                        alert('AJAX error updating permission.');
                        console.error('AJAX error:', status, err, xhr && xhr.responseText);
                    },
                    complete: function(){
                        $cb.prop('disabled', false);
                    }
                });
            });

            $(document).on('change', '.menu-assign-toggle', function(){
                var $cb = $(this);
                var staffId = $cb.data('staff-id');
                var isChecked = $cb.is(':checked') ? 1 : 0;
                $cb.prop('disabled', true);

                $.ajax({
                    url: '<?= base_url("admin/update_menu_assign") ?>',
                    method: 'POST',
                    dataType: 'json',
                    data: { staff_id: staffId, menu_assign: isChecked },
                    success: function(resp){
                        if (resp && resp.success) {
                            $cb.closest('th').css('background','#e6fff0');
                            setTimeout(function(){ $cb.closest('th').css('background',''); }, 600);
                        } else {
                            $cb.prop('checked', !isChecked);
                            alert('Server error: ' + (resp && resp.message ? resp.message : 'unknown'));
                        }
                    },
                    error: function(){
                        $cb.prop('checked', !isChecked);
                        alert('AJAX error updating menu assign.');
                    },
                    complete: function(){ $cb.prop('disabled', false); }
                });
            });
        });
    })(jQuery);
    </script>

</main>
