<!-- Edit Payment Log Modal (Bootstrap 5) -->
<!-- Bootstrap 5 Modal -->

<main class="page-content">
  <!--breadcrumb-->
  <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
    <div class="breadcrumb-title pe-3"> <?= $title ?> </div>
  </div>
  <!--end breadcrumb-->
  <div class="card">
    <div class="card-body">
    <div class="modal-body">
                <form id="mergeInvoiceForm" method="post">
                    <input type="hidden" id="edit_invoice_batchno" name="invoice_batchno">
                    <input type="hidden" id="edit_invoice_no_id" name="invoice_no_id">
                
                    <div class="row mb-3">
                        <div class="col-md-12">
                           <label class="form-label fs-5">Merged By: <?= $staffname; ?></label>
                        </div>
                        
                        <div class="col-md-3">
                            <label class="form-label">From Invoice No:</label>
                            <input type="text" class="form-control" id="from_invoice_no" name="from_invoice_no" required>
                        </div>
                
                        <div class="col-md-3">
                            <label class="form-label">To Invoice No:</label>
                            <input type="text" class="form-control" id="to_invoice_no" name="to_invoice_no" required>
                        </div>
                
                        <div class="col-md-3">
                            <label class="form-label">Remark:</label>
                            <textarea class="form-control" id="remark" name="remark"></textarea>
                        </div>
                
                      
                    </div>
                
                    <div class="row">
                        <div class="col-md-12">
                            <button type="submit" class="btn btn-success">Merge Invoice</button>
                        </div>
                    </div>
                </form>
<div id="message-box" style="position: fixed; top: 20px; right: 20px; z-index: 1050;"></div>
            </div>

      <hr class="mt-3">
   

    </div>
  </div>
</main>

<script>
    $(document).ready(function() {
        $('#mergeInvoiceForm').submit(function(e) {
            e.preventDefault(); // Prevent default form submission

            $.ajax({
                type: "POST",
                url: "<?= base_url('admin/save_merged_invoices') ?>", // Change if needed
                data: $(this).serialize(),
                dataType: "json",
                success: function(response) {
                    if (response.success === "1") {
                        $('#message-box').html('<div class="alert alert-success">' + response.message + '</div>');
                    } else {
                        $('#message-box').html('<div class="alert alert-danger">' + response.message + '</div>');
                    }
                    
                     $('#mergeInvoiceForm')[0].reset();
                     // Auto-hide after 3 seconds
                    setTimeout(function() {
                        $('#message-box .alert').fadeOut('slow', function() {
                            $(this).remove();
                        });
                    }, 3000);
                },
                error: function(xhr, status, error) {
                    
                     alert("AJAX error: " + error); // Just for debugging
                    $('#message-box').html('<div class="alert alert-danger">Something went wrong!</div>');
                    
                     // Auto-hide after 3 seconds
                    setTimeout(function() {
                        $('#message-box .alert').fadeOut('slow', function() {
                            $(this).remove();
                        });
                    }, 3000);
                }
            });
        });
    });
</script>
