<main class="page-content">
    <!--breadcrumb-->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"><?= $title ?></div>
    </div>
    <!--end breadcrumb-->
    <div class="card">
        <?php if ($_SESSION['staff_type']=='0') { ?>
        <div class="card-header py-3">
            <div class="row align-items-center m-0">
                <div class="col-md-4 col-12 me-auto mb-md-0 mb-3">
                    <a href="<?= base_url('admin/tds_certificate_form/') ?>">
                        <button type="button" class="btn btn-outline-primary radius-30">Upload TDS Certificate</button>
                    </a>
                </div>
            </div>
        </div>
        <?php } ?>
        <div class="card-body">
             <form id="filterForm" method="post">
                <div class="row">
                  <?php if($_SESSION['staff_type']==0){ ?>
                  <div class="col-md-3 mb-3">
                    <label class="form-label" for="connector">Partner</label>
                    <select class="single-select" id="connector" name="connector">
                      <option value="">Select Partner</option> 
                      <?php foreach ($connector as $connectorItem) : ?> 
                      <option value="<?= $connectorItem['staff_id']; ?>"><?= $connectorItem['staff_fullname']; ?></option>
                      <?php endforeach; ?>
                    </select>
                  </div> 
                  <?php } ?>
                 <!-- <div class="col-md-3 mb-3">
                    <label class="form-label">Quarter</label>
                    <select class="form-control" id="quarter" name="quarter">
                        <option value="">-Select Quarter-</option>
                        <option value="Quarter 1">Quarter 1</option>
                        <option value="Quarter 2">Quarter 2 </option>
                        <option value="Quarter 3">Quarter 3 </option>
                        <option value="Quarter 4">Quarter 4 </option>
                    </select>
                </div>
-->
                  <div class="col-md-3 mb-3">
                      <br>
                    <button class="btn btn-success" type="button" id="filterButton">Filter</button>
                    <button class="btn btn-info" type="button" id="resetButton">Reset</button>
                  </div>
                </div>
             </form>
            <div class="table-responsive">
              <table class="table align-middle table-striped" id="Table">
                <thead>
                    <tr>
                        <th>Sr.No</th>
                        <th>Name</th>
                      
                        <th>File</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
            </div>
        </div>
    </div>
</main>

<script>
$(document).ready(function() {
    var base_url = "<?= base_url(); ?>";

    var table = $('#Table').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?= base_url('admin/fetch_tds_certificate') ?>",
            "type": "POST",
            "data": function(d) {
                d.filter_month = $('#month').val();
                d.filter_connector = $('#connector').val();
            }
        },
        "columns": [
            { "data": 0 }, 
            { "data": 1 }, 
            { "data": 2 }
        ],
        "lengthChange": true,
        "lengthMenu": [[50, 100, 150, 200, -1], [50, 100, 150, 200, "All"]],
        "dom": 'lBfrtip',
        "buttons": [
            { extend: 'copy', text: 'Copy' },
            { extend: 'excel', text: 'Excel' },
            { extend: 'pdf', text: 'PDF' },
            {
                extend: 'print',
                text: 'Print',
                customize: function(win) {
                    $(win.document.body).find('h1').text('Branches');
                }
            }
        ]
    });

    // Move buttons container to a specific location if needed
    table.buttons().container().appendTo('#Table_wrapper .col-md-6:eq(0)');

    // Event delegation for delete button
    $(document).on('click', '.delete', function () {
        var element = $(this);
        var id = element.data('id'); // Use data-id attribute to get the ID
        var action = element.attr('action');
       
        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to delete this TDS certificate?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    url: base_url + 'admin/' + action,
                    data: {id: id},
                    dataType: 'json',
                    success: function(res) {
                        if (res.success == '1') {
                            Swal.fire('Deleted!', res.message, 'success');
                            table.ajax.reload();  // Reload the table data after deletion
                        } else {
                            Swal.fire('Error!', res.message, 'error');
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log(xhr.responseText);
                        alert('Error occurred while deleting data. Please try again.');
                    }
                });
            }
        });
    });

    // Trigger table reload on filter button click
    $('#filterButton').click(function() {
        table.ajax.reload();
    });

    // Reset filters
    $('#resetButton').click(function() {
        $('#filterForm')[0].reset();
        table.ajax.reload();
    });
});



$(document).on('click', '.delete_tds', function () {
     var base_url = "<?= base_url(); ?>";

    var fileId = $(this).data('id');
    console.log('Deleting file with ID:', fileId); // Debugging
    if (confirm('Are you sure you want to delete this file?')) {
        $.ajax({
            url: base_url + 'admin/delete_tds_certificate',
            type: 'POST',
            data: { id: fileId },
            success: function (response) {
                var res = JSON.parse(response);
                if (res.success == '1') {
                    alert(res.message);
                    location.reload();
                } else {
                    alert(res.message);
                }
            },
            error: function () {
                alert('Error while deleting the file. Please try again.');
            }
        });
    }
});

</script>

<style>
    .dataTables_length{
        margin-bottom:13px;
    }
    .dataTables_filter{
        margin-top:12px;
    }
</style>
