<main class="page-content">
    <div class="card">

        <!-- ================= Table Settings Overlay ================= -->
        <div class="table-settings-overlay" id="tableSettingsOverlay"></div>

        <!-- ================= Table Settings Panel ================= -->
        <div class="table-settings-panel" id="tableSettingsPanel">
            <div class="ts-header">
                <h6>Table Settings</h6>
                <button class="ts-close" id="closeTableSettings">&times;</button>
            </div>

            <div class="ts-body">
                <div class="ts-grid">
                    <?php if($_SESSION['staff_type']==0){ ?>
                    <div class="formgroup">
                        <label>Partner</label>
                        <select class="form-control" id="connector">
                            <option value="">Select Partner</option>
                            <?php foreach ($connector as $connectorItem) { ?>
                                <option value="<?= $connectorItem['staff_id']; ?>">
                                    <?= $connectorItem['staff_fullname']; ?>
                                </option>
                            <?php } ?>
                        </select>
                    </div>
                    <?php } ?>
                </div>
            </div>

            <div class="ts-footer">
                <button class="btn-back-white" id="resetButton">Reset</button>
                <button class="btn-submit" id="filterButton">Apply</button>
            </div>
        </div>

        <!-- ================= Card Body ================= -->
        <div class="card-body">

            <!-- ================= Top Controls ================= -->
            <div class="top-controls">

                <div class="left-area">
                    <div id="tableSettingsBtn" class="table-settings-chip">
                        <span class="ts-text">Table Settings</span>
                        <span class="ts-icon">
                            <i class="bi bi-grid-3x3-gap-fill"></i>
                        </span>
                    </div>

                    <div class="export-buttons"></div>
                </div>

                <div class="right-area">
                    <input type="text" class="search-box" id="tableSearch" placeholder="🔍 Search">

                    <?php if ($_SESSION['staff_type']=='0') { ?>
                    <a href="<?= base_url('admin/tds_certificate_form/') ?>" class="role-btn">
                        <i class="bi bi-upload"></i> Upload TDS Certificate
                    </a>
                    <?php } ?>
                </div>
            </div>

            <!-- ================= Table ================= -->
            <div class="table-responsive mobile-scroll">
                <table class="table table-striped align-middle" id="Table">
                    <thead>
                        <tr>
                            <th>Sr.No</th>
                            <th>Name</th>
                            <th>File</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>

        </div>
    </div>
</main>

<script>
$(document).ready(function() {

    var base_url = "<?= base_url(); ?>";

    var table = $('#Table').DataTable({
        processing: true,
        serverSide: true,
        paging: false,
        ajax: {
            url: "<?= base_url('admin/fetch_tds_certificate') ?>",
            type: "POST",
            data: function(d) {
                d.filter_connector = $('#connector').val();
            }
        },
        columns: [
            { data: 0 },
            { data: 1 },
            { data: 2 }
        ],
        lengthChange: true,
        lengthMenu: [[50, 100, 150, 200, -1], [50, 100, 150, 200, "All"]],
        dom: 'Blfrtip',
        buttons: [

            {
                extend: 'excelHtml5',
                text: '<img src="<?= base_url("admin_assets/images/icons/excel.png") ?>" class="export-icon">',
                className: 'export-btn'
            },
            {
                extend: 'pdfHtml5',
                text: '<img src="<?= base_url("admin_assets/images/icons/pdf.png") ?>" class="export-icon">',
                className: 'export-btn'
            },
            {
                extend: 'print',
                text: '<img src="<?= base_url("admin_assets/images/icons/print.png") ?>" class="export-icon">',
                className: 'export-btn'
            }
        ]
    });

    // Move export buttons
    table.buttons().container().appendTo($('.export-buttons'));

    // Search
    $('#tableSearch').on('keyup', function () {
        table.search(this.value).draw();
    });

    // Open settings
    $('#tableSettingsBtn').on('click', function () {
        $('#tableSettingsPanel, #tableSettingsOverlay').addClass('active');
    });

    // Close settings
    $('#closeTableSettings, #tableSettingsOverlay').on('click', function () {
        $('#tableSettingsPanel, #tableSettingsOverlay').removeClass('active');
    });

    // Apply filter
    $('#filterButton').on('click', function () {
        table.ajax.reload();
        $('#tableSettingsPanel, #tableSettingsOverlay').removeClass('active');
    });

    // Reset filter
    $('#resetButton').on('click', function () {
        $('#connector').val('');
        table.ajax.reload();
    });

});
</script>


<!--<main class="page-content">
  
    <div class="card">
        <?php if ($_SESSION['staff_type']=='0') { ?>
        <div class="card-header py-3">
            <div class="row align-items-center m-0">
                <div class="col-md-4 col-12 me-auto mb-md-0 mb-3">
                    <a href="<?= base_url('admin/tds_certificate_form/') ?>">
                        <button type="button" class="btn btn-outline-primary radius-30">Upload TDS Certificate</button>
                    </a>
                </div>
            </div>
        </div>
        <?php } ?>
        <div class="card-body">
             <form id="filterForm" method="post">
                <div class="row">
                  <?php if($_SESSION['staff_type']==0){ ?>
                  <div class="col-md-3 mb-3">
                    <label class="form-label" for="connector">Partner</label>
                    <select class="single-select" id="connector" name="connector">
                      <option value="">Select Partner</option> 
                      <?php foreach ($connector as $connectorItem) : ?> 
                      <option value="<?= $connectorItem['staff_id']; ?>"><?= $connectorItem['staff_fullname']; ?></option>
                      <?php endforeach; ?>
                    </select>
                  </div> 
                  <?php } ?>
              
                  <div class="col-md-3 mb-3">
                      <br>
                    <button class="btn btn-success" type="button" id="filterButton">Filter</button>
                    <button class="btn btn-info" type="button" id="resetButton">Reset</button>
                  </div>
                </div>
             </form>
            <div class="table-responsive">
              <table class="table align-middle table-striped" id="Table">
                <thead>
                    <tr>
                        <th>Sr.No</th>
                        <th>Name</th>
                      
                        <th>File</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
            </div>
        </div>
    </div>
</main>-->

<script>
/*$(document).ready(function() {
    var base_url = "<?= base_url(); ?>";

    var table = $('#Table').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?= base_url('admin/fetch_tds_certificate') ?>",
            "type": "POST",
            "data": function(d) {
                d.filter_month = $('#month').val();
                d.filter_connector = $('#connector').val();
            }
        },
        "columns": [
            { "data": 0 }, 
            { "data": 1 }, 
            { "data": 2 }
        ],
        "lengthChange": true,
        "lengthMenu": [[50, 100, 150, 200, -1], [50, 100, 150, 200, "All"]],
        "dom": 'lBfrtip',
        "buttons": [
            { extend: 'copy', text: 'Copy' },
            { extend: 'excel', text: 'Excel' },
            { extend: 'pdf', text: 'PDF' },
            {
                extend: 'print',
                text: 'Print',
                customize: function(win) {
                    $(win.document.body).find('h1').text('Branches');
                }
            }
        ]
    });

    // Move buttons container to a specific location if needed
    table.buttons().container().appendTo('#Table_wrapper .col-md-6:eq(0)');

    // Event delegation for delete button
    $(document).on('click', '.delete', function () {
        var element = $(this);
        var id = element.data('id'); // Use data-id attribute to get the ID
        var action = element.attr('action');
       
        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to delete this TDS certificate?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    url: base_url + 'admin/' + action,
                    data: {id: id},
                    dataType: 'json',
                    success: function(res) {
                        if (res.success == '1') {
                            Swal.fire('Deleted!', res.message, 'success');
                            table.ajax.reload();  // Reload the table data after deletion
                        } else {
                            Swal.fire('Error!', res.message, 'error');
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log(xhr.responseText);
                        alert('Error occurred while deleting data. Please try again.');
                    }
                });
            }
        });
    });

    // Trigger table reload on filter button click
    $('#filterButton').click(function() {
        table.ajax.reload();
    });

    // Reset filters
    $('#resetButton').click(function() {
        $('#filterForm')[0].reset();
        table.ajax.reload();
    });
});



$(document).on('click', '.delete_tds', function () {
     var base_url = "<?= base_url(); ?>";

    var fileId = $(this).data('id');
    console.log('Deleting file with ID:', fileId); // Debugging
    if (confirm('Are you sure you want to delete this file?')) {
        $.ajax({
            url: base_url + 'admin/delete_tds_certificate',
            type: 'POST',
            data: { id: fileId },
            success: function (response) {
                var res = JSON.parse(response);
                if (res.success == '1') {
                    alert(res.message);
                    location.reload();
                } else {
                    alert(res.message);
                }
            },
            error: function () {
                alert('Error while deleting the file. Please try again.');
            }
        });
    }
});*/

</script>

<style>
    .dataTables_length{
        margin-bottom:13px;
    }
    .dataTables_filter{
        margin-top:12px;
    }
</style>
