<main class="page-content">
    <!--breadcrumb-->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"><?= $title ?></div>
    </div>
    <!--end breadcrumb-->
    <div class="card">
        <div class="card-body">
            <div class="top-controls">
    
                <div class="left-area">
                     <div class="export-buttons"></div>
                </div>
        
                <div class="right-area">
                    <input type="text" class="search-box" id="tableSearch" placeholder="🔍 Search">
                    
                    <!-- FIX: button inside anchor removed -->
                    <a href="<?= base_url('admin/circle_form/') ?>" class="role-btn">+ Add Circle</a>
        
                </div>
            </div>
            <div class="table-responsive mobile-scroll">
                <table class="table align-middle table-striped" id="Table">                   
                    <thead>
                        <tr>
                            <th>Sr.No</th>
                            <th>Circle Name</th>  
                            <th>Circle Code</th>  
                            <th>Created By</th> 
                            <th>Modified By</th> 
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    <thead>
                    <tbody>
                        <?php
                        if (!empty($circle)) {
                            foreach ($circle as $key => $row) {
                                ?>
                                <tr class='main_block' main_id="<?= $row['id'] ?>">
                                    <td><?= $key + 1 ?></td>
                                    <td class="">
                                        <?= $row['c_name'] ?>    
                                    </td>
                                      <td class="">
                                        <?= $row['c_code'] ?>    
                                    </td>
                                    <td class="">
                                        <?= $row['created_by_name'] ?>    
                                    </td>
                                    <td class="">
                                        <?= $row['modified_by_name'] ?>    
                                    </td>
                                    <td>
                                        <?php if ($row['active'] == 1) { ?>
                                            <a href="javascript:void(0);" >
                                                <span class="badge rounded-pill bg-success commoon_active"  action='active_circle' active='0'>Active</span>
                                            </a>
                                        <?php } else { ?>
                                            <a href="javascript:void(0);" >
                                                <span class="badge rounded-pill bg-danger commoon_active"  action='active_circle' active='1'>Deactive</span>
                                            </a>  <?php } ?>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center gap-3 fs-6">
                                            <!--<a href="javascript:;" class="text-primary" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="View detail" aria-label="Views"><i class="bi bi-eye-fill"></i></a>-->
                                            <a href="<?= base_url('admin/circle_form/' . $row['id']) ?>" class="text-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Edit info" aria-label="Edit"><i class="bi bi-pencil-fill"></i></a>
                                            <a href="javascript:;" class="text-danger delete" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Delete" aria-label="Delete"  action='delete_circle'><i class="bi bi-trash-fill"></i></a>
                                        </div>
                                    </td>
                                </tr>
                                <?php
                            }
                        } else {
                            ?>
                            <tr><td colspan="5" align="center">Sorry no records available! </td></tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <?//= $pagination ?>
        </div>
    </div>
</main>

<script>
$(document).ready(function() {
    var table = $('#Table').DataTable({
        "paging": false,
        "lengthChange": false,
        "info": false,
        "ordering": true,
        "dom": 'Bfrtip', // basic dom for buttons

        "buttons": [
            {
                extend: 'excel',
                text: '<img src="<?= base_url("admin_assets/images/icons/excel.png") ?>" class="export-icon">',
                titleAttr: 'Export to Excel',
                className: 'export-btn'
            },
            {
                extend: 'pdf',
                text: '<img src="<?= base_url("admin_assets/images/icons/pdf.png") ?>" class="export-icon">',
                titleAttr: 'Export to PDF',
                className: 'export-btn',
                orientation: 'landscape'
            },
            {
                extend: 'print',
                text: '<img src="<?= base_url("admin_assets/images/icons/print.png") ?>" class="export-icon">',
                titleAttr: 'Print',
                className: 'export-btn',
                orientation: 'landscape'
            }
        ]
    });

    // Move buttons into left-area
    table.buttons().container().appendTo($('.export-buttons'));

    // Search box
    $("#tableSearch").on("keyup", function () {
        table.search(this.value).draw();
    });

    table.buttons().container().appendTo('#Table_wrapper .col-md-6:eq(0)');
});
</script>

<style>
    .dataTables_length{
        margin-bottom:13px;
    }
    .dataTables_filter{
        margin-top:12px;
    }
</style>