<main class="page-content">
    <!-- Breadcrumb -->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"><?= htmlspecialchars($title) ?></div>
    </div>
    <!-- End Breadcrumb -->

    <div class="card">
        <div class="card-header py-3">
            <div class="row align-items-center m-0">
                <div class="col-md-4 col-12 me-auto mb-md-0 mb-3"></div>
            </div>
        </div>
        <div class="card-body">
            
             <form id="filterForm" action="<?php echo base_url('admin/fetch_deleted_cases'); ?>" method="post">
                <div class="row">
                     <div class="col-md-2 mb-3">
                            <label for="rbo">Applicants</label>
                            <select class="single-select" id="applicants" name="applicants">
                                <option value="all" selected>All</option>
                                <option value="PaisaBazaar">PB</option>
                                <option value="Mortgagebuddy">MB</option>
                            </select>
                    </div>
             
                    <div class="col-md-3 mb-3">
                        <br>
                        <button type="button" class="btn btn-success" id="filterSubmit">Filter</button>
                        <button class="btn btn-info" type="button" id="resetButton">Reset</button>
                    </div>
                </div>
            </form>
            
            
            <div class="table-responsive">
                <table class="table align-middle table-striped" id="Table">
                    <thead>
                        <tr>
                            <th>Sr. No</th> 
                            <th>Partner Name</th>
                            <th>Applicant Name</th>
                            <th>Login Code</th>
                            <th>RLMS ID</th>
                            <th>CBS Account No</th>
                            <th>Loan Type</th>
                            <th>Sanction Loan Amt</th>
                            <th>Branch</th>
                            <th>Deleted Date</th>
                            <th>Deleted By</th>
                           <!-- <th>Actions</th>-->
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($deleted_user)) : 
                            $sr_no = 1;
                            foreach ($deleted_user as $entry) : 
                                $decoded_data = json_decode($entry['deleted_user_data'], true); // Decode JSON
                                   
                                   
                                   if (!empty($decoded_data['loan_type_id'])) {
                                    $loan_type = $this->db->select('name')
                                        ->from('mst_loan_type')
                                        ->where('id', $decoded_data['loan_type_id'])
                                        ->get()
                                        ->row();
                                    $decoded_data['loan_type_name'] = $loan_type ? $loan_type->name : 'N/A';
                                    unset($decoded_data['loan_type_id']); // Remove loan_type_id
                                }
        
                                // Fetch required details
                                if (!empty($decoded_data['branch_id'])) {
                                    $branch = $this->db->select('branch_name')
                                        ->from('branch')
                                        ->where('id', $decoded_data['branch_id'])
                                        ->get()
                                        ->row();
                                    $decoded_data['branch_name'] = $branch ? $branch->branch_name : 'N/A';
                                    unset($decoded_data['branch_id']); // Remove branch_id
                                }

                                if (!empty($decoded_data['state_id'])) {
                                    $state = $this->db->select('state_name')
                                        ->from('mst_state')
                                        ->where('id', $decoded_data['state_id'])
                                        ->get()
                                        ->row();
                                    $decoded_data['state_name'] = $state ? $state->state_name : 'N/A';
                                    unset($decoded_data['state_id']); // Remove state_id
                                }

                                if (!empty($decoded_data['city_id'])) {
                                    $city = $this->db->select('city_name')
                                        ->from('mst_city')
                                        ->where('id', $decoded_data['city_id'])
                                        ->get()
                                        ->row();
                                    $decoded_data['city_name'] = $city ? $city->city_name : 'N/A';
                                    unset($decoded_data['city_id']); // Remove city_id
                                }

                                if (!empty($decoded_data['connector_id'])) {
                                    $connector = $this->db->select('staff_fullname')
                                        ->from('mst_staff')
                                        ->where('staff_id', $decoded_data['connector_id'])
                                        ->get()
                                        ->row();
                                    $decoded_data['partner_name'] = $connector ? $connector->staff_fullname : 'N/A';
                                    unset($decoded_data['connector_id']); // Remove connector_id
                                }

                                if (isset($decoded_data['bank_acct_no'])) {
                                    $decoded_data['cbs_acct_no'] = $decoded_data['bank_acct_no'];
                                    unset($decoded_data['bank_acct_no']); // Remove bank_acct_no
                                }

                                unset(
                                    $decoded_data['id'],
                                    $decoded_data['applicant_rr_id'],
                                    $decoded_data['other_branch'],
                                    $decoded_data['other_branch_code'],
                                    $decoded_data['other_branch_state_id'],
                                    $decoded_data['other_branch_city_id'],
                                    $decoded_data['other_branch_circle_id'],
                                    $decoded_data['active'],
                                    $decoded_data['commi_slab'],
                                    $decoded_data['apprisal_letter'],
                                    $decoded_data['apprisal_letter_two']
                                );
                                
                                 $modal_id = 'detailsModal' . $sr_no; 
                                ?>
                                <tr>
                                   
                                    <td><?= $sr_no++ ?></td>
                                    <td><?= htmlspecialchars($decoded_data['partner_name'] ?? 'N/A') ?></td>
                                    <td><?= htmlspecialchars($decoded_data['user_name'] ?? 'N/A') ?></td>
                                    <td><?= htmlspecialchars($decoded_data['login_code'] ?? 'N/A') ?></td>
                                    <td><?= htmlspecialchars($decoded_data['los_id'] ?? 'N/A') ?></td>
                                    <td><?= htmlspecialchars($decoded_data['rr_cbs_acct_no'] ?? 'N/A') ?></td>
                                    <td><?= htmlspecialchars($decoded_data['loan_type_name'] ?? 'N/A') ?></td>
                                    <td> <?= ($decoded_data['loan_type_id'] ?? null) == 5 
                                            ? htmlspecialchars($decoded_data['rinnraksha_amt'] ?? 'N/A') 
                                            : htmlspecialchars($decoded_data['sanction_amt'] ?? 'N/A') ?></td>
                                    <td><?= htmlspecialchars($decoded_data['branch_name'] ?? 'N/A') ?></td>
                                    
                                    <td><?= date('F d, Y h:i A', strtotime($entry['deleted_date'])) ?></td>
                                    <td><?= htmlspecialchars($entry['deleted_by_name']) ?></td>
                                     <!--<td>
                                        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#<?= $modal_id ?>">View Details</button>
                                    </td>-->
                                </tr>
                             
                                <!-- Modal for details -->
                                <div class="modal fade" id="<?= $modal_id ?>" tabindex="-1" aria-labelledby="<?= $modal_id ?>Label" aria-hidden="true">
                                    <div class="modal-dialog modal-lg">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="<?= $modal_id ?>Label">Details</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <ul>
                                                    <?php foreach ($decoded_data as $key => $value) : ?>
                                                        <li><strong><?= htmlspecialchars($key) ?>:</strong> <?= htmlspecialchars($value) ?></li>
                                                    <?php endforeach; ?>
                                                </ul>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach;
                        else : ?>
                            <tr>
                                <td colspan="5" align="center">Sorry, no records available!</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<script>
$(document).ready(function () {
    var table = $('#Table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '<?= base_url("admin/fetch_deleted_cases") ?>',
            type: 'POST',
            data: function (d) {
                d.applicants = $('#applicants').val();
            }
        },
        columns: [
            { title: "Sr. No" },
            { title: "Partner Name" },
            { title: "Applicant Name" },
            { title: "Login Code" },
            { title: "RLMS ID" },
            { title: "CBS Account No" },
            { title: "Loan Type" },
            { title: "Sanction Loan Amt" },
            { title: "Branch" },
            { title: "Deleted Date" },
            { title: "Deleted By" }
           /* { title: "Actions", orderable: false, searchable: false }*/
        ]
    });

    $('#filterSubmit').on('click', function () {
        table.ajax.reload();
    });
    
    $('#resetButton').on('click', function() {
         $('.single-select').each(function() {
            $(this).val('all').trigger('change'); // Works for select2 or similar plugins
        });
    $('#filterForm')[0].reset();
    table.ajax.reload();
  });
});

</script>
