<main class="page-content">
    <!-- Breadcrumb -->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"><?= $title ?></div>
    </div>
    <!-- End Breadcrumb -->

    <div class="card">
        <div class="card-header py-3">
            <div class="row align-items-center m-0">
                <div class="col-md-4 col-12 me-auto mb-md-0 mb-3"></div>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
       
<table class="table align-middle table-striped" id="Table">
    <thead>
        <tr>
            <th>Sr. No</th>
            <th>Invoice No</th>
            <th>Users</th>
            <th>Net Pay</th>
            <th>Paid Amt</th>
            <th>Status</th>
            <th>Payment Log</th>
            <th>Deleted Date</th>
            <th>Deleted By</th>
        </tr>
    </thead>
    <tbody>
        <?php if (!empty($deleted_payment)) : 
            $sr_no = 1;

            // Grouping deleted payment logs by invoice_batchno
            $grouped_payments = [];
            foreach ($deleted_payment as $row) {
                $grouped_payments[$row['invoice_batchno']][] = $row;
            }

            foreach ($grouped_payments as $batch_no => $entries): 
                // Fetch user_ids from invoices table based on inv_batchno
                $invoice_data = $this->db->select('user_id')
                    ->from('invoices')
                    ->where('inv_batchno', $batch_no)
                    ->get()
                    ->result_array();

                $user_ids = array_column($invoice_data, 'user_id'); // Extract user_ids as an array

                // Fetch user names from mst_user
                $users = !empty($user_ids)
                    ? $this->db->select('
                            mst_user.user_name, 
                            mst_loan_type.name AS loan_type_name, 
                            mst_user.loan_type_id, 
                            mst_user.rinnraksha_amt, 
                            mst_user.sanction_amt
                        ')
                        ->from('mst_user')
                        ->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id', 'left')
                        ->where_in('mst_user.id', $user_ids)
                        ->get()
                        ->result_array()
                    : [];

                // Generate user list
                $user_list = !empty($users)
                    ? implode('<br>', array_map(function ($u, $index) {
                        $loan_amt = ($u['loan_type_id'] == 5) ? $u['rinnraksha_amt'] : $u['sanction_amt'];
                        return ($index + 1) . ') ' . $u['user_name'] . ' (' . $u['loan_type_name'] . ') - Loan Amt: ' . number_format($loan_amt, 2);
                    }, $users, array_keys($users)))
                    : 'No users found';

                // Get the first entry for displaying common data
                $first_entry = $entries[0];

                // Initialize variables for Net Pay, Paid Amt, and Status
                $net_pay = 'N/A';
                $paid_amt = 0;
                $status = 'N/A';

                // Calculate Net Pay, Paid Amt, and Status
                foreach ($entries as $entry) {
                    $payment_log_details = json_decode($entry['payment_log'], true); // Decode the JSON log
                    if (!empty($payment_log_details)) {
                        if (isset($payment_log_details['net_pay'])) {
                            $net_pay = number_format($payment_log_details['net_pay'], 2);
                        }
                        if (isset($payment_log_details['pay_amt'])) {
                            $paid_amt += $payment_log_details['pay_amt'];
                        }
                        if (isset($payment_log_details['status'])) {
                            $status = htmlspecialchars($payment_log_details['status']);
                        }
                    }
                }
                ?>
                <tr>
                    <td><?= $sr_no++ ?></td>
                    <td><?= $first_entry['invoice_number'] ?></td>
                    <td><?= $user_list ?></td>
                    <td><?= $net_pay ?></td>
                    <td><?= number_format($paid_amt, 2) ?></td>
                    <td><?= $status ?></td>
                    <td>
                        <?php foreach ($entries as $entry): 
                            $payment_log_details = json_decode($entry['payment_log'], true); // Decode the JSON log
                            if (!empty($payment_log_details)): ?>
                                <p>
                                   <strong>Pay Date:</strong> 
<?= !empty($payment_log_details['payment_date']) 
    ? date('d.m.Y', strtotime($payment_log_details['payment_date'])) 
    : 'N/A' ?><br>

                                    <strong>Pay Amt:</strong> <?= !empty($payment_log_details['pay_amt']) ? number_format($payment_log_details['pay_amt'], 2) : 'N/A' ?><br>
                                    <strong>Ref No/Cheq No:</strong> <?= !empty($payment_log_details['ref_no']) ? htmlspecialchars($payment_log_details['ref_no']) : 'N/A' ?><br>
                                    <strong>Remark:</strong> <?= !empty($payment_log_details['remark']) ? htmlspecialchars($payment_log_details['remark']) : 'N/A' ?><br>
                                </p>
                            <?php else: ?>
                                <p>No details found in payment log.</p>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </td>
                    <td><?= date('F d, Y h:i A', strtotime($first_entry['deleted_date'])) ?></td>
                    <td><?= htmlspecialchars($first_entry['staff_fullname']) ?></td>
                </tr>
            <?php endforeach;
        else : ?>
            <tr>
                <td colspan="9" align="center">Sorry, no records available!</td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>


            </div>
        </div>
    </div>
</main>

<script>
$(document).ready(function() {
    var table = $('#Table').DataTable({
        "lengthChange": true,
        "lengthMenu": [[10, 25, 50, 200, -1], [10, 25, 50, 200, "All"]],
        "buttons": [
            { extend: 'copy', text: 'Copy' },
            { extend: 'excel', text: 'Excel' },
            { extend: 'pdf', text: 'PDF' },
            {
                extend: 'print',
                text: 'Print',
                customize: function(win) {
                    $(win.document.body).find('h1').text('Deleted Invoice Log');
                }
            }
        ]
    });

    table.buttons().container().appendTo('#Table_wrapper .col-md-6:eq(0)');
});
</script>

<style>
    .dataTables_length {
        margin-bottom: 13px;
    }
    .dataTables_filter {
        margin-top: 12px;
    }
</style>
