<main class="page-content">
    <!--breadcrumb-->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"><?= $title ?></div>
    </div>
    <!--end breadcrumb-->
    <div class="card">
        <div class="card-header py-3">
            <div class="row align-items-center m-0">
                <div class="col-md-4 col-12 me-auto mb-md-0 mb-3"></div>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table align-middle table-striped" id="Table">
                    <thead>
                        <tr>
                            <th>Sr.No</th>
                            <th>Batch Number</th>
                            <th>Users</th>
                            <th>Deleted Date</th>
                            <th>Deleted By</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if (!empty($deleted_invoice)) {
                            $batch_group = [];
                            foreach ($deleted_invoice as $row) {
                                // Group by inv_batchno
                                $batch_group[$row['inv_batchno']][] = $row;
                            }

                            $sr_no = 1;
                            foreach ($batch_group as $batch_no => $entries) {
                                // Fetch all users in the group
                                $user_ids = [];
                                foreach ($entries as $entry) {
                                    $invoice_data = json_decode($entry['invoice_data'], true);
                                    if (!empty($invoice_data['user_id'])) {
                                        $user_ids[] = $invoice_data['user_id'];
                                    }
                                }
                                $user_ids = array_unique($user_ids);

                                // Fetch user names from mst_user
                                $users = [];
                                        if (!empty($user_ids)) {
                                            $users = $this->db->select('
                                                    mst_user.user_name, 
                                                    mst_loan_type.name AS loan_type_name, 
                                                    mst_user.loan_type_id, 
                                                    mst_user.rinnraksha_amt, 
                                                    mst_user.sanction_amt
                                                ') // Select user details, loan type name, and amounts
                                                ->from('mst_user')
                                                ->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id', 'left') // Join mst_loan_type with mst_user on loan_type_id
                                                ->where_in('mst_user.id', $user_ids) // Filter by user IDs
                                                ->get()
                                                ->result_array();
                                        }
                                        
                                        // Prepare the user list with loan types, loan amounts, and serial numbers
                                        $user_list = !empty($users) 
                                            ? implode('<br>', array_map(
                                                function ($u, $index) {
                                                    // Determine loan amount based on loan_type_id
                                                    $loan_amt = ($u['loan_type_id'] == 5) ? $u['rinnraksha_amt'] : $u['sanction_amt'];
                                                    return ($index + 1) . ') ' . $u['user_name'] . ' (' . $u['loan_type_name'] . ') - Loan Amt: ' . number_format($loan_amt, 2);
                                                },
                                                $users,
                                                array_keys($users)
                                            )) 
                                            : 'No users found';


                                // Display grouped data
                                ?>
                                <tr>
                                    <td><?= $sr_no++ ?></td>
                                    <td><?= $entries[0]['invoice_number'] ?></td>
                                    <td><?= $user_list ?></td>
                                    <td><?= date('F d, Y h:i A', strtotime($entries[0]['deleted_at'])) ?></td>
                                    <td><?= $entries[0]['staff_fullname'] ?></td>
                                </tr>
                                <?php
                            }
                        } else {
                            ?>
                            <tr><td colspan="5" align="center">Sorry no records available!</td></tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <?//= $pagination ?>
        </div>
    </div>
</main>

<script>
$(document).ready(function() {
    var table = $('#Table').DataTable({
        "lengthChange": true,
        "lengthMenu": [[10, 25, 50, 200, -1], [10, 25, 50, 200, "All"]],
        "buttons": [
            { extend: 'copy', text: 'Copy' },
            { extend: 'excel', text: 'Excel' },
            { extend: 'pdf', text: 'PDF' },
            {
                extend: 'print',
                text: 'Print',
                customize: function(win) {
                    $(win.document.body).find('h1').text('Deleted Invoice Log');
                }
            }
        ]
    });

    table.buttons().container().appendTo('#Table_wrapper .col-md-6:eq(0)');
});
</script>

<style>
    .dataTables_length {
        margin-bottom: 13px;
    }
    .dataTables_filter {
        margin-top: 12px;
    }
</style>
