<?php

class Pbsbiannx_download_list_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        $db_group = $this->session->userdata('db_group') ?? 'default';
        $this->db = $this->load->database($db_group, TRUE);
        date_default_timezone_set('Asia/Kolkata');
    }

    private function apply_filters($search, $start_date, $end_date, $status, $conn_id, $branch_id, $applicant_invoice_status, $sbi_genrated, $hlc_invoice_status, $hlc_paid_status, 
        $city_id, $pb_payment_status, $disb_month_year, $pb_generated, $branch_generated, $partner_generated, $rbo, $created_by_part, $team_leader, $circle) {

        if (!empty($start_date) && !empty($end_date)) {
            $this->db->where("mst_user.pbsbi_branch_annx_download_date >=", $start_date);
            $this->db->where("mst_user.pbsbi_branch_annx_download_date <=", date('Y-m-d', strtotime($end_date . ' +1 day')));
        }

        if (!empty($disb_month_year)) {
            list($disb_year, $disb_month) = explode('-', $disb_month_year);
            $this->db->where('MONTH(mst_user.disb_date)', $disb_month);
            $this->db->where('YEAR(mst_user.disb_date)', $disb_year);
        }

        if (!empty($search)) {
            $this->db->group_start();
            $searchable_fields = [
                'mst_user.user_name'
            ];
            foreach ($searchable_fields as $field) {
                $this->db->or_like($field, $search);
            }
            $this->db->group_end();
        }

        if ($this->session->userdata('staff_type') == 1) {
            $this->db->where('mst_user.connector_id', $this->session->userdata('staff_id'));
        }
    }

    public function get_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset, $applicant_invoice_status, $sbi_genrated, $hlc_invoice_status, $hlc_paid_status, $city_id, $pb_payment_status, $disb_month_year, $pb_generated, $branch_generated, $partner_generated, $rbo, $created_by_part, $team_leader, $circle) {
        $this->db->select('mst_user.*, mst_staff.staff_fullname as pbsbi_branch_annx_download_by_name');
        $this->db->from('mst_user');
        $this->db->join('mst_staff', 'mst_user.pbsbi_branch_annx_download_by = mst_staff.staff_id');
        $this->db->where('mst_user.pbsbi_branch_annx_download_status', 1);

        $this->apply_filters($search, $start_date, $end_date, $status, $conn_id, $branch_id, $applicant_invoice_status, $sbi_genrated, $hlc_invoice_status, $hlc_paid_status, $city_id, $pb_payment_status, $disb_month_year, $pb_generated, $branch_generated, $partner_generated, $rbo, $created_by_part, $team_leader, $circle);

        if ($limit != -1) {
            if ($limit !== '' && $offset !== '') {
                $this->db->limit($limit, $offset);
            } elseif ($limit !== '') {
                $this->db->limit($limit);
            }
        }

        $this->db->group_by('mst_user.pbsbi_branch_annx_download_key');
        $this->db->order_by('mst_user.pbsbi_branch_annx_download_date','DESC');
        return $this->db->get()->result_array();
    }

    public function count_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, $applicant_invoice_status, $sbi_genrated, $hlc_invoice_status, $hlc_paid_status, $city_id, $pb_payment_status, $disb_month_year, $pb_generated, $branch_generated, $partner_generated, $rbo, $created_by_part, $team_leader, $circle) {
        $this->db->select('COUNT(*) as total');
        $this->db->from('mst_user');
        $this->db->join('mst_staff', 'mst_user.pbsbi_branch_annx_download_by = mst_staff.staff_id');
        $this->db->where('mst_user.pbsbi_branch_annx_download_status', 1);

        $this->apply_filters($search, $start_date, $end_date, $status, $conn_id, $branch_id, $applicant_invoice_status, $sbi_genrated, $hlc_invoice_status, $hlc_paid_status, $city_id, $pb_payment_status, $disb_month_year, $pb_generated, $branch_generated, $partner_generated, $rbo, $created_by_part, $team_leader, $circle);

        if ($this->session->userdata('staff_type') == 1) {
            $this->db->where('mst_user.connector_id', $this->session->userdata('staff_id'));
        }

        return $this->db->get()->row()->total;
    }

    public function get_batchwise_total_sanction_amt($search, $start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset, $applicant_invoice_status, $sbi_genrated, $hlc_invoice_status, $hlc_paid_status, $city_id, $pb_payment_status, $disb_month_year, $pb_generated, $branch_generated, $partner_generated, $rbo, $created_by_part, $team_leader, $circle) {
    $this->db->select("
        pbsbi_branch_annx_download_key,
        COUNT(*) as total_applicants,
        SUM(
            CASE 
                WHEN loan_type_id = 5 THEN CAST(REPLACE(rinnraksha_amt, ',', '') AS DECIMAL(15,2))
                ELSE CAST(REPLACE(sanction_amt, ',', '') AS DECIMAL(15,2))
            END
        ) as total_amt
    ");
    $this->db->from('mst_user');
    $this->db->where('pbsbi_branch_annx_download_status', 1);

    $this->apply_filters($search, $start_date, $end_date, $status, $conn_id, $branch_id, $applicant_invoice_status, $sbi_genrated, $hlc_invoice_status, $hlc_paid_status, $city_id, $pb_payment_status, $disb_month_year, $pb_generated, $branch_generated, $partner_generated, $rbo, $created_by_part, $team_leader, $circle);

    $this->db->group_by('pbsbi_branch_annx_download_key');
    $query = $this->db->get()->result_array();

    $result = [];
    foreach ($query as $row) {
        $key = $row['pbsbi_branch_annx_download_key'];
        $result[$key] = [
            'total_amt' => $row['total_amt'],
            'total_applicants' => $row['total_applicants']
        ];
    }

    return $result;
}


public function get_pbsbiannx_download_list_excel($filters = [],$batch_no) {
    $this->db->select('branch.branch_name, 
                      branch.branch_code,
                      mst_user.user_name,
                      mst_user.disb_date,
                      mst_user.sanction_amt,
                      mst_user.rinnraksha_amt,
                      mst_user.bank_acct_no,
                      mst_user.rr_cbs_acct_no,
                      mst_user.los_id,
                      mst_user.status,
                      mst_user.loan_type_id,
                      mst_user.branch_id,
                      mst_user.commi_slab,
                      mst_user.sbi_commi,
                      mst_user.pb_commi,
                      mst_user.sbi_pb_invoice_no,
                      mst_user.sbi_pb_payment_status,
                      mst_user.invoice_id,
                      mst_user.id,
                      mst_user.hlc_payment_status,
                      mst_user.part_payout,
                      mst_user.pb_payment_status,
                      mst_user.add_date,
                      mst_user.connector_id,
                      mst_user.verify_by,
                      mst_user.is_verify,
                      mst_user.pb_genrated,
                      mst_user.pb_invoice_id,
                      mst_user.applicant_invoice_status,
                      mst_user.pbsbi_branch_annx_download_key,
                      mst_user.pb_branch_annx_no,
                      mst_user.pb_branch_annx_date,
                      mst_user.login_code,
                      mst_user.pb_to_sbi_remuneration,
                      mst_rbo.rbo_name,
                      mst_loan_type.name as account_type,
                      mst_city.city_name,
                      mst_city.agency_code,
                      mst_city.agency_name,
                      mst_state.state_name,
                      mst_staff.staff_fullname, 
                      mst_staff.conn_commision, 
                      mst_staff.hlc_code'); // Add more fields as needed
    $this->db->from('mst_user');
    $this->db->join('branch', 'mst_user.branch_id = branch.id','left');
    $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
    $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
    $this->db->join('mst_state', 'mst_city.state_id = mst_state.id');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');  // Join with mst_staff table

    $this->db->where('mst_user.login_code', 'PaisaBazaar');
    $this->db->where('mst_user.is_archive', 'No');
    
    if (!empty($filters['start_date'])) {
        $this->db->where('mst_user.disb_date >=', $filters['start_date']);
    }
    if (!empty($filters['end_date'])) {
        $this->db->where('mst_user.disb_date <=', $filters['end_date']);
    }

    // Example: Branch
    if (!empty($filters['branch'])) {
        $this->db->where('mst_user.branch_id', $filters['branch']);
    }

    // Example: Connector
    if (!empty($filters['connector'])) {
        $this->db->where('mst_user.connector_id', $filters['connector']);
    }

    // Example: Payment status (if you want to override the default statuses)
    if (!empty($filters['hlc_status'])) {
        // If you need multiple statuses, use where_in(); if single, do a normal where:
        $this->db->where('mst_user.hlc_payment_status', $filters['hlc_status']);
    }

    // Example: State or city
    if (!empty($filters['state_id'])) {
        $this->db->where('mst_state.id', $filters['state_id']);
    }
    if (!empty($filters['city_id'])) {
        $this->db->where('branch.city_id', $filters['city_id']);
    }

    // Example: Disb month
    // "YYYY-MM" -> from the 1st to the last day of that month
    if (!empty($filters['disb_month'])) {
        $firstOfMonth = $filters['disb_month'] . '-01';
        $lastOfMonth = date('Y-m-t', strtotime($firstOfMonth));
        $this->db->where('mst_user.disb_date >=', $firstOfMonth);
        $this->db->where('mst_user.disb_date <=', $lastOfMonth);
    }
    $this->db->where('pbsbi_branch_annx_download_status', 1);
    $this->db->where('mst_user.pbsbi_branch_annx_download_key',$batch_no);
   
    
    $query = $this->db->get();
    
    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return array();
    }
}


}
?>
