<?php

class PBsbibranchannx_model extends CI_Model {

    public function __construct() {
        
        parent::__construct();
        
        $db_group = $this->session->userdata('db_group') ?? 'default';
        $this->db = $this->load->database($db_group, TRUE);
        date_default_timezone_set('Asia/Kolkata');
    }
    
    

    private function apply_filters($search, $start_date, $end_date, $status, $conn_id, $branch_id, $applicant_invoice_status, $sbi_genrated, $hlc_invoice_status, $hlc_paid_status, $city_id, $pb_payment_status, $disb_month_year, $pb_generated,$branch_generated,$partner_generated,$rbo,$created_by_part,$pb_sbi_branch_annx_blank) {
        if (!empty($start_date) && !empty($end_date)) {
            $this->db->where("mst_user.add_date >=", $start_date);
            $this->db->where("mst_user.add_date <=", date('Y-m-d', strtotime($end_date . ' +1 day')));
        }
        if (!empty($status)) {
            $this->db->where('mst_user.status', $status);
        }
        if (!empty($conn_id)) {
            $this->db->where('mst_user.connector_id', $conn_id);
        }
        if (!empty($branch_id)) {
            $this->db->where('mst_user.branch_id', $branch_id);
        }
        if (!empty($applicant_invoice_status)) {
            $this->db->where('mst_user.applicant_invoice_status IS NULL');
        }
        if (!empty($sbi_genrated)) {
            $this->db->where('mst_user.pb_genrated', $sbi_genrated);
        }
        if (!empty($hlc_invoice_status)) {
            $this->db->where('mst_user.applicant_invoice_status', $hlc_invoice_status);
        }
        if (!empty($city_id)) {
            $this->db->where('branch.city_id', $city_id);
        }
        if (!empty($hlc_paid_status)) {
            if ($hlc_paid_status === 'unpaid') {
                $this->db->where('mst_user.hlc_payment_status', NULL, true);
                $this->db->where('mst_user.disb_status', 'yes');
            } else {
                $this->db->where('mst_user.hlc_payment_status', $hlc_paid_status);
            }
        }
        if (!empty($pb_payment_status)) {
            if ($pb_payment_status === 'unpaid') {
                $this->db->where('mst_user.pb_payment_status', NULL, true);
                $this->db->where('mst_user.pb_genrated', 'Yes');
            } else {
                $this->db->where('mst_user.pb_payment_status', $pb_payment_status);
            }
        }
        if (!empty($disb_month_year)) {
            list($disb_year, $disb_month) = explode('-', $disb_month_year);
            $this->db->where('MONTH(mst_user.disb_date)', $disb_month);
            $this->db->where('YEAR(mst_user.disb_date)', $disb_year);
        }
         if (!empty($pb_generated)) {
            $this->db->where('mst_user.pb_genrated', $pb_generated);
        }
         if (!empty($branch_generated)) {
             if($branch_generated==='No'){
                 $this->db->where('mst_user.branch_genrated', NULL, true);
             }else{
                 $this->db->where('mst_user.branch_genrated', $branch_generated);
             }
        }
         if (!empty($partner_generated)) {
             if($partner_generated==='No'){
                 $this->db->where('mst_user.applicant_invoice_status', NULL, true);
             }else{
                 $this->db->where('mst_user.applicant_invoice_status', 'Generated');
             }
        }
        
        if (!empty($pb_sbi_branch_annx_blank)) {
                if ($pb_sbi_branch_annx_blank === 'No') {
                    // Exclude NULL entries (Only show non-blank values)
                    $this->db->where('mst_user.pb_branch_annx_no IS NOT NULL', null, false);
                } elseif ($pb_sbi_branch_annx_blank === 'Yes') {
                    // Only show blank (NULL) entries
                    $this->db->where('mst_user.pb_branch_annx_no', NULL, true);
                } 
            }
            
        if (!empty($rbo)) {
        $this->db->where('branch.rbo_id', $rbo);
    }
    
    if (!empty($created_by_part)) {
            $this->db->where('created_by_staff.staff_fullname', $created_by_part);
        }

        if (!empty($search)) {
            $this->db->group_start();
            $this->db->like('mst_user.user_name', $search);
            $this->db->or_like('mst_user.los_id', $search);
            $this->db->or_like('mst_user.bank_acct_no', $search);
            $this->db->or_like('mst_user.user_phone', $search);
            $this->db->or_like('mst_user.user_email', $search);
            $this->db->or_like('mst_user.user_address', $search);
            $this->db->or_like('mst_user.applicant_rr_id', $search);
            $this->db->or_like('mst_user.rr_cbs_acct_no', $search);
            $this->db->or_like('mst_user.sanction_amt', $search);
            $this->db->or_like('mst_user.status', $search);
            $this->db->or_like('mst_user.disb_status', $search);
            $this->db->or_like('mst_user.hlc_payment_status', $search);
            $this->db->or_like('mst_user.pb_payment_status', $search);
            $this->db->or_like('mst_user.login_code', $search);
            $this->db->or_like('mst_user.pbsbi_branch_annx_download_key', $search);
            $this->db->or_like('mst_user.pb_branch_annx_no', $search);
            $this->db->or_like('branch.branch_name', $search);
            $this->db->or_like('branch.branch_code', $search);
            $this->db->or_like('mst_city.city_name', $search);
            $this->db->or_like('mst_city.agency_code', $search);
            $this->db->or_like('mst_city.agency_name', $search);
            $this->db->or_like('mst_rbo.rbo_name', $search);
            $this->db->or_like('mst_loan_type.name', $search);
            $this->db->or_like('mst_staff.staff_fullname', $search);
            $this->db->or_like('mst_staff.hlc_code', $search);
            $this->db->or_like('mst_user.sbi_pb_invoice_no', $search);
            $this->db->or_like('created_by_staff.staff_fullname', $search);
            $this->db->group_end();
        }

        $staff_type = $this->session->userdata('staff_type');
        if ($staff_type == 1) {
            $current_staff_id = $this->session->userdata('staff_id');
            $this->db->where('mst_user.connector_id', $current_staff_id);            
        }
        
    }

    public function get_applicant_data(
    $search, $start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset, 
    $applicant_invoice_status, $sbi_genrated, $hlc_invoice_status, $hlc_paid_status, 
    $city_id, $pb_payment_status, $disb_month_year, $pb_generated, $branch_generated, 
    $partner_generated, $rbo, $created_by_part, $pb_sbi_branch_annx_blank
) {
    $this->db->select([
        'mst_user.id', 'mst_user.los_id', 'mst_user.loan_type_id', 'mst_user.applicant_rr_id','mst_user.pbsbi_branch_annx_invoice_download_status',
        'mst_user.connector_id', 'mst_user.user_name', 'mst_user.branch_id', 'mst_user.state_id', 
        'mst_user.city_id', 'mst_user.sanction_amt', 'mst_user.rinnraksha_amt', 'mst_user.bank_acct_no', 
        'mst_user.rr_cbs_acct_no', 'mst_user.disb_date', 'mst_user.disb_status', 
        'mst_user.rinnraksha_status', 'mst_user.user_phone', 'mst_user.user_email', 
        'mst_user.user_address', 'mst_user.other_branch', 'mst_user.other_branch_code', 
        'mst_user.other_branch_state_id', 'mst_user.other_branch_city_id', 'mst_user.other_branch_circle_id', 
        'mst_user.remark', 'mst_user.status', 'mst_user.applicant_invoice_status', 'mst_user.invoice_id', 
        'mst_user.hlc_payment_status', 'mst_user.sbi_commi', 'mst_user.part_payout', 
        'mst_user.sbi_genrated', 'mst_user.sbi_invoice_id', 'mst_user.sbi_payment_status', 
        'mst_user.branch_genrated', 'mst_user.branch_invoice_id', 'mst_user.pb_genrated', 
        'mst_user.pb_invoice_id', 'mst_user.pb_commi', 'mst_user.pb_payment_status', 
        'mst_user.pb_pending_approve', 'mst_user.pb_branch_annx_no', 'mst_user.sbi_pb_invoice_no', 
        'mst_user.pb_sbi_invoice_date', 'mst_user.pb_sbi_input_by', 'mst_user.pba_input_date', 
        'mst_user.pb_branch_annx_date', 'mst_user.sbi_pb_payment_status', 'mst_user.pb_branch_conf_no', 
        'mst_user.pblba_handoverto', 'mst_user.pblba_handover_date', 'mst_user.pblba_handover_by', 
        'mst_user.pblba_ack_file', 'mst_user.pbrbo_invoices_handover_to', 'mst_user.pbrbo_invoices_handover_input_by', 
        'mst_user.pbrbo_invoices_handover_input_date', 'mst_user.pbrbo_invoices_ack_file', 'mst_user.commi_slab', 
        'mst_user.apprisal_letter', 'mst_user.apprisal_letter_two', 'mst_user.is_verify', 'mst_user.verify_by','mst_user.pbsbi_branch_annx_download_key', 
        'mst_user.login_code', 'mst_user.active', 'mst_user.is_archive', 'mst_user.archive_remark', 
        'mst_user.todays_payment', 'mst_user.payment_verified_by', 'mst_user.payment_approve_status', 
        'mst_user.payment_approved_by', 'mst_user.payment_act_remark', 'mst_user.payment_send_date', 
        'mst_user.payment_approval_date', 'mst_user.add_date', 'mst_user.created_by',
        'mst_staff.staff_fullname',
        'mst_loan_type.name as user_type', 
        'branch.branch_name', 'branch.branch_code', 
        'mst_city.city_name', 
        'mst_rbo.rbo_name', 
        'created_by_staff.staff_fullname as created_by_fullname'
    ]);

    $this->db->from('mst_user');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id', 'left');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id', 'left');
    $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
    $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
    $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
    $this->db->join('mst_staff as created_by_staff', 'mst_user.created_by = created_by_staff.staff_id', 'left');

    $this->db->where([
        'mst_user.login_code' => 'PaisaBazaar',
        'mst_user.is_archive' => 'No',
        'mst_user.is_verify'  => '1'
    ]);
    $this->db->where('mst_user.pb_branch_annx_no IS NOT NULL', null, false);

    // Apply dynamic filters
    $this->apply_filters(
        $search, $start_date, $end_date, $status, $conn_id, $branch_id, 
        $applicant_invoice_status, $sbi_genrated, $hlc_invoice_status, 
        $hlc_paid_status, $city_id, $pb_payment_status, $disb_month_year, 
        $pb_generated, $branch_generated, $partner_generated, $rbo, 
        $created_by_part, $pb_sbi_branch_annx_blank
    );

    // Apply limit and offset if provided
    if ($limit > 0) {
        $this->db->limit($limit, ($offset ?: 0));
    }

    $this->db->order_by('mst_user.add_date', 'desc');
    
    $query = $this->db->get();
    return $query->result_array();
}


    public function count_applicant_data(
    $search, $start_date, $end_date, $status, $conn_id, $branch_id, 
    $applicant_invoice_status, $sbi_genrated, $hlc_invoice_status, $hlc_paid_status, 
    $city_id, $pb_payment_status, $disb_month_year, $pb_generated, $branch_generated, 
    $partner_generated, $rbo, $created_by_part, $pb_sbi_branch_annx_blank
) {
    $this->db->select('COUNT(*) as total');
    $this->db->from('mst_user');
    
    // Joins only necessary tables to avoid overhead
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id', 'left');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id', 'left');
    $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
    $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
    $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
    $this->db->join('mst_staff as created_by_staff', 'mst_user.created_by = created_by_staff.staff_id', 'left');

    // Fixed the incorrect join reference in created_by_staff
    // Changed 'mst_staff.created_by' to 'mst_user.created_by'

    // Applying fixed conditions
    $this->db->where([
        'mst_user.login_code' => 'PaisaBazaar',
        'mst_user.is_archive' => 'No',
        'mst_user.is_verify'  => '1',
    ]);
    $this->db->where('mst_user.pb_branch_annx_no IS NOT NULL', null, false);

    // Apply dynamic filters
    $this->apply_filters(
        $search, $start_date, $end_date, $status, $conn_id, $branch_id, 
        $applicant_invoice_status, $sbi_genrated, $hlc_invoice_status, 
        $hlc_paid_status, $city_id, $pb_payment_status, $disb_month_year, 
        $pb_generated, $branch_generated, $partner_generated, $rbo, 
        $created_by_part, $pb_sbi_branch_annx_blank
    );

    // Restrict query for staff_type = 1
    $staff_type = $this->session->userdata('staff_type');
    if ($staff_type == 1) {
        $current_staff_id = $this->session->userdata('staff_id');
        $this->db->where('mst_user.connector_id', $current_staff_id);
    }

    $query = $this->db->get();
    return $query->row()->total;
}

    

public function get_optimized_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset, $hlc_paid_st, $city_id, $pb_payment_status, $disb_month_year, $pb_generated, $branch_generated, $partner_generated, $rbo, $created_by_part, $pb_sbi_branch_annx_blank) {
    
    $this->db->select("
        mst_user.id,
        mst_user.user_name AS applicant_name,
        mst_user.los_id AS rlms_id,
        mst_user.bank_acct_no,
        mst_user.rr_cbs_acct_no,
        mst_user.sanction_amt,
        mst_user.rinnraksha_amt,
        mst_user.rinnraksha_status,
        mst_user.pb_branch_annx_no,
        mst_user.pb_branch_annx_date,
        mst_user.disb_date,
        mst_user.pb_payment_status,
        mst_user.hlc_payment_status,
        mst_user.pb_sbi_input_by,
        mst_user.pba_input_date,
        mst_user.pbsbi_branch_annx_invoice_download_status,
        mst_user.status,
        branch.branch_name,
        branch.branch_code,
        mst_city.city_name,
        mst_state.state_name,
        mst_rbo.rbo_name,
        mst_staff.staff_fullname AS hlc_name,
        mst_staff.hlc_code,
        mst_loan_type.name as loan_type,
        created_by_staff.staff_fullname AS created_by,
        IF(mst_user.rinnraksha_status='Yes' AND mst_user.applicant_rr_id IS NULL, mst_user.rr_cbs_acct_no, mst_user.bank_acct_no) AS cbs_account_no,
        IF(mst_user.rinnraksha_status='Yes' AND mst_user.applicant_rr_id IS NULL, mst_user.rinnraksha_amt, mst_user.sanction_amt) AS sanction_loan_amt,
        DATE_FORMAT(mst_user.disb_date, '%d-%m-%Y') AS formatted_disb_date
    ");

    $this->db->from('mst_user');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id', 'left');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id', 'left');
    $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
    $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
    $this->db->join('mst_state', 'mst_user.state_id = mst_state.id', 'left');
    $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
    $this->db->join('mst_staff as created_by_staff', 'mst_user.created_by = created_by_staff.staff_id', 'left');
    
    $this->db->where([
        'mst_user.login_code' => 'PaisaBazaar',
        'mst_user.is_archive' => 'No',
        'mst_user.is_verify'  => '1'
    ]);

    // Apply filters dynamically
    if (!empty($start_date) && !empty($end_date)) {
        $this->db->where("mst_user.add_date >=", $start_date);
        $this->db->where("mst_user.add_date <=", date('Y-m-d', strtotime($end_date . ' +1 day')));
    }
    if (!empty($status)) $this->db->where('mst_user.status', $status);
    if (!empty($conn_id)) $this->db->where('mst_user.connector_id', $conn_id);
    if (!empty($branch_id)) $this->db->where('mst_user.branch_id', $branch_id);
    if (!empty($city_id)) $this->db->where('mst_user.city_id', $city_id);
    if (!empty($rbo)) $this->db->where('branch.rbo_id', $rbo);
    if (!empty($created_by_part)) $this->db->where('created_by_staff.staff_fullname', $created_by_part);

    if (!empty($pb_sbi_branch_annx_blank)) {
        if ($pb_sbi_branch_annx_blank === 'No') {
            $this->db->where('mst_user.pb_branch_annx_no IS NOT NULL', null, false);
        } elseif ($pb_sbi_branch_annx_blank === 'Yes') {
            $this->db->where('mst_user.pb_branch_annx_no', NULL, true);
        }
    }

    if (!empty($search)) {
        $this->db->group_start();
            $this->db->like('mst_user.user_name', $search);
            $this->db->or_like('mst_user.los_id', $search);
            $this->db->or_like('mst_user.bank_acct_no', $search);
            $this->db->or_like('mst_user.user_phone', $search);
            $this->db->or_like('mst_user.user_email', $search);
            $this->db->or_like('mst_user.user_address', $search);
            $this->db->or_like('mst_user.applicant_rr_id', $search);
            $this->db->or_like('mst_user.rr_cbs_acct_no', $search);
            $this->db->or_like('mst_user.sanction_amt', $search);
            $this->db->or_like('mst_user.status', $search);
            $this->db->or_like('mst_user.disb_status', $search);
            $this->db->or_like('mst_user.pb_payment_status', $search);
            $this->db->or_like('mst_user.login_code', $search);
            $this->db->or_like('mst_user.pb_branch_annx_no', $search);
            $this->db->or_like('branch.branch_name', $search);
            $this->db->or_like('branch.branch_code', $search);
            $this->db->or_like('mst_city.city_name', $search);
            $this->db->or_like('mst_city.agency_code', $search);
            $this->db->or_like('mst_city.agency_name', $search);
            $this->db->or_like('mst_rbo.rbo_name', $search);
            $this->db->or_like('mst_loan_type.name', $search);
            $this->db->or_like('mst_staff.staff_fullname', $search);
            $this->db->or_like('mst_staff.hlc_code', $search);
            $this->db->or_like('mst_user.sbi_pb_invoice_no', $search);
            $this->db->or_like('created_by_staff.staff_fullname', $search);
            $this->db->group_end();
    }

     // Clone query to get total record count before applying pagination
    $queryTotal = clone $this->db;
    $totalRecords = $queryTotal->count_all_results(); // Get total count without limit

    // Apply pagination
    if ($limit != -1) {  // If "All" is selected, do not limit
        $this->db->limit($limit, $offset);
    }

    $this->db->order_by('mst_user.add_date', 'DESC');
    $query = $this->db->get();

    $data = [];
    $sr_no = $offset + 1;  // Correct Sr. No for pagination

    foreach ($query->result_array() as $row) {
        $row['sr_no'] = $sr_no++;
        
        // Determine if the input should be readonly
        $readonly = !empty($row['pb_branch_annx_no']) ? 'readonly' : '';
        $readonly_date = !empty($row['pb_branch_annx_date']) ? 'readonly' : '';

        // Editable fields
        $row['pb_branch_annx_no'] = '
            <input type="text" class="form-control pb-branch-annx-no" 
                   data-id="'.$row['id'].'" value="'.$row['pb_branch_annx_no'].'" 
                   style="width: 200px;" '.$readonly.' />';
        
        $row['pb_branch_annx_date'] = '
            <input type="date" class="form-control pb-branch-annx-date" 
                   data-id="'.$row['id'].'" value="'.$row['pb_branch_annx_date'].'" 
                   style="width: 150px;" '.$readonly_date.' />';

        $row['pba_input_date'] = !empty($row['pba_input_date']) ? date('d-m-Y', strtotime($row['pba_input_date'])) : '';

        // Fetch staff input name
        $pb_sbi_input_by = $this->db->select('staff_fullname')
            ->where(['staff_id' => $row['pb_sbi_input_by']])
            ->from('mst_staff')
            ->get()
            ->row();
        
        $row['pb_sbi_input_by'] = @$pb_sbi_input_by->staff_fullname; 
        
        // Add Edit button for specific staff IDs
        $editBtn = '';
        if (in_array($_SESSION['staff_id'], [14, 498, 752])) {
            $editBtn = '
                <a href="javascript:void(0);" class="text-info edit-btn" data-id="'.$row['id'].'" title="Edit">
                    <i class="bi bi-pencil-fill fs-5"></i>
                </a>';
        }

        $row['edit'] = $editBtn;
        $data[] = $row;
    }

     return [
        "draw" => intval($this->input->post('draw')),
        "recordsTotal" => $totalRecords, // Total records for pagination
        "recordsFiltered" => $totalRecords, // Show the correct filtered count
        "data" => $data
    ];
}

   
    
    
}
?>
