<?php

defined('BASEPATH') OR exit('No direct script access allowed');



if(!function_exists("getTruncatedCCNumber")) {

function getTruncatedCCNumber($ccNum){

        return str_replace(range(0,9), "X", substr($ccNum, 0, -5)) .  substr($ccNum, -5);

    }

    

}

function has_menu_permission($role_id, $menu_name) {
    $CI =& get_instance();
    $CI->load->database();

    // Query to join menu_permissions with mst_menus to check permission
    $query = $CI->db->select('mst_menus.menu_name')
                    ->from('menu_permissions')
                    ->join('mst_menus', 'menu_permissions.menu_id = mst_menus.id')
                    ->where('menu_permissions.role_id', $role_id)
                    ->where('mst_menus.menu_name', $menu_name)
                    ->get();

    // Return true if a record is found (permission granted), otherwise false
    return $query->num_rows() > 0;
}

function getIndianCurrency(float $amount) {
    // Round the amount to 2 decimal places
    $amount = round($amount, 2);

    // Split the amount into the integer and decimal parts
    $num = floor($amount);
    $amount_after_decimal = round(($amount - $num) * 100);

    // Define the words for numbers
    $change_words = array(
        0 => 'Zero', 1 => 'One', 2 => 'Two',
        3 => 'Three', 4 => 'Four', 5 => 'Five', 6 => 'Six',
        7 => 'Seven', 8 => 'Eight', 9 => 'Nine',
        10 => 'Ten', 11 => 'Eleven', 12 => 'Twelve',
        13 => 'Thirteen', 14 => 'Fourteen', 15 => 'Fifteen',
        16 => 'Sixteen', 17 => 'Seventeen', 18 => 'Eighteen',
        19 => 'Nineteen', 20 => 'Twenty', 30 => 'Thirty',
        40 => 'Forty', 50 => 'Fifty', 60 => 'Sixty',
        70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety'
    );

    // Define the place values
    $here_digits = array('', 'Hundred', 'Thousand', 'Lakh', 'Crore');

    // Convert the number to words
    $string = array();
    $count_length = strlen($num);
    $x = 0;
    while ($x < $count_length) {
        $get_divider = ($x == 2) ? 10 : 100;
        $amount_part = floor($num % $get_divider);
        $num = floor($num / $get_divider);
        $x += $get_divider == 10 ? 1 : 2;
        if ($amount_part) {
            $add_plural = (($counter = count($string)) && $amount_part > 9) ? 's' : null;
            $amt_hundred = ($counter == 1 && $string[0]) ? ' and ' : null;
            if ($amount_part < 21) {
                $string[] = $change_words[$amount_part] . ' ' . $here_digits[$counter] . $add_plural . ' ' . $amt_hundred;
            } else {
                $string[] = $change_words[floor($amount_part / 10) * 10] . ' ' . $change_words[$amount_part % 10] . ' ' . $here_digits[$counter] . $add_plural . ' ' . $amt_hundred;
            }
        } else {
            $string[] = null;
        }
    }

    // Correct the string for proper formatting
    $implode_to_Rupees = implode(' ', array_reverse($string));
    $implode_to_Rupees = preg_replace('/\s+/', ' ', $implode_to_Rupees);  // Remove double spaces
    $implode_to_Rupees = str_replace("Zero Thousand", "Thousand", $implode_to_Rupees);  // Remove "Zero Thousand"
    $implode_to_Rupees = str_replace("Zero ", "", $implode_to_Rupees);  // Remove "Zero"

    $get_paise = ($amount_after_decimal > 0) ? "And " . $change_words[intval($amount_after_decimal / 10)] . " " . $change_words[$amount_after_decimal % 10] . ' Paise' : '';

    return trim($implode_to_Rupees) . ' Rupees ' . $get_paise;
}


/*function getIndianCurrency(float $amount) {
        $amount_after_decimal = round($amount - ($num = floor($amount)), 2) * 100;

    // Define the words for numbers
    $change_words = array(
        0 => 'Zero', 1 => 'One', 2 => 'Two',
        3 => 'Three', 4 => 'Four', 5 => 'Five', 6 => 'Six',
        7 => 'Seven', 8 => 'Eight', 9 => 'Nine',
        10 => 'Ten', 11 => 'Eleven', 12 => 'Twelve',
        13 => 'Thirteen', 14 => 'Fourteen', 15 => 'Fifteen',
        16 => 'Sixteen', 17 => 'Seventeen', 18 => 'Eighteen',
        19 => 'Nineteen', 20 => 'Twenty', 30 => 'Thirty',
        40 => 'Forty', 50 => 'Fifty', 60 => 'Sixty',
        70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety'
    );

    // Define the place values
    $here_digits = array('', 'Hundred', 'Thousand', 'Lakh', 'Crore');

    // Convert the number to words
    $string = array();
    $count_length = strlen($num);
    $x = 0;
    while ($x < $count_length) {
        $get_divider = ($x == 2) ? 10 : 100;
        $amount = floor($num % $get_divider);
        $num = floor($num / $get_divider);
        $x += $get_divider == 10 ? 1 : 2;
        if ($amount) {
            $add_plural = (($counter = count($string)) && $amount > 9) ? 's' : null;
            $amt_hundred = ($counter == 1 && $string[0]) ? ' and ' : null;
            if ($amount < 21) {
                $string[] = $change_words[$amount] . ' ' . $here_digits[$counter] . $add_plural . ' ' . $amt_hundred;
            } else {
                $string[] = $change_words[floor($amount / 10) * 10] . ' ' . $change_words[$amount % 10] . ' ' . $here_digits[$counter] . $add_plural . ' ' . $amt_hundred;
            }
        } else {
            $string[] = null;
        }
    }

    // Convert the words to Indian currency format
    $implode_to_Rupees = implode('', array_reverse($string));
    $get_paise = ($amount_after_decimal > 0) ? "And " . ($change_words[intval($amount_after_decimal / 10)] . " " . $change_words[$amount_after_decimal % 10]) . ' Paise' : '';

    return ($implode_to_Rupees ? $implode_to_Rupees . ' Rupees ' : '') . $get_paise;

}*/


function formatIndianNumber($number) {
  // Round up the number to two decimal places
    $rounded_number = round($number, 2);

    // Convert the rounded number to string
    $number_str = strval($rounded_number);

    // Split the number into integral and fractional parts
    $parts = explode('.', $number_str);

    // Format the integral part
    $integral_part = $parts[0];
    $formatted_integral = '';

    // Format the integral part with commas after every two digits if the number has six or more digits
    $len = strlen($integral_part);
    $i = $len - 1;
    $count = 0;
    while ($i >= 0) {
        $formatted_integral = $integral_part[$i] . $formatted_integral;
        $count++;
        if (($count == 3 || $count == 5 || $count == 7) && $i != 0) {
            $formatted_integral = ',' . $formatted_integral;
        }
        $i--;
    }

    // Format the fractional part
    $formatted_fractional = isset($parts[1]) ? '.' . str_pad($parts[1], 2, '0') : '';

    // Combine the formatted integral part with the formatted fractional part
    $formatted_number = $formatted_integral . $formatted_fractional;

    return $formatted_number;
}



function formatIndianNumberPB($number) {
   // Round up the number to two decimal places
    $rounded_number = round($number, 2);

    // Convert the rounded number to string
    $number_str = number_format($rounded_number, 2, '.', '');

    // Split the number into integral and fractional parts
    $parts = explode('.', $number_str);

    // Format the integral part
    $integral_part = $parts[0];
    $formatted_integral = '';

    // Format the integral part with commas after every two digits if the number has six or more digits
    $len = strlen($integral_part);
    $i = $len - 1;
    $count = 0;
    while ($i >= 0) {
        $formatted_integral = $integral_part[$i] . $formatted_integral;
        $count++;

        // After the first three digits from the right, insert a comma every two digits
        if ($count == 3 || ($count > 3 && ($count - 3) % 2 == 0) && $i != 0) {
            $formatted_integral = ',' . $formatted_integral;
        }

        $i--;
    }

    // Format the fractional part
    $formatted_fractional = isset($parts[1]) ? '.' . str_pad($parts[1], 2, '0') : '.00';

    // Combine the formatted integral part with the formatted fractional part
    $formatted_number = $formatted_integral . $formatted_fractional;

    return $formatted_number;
}




?>