<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

if (!function_exists('calculate_rr_commission_multi_year')) {
    function calculate_rr_commission_multi_year($financial_year, $user_data) {
        $CI =& get_instance();
        $CI->load->helper('multiyeardb');

        $db_current = load_database_by_year($financial_year);
        $next_year = get_next_financial_year($financial_year);
        $prev_year = get_previous_financial_year($financial_year);  // Also add previous year

        $premiumAmountCommission = 0;
        $sanctionAmt = 0;
        $main_los_id = null;

        // STEP 1: Check RR in current year DB
        $rr_record_main = $db_current->select('*')
            ->from('mst_user')
            ->where(['loan_type_id' => 5, 'rinnraksha_status' => 'Yes', 'los_id' => $user_data->los_id])
            ->get()->row();

        if ($rr_record_main) {
            $main_los_id = $rr_record_main->los_id;
            log_message('debug', 'Found RR record in current FY: LOS ID ' . $main_los_id);
        } else {
            // STEP 2: Check RR in next year DB
            $db_next = load_database_by_year($next_year);
            $rr_record_next = $db_next->select('*')
                ->from('mst_user')
                ->where(['loan_type_id' => 5, 'rinnraksha_status' => 'Yes', 'los_id' => $user_data->los_id])
                ->get()->row();

            if ($rr_record_next) {
                $main_los_id = $rr_record_next->los_id;
                log_message('debug', 'Found RR record in NEXT FY: LOS ID ' . $main_los_id);
            } else {
                log_message('debug', 'No RR record found in current or next FY.');
            }
        }

        // STEP 3: Multi-year main-case search:
        if (!empty($main_los_id)) {
            $sanctionAmt = 0;
            
            // Check in Current FY
            $main_case_current = $db_current->select('*')
                ->from('mst_user')
                ->where(['los_id' => $main_los_id, 'loan_type_id !=' => 5])
                ->get()->row();

            if ($main_case_current) {
                $sanctionAmt = $main_case_current->sanction_amt;
                log_message('debug', 'Main case found in CURRENT FY: ' . $sanctionAmt);
            } else {
                // If not in current, search previous year DB
                $db_prev = load_database_by_year($prev_year);
                $main_case_prev = $db_prev->select('*')
                    ->from('mst_user')
                    ->where(['los_id' => $main_los_id, 'loan_type_id !=' => 5])
                    ->get()->row();

                if ($main_case_prev) {
                    $sanctionAmt = $main_case_prev->sanction_amt;
                    log_message('debug', 'Main case found in PREVIOUS FY: ' . $sanctionAmt);
                } else {
                    log_message('debug', 'Main case not found in any year.');
                }
            }
        }

        // STEP 4: Apply slab
        if ($sanctionAmt > 0) {
            if ($sanctionAmt < 5000000) {
                $premiumAmountCommission = 4000;
            } elseif ($sanctionAmt == 5000000) {
                $premiumAmountCommission = 4000;
            } elseif ($sanctionAmt > 5000000 && $sanctionAmt <= 10000000) {
                $premiumAmountCommission = 5000;
            } elseif ($sanctionAmt > 10000000) {
                $premiumAmountCommission = 6000;
            }
            log_message('debug', 'Calculated commission: ' . $premiumAmountCommission);
        } else {
            log_message('debug', 'Sanction amount not found. Commission zero.');
        }

        return $premiumAmountCommission;
    }
}


function preload_rr_commissions($financial_year, $los_ids) {
    if (empty($los_ids)) return []; // ✅ prevent SQL error

    $CI =& get_instance();
    $CI->load->helper('multiyeardb');

    $db_current = load_database_by_year($financial_year);
    $db_next = load_database_by_year(get_next_financial_year($financial_year));
    $db_prev = load_database_by_year(get_previous_financial_year($financial_year));

    $commissions = [];

    // STEP 1: Find RR users in CURRENT year
    $rr_current = $db_current->select('los_id')
        ->from('mst_user')
        ->where('loan_type_id', 5)
        ->where('rinnraksha_status', 'Yes')
        ->where_in('los_id', $los_ids)
        ->get()->result();

    $found_los_ids = array_column($rr_current, 'los_id');
    $remaining_los_ids = array_diff($los_ids, $found_los_ids);

    // STEP 2: Find RR users in NEXT year if not found in current
    if (!empty($remaining_los_ids)) {
        $rr_next = $db_next->select('los_id')
            ->from('mst_user')
            ->where('loan_type_id', 5)
            ->where('rinnraksha_status', 'Yes')
            ->where_in('los_id', $remaining_los_ids)
            ->get()->result();

        $rr_current = array_merge($rr_current, $rr_next);
        $found_los_ids = array_merge($found_los_ids, array_column($rr_next, 'los_id'));
    }

    $final_los_ids = array_unique(array_column($rr_current, 'los_id'));

    // STEP 3: For each found LOS ID, find main case and compute commission
    foreach ($final_los_ids as $los_id) {
        // Try CURRENT year main case
        $main = $db_current->select('sanction_amt')
            ->from('mst_user')
            ->where('los_id', $los_id)
            ->where('loan_type_id !=', 5)
            ->get()->row();

        if (!$main) {
            // Try PREVIOUS year if not in current
            $main = $db_prev->select('sanction_amt')
                ->from('mst_user')
                ->where('los_id', $los_id)
                ->where('loan_type_id !=', 5)
                ->get()->row();
        }

        $amt = $main->sanction_amt ?? 0;
        if ($amt < 5000000) {
            $commi = 4000;
        } elseif ($amt <= 10000000) {
            $commi = 5000;
        } else {
            $commi = 6000;
        }

        $commissions[$los_id] = $commi;
    }

    // STEP 4: Default 0 for any LOS ID not found
    foreach ($los_ids as $id) {
        if (!isset($commissions[$id])) {
            $commissions[$id] = 0;
        }
    }

    return $commissions;
}

?>
