<main class="page-content">

    <div class="card">

        <div class="card-header py-3">
            <div class="row align-items-center m-0">
                <div class="col-md-4 col-12 me-auto mb-md-0 mb-3">
                   <!--  <a href="<?= base_url('admin/applicant_form/') ?>">
                        <button type="button" class="btn btn-outline-primary radius-30">Add Applicant</button>
                    </a> -->
                    <button type="button" class="btn btn-outline-primary radius-30" data-bs-toggle="modal" data-bs-target="#applicantFormModal">Add Applicant</button>
                </div>
            </div>
        </div>

        <div class="card-body">
            <form id="filterForm" action="<?php echo base_url('admin/manage_rbo_paid_applicant'); ?>" method="post">
                <div class="row">
                    <div class="col-md-2 mb-3">
                        <label for="start_date">Start Date:</label>
                        <input class="form-control" type="date" id="start_date" name="start_date" value="<?php echo isset($_POST['start_date']) ? $_POST['start_date'] : ''; ?>">
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="end_date">End Date:</label>
                        <input class="form-control" type="date" id="end_date" name="end_date" value="<?php echo isset($_POST['end_date']) ? $_POST['end_date'] : ''; ?>">
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="branch">Branch</label>
                        <select class="single-select" id="branch" name="branch">
                            <option value="">Select Branch</option>
                            <?php foreach ($branch as $branchItem) : ?>
                                <option value="<?= $branchItem['id']; ?>" <?php echo isset($_POST['branch']) && $_POST['branch'] === $branchItem['id'] ? 'selected' : ''; ?>><?= $branchItem['branch_name']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                      <div class="col-md-3">
                           <?php $rbo = $this->db->select("*")->from('mst_rbo')->where('active', 1)->get()->result_array(); ?>
                            <label for="rbo">RBO</label>
                            <select class="single-select" id="rbo" name="rbo">
                                <option value="">Select RBO</option>
                                <?php foreach ($rbo as $rboItem) { ?>
                                    <option value="<?= $rboItem['id']; ?>" <?php echo isset($_POST['rbo']) && $_POST['rbo'] === $rboItem['id'] ? 'selected' : ''; ?>>
                                        <?= $rboItem['rbo_name']; ?>
                                    </option>
                                <?php } ?>
                            </select>
                        </div>

                    <?php if($_SESSION['staff_type']==0){ ?>
                    <div class="col-md-2 mb-3">
                        <label for="connector">Partner</label>
                        <select class="single-select" id="connector" name="connector">
                            <option value="">Select Partner</option>
                            <?php foreach ($connector as $connectorItem) : ?>
                                <option value="<?= $connectorItem['staff_id']; ?>" <?php echo isset($_POST['connector']) && $_POST['connector'] === $connectorItem['staff_id'] ? 'selected' : ''; ?>><?= $connectorItem['staff_fullname']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <?php } ?>

                    <div class="col-md-2 mb-3">
                        <label for="status">Status</label>
                        <select name="status" id="status" class="form-control">
                            <option value="">--Select--</option>
                            <option value="Login Case" <?php echo isset($_POST['status']) && $_POST['status'] === 'Login Case' ? 'selected' : ''; ?>>Login Case</option>
                            <option value="Disb Case" <?php echo isset($_POST['status']) && $_POST['status'] === 'Disb Case' ? 'selected' : ''; ?>>Disb Case</option>
                           <!-- <option value="Sanction" <?php echo isset($_POST['status']) && $_POST['status'] === 'Sanction' ? 'selected' : ''; ?>>Sanction</option>
                            <option value="Reject" <?php echo isset($_POST['status']) && $_POST['status'] === 'Reject' ? 'selected' : ''; ?>>Reject</option>-->
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label for="hlc_status">Payment Partner Status</label>
                        <select name="hlc_status" id="hlc_status" class="form-control">
                            <option value="">--Select--</option>
                            <option value="paid" <?php echo isset($_POST['hlc_status']) && $_POST['hlc_status'] === 'paid' ? 'selected' : ''; ?>>Paid</option>
                            <option value="unpaid" <?php echo isset($_POST['hlc_status']) && $_POST['hlc_status'] === 'unpaid' ? 'selected' : ''; ?>>Unpaid</option>
                            <option value="partly paid" <?php echo isset($_POST['hlc_status']) && $_POST['hlc_status'] === 'partly paid' ? 'selected' : ''; ?>>Partly Paid</option>
                            <option value="excess paid" <?php echo isset($_POST['hlc_status']) && $_POST['hlc_status'] === 'excess paid' ? 'selected' : ''; ?>>Excess paid</option>
                        </select>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="partner_generated">Partner Generated</label>
                        <select name="partner_generated" id="partner_generated" class="form-control">
                            <option value="">--Select--</option>
                            <option value="Yes" <?php echo isset($_POST['partner_generated']) && $_POST['partner_generated'] === 'Yes' ? 'selected' : ''; ?>>Yes</option>
                            <option value="No" <?php echo isset($_POST['partner_generated']) && $_POST['partner_generated'] === 'No' ? 'selected' : ''; ?>>No</option>
                        </select>
                    </div>
                    <?php if($_SESSION['staff_type']==0){ ?>
                    <div class="col-md-2 mb-3">
                        <label for="branch_generated">Branch Generated</label>
                        <select name="branch_generated" id="branch_generated" class="form-control">
                            <option value="">--Select--</option>
                            <option value="Yes" <?php echo isset($_POST['branch_generated']) && $_POST['branch_generated'] === 'Yes' ? 'selected' : ''; ?>>Yes</option>
                            <option value="No" <?php echo isset($_POST['branch_generated']) && $_POST['branch_generated'] === 'No' ? 'selected' : ''; ?>>No</option>
                        </select>
                    </div>
                     <div class="col-md-2 mb-3">
                        <label for="sbi_generated">SBI Generated</label>
                        <select name="sbi_generated" id="sbi_generated" class="form-control">
                            <option value="">--Select--</option>
                            <option value="Yes" <?php echo isset($_POST['sbi_generated']) && $_POST['sbi_generated'] === 'Yes' ? 'selected' : ''; ?>>Yes</option>
                            <option value="No" <?php echo isset($_POST['sbi_generated']) && $_POST['sbi_generated'] === 'No' ? 'selected' : ''; ?>>No</option>
                        </select>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="sbi_payment_status">Payment SBI Status</label>
                        <select name="sbi_payment_status" id="sbi_payment_status" class="form-control">
                            <option value="">--Select--</option>
                            <option value="paid" <?php echo isset($_POST['sbi_payment_status']) && $_POST['sbi_payment_status'] === 'paid' ? 'selected' : ''; ?>>Paid</option>
                            <option value="unpaid" <?php echo isset($_POST['sbi_payment_status']) && $_POST['sbi_payment_status'] === 'unpaid' ? 'selected' : ''; ?>>Unpaid</option>
                            <option value="partly paid" <?php echo isset($_POST['sbi_payment_status']) && $_POST['sbi_payment_status'] === 'partly paid' ? 'selected' : ''; ?>>Partly Paid</option>
                            <option value="excess paid" <?php echo isset($_POST['sbi_payment_status']) && $_POST['sbi_payment_status'] === 'excess paid' ? 'selected' : ''; ?>>Excess paid</option>
                        </select>
                    </div>
                    <?php } ?>

                    <div class="col-md-2 mb-3">
                        <label for="state_id">State</label>
                        <select name="state_id" id="state_id" class="single-select">
                            <option value="">-Select-</option>
                            <?php foreach ($state as $value) { ?>
                                <option value="<?= $value['id']; ?>" <?php echo isset($_POST['state_id']) && $_POST['state_id'] === $value['id'] ? 'selected' : ''; ?>><?= $value['state_name']; ?></option>
                            <?php } ?>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label for="city_id">City</label>
                        <select name="city_id" id="city_id" class="single-select">
                            <option value="">-Select-</option>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label for="month">Month</label>
                        <input type="month" name="month" id="month" class="form-control" value="<?php echo isset($_POST['month']) ? $_POST['month'] : ''; ?>">
                    </div>

                    <div class="col-md-3 mb-3">
                        <br>
                        <button type="button" class="btn btn-success" id="filterSubmit">Filter</button>
                        <button class="btn btn-info" type="button" id="resetButton">Reset</button>
                    </div>
                </div>
            </form>
           
            <div class="table-responsive">
                <table class="table align-middle table-striped" id="userTable">
                     <thead>
                        <tr>
                            <th>Sr.No</th>
                            <th>Partner Name</th>
                            <th>Partner Code</th>
                            <th>Applicant Name</th>
                            <th>State</th>
                            <th>City</th>
                            <th>RLMS ID</th>
                            <th>CBS Account No</th>
                            <th>Branch Name</th>
                            <th>RBO</th>
                            <th>Loan Type</th>
                            <th>Sanction Loan Amt</th>
                            <th>Partner Payout %</th>
                            <th>Partner Payout Amt</th>
                            <th>SBI %</th>
                            <th>SBI Commi. Amt</th>
                            <th>SBI 10%</th>
                            <th>SBI 90% Commi</th>
                            <th>Disb Date</th>
                            <th>Status</th>
                            <th>Partner Generated</th>
                            <th>Partner Payment Status</th>
                            <th>Branch Generated</th>
                            <th>SBI Generated</th>
                            <th>SBI Payment Status</th>
                            <th>Add Date</th>
                            <th>Created By</th>
                            <th>Login Code</th>
                            <th>Appraisal</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>          
                             
                   </tbody>
                  
                </div>
  </div>
</main>

<script>
$(document).ready(function () {
    var staffType = <?php echo $_SESSION['staff_type']; ?>;
    var staffId = <?php echo $_SESSION['staff_id']; ?>;
    var columns = [
        { "data": "sr_no" },        
        { "data": "hlc_name", "visible": (staffType == 0) },
        { "data": "hlc_code", "visible": (staffId == 1 || staffId == 14) },
        { "data": "applicant_name" },
        { "data": "state" },
        { "data": "city" },
        { "data": "rlms_id" },
        { "data": "cbs_account_no" },
        { "data": "branch_name" },
        { "data": "rbo" },
        { "data": "loan_type" },
        { "data": "sanction_loan_amt" },
        { "data": "conn_commision", "visible": (staffId == 1 || staffId == 14) },
        { "data": "conn_payout_amt", "visible": (staffId == 1 || staffId == 14) },
        { "data": "sbi_payout", "visible": (staffId == 1 || staffId == 14) },
        { "data": "sbi_commi_amt", "visible": (staffId == 1 || staffId == 14) },
        { "data": "sbi_ten_per", "visible": (staffId == 1 || staffId == 14) },
        { "data": "sbi_ninety_per", "visible": (staffId == 1 || staffId == 14) },
        { "data": "disb_date" },
        { "data": "status" },
        { "data": "hlc_generated" },
        { "data": "hlc_payment_status" },
        { "data": "branch_generated", "visible": (staffType == 0) },
        { "data": "sbi_generated", "visible": (staffType == 0) },
        { "data": "sbi_payment_status", "visible": (staffType == 0) },
        { "data": "add_date" },
        { "data": "created_by", "visible": (staffId == 14) },
        { "data": "login_code", "visible": (staffId == 1 || staffId == 14) },
        { "data": "appraisal_letter", "exportable": true },       
        { "data": "edit" }
    ];

    var table = $('#userTable').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?php echo base_url('admin/fetch_applicants_rbo_paid'); ?>",
            "type": "POST",
            "data": function (d) {
                d.start_date = $('#start_date').val();
                d.end_date = $('#end_date').val();
                d.status = $('#status').val();
                d.connector = $('#connector').val();
                d.branch = $('#branch').val();
                d.hlc_status = $('#hlc_status').val();
                d.sbi_payment_status = $('#sbi_payment_status').val();
                d.state_id = $('#state_id').val();
                d.city_id = $('#city_id').val();
                d.month = $('#month').val();
                d.sbi_generated = $('#sbi_generated').val();
                d.branch_generated = $('#branch_generated').val();
                d.partner_generated = $('#partner_generated').val();
                d.rbo = $('#rbo').val();
            },
            "error": function (jqXHR, textStatus, errorThrown) {
                console.error("Error loading data: ", textStatus, errorThrown);
            }
        },
        "columns": columns,
        "lengthChange": true,
        "lengthMenu": [[100, 400, 600, 1000, -1], [100, 400, 600, 1000, "All"]],
        "pageLength": 100,
        "order": [[0, 'desc']],
        "dom": 'lBfrtip',
        "scrollX": true,
        "fixedColumns": {
          leftColumns: 0,
          rightColumns: 2,
        },
        "buttons": [
            { extend: 'copy', text: 'Copy' },
            { extend: 'excel', text: 'Excel' },
            { extend: 'colvis', text: 'Column Visibility' }
        ],
     "drawCallback": function(settings) {
     
      // Adjust the height of the fixed columns to match the scrollable columns
      setTimeout(function() {
        var scrollBodyHeight = $('.dataTables_scrollBody').height();
        $('.DTFC_LeftBodyWrapper').height(scrollBodyHeight);
        $('.DTFC_RightBodyWrapper').height(scrollBodyHeight);

        // Adjust the row heights to match
        $('#userTable tbody tr').each(function(index) {
          var rowHeight = $(this).height();
          $('.DTFC_LeftBodyWrapper tbody tr').eq(index).height(rowHeight);
          $('.DTFC_RightBodyWrapper tbody tr').eq(index).height(rowHeight);
        });
      }, 10);
      
        calculateAndDisplayTotals();
     },
        "footerCallback": function (row, data, start, end, display) {
            calculateAndDisplayTotals();
        }
    });

    $('#filterSubmit').click(function() {
        table.draw();
    });
    
    $('#resetButton').on('click', function() {
    $('#filterForm')[0].reset();
     $('.single-select').each(function() {
            $(this).val('').trigger('change'); // Works for select2 or similar plugins
        });
    table.ajax.reload();
  });

    $('#state_id').change(function() {
        var stateId = $(this).val();
        if(stateId !== '') {
            $.ajax({
                url: '<?= base_url('Admin/get_cities') ?>',
                type: 'POST',
                data: { state_id: stateId },
                dataType: 'json',
                success: function(data) {
                    $('#city_id').empty().append('<option value="">-Select-</option>');
                    $.each(data, function(key, value) {
                        $('#city_id').append('<option value="' + value.id + '">' + value.city_name + '</option>');
                    });
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        } else {
            $('#city_id').empty().append('<option value="">-Select-</option>');
        }
    });

    $('#state_id').trigger('change');
    
   $('.dataTables_scrollBody').on('scroll', function() {
    var $scrollBody = $(this);
    var $fixedColumnsRight = $('.DTFC_RightBodyWrapper');
    var scrollLeft = $scrollBody.scrollLeft();
    var scrollWidth = $scrollBody[0].scrollWidth;
    var clientWidth = $scrollBody[0].clientWidth;
    
    var isScrolledToEnd = scrollLeft + clientWidth >= scrollWidth - 1; // -1 to account for rounding issues
    
    if (isScrolledToEnd) {
        $fixedColumnsRight.hide();
    } else {
        $fixedColumnsRight.show();
    }
  });

    $(document).on('click', '.delete', function () {
        var element = $(this);
        var id = element.attr('data-id'); // Use data-id attribute to get the ID
        var action = element.attr('action');

        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to delete this account?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    url: base_url + 'admin/' + action + '/' + id,
                    dataType: 'json',
                    success: function (res) {
                        if (res.success == '1') {
                            notify(res.type, res.message);
                            table.ajax.reload(null, false);  // Reload the table data without resetting pagination
                        } else {
                            notify(res.type, res.message);
                        }
                    },
                    error: function (xhr, status, error) {
                        console.log(xhr.responseText);
                        alert('Error occurred while deleting data. Please try again.');
                    }
                });
            }
        });
    });
});


function calculateAndDisplayTotals() {
    var totalSanctionLoanAmt = 0;
    var totalpartnerPercentage = 0;
    var totalPartnerPayoutAmt = 0;
    var totalsbiPerAmt = 0;
    var totalsbiCommAmt = 0;
    var totalsbiCommTenPerAmt = 0;
    var totalsbiComm90PerAmt = 0;

    // Define column indices
    var sanctionLoanColumnIndex = <?php echo ($_SESSION['staff_type'] == 0) ? 11 : 9; ?>;
    var partnerPercentageColumnIndex = <?php echo ($_SESSION['staff_type'] == 0) ? 12 : 12; ?>;
    var partnerPayoutColumnIndex = <?php echo ($_SESSION['staff_type'] == 0) ? 13 : 13; ?>;
    var sbiPerColumnIndex = <?php echo ($_SESSION['staff_type'] == 0) ? 14 : 14; ?>;
    var sbiCommColumnIndex = <?php echo ($_SESSION['staff_type'] == 0) ? 15 : 15; ?>;
    var sbiTenPerColumnIndex = <?php echo ($_SESSION['staff_type'] == 0) ? 16 : 16; ?>;
    var sbi90PerColumnIndex = <?php echo ($_SESSION['staff_type'] == 0) ? 17 : 17; ?>;

    // Iterate through table rows to calculate totals
    $('#userTable tbody tr').each(function() {
        var sanctionLoanAmt = parseFloat($(this).find('td').eq(sanctionLoanColumnIndex).text().replace(/[^0-9.-]+/g, ""));
        var partnerPercentage = parseFloat($(this).find('td').eq(partnerPercentageColumnIndex).text().replace(/[^0-9.-]+/g, ""));
        var partnerPayoutAmt = parseFloat($(this).find('td').eq(partnerPayoutColumnIndex).text().replace(/[^0-9.-]+/g, ""));
        var sbiPerAmt = parseFloat($(this).find('td').eq(sbiPerColumnIndex).text().replace(/[^0-9.-]+/g, ""));
        var sbiCommAmt = parseFloat($(this).find('td').eq(sbiCommColumnIndex).text().replace(/[^0-9.-]+/g, ""));
        var sbiCommTenPerAmt = parseFloat($(this).find('td').eq(sbiTenPerColumnIndex).text().replace(/[^0-9.-]+/g, ""));
        var sbiComm90PerAmt = parseFloat($(this).find('td').eq(sbi90PerColumnIndex).text().replace(/[^0-9.-]+/g, ""));

        if (!isNaN(sanctionLoanAmt)) totalSanctionLoanAmt += sanctionLoanAmt;
        if (!isNaN(partnerPercentage)) totalpartnerPercentage += partnerPercentage;
        if (!isNaN(partnerPayoutAmt)) totalPartnerPayoutAmt += partnerPayoutAmt;
        if (!isNaN(sbiPerAmt)) totalsbiPerAmt += sbiPerAmt;
        if (!isNaN(sbiCommAmt)) totalsbiCommAmt += sbiCommAmt;
        if (!isNaN(sbiCommTenPerAmt)) totalsbiCommTenPerAmt += sbiCommTenPerAmt;
        if (!isNaN(sbiComm90PerAmt)) totalsbiComm90PerAmt += sbiComm90PerAmt;
    });

    // Remove existing tfoot if present
    $('#totalsFooter').remove();

    // Check if the staff ID is 1 or 14 to display totals
    var staffId = <?php echo $_SESSION['staff_id']; ?>;
    if (staffId == 1 || staffId == 14) {
        // Construct the tfoot with totals in the correct columns
        var tfootHtml = `
          <tfoot id="totalsFooter">
            <tr>
              <th colspan="${sanctionLoanColumnIndex}" style="text-align:right">Total</th>
              <th>${totalSanctionLoanAmt.toFixed(2)}</th>
              <th>${totalpartnerPercentage.toFixed(2)}</th>
              <th>${totalPartnerPayoutAmt.toFixed(2)}</th>
              <th>${totalsbiPerAmt.toFixed(2)}</th>
              <th>${totalsbiCommAmt.toFixed(2)}</th>
              <th>${totalsbiCommTenPerAmt.toFixed(2)}</th>
              <th>${totalsbiComm90PerAmt.toFixed(2)}</th>
            </tr>
          </tfoot>
        `;

        // Append the footer to the table
        $('#userTable').append(tfootHtml);
    }
}






function appLetterUpload(userId, fileInputId) {
    var fileInput = document.getElementById(fileInputId); // Use the passed ID

    // Check if file input exists
    if (!fileInput) {
        alert('File input not found');
        return;
    }

    // Get the selected file
    var file = fileInput.files[0];

    // Check if a file is selected
    if (!file) {
        alert('No file selected');
        return;
    }

    // Create a FormData object to send the file data
    var formData = new FormData();
    formData.append('apprisal_letter', file);
    formData.append('user_id', userId);

    // Send an Ajax request to the CodeIgniter controller
    $.ajax({
        url: 'admin/upload_apprisal_file', // Update the URL to match your CodeIgniter controller method
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function(response) {
            // Handle success response
            alert('File uploaded successfully');
        },
        error: function(xhr, status, error) {
            // Handle error
            alert('Error uploading file: ' + error);
        }
    });
}



$(document).on('submit', '.archive-form', function (e) {
    e.preventDefault();

    const form = $(this);
    const formData = form.serialize();

    $.ajax({
        url: form.attr('action'),
        method: 'POST',
        data: formData,
        dataType: 'json',
        success: function (response) {
            if (response.status === 'success') {
                alert(response.message); // Display success message
                location.reload(); // Reload the page to reflect changes
            } else if (response.status === 'error') {
                alert(response.message); // Display error message
            }
        },
        error: function () {
            alert('An unexpected error occurred.');
        }
    });
});

</script>

<style>
   .dataTables_length {
      margin-bottom: 13px;
  }
  .dataTables_filter {
      margin-top: 12px;
  }
    
    .DTFC_RightBodyWrapper table,
  .DTFC_LeftBodyWrapper table {
      width: 100% !important;
  }

  .dataTables_scrollBody {
      overflow: auto;
  }

  .DTFC_LeftBodyLiner,
  .DTFC_RightBodyLiner {
      overflow: hidden !important;
  }

  .DTFC_LeftBodyWrapper,
  .DTFC_RightBodyWrapper {
      top: 0 !important;
  }

  .DTFC_RightBodyWrapper {
      right: 0 !important;
  }

  .DTFC_RightBodyLiner {
      overflow: hidden;
      position: absolute;
      right: 0;
      top: -11px !important;
      background-color: white !important;
  }

  .DTFC_LeftBodyLiner {
      overflow: hidden;
      position: absolute;
      left: 0;
  }

  .dataTables_scrollHeadInner, .dataTables_scrollHead, .dataTables_scrollBody {
      margin-bottom: 0 !important;
  }

  .dataTables_wrapper .dataTables_scroll div.dataTables_scrollBody {
      background: white;
  }


  table.dataTable tr:nth-child(even) {
      background-color: #ffff;
  }

  table.dataTable tr:nth-child(odd) {
      background-color: #ffffff;
  }

</style>




<!-- Modal -->
<div class="modal fade" id="applicantFormModal" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="applicantFormModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="applicantFormModalLabel">Select Login Code</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form id="formSelection" class="d-flex justify-content-around">
          <div class="form-check custom-card">
            <input class="form-check-input" type="radio" name="formType" id="paisabazar" value="PaisaBazaar" required>
            <label class="form-check-label custom-label" for="paisabazar">
             PaisaBazaar
            </label>
          </div>
          <div class="form-check custom-card">
            <input class="form-check-input" type="radio" name="formType" id="mortgagebuddy" value="Mortgagebuddy" required>
            <label class="form-check-label custom-label" for="mortgagebuddy">
              Mortgagebuddy
            </label>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        
        <button type="button" class="btn btn-primary" id="redirectBtn">Proceed</button>
      </div>
    </div>
  </div>
</div>

<script>
document.getElementById('redirectBtn').addEventListener('click', function() {
    // Get the selected radio button
    var selectedRadio = document.querySelector('input[name="formType"]:checked');
    
    // Check if any radio button is selected
    if (selectedRadio) {
        var selectedFormType = selectedRadio.value;

        // Create a hidden form element
        var form = document.createElement('form');
        form.method = 'POST';

        // Set form action URL based on the selected option
        if (selectedFormType === 'PaisaBazaar') {
            form.action = "<?php echo base_url('admin/pb_user_form'); ?>";  // Redirect to PaisaBazaar form
        } else if (selectedFormType === 'Mortgagebuddy') {
            form.action = "<?php echo base_url('admin/applicant_form'); ?>";  // Redirect to Mortgagebuddy form
        }

        // Create a hidden input field for the selected form type
        var input = document.createElement('input');
        input.type = 'hidden';
        input.name = 'selectedFormType';
        input.value = selectedFormType;

        // Append the input to the form and submit it
        form.appendChild(input);
        document.body.appendChild(form);
        form.submit();
    } else {
        alert('Please select a Login Code.');
    }
});

// Handle modal close event to unselect radio buttons
$('#applicantFormModal').on('hide.bs.modal', function () {
    // Unselect any selected radio button
    var selectedRadio = document.querySelector('input[name="formType"]:checked');
    if (selectedRadio) {
        selectedRadio.checked = false;
    }
    
    // Optionally reset the form if you have more fields
    document.getElementById('formSelection').reset();
});

</script>
<style>
/* Hide default radio button appearance */
.form-check-input {
    position: absolute;
    opacity: 0;
   
}
.form-check {
    display: block;
    min-height: 1.5rem;
    padding-left: 0px !important;
    margin-bottom: .125rem;
}

/* Style the card as selectable */
.custom-card {
    cursor: pointer;
    width: 150px;
    margin-bottom: 20px;
    border: 2px solid #ccc;
    border-radius: 5px;
    transition: all 0.3s ease;
    display: inline-block;
    text-align: center;
}

/* Change border color and background when selected */
.form-check-input:checked + .custom-label {
    border-color: green;
    background-color: green;
    color: white;
    padding: 10px;
    border-radius: 5px;
    display: inline-block;
}

/* Style for the label to appear like a card */
.custom-label {
    display: inline-block;
    padding: 10px;
    border-radius: 5px;
    border: 2px solid #ccc;
    transition: all 0.3s ease;
    width: 100%;
}

/* Hover effect for the card */
.custom-card:hover .custom-label {
    border-color: green;
}
</style>
