
<div class="modal fade" id="GenrateInvoiceModal" tabindex="-1" aria-labelledby="GenrateInvoiceModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            
            <!-- Modal Header -->
            <div class="modal-header">
                <h5 class="modal-title" id="GenrateInvoiceModalLabel">Generate Invoice</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <!-- Modal Body -->
            <div class="modal-body">
                <!-- Hidden Field for Invoice Type -->
                <input type="hidden" name="invoice_type" id="invoice_type" value="inv_hlc">

               
               <!-- Invoice Date -->
                <div class="mb-3">
                    <label for="invoice_date" class="form-label">Invoice Date</label>
                    <input type="date" class="form-control" id="invoice_date" 
                           value="<?= date('Y-m-d'); ?>" readonly>
                    <span id="invoice_date_error" class="text-danger"></span>
                </div>


                <div class="row">
                    <!-- Split Partner -->
                    <div class="mb-3 col-md-6">
                        <label for="split_partner" class="form-label">Split Partner</label>
                        <select name="split_partner" class="form-select" id="split_partner">
                            <option value="">Select</option>
                            <!-- Populate dynamically -->
                        </select>
                        <span class="error text-danger"></span>
                    </div>
                
                    <!-- Split Partner Payout Commission -->
                    <div class="mb-3 col-md-6">
                        <label for="split_part_payout" class="form-label">Split Part Payout Commi.</label>
                        <select name="split_part_payout" class="form-select" id="split_part_payout">
                            <option value="">Select</option>
                        </select>
                        <span class="error text-danger"></span>
                    </div>
                </div>
            </div>

            <!-- Modal Footer -->
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="applyinvoice">Submit</button>
            </div>
        </div>
    </div>
</div>

<main class="page-content">
    
    <div class="card">
        <div class="table-settings-overlay" id="tableSettingsOverlay"></div>
                    
        <div class="table-settings-panel" id="tableSettingsPanel">
            <div class="ts-header">
                <h6>Table Settings</h6>
                <button class="ts-close" id="closeTableSettings">&times;</button>
            </div>
        
            <div class="ts-body">
               
                <div class="ts-grid">
                        <div class="formgroup">
                            <label for="branch">Branch</label>
                             <select class="form-control" id="branch">
                                <option value="">Select Branch</option>
                                <?php foreach ($branch as $branchItem) { ?>
                                    <option value="<?= $branchItem['id']; ?>">
                                        <?= $branchItem['branch_name']; ?>
                                    </option>
                                <?php } ?>
                            </select>
                        </div>
                
                        <div class="formgroup">
                            <?php if($_SESSION['staff_type']==0){ ?> 
                                <label for="connector">Partner</label> 
                                <select class="form-control" id="connector">
                                <option value="">Select HLC</option>
                                <?php foreach ($connector as $connectorItem) { ?>
                                    <option value="<?= $connectorItem['staff_id']; ?>">
                                        <?= $connectorItem['staff_fullname']; ?>
                                    </option>
                                <?php } ?>
                            </select> 
                            <?php } ?> 
                        </div>
                
                        <div class="formgroup">
                            <label class="">Disb Month</label>
                            <input type="month" class="form-control" id="month">
                        </div>
                
                    </div>
            </div>
        
        
            <div class="ts-footer">
                <button class="btn-back-white" id="resetFilters">Reset</button>
                <button class="btn-submit" id="applyFilters">Apply</button>
            </div>
             
        </div>
         <!-- 
        <div class="card-header py-3">
           <?php 
            $allowedStaffIds = [14, 1, 13, 538, 28, 651]; 
            
            if (in_array($_SESSION['staff_id'], $allowedStaffIds)) { ?>
              <div class="row align-items-center m-0">
                    <div class="col-md-4 col-12 me-auto mb-md-0 mb-3"></div>
                    <div class="col-md-2 text-end"> 
                        <button class="btn btn-primary btn-sm d-flex align-items-center gap-1" id="GenrateInvoiceButton">
                            <i class="bi bi-file-earmark-text"></i> Generate Invoice MB
                        </button>
                    </div>
                </div>
            <?php } ?>
        </div>
        -->
        <div class="card-body">
         
         <div class="top-controls">
    
                    <div class="left-area">
                        <div id="tableSettingsBtn" class="table-settings-chip">
                            <span class="ts-text">Table Settings</span>
                            <span class="ts-icon">
                                <i class="bi bi-grid-3x3-gap-fill"></i>
                            </span>
                        </div>
        
        
                         <div class="export-buttons"></div>
                    </div>
                <?php 
                    $allowedStaffIds = [14, 1, 13, 538, 28, 651]; 
                    
                    if (in_array($_SESSION['staff_id'], $allowedStaffIds)) { ?>
                        <div class="right-area">
                            <input type="text" class="search-box" id="tableSearch" placeholder="🔍 Search">
                            
                            <!-- FIX: button inside anchor removed -->
                            
                            <a href="#" id="GenerateInvoiceButton" class="role-btn">
                                <i class="bi bi-receipt-cutoff"></i> Generate Invoice MB
                            </a>
                        </div>
                     <?php } ?>   
            </div>
            
                  <div class="table-responsive mobile-scroll">
                    <table class="table table-striped dataTable" id="Table">
                            <thead>
                                <tr>
                                    <th></th>
                                    <th><input type="checkbox" id="checkAll"></th>
                                    <th>Sr.No</th> 
                                    <?php if($_SESSION['staff_type']==0){ ?> 
                                    <th>Partner Name</th> 
                                    <?php } ?> 
                                    <th>Applicant Name</th>
                                    <th>RBO</th>
                                    <th>Branch Name</th>
                                    <th>City</th>
                                    <th>Loan Type</th>
                                    <th>Sanction Loan Amt </th>
                                    <th>DISB Date </th>
                                      <!--  <th>DISB Status </th>-->
                                      <?php if($_SESSION['staff_id']==14 || $_SESSION['staff_id']==651 || $_SESSION['staff_id']==13 || $_SESSION['staff_id']==538 || $_SESSION['staff_id']==28){ ?>
                                       <th>Part. Payout </th>
                                      <?php } ?>
                                   <!-- <th>Invoice Status</th> -->
                                     <th>Appraisal Letter</th>
                                     <th>Add Date</th>
                                     <th>Action</th>
                                </tr>
                                </thead>
                                <tbody> <?php

                        if (!empty($user)) {

                            foreach ($user as $key => $row) {

                                $branch = $this->db->select("*")->where(['id' => $row['branch_id']])->from('branch')->get()->row();
                                $city = $this->db->select("*")->where(['id' => $branch->city_id])->from('mst_city')->get()->row();
                                $rbo = $this->db->select("*")->where(['id' => $branch->rbo_id])->from('mst_rbo')->get()->row();
                                
                                $rinnraksha_status = 'Yes'; 
                                $rr_aact = $this->db->select("*")->where(['applicant_rr_id' => $row['id'], 'rinnraksha_status' => $rinnraksha_status])->from('mst_user')->get()->row();
                                @$rr_sanction_amt = $this->db->select("*")->where(['id' => $rr_aact->id])->from('mst_user')->get()->row();
                                
                                    
                                $conn = $this->db->select("*")->where(['staff_id' => $row['connector_id']])->from('mst_staff')->get()->row();
                                if ($row['applicant_invoice_status'] !== 'Invoice SBI') {
                                ?> 
                                <tr class='main_block' main_id="<?= $row['id'] ?>">
                                    
                                     <!-- Expand icon -->
                                    <td class="details-control">
                                        <span class="circle-icon">
                                            <i class="bi bi-caret-right-fill collapse-icon"></i>
                                        </span>
                                    </td>
                                
                                    <!-- Checkbox -->
                                    <td>
                                        <input type="checkbox" name="selected_rows[]"  class="form-check-input" value="<?= $row['id'] ?>">
                                    </td>
                                  <!--<td><input type="checkbox" name="selected_rows[]" class="form-check-input" value="<?= $row['id'] ?>"></td>-->
                                    <td><?= $key + 1 ?></td>
                                        <?php if($_SESSION['staff_type']==0): ?>
                                        <td class="">
                                            <?= $conn->staff_fullname; ?>
                                        </td>
                                        <?php endif; ?>
                                        <input type="hidden" name="connector_id_<?= $row['id']; ?>" value="<?= $conn->staff_id ?>">
                                        <td>
                                            <?= $row['user_name']; ?>
                                        </td>
                                        <td>
                                            <?= @$rbo->rbo_name; ?>
                                        </td>
                                        <td>
                                            <?php
                                                echo $branch->branch_name;
                                            ?>(<?php
                                                echo $branch->branch_code;
                                            ?>)
                                        </td>
                                        <td>
                                            <?= $city->city_name; ?>
                                        </td>
                                        <td>
                                            <?= $row['user_type']; ?>
                                        </td>
                                       
                                        <td>
                                            
                                            <input type="number" class="form-control" id="inputsanction_amt"
                                                <?php if ($row['applicant_invoice_status'] == 'Generated') { echo 'readonly'; } ?>
                                                <?php if ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id'])) { echo 'readonly'; } ?>
                                                name="sanction_amt" 
                                                value="<?= ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id'])) ? $row['rinnraksha_amt'] : $row['sanction_amt']; ?>"  
                                                oninput="validateAndUpdate(this, <?= $row['id']; ?>)">
                                            <span class="error-message text-danger"></span>
                                                
                                            <?php if ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id'])): ?>
                                                        <span>
                                                            <?php
                                                            // Ensure sanctionAmt is numeric
                                                                $sanctionAmt = isset($rr_sanction_amt->sanction_amt) ? str_replace(',', '', $rr_sanction_amt->sanction_amt) : '0';
                                                                $sanctionAmt = is_numeric($sanctionAmt) ? (float) $sanctionAmt : 0;
                                                                
                                                                // Ensure premiumAmt is numeric
                                                                $premiumAmt = isset($row['rinnraksha_amt']) ? str_replace(',', '', $row['rinnraksha_amt']) : '0';
                                                                $premiumAmt = is_numeric($premiumAmt) ? (float) $premiumAmt : 0;
                                                                
                                                                // Ensure conn_commision is numeric
                                                                $conn_commision = isset($conn->conn_commision) ? str_replace(',', '', $conn->conn_commision) : '0';
                                                                $conn_commision = is_numeric($conn_commision) ? (float) $conn_commision : 0;
                                                                
                                                                // Calculate premium commission safely
                                                                $premiumCommission = ($premiumAmt * $conn_commision) / 100;

                                                            
                                                            if ($sanctionAmt == 5000000) {
                                                                // If the sanction amount is exactly 50 lakh, set commission to 4000
                                                                $commission = 4000;
                                                            } elseif ($sanctionAmt >= 100000 && $sanctionAmt < 5000000) {
                                                                $commission = 4000;
                                                            } elseif ($sanctionAmt > 5000000 && $sanctionAmt < 10000000) {
                                                                $commission = 5000;
                                                            } elseif ($sanctionAmt >= 10000000) {
                                                                $commission = 6000;
                                                            } else {
                                                                $commission = 0;
                                                            }

                                                            ?>
                                                        </span>
                                                        
                                                       <span>RR Commi:<?= $sanctionAmt ?> on <?= $commission ?></span>
                                                        <br>
                                                        <span class="rinnraksha_premium_amt">RR Premium Amt Rs.<?= $premiumAmt; ?></span>
                                                        <br>
                                                        <span>RR Premium Amt Commi.(<?=$conn->conn_commision ?>%):<?= $premiumCommission; ?></span>
                                                    <?php endif; ?>
                                        </td>
                                        <td>
                                            <input type="date" class="form-control" name="disb_date" 
                                                <?php if ($row['applicant_invoice_status'] == 'Generated') { echo 'disabled'; } ?>
                                                max="<?= date('Y-m-d') ?>" value="<?= $row['disb_date']; ?>" oninput="updateRowValues(this, <?= $row['id']; ?>)">
                                        </td>

                                           <?php if($_SESSION['staff_id']==14 || $_SESSION['staff_id']==651 || $_SESSION['staff_id']==13 || $_SESSION['staff_id']==538 || $_SESSION['staff_id']==28){ ?>
                                            <?php
                                                // Default pre-fill from saved value or conn_commision
                                                $defaultPartPayout = isset($row['part_payout']) && $row['part_payout'] !== ''
                                                    ? $row['part_payout']
                                                    : (isset($conn->conn_commision) ? number_format($conn->conn_commision, 2) : '');
                                            ?>
                                            <td>
                                                <select name="part_payout" class="form-select"
                                                    <?php if ($row['applicant_invoice_status'] == 'Generated') echo 'disabled'; ?>
                                                    oninput="updateRowpartpayout(this, <?= $row['id']; ?>)">
                                                    <option value="">Select</option>
                                                    <?php
                                                        $options = [
                                                            "0.18", "0.20", "0.28", "0.30", "0.35", "0.40", "0.45", "0.47", "0.50",
                                                            "0.52", "0.55", "0.60", "0.65", "0.70", "0.75", "0.77", "0.78", "0.79", "0.80",
                                                            "0.82", "0.83", "0.84", "0.85", "0.86", "0.87", "0.88", "0.89", "0.90", "0.91", "0.92"
                                                        ];
                                                        foreach ($options as $opt) {
                                                            $selected = ($defaultPartPayout == $opt) ? 'selected' : '';
                                                            echo "<option value=\"$opt\" $selected>$opt%</option>";
                                                        }
                                                    ?>
                                                </select>
                                            </td>
                                        <?php } ?>

                                             <td> 
                                              <?php
                                                   // Fetch appraisal letters for a specific user
                                                    if (isset($row['id']) && !empty($row['id'])) {
                                                        $user_id = $row['id'];
                                                        
                                                        // Query the appraisal_letters table
                                                        $this->db->where('user_id', $user_id);
                                                        $this->db->order_by('add_date', 'DESC');
                                                        $query = $this->db->get('appraisal_letters');
                                                        $appraisal_letters = $query->result(); // Fetch all results
                                                    }
                                                ?>
                                               <!--<input type="file" name="apprisal_letter" id="apprisal_letter_<?= $row['id']; ?>" onchange="appLetterUpload(<?= $row['id']; ?>, 'apprisal_letter_<?= $row['id']; ?>')" accept=".pdf,.docx,.doc,.jpg,.jpeg">
                                               <br>-->
                                               <?php if (!empty($appraisal_letters)) { ?>
                                               <?php 
                                                    foreach ($appraisal_letters as $letter) {
                                                        $letters[] = base_url('assets/uploads/documents/' . $letter->appraisal_letter);
                                               ?>
                                                    <a href="<?= base_url() . 'assets/uploads/documents/' . $letter->appraisal_letter ?>" target="_blank"><i class="bi bi-eye-fill"></i>
                                                        Appraisal Letter
                                                    </a><br>
                                                <?php } ?>
                                            <?php } ?>
                                            </td> 
                                            
                                            
                                          
                                       <!--<td class="">
                                                <?php
                                                if (empty($row['applicant_invoice_status'])) {
                                                    $applicant_invoice_status = "Processing";
                                                } else {
                                                    $applicant_invoice_status = $row['applicant_invoice_status'];
                                                }
                                                ?>
                                                <?= $applicant_invoice_status; ?>
                                        </td>-->
                                          <td class="">
                                           <?php echo date('d-m-Y',strtotime($row['add_date'])); ?>
                                    </td>
                                    
                                     <td>
                                        <div class="d-flex align-items-center gap-3 fs-6">
                                             <a href="javascript:;" class="text-primary" data-bs-toggle="modal" data-bs-target="#userDetailsModal<?= $row['id']; ?>" data-bs-placement="bottom" title="View detail" aria-label="Views">
                                              <i class="bi bi-eye-fill"></i>
                                            </a>
                                            <a href="<?= base_url('admin/applicant_form/' . $row['id']) ?>" class="text-info" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Edit info" aria-label="Edit"><i class="bi bi-pencil-fill"></i></a>

                                        </div>
                                    </td>
                                       
                                    </tr> 
                                    
                                     <!-- Modal for displaying Applicant details -->
                                    <div class="modal fade" id="userDetailsModal<?= $row['id']; ?>" tabindex="-1" aria-labelledby="userDetailsModalLabel" aria-hidden="true">
                                      <div class="modal-dialog">
                                        <div class="modal-content">
                                          <div class="modal-header">
                                            <h5 class="modal-title" id="userDetailsModalLabel">Applicant Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                          </div>
                                          <div class="modal-body">
                                           <p><strong>Name:</strong><?= $row['user_name']; ?></p>
                                           <p><strong>Branch Name:</strong><?= $branch->branch_name; ?>[<?= $branch->branch_code; ?>]</p>
                                           <p><strong>Mobile:</strong> <?= $row['user_phone']; ?></p>
                                           <p><strong>Email:</strong> <?= $row['user_email']; ?></p>
                                           <p><strong>Address:</strong></p>
                                            <p style="white-space: pre-line;"><?= $row['user_address']; ?></p>
                                             <hr>
                                              <p><strong>Loan Type:</strong>  <?= $row['user_type']; ?>  </p>
                                             <p><strong>RLMS ID:</strong>  <?= $row['los_id']; ?> </p>
                                             <p><strong>CBS Account No:</strong>   
                                             <?php if($row['rinnraksha_status']=='Yes' && empty($row['applicant_rr_id'])){
                                                echo $row['rr_cbs_acct_no']; }else{
                                               echo $row['bank_acct_no']; }
                                             ?> 
                                             </p>
                                               <p><strong>Sanction Loan Amt:</strong>  <?php 
                                                $amt = ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id'])) ? $row['rinnraksha_amt'] : $row['sanction_amt'];
                                                echo isset($amt) ? $amt : '0.00';
                                            ?></p>
                                             <p><strong>Status:</strong>   <?= $row['status']; ?>  </p>
                                             
                                          </div>
                                        </div>
                                      </div>
                                    </div>
 
                                    
                                    
                                    <?php

                            }
                            }

                        } else {

                            ?> <tr>
                                        <td colspan="3" align="center">Sorry no records available! </td>
                                    </tr> <?php } ?> </tbody>
                        </table>
            </div>
        </div>
    </div>
</main> <!-- Add your change status modal -->




<script>
$(document).ready(function () {
    
    if ($.fn.DataTable.isDataTable('#Table')) {
    $('#Table').DataTable().destroy();
}

    var table = $('#Table').DataTable({
        "paging": false,
        "processing": true,
        "serverSide": true,
        "scrollX": true,     
        "autoWidth": false,   
        "dom": 'Blfrtip',      
        "buttons": [          
            { 
                extend: 'excelHtml5', 
                text: '<img src="<?= base_url("admin_assets/images/icons/excel.png") ?>" class="export-icon" />',
                className: 'export-btn',
                exportOptions: {
                    columns: ':visible',
                    format: {
                         body: function (data, row, column, node) {
                            if ($(node).find('input').length) {
                                return $(node).find('input').val();
                            }
                            if ($(node).find('select').length) {
                                return $(node).find('select option:selected').text();
                            }
                            if ($(node).find('.badge').length) {
                                return $(node).find('.badge').text().trim();
                            }
                            return $('<div>').html(data).text();
                        }
                    }
                }
            }
        ],
        "ajax": {
            "url": "<?= base_url('admin/generate_invoice_hlc'); ?>",
            "type": "POST",
            "data": function (d) {
                d.branch = $('#branch').val();
                d.connector = $('#connector').val();
                d.month = $('#month').val();
            }
        },
         "columns": [
                {
                    "data": null,
                    "className": 'details-control',
                    "orderable": false,
                    "searchable": false,
                    "defaultContent":
                        '<span class="circle-icon">' +
                        '<i class="bi bi-caret-right-fill collapse-icon"></i>' +
                        '</span>'
                },
                {   // 2️⃣ Checkbox
                    "data": "id",
                    "orderable": false,
                    "render": function (data) {
                        return '<input type="checkbox" name="selected_rows[]" class="row-checkbox" value="' + data + '">';
                    }
                },
            
                { "data": "sr_no" },                  // 3️⃣ Sr.No
            
                <?php if($_SESSION['staff_type']==0){ ?>
                    { "data": "partner_name" },        // 4️⃣ Partner Name
                <?php } ?>
            
                { "data": "user_name" },               // 5️⃣ Applicant Name
                { "data": "rbo_name" },                // 6️⃣ RBO
                { "data": "branch_name" },             // 7️⃣ Branch Name
                { "data": "city_name" },               // 8️⃣ City
                { "data": "user_type" },               // 9️⃣ Loan Type
                { "data": "sanction_amt" },            // 🔟 Sanction Loan Amt
                { "data": "disb_date" },               // 1️⃣1️⃣ DISB Date
            
                <?php if($_SESSION['staff_id']==14 || $_SESSION['staff_id']==651 || $_SESSION['staff_id']==13 || $_SESSION['staff_id']==538 || $_SESSION['staff_id']==28){ ?>
                    { "data": "part_payout" },          // 1️⃣2️⃣ Partner Payout
                <?php } ?>
            
                { "data": "appraisal" },               // 1️⃣3️⃣ Appraisal Letter
                { "data": "add_date" },                // 1️⃣4️⃣ Add Date
            
                {   // 1️⃣5️⃣ Action
                    "data": "action",
                    "orderable": false,
                    "searchable": false
                }
            ],
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "pageLength": 50
    });
    
      // Move buttons into left-area
    table.buttons().container().appendTo($('.export-buttons'));

    // Search box
    $("#tableSearch").on("keyup", function () {
        table.search(this.value).draw();
    });

    
    // Step 3 — Expandable Row Content
$('#Table tbody').on('click', 'td.details-control', function () {
    var tr = $(this).closest('tr');
    var row = table.row(tr);
    var icon = tr.find('.collapse-icon');

    if (row.child.isShown()) {
        row.child.hide();
        icon.removeClass('rotate-down');
    } else {
        row.child(format(row.data())).show();
        icon.addClass('rotate-down');
    }
});


// Open panel
$("#tableSettingsBtn").on("click", function () {
    $("#tableSettingsPanel, #tableSettingsOverlay").addClass("active");
});

// Close panel
$("#closeTableSettings, #tableSettingsOverlay").on("click", function () {
    $("#tableSettingsPanel, #tableSettingsOverlay").removeClass("active");
});

// Apply filters
$("#applyFilters").on("click", function () {
    table.ajax.reload();
    $("#tableSettingsPanel, #tableSettingsOverlay").removeClass("active");
});

// Reset filters
$("#resetFilters").on("click", function () {
    $('#branch, #connector, #month').val('');
    table.ajax.reload();
});


function renderDocuments(letters) {

    if (!letters || letters.length === 0) {
        return 'N/A';
    }

    let html = '';
    letters.forEach(function (url) {
        html += `
            <a href="${url}" target="_blank">
                <i class="bi bi-eye-fill"></i> Appraisal Letter
            </a><br>
        `;
    });

    return html;
}

// Function that returns the expandable HTML
function format(row) {
    return `
        <div class="child-wrap">

            <!-- Documents row -->
            <div class="child-row-wrap">
                <div class="child-dot"></div>
                <div class="child-content">
                    <strong>Documents :</strong>
                    ${renderDocuments(row.letters)}
                    &nbsp;&nbsp;
                   
                </div>
            </div>

            <!-- Remark row (NEXT LINE) -->
            <div class="child-row-wrap">
                <div class="child-dot"></div>
                <div class="child-content">
                    <strong>Remark :</strong>
                   
                </div>
            </div>

        </div>
    `;
}

   

    $("#filterForm").submit(function (e) {
        e.preventDefault();
        table.ajax.reload();
    });

    $("#resetFilter").click(function () {
        $("#filterForm")[0].reset();
        $('.single-select').each(function() {
            $(this).val('').trigger('change');
        });
        table.ajax.reload();
    });

    table.buttons().container().appendTo('#Table_wrapper .col-md-6:eq(0)');

    table.on('draw', function () {
        restoreSelectedRows();
    });

    $('#Table tbody').on('change', 'input[name="selected_rows[]"]', function () {
        updateSelectedRows();
    });

    // Initialize selected rows object
    let selectedRows = {};

    function updateSelectedRows() {
        $("tbody input[name='selected_rows[]']").each(function () {
            if ($(this).is(':checked')) {
                selectedRows[$(this).val()] = true;
            } else {
                delete selectedRows[$(this).val()];
            }
        });
    }

    function restoreSelectedRows() {
        $("tbody input[name='selected_rows[]']").each(function () {
            if (selectedRows[$(this).val()]) {
                $(this).prop('checked', true);
            } else {
                $(this).prop('checked', false);
            }
        });
    }

    $("#checkAll").on('change', function () {
        var checkboxes = $("input[name='selected_rows[]']");
        checkboxes.prop('checked', this.checked);
        updateSelectedRows();
    });
 
    $(document).on('click', '#GenerateInvoiceButton', function (e) {
    e.preventDefault(); // important for <a>

    if (Object.keys(selectedRows).length > 0) {
        $('#GenrateInvoiceModal').modal('show');
    } else {
        alert("Please select at least one row before generating the invoice.");
    }
});


    $("#applyinvoice").click(function () {
        const inv_type = $("#invoice_type").val();
        const invoice_date = $("#invoice_date").val();
        const signature_id = $("#signature_id").val();
        const is_tenper_hold = $("#is_tenper_hold").val();
        const selectedRowsArray = Object.keys(selectedRows);

        if (!inv_type || !invoice_date || !signature_id) {
            alert("Please complete all fields.");
            return;
        }

        $.ajax({
            type: "POST",
            url: "<?= base_url('admin/generate_invoice_pb'); ?>",
            data: { 
                inv_type: inv_type, 
                invoice_date: invoice_date, 
                signature_id: signature_id, 
                is_tenper_hold: is_tenper_hold, 
                selectedRows: JSON.stringify(selectedRowsArray)
            },
            success: function (response) {
                var data = JSON.parse(response);
                if (data.status === 'success') {
                    alert(data.message);
                    window.location.href = '<?= base_url("admin/manage_invoice_pb") ?>';
                } else {
                    alert("Error: " + data.message);
                }
            }
        });
    });

    $(document).on('change', '.remark-input', function () {
        var userId = $(this).data('id');
        var remark = $(this).val();

        $.ajax({
            type: 'POST',
            url: '<?= base_url('admin/update_remark'); ?>',
            data: { user_id: userId, remark: remark },
            success: function (response) {
                var res = JSON.parse(response);
                if (res.success) {
                    alert("Remark updated successfully.");
                } else {
                    alert("Error updating remark.");
                }
            }
        });
    });

    $(document).on('change', '.commoon_active_pb_approve', function () {
        var element = $(this);
        var nextStatus = element.val();
        var id = element.data('id');
        var action = element.attr('action');

        $.ajax({
            type: 'POST',
            url: "<?= base_url('admin/') ?>" + action + "/" + id + "/" + nextStatus,
            success: function (response) {
                var res = JSON.parse(response);
                if (res.success === '1') {
                    element.removeClass('bg-success bg-warning');
                    if (nextStatus === '1') {
                        element.addClass('bg-success');
                    } else {
                        element.addClass('bg-warning');
                    }
                    alert(res.message);
                } else {
                    alert(res.message);
                }
            }
        });
    });

});

</script>

  <!-- Pass PHP session value to JS -->
 
<style>

    #GenerateInvoiceButton {
    transition: all 0.3s ease-in-out;
}

#GenerateInvoiceButton:hover {
    background-color: #0056b3; /* Slightly darker blue */
    transform: scale(1.05); /* Slight hover zoom effect */
}
</style>




