<?php
function getIndianCurrency(float $amount) {
        $amount_after_decimal = round($amount - ($num = floor($amount)), 2) * 100;

    // Define the words for numbers
    $change_words = array(
        0 => 'Zero', 1 => 'One', 2 => 'Two',
        3 => 'Three', 4 => 'Four', 5 => 'Five', 6 => 'Six',
        7 => 'Seven', 8 => 'Eight', 9 => 'Nine',
        10 => 'Ten', 11 => 'Eleven', 12 => 'Twelve',
        13 => 'Thirteen', 14 => 'Fourteen', 15 => 'Fifteen',
        16 => 'Sixteen', 17 => 'Seventeen', 18 => 'Eighteen',
        19 => 'Nineteen', 20 => 'Twenty', 30 => 'Thirty',
        40 => 'Forty', 50 => 'Fifty', 60 => 'Sixty',
        70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety'
    );

    // Define the place values
    $here_digits = array('', 'Hundred', 'Thousand', 'Lakh', 'Crore');

    // Convert the number to words
    $string = array();
    $count_length = strlen($num);
    $x = 0;
    while ($x < $count_length) {
        $get_divider = ($x == 2) ? 10 : 100;
        $amount = floor($num % $get_divider);
        $num = floor($num / $get_divider);
        $x += $get_divider == 10 ? 1 : 2;
        if ($amount) {
            $add_plural = (($counter = count($string)) && $amount > 9) ? 's' : null;
            $amt_hundred = ($counter == 1 && $string[0]) ? ' and ' : null;
            if ($amount < 21) {
                $string[] = $change_words[$amount] . ' ' . $here_digits[$counter] . $add_plural . ' ' . $amt_hundred;
            } else {
                $string[] = $change_words[floor($amount / 10) * 10] . ' ' . $change_words[$amount % 10] . ' ' . $here_digits[$counter] . $add_plural . ' ' . $amt_hundred;
            }
        } else {
            $string[] = null;
        }
    }

    // Convert the words to Indian currency format
    $implode_to_Rupees = implode('', array_reverse($string));
    $get_paise = ($amount_after_decimal > 0) ? "And " . ($change_words[intval($amount_after_decimal / 10)] . " " . $change_words[$amount_after_decimal % 10]) . ' Paise' : '';

    return ($implode_to_Rupees ? $implode_to_Rupees . ' Rupees ' : '') . $get_paise;

}


function formatIndianNumber($number) {
  // Round up the number to two decimal places
    $rounded_number = round($number, 2);

    // Convert the rounded number to string
    $number_str = strval($rounded_number);

    // Split the number into integral and fractional parts
    $parts = explode('.', $number_str);

    // Format the integral part
    $integral_part = $parts[0];
    $formatted_integral = '';

    // Format the integral part with commas after every two digits if the number has six or more digits
    $len = strlen($integral_part);
    $i = $len - 1;
    $count = 0;
    while ($i >= 0) {
        $formatted_integral = $integral_part[$i] . $formatted_integral;
        $count++;
        if (($count == 3 || $count == 5 || $count == 7) && $i != 0) {
            $formatted_integral = ',' . $formatted_integral;
        }
        $i--;
    }

    // Format the fractional part
    $formatted_fractional = isset($parts[1]) ? '.' . str_pad($parts[1], 2, '0') : '';

    // Combine the formatted integral part with the formatted fractional part
    $formatted_number = $formatted_integral . $formatted_fractional;

    return $formatted_number;
}

?>

  

 <main class="page-content"> 
 
              <div id="invoice">
                  <style>
                      .table-bordered {
                        border-collapse: collapse;
                        border: 1px solid #CCCCCC; /* Border color */
                    }
                    
                    .table-bordered th,
                    .table-bordered td {
                        border: 1px solid #CCCCCC; /* Border color */
                        padding: 4px; /* Adjust padding as needed */
                    }
                    
                  </style>
                   <div class="card-body bg-white">
             


    <table class="table table-invoice table-bordered" id="gstTable">
      
	                <thead>
                <tr>
                    <td colspan="12" style="font-size:10px;background-color:rgb(217, 225, 242);border-bottom:0.5pt solid black;border-left:0.5pt solid windowtext;border-right-style:block;border-top:0.5pt solid windowtext;height:18.0pt;padding:3px;text-align:center;">
                        <strong>GST TAX INVOICE</strong>
                    </td>
               </tr>
               	<tr>
			<td colspan="4" style="width: 29%;">
			<p><strong>Name of HLC: MortgageBuddy Private Limited</strong></p>
			ADDRESS: Office No H 218, 2nd Floor, Tower No 3, Belapur Station Complex, CBD Belapur, Navi Mumbai - 400614, Maharashtra</td>
			
			<td colspan="5" rowspan="2" style="width: 41.7%;">
			<p><img src="https://www.mortgagebuddy.in/myimg/logofinal.png" style="width:2000%; text-align:center;"/></p>
			<p style="text-align:center;"><strong>CORPORATE CHANNEL PARTNER OF SBI</strong></p>
				Office No- 022 46082235<br />
			Mobile - 8830394993<br />
			Email - Accounts@mortgagebuddy.in
			</td>
			
			<td colspan="3" rowspan="2" style="width: 29.3%;">
			<p><strong>TO</strong><br />
			<strong>STATE BANK OF INDIA</strong><br />
			City - <?= @$city->city_name; ?>, State-<?= @$state->state_name; ?><br />
			GSTIN NO - 27AAACS8577K2ZO<br />
			RBO -</p>
			<br>
			<strong>Invoice No : <?= $invoice_num; ?></strong><br>
			<strong>Invoice Date : <?= date('d-m-Y',strtotime($invoice_date))?></strong></td>
		</tr>
		<tr>
			<td colspan="4" rowspan="6">HLC Code -MUMHLC03147<br />
			GSTIN NO -27AAQCM2355K1ZZ<br />
			PAN NO- AAQCM2355K<br />
			Bank Account No : 41326113534</td>
		</tr>

	</thead>
       <tbody>
		<tr>
			<td rowspan="2" style="text-align:center" width="3%">Sr. No.</td>
			<td rowspan="2" style="text-align:center">CBS A/c No</td>
			<td rowspan="2" style="text-align:center" width="11%">Branch</td>
			<td rowspan="2" style="text-align:center" width="6.7%">HSN / SAC</td>
			<td rowspan="2" style="text-align:center">Taxable Value Rs</td>
			<td colspan="2" style="text-align:center">CGST</td>
			<td colspan="2" style="text-align:center">SGST</td>
			<td colspan="2" style="text-align:center">IGST</td>
			<td rowspan="2" style="text-align:center" width="12.6%">TOTAL</td>
		</tr>
		<tr>
			<td style="text-align:center">Rate</td>
			<td style="text-align:center">Amount Rs</td>
			<td style="text-align:center">Rate</td>
			<td style="text-align:center">Amount Rs</td>
			<td style="text-align:center">Rate</td>
			<td style="text-align:center">Amount Rs</td>
		</tr>
		 <?php
                     if (!empty($invoice_items)) {
                        $totalTaxableValue = 0;
                        $totalCgstAmount =0;
                        $totalSgstAmount =0;
                          
                        $tot90percent_commi = 0;
                        $totcommissionRR = 0;
                        foreach ($invoice_items as $key => $row) { 
                            $user_data = $this->db->select("*")->from('mst_user')->where(['id' =>$row['user_id']])->get()->row();
                            $user_branch = $this->db->select("*")->from('branch')->where(['id' => $user_data->branch_id])->get()->row();
                            $type_data = $this->db->select("*")->from('mst_loan_type')->where(['id' =>$user_data->loan_type_id])->get()->row();
                            $tot90percent_commi += $row['90percent_commi'];
                            $totcommissionRR += $row['rr_fix_commi'];
                            
                            $totalTaxableValue += $row['90percent_commi'] + $row['rr_fix_commi'];
                            $totalCgstAmount += ($row['90percent_commi'] * 9 / 100) + ($row['rr_fix_commi'] * 9 / 100);
                            $totalSgstAmount += ($row['90percent_commi'] * 9 / 100) + ($row['rr_fix_commi'] * 9 / 100);
                           ?>
                		<tr>
                			<td style="text-align:center"><?= $key +1; ?></td>
                			 <td>
                                 <?php if($row['loan_type_id']==5){ ?>
                                  <?= $user_data->rr_cbs_acct_no; ?>
                                  <?php } else{ ?>
                                  <?= $user_data->bank_acct_no; ?>
                                  <?php } ?>
                            </td>
                			<td style="text-align:left;"><?= $user_branch->branch_name; ?><br>(<?= $user_branch->branch_code; ?>) </td> 
                		
                			<td style="text-align:center;">9971</td>
                			<td class="taxable-value" style="text-align:center;">
                                <?= formatIndianNumber(round($row['90percent_commi'])) ?>
                            </td>
                			<td style="text-align:center;">9%</td>
                			<td class="tot_amount1 cgst-amount" style="text-align:center;">
                                 <?= formatIndianNumber(round($row['90percent_commi']*9/100)) ?>
                            </td>
                			<td style="text-align:center;">9%</td>
                			<td class="sgst-amount" style="text-align:center;">
                            <?= formatIndianNumber(round($row['90percent_commi']*9/100)) ?>
                            </td>
                			<td style="text-align:center;">18.00%</td>
                			<td style="text-align:center;">
                                -
                            </td>
                            <?php $row_tot_new = ($row['90percent_commi'] + ($row['90percent_commi']*9/100) + ($row['90percent_commi']*9/100)); ?>
                	<td class="row-total-amount" style="text-align:right;"><?= formatIndianNumber(round($row_tot_new)); ?></td>
                </tr>
                
                  <?php if($row['loan_type_id']==5){ ?>
                       <tr>
                           <td></td>
                            <td>
                             <?php if($row['loan_type_id']==5){ ?>
                              <?= $user_data->rr_cbs_acct_no; ?>
                              <?php } else{ ?>
                              <?= $user_data->bank_acct_no; ?>
                              <?php } ?>
                            </td>
                           <td><?= $user_branch->branch_name; ?><br>(<?= $user_branch->branch_code; ?>) </td> 
                           <td style="text-align:center;">9971</td>
                           <td class="taxable-value" style="text-align:center;"><?= formatIndianNumber(round($row['rr_fix_commi'])) ?></td> 
                           <td style="text-align:center;">9%</td>
                           <td class="cgst-amount" style="text-align:center;"><?= formatIndianNumber(round($row['rr_fix_commi']*9/100)) ?>
                            </td>
                           <td style="text-align:center;">9%</td>
                           <td class="sgst-amount" style="text-align:center;"><?= formatIndianNumber(round($row['rr_fix_commi']*9/100)) ?></td>
                            <td style="text-align:center;">18.00%</td>
                            <td style="text-align:center;">-</td>
                             <?php $row_tot_rr = ($row['rr_fix_commi'] + ($row['rr_fix_commi']*9/100) + ($row['rr_fix_commi']*9/100)); ?>
                          <td class="row-total-amount" style="text-align:right;"><?= formatIndianNumber(round($row_tot_rr)); ?></td>
                           
                     </tr>
                     <?php } ?> 
                     <?php } ?> 
                     <?php } ?> 
                 
            		<tr>
            			<td></td>
            			<td></td>
            			<td></td>
            			<td></td>
            			<td></td>
            			<td></td>
            			<td></td>
            			<td></td>
            			<td></td>
            			<td></td>
            			<td style="text-align:center;">-</td>
            			<td style="text-align:center;">-</td>
            		</tr>
		<tr>
			<td></td>
			<td><strong>Sub Total</strong></td>
			<td></td>
			<td></td>
			<td class="taxable-value-total text-center"><strong><?= formatIndianNumber(round($totalTaxableValue)); ?></strong></td>
			<td></td>
			<?php $total90perGSTBILL = round($tot90percent_commi+$totcommissionRR); ?> 
			<td class="cgst-total-amt text-center"><strong><?= formatIndianNumber($total90perGSTBILL*9/100); ?></strong></td>
			<td></td>
			<td class="sgst-total-amt text-center"><strong><?= formatIndianNumber($total90perGSTBILL*9/100); ?></strong></td>
			<td></td>
			<td style="text-align:center;">-</td>
			<?php $totAmtall = $total90perGSTBILL + $total90perGSTBILL*9/100 + $total90perGSTBILL*9/100; ?>
			<td class="total" style="text-align:right;"><strong><?= formatIndianNumber($totAmtall); ?></strong></td>
		</tr>
		<tr>
			<td colspan="8" rowspan="2">In Word: <?= @getIndianCurrency($total90perGSTBILL + $total90perGSTBILL*18/100); ?></td>
			<td colspan="3" style="background-color:rgb(217, 225, 242);"><strong>TOTAL GST</strong></td>
			<td style="background-color:rgb(217, 225, 242);text-align:right;"><strong><?= formatIndianNumber($total90perGSTBILL*18/100); ?></strong></td>
		</tr>
	
	</tbody>
</table>

  <table class="table" style="width: 100%; border-collapse: collapse;">
    <tr>
        <td colspan="4" rowspan="3" style="border: none;">
            <br>For Approval Rs. <?= formatIndianNumber($totAmtall); ?>
            <br>Recommended for HLC Commission
            <br><br><br><br>
            <b>Regional Manager (RBO)</b>
        </td>
        <td colspan="4" style="border: none;">
            <br>For Approval Rs. <?= formatIndianNumber($totAmtall); ?> recommended
            <br><br><br><br><br>
            <b>Manager/Chief Manager</b>
        </td>
        <td colspan="4" style="text-align: right; border: none;">
           <table style="width: 100%; border: none;">
                <tr>
                    <td style="width: 40%; text-align: center; border: none;">
                        <img src="<?= base_url() ?>assets/site_img/Rubber_Stamp_MBPL_circle.png" style="height: 50px;">
                    </td>
                    <td style="width: 60%; border: none;">
                        <br><b>For, Mortgagebuddy Private Limited</b>
                        <br><img src="<?= base_url() ?>assets/site_img/Sign_bhushan.png" style="height: 30px;">
                        <br><b>Authorised Signatory</b>
                    </td>
                </tr>
            </table>
             
        </td>
    </tr>
</table>


   
<!-------------------------HLC BILL-------------------------------------->  
<!-------------------------HLC BILL-------------------------------------->  
<!-------------------------HLC BILL-------------------------------------->  
<!-------------------------HLC BILL-------------------------------------->  

 <style>
 
        .new-page {
            page-break-before: always; /* or page-break-after: always; */
           
        }
    </style>
     <div class="new-page"></div>
                <table class="table table-invoice table-bordered">
                  <thead>
                <tr>
                    <td colspan="12" style="font-size:10px;background-color:rgb(217, 225, 242);border-bottom:0.5pt solid black;border-left:0.5pt solid windowtext;border-right-style:block;border-top:0.5pt solid windowtext;height:18.0pt;padding:3px;text-align:center;">
                        <span style="color:black;"><strong>HLC BILL</strong></span>
                    </td>
               </tr>
               	<tr>
			<td colspan="4" style="width: 29%;">
			<p><strong>Name of HLC: MortgageBuddy Private Limited</strong></p>
			ADDRESS: Office No H 218, 2nd Floor, Tower No 3, Belapur Station Complex, CBD Belapur, Navi Mumbai - 400614, Maharashtra</td>
			
			<td colspan="5" rowspan="2" style="width: 41%;">
			<p><img src="https://www.mortgagebuddy.in/myimg/logofinal.png" style="width:2000%; text-align:center;"/></p>
			<p style="text-align:center;"><strong>CORPORATE CHANNEL PARTNER OF SBI</strong></p>
				Office No- 022 46082235<br />
			Mobile - 8830394993<br />
			Email - Accounts@mortgagebuddy.in
			</td>
			
			<td colspan="3" rowspan="2" style="width: 30%;">
			<p><strong>TO</strong><br />
			<strong>STATE BANK OF INDIA</strong><br />
			City - <?= @$city->city_name; ?>, State-<?= @$state->state_name; ?><br />
			GSTIN NO - 27AAACS8577K2ZO<br />
			RBO -</p>
			<br>
			<strong>Invoice No : <?= $invoice_num; ?></strong><br>
			<strong>Invoice Date : <?= date('d-m-Y',strtotime($invoice_date))?></strong></td>
		</tr>
		<tr>
			<td colspan="4" rowspan="6">HLC Code -MUMHLC03147<br />
			GSTIN NO -27AAQCM2355K1ZZ<br />
			PAN NO- AAQCM2355K<br />
			Bank Account No : 41326113534</td>
		</tr>

	</thead>
                 <style>
                     .text-center{
                         text-align:center;
                     }
                 </style> 
                 
		               <tr style="background-color:rgb(217, 225, 242);font-weight: bold;">
                         <th class="text-center" width="3%">Sr. No</th>
                         <th class="text-center" width="15%">LOS ID & RLMS<br>Name of Borrower</th>
                         <th class="text-center" width="11%">Branch</th>
                         <th class="text-center" width="10%">CBS A/c.</th>
                         <th class="text-center" width="8%">Type of Loan</th>
                         <th class="text-center" width="8%">Date of Disb</th>
                         <th class="text-center" width="10%">Loan Amount</th>
                         <th class="text-center" width="5%">Slab</th>
                         <th class="text-center" width="6%">Comm<br> %</th>
                         <th class="text-center" width="7%">Total<br>Comm</th>
                         <th class="text-center" width="7%">10% <br>Hold</th>
                         <th class="text-center" width="10%">Comm to be  <br>paid (90%)</th>
                        
                      </tr>
	
                   <tbody>
                   <?php
                     if (!empty($invoice_items)) {
                        $totalLoanAmt = 0;
                        $totalCommisionAmt = 0;
                        $tot10percent_commi = 0;
                        $tot90percent_commi = 0;
                        $totcommissionRR = 0;

                        foreach ($invoice_items as $key => $row) { 
                            $user_data = $this->db->select("*")->from('mst_user')->where(['id' =>$row['user_id']])->get()->row();
                            $user_branch = $this->db->select("*")->from('branch')->where(['id' => $user_data->branch_id])->get()->row();
                            $type_data = $this->db->select("*")->from('mst_loan_type')->where(['id' =>$user_data->loan_type_id])->get()->row();
                            $totalLoanAmt += $row['loan_amt'];
                            $totalCommisionAmt += $row['total_commission'];
                            $tot10percent_commi += $row['10percent_commi'];
                            $tot90percent_commi += $row['90percent_commi'];
                            $totcommissionRR += $row['rr_fix_commi'];
                           
                           $rr_aact = $this->db->select("*")->where(['applicant_rr_id' => $row['user_id'], 'rinnraksha_status' => 'Yes'])->from('mst_user')->get()->row();
                           ?>
                      <tr>
                         <td>                           
                         <?= $key + 1 ?>
                         </td>
                         <td style="text-align:left;"><?= $user_data->los_id; ?><br><?= $user_data->user_name; ?></td>
                         <td style="text-align:left;"><?= $user_branch->branch_name; ?><br>(<?= $user_branch->branch_code; ?>) </td>                         
                          <td style="text-align:center;">
                             <?php if($row['loan_type_id']==5){ ?>
                              <?= $user_data->rr_cbs_acct_no; ?>
                              <?php } else{ ?>
                              <?= $user_data->bank_acct_no; ?>
                              <?php } ?>
                         </td>
                         <td>
                            <?= $type_data->name; ?>
                         </td>
                         
                         <td>
                            <?= date('d.m.Y',strtotime($user_data->disb_date)); ?>
                         </td>
                         <td>
                            <?= formatIndianNumber($row['loan_amt']); ?>
                         </td>                        
                                            
                         <td>
                            <?= $user_data->commi_slab; ?>
                         </td>
                         <td>
                           <?= $user_data->sbi_commi; ?>%
                         </td>
                         
                         <td>
                           <?= formatIndianNumber(round($row['total_commission'])) ?>
                         </td>
                         
                          <td>
                            <?= formatIndianNumber(round($row['10percent_commi'])) ?>
                         </td>
                         
                         <td style="text-align:left;">
                           <?= formatIndianNumber(round($row['90percent_commi'])) ?>
                         </td>
                         
                       
                        </tr>
                    <?php if($row['loan_type_id']==5){ ?>
                       <tr>
                           
                           <td></td>
                           <td style="text-align:left;"><?= $user_data->los_id; ?><br><span class="text-inverse"><?= $user_data->user_name; ?></span></td>
                           <td style="text-align:left;"><?= $user_branch->branch_name; ?><br>(<?= $user_branch->branch_code; ?>) </td> 
                            <td style="text-align:center;">
                             <?php if($row['loan_type_id']==5){ ?>
                              <?= $user_data->rr_cbs_acct_no; ?>
                              <?php } else{ ?>
                             <?= $user_data->bank_acct_no; ?>
                              <?php } ?>
                            </td>
                           <td>RR Commission</td>
                           <td></td> 
                           <td></td>
                           <td></td>
                           <td></td>
                           <td></td>
                           <td></td>
                           <?php
                                    if ($user_data->rinnraksha_status == 'Yes' && empty($user_data->applicant_rr_id)) { 
                                        // Calculate commission based on different conditions
                                        @$rr_sanction_amt = $this->db->select("*")->where(['id' => $rr_aact->id])->from('mst_user')->get()->row();
                                        $sanctionAmt = @$rr_sanction_amt->sanction_amt;
                                        $premiumAmt = $user_data->rinnraksha_amt;
                                        $premiumCommission = $premiumAmt * $row['conn_commision_set'];
                                        
                                        if ($sanctionAmt >= 100000 && $sanctionAmt < 5000000) {
                                            $commission = 4000;
                                        } elseif ($sanctionAmt >= 5000000 && $sanctionAmt < 10000000) {
                                            $commission = 5000;
                                        } elseif ($sanctionAmt >= 10000000) {
                                            $commission = 6000;
                                        } ?>
                                        <td style="text-align:left !important;"> <?= formatIndianNumber(round($commission)) ?></td>
                                      <?php
                                    } else { ?>
                                       <td style="text-align:left !important;"><?= formatIndianNumber(round($row['total_commission'])) ?></td>
                                   <?php }
                                    ?>
                           
                      </tr>
                     <?php } ?> 
                     <?php } ?> 
                     <?php } ?> 
                 
                 
                   
                     
                      <tr>
                        <?php $total90per = round($tot90percent_commi+$totcommissionRR); 
                        
                         $netPay = $total90per+$total90per * 18 / 100;
                        
                        ?>
                        
                           <td colspan="7" rowspan="3"> <strong>In Word : <?= @getIndianCurrency($total90per+$total90per * 18 / 100); ?></strong></td>
                           <td colspan="2" style="text-align:right;"><b>Sub Total</b></td>
                           <td><b><?= formatIndianNumber(round($totalCommisionAmt)); ?></b></td>
                           <td><b><?= formatIndianNumber(round($tot10percent_commi)); ?></b></td>
                           <td><b><?= formatIndianNumber(round($total90per)); ?></b></td>
                         
                     </tr>
                     
                     <tr>
                           <td colspan="2" style="text-align:right;"><b>Tax Amount Rs</b></td>
                           <td><b>CGST 9% <br><?= formatIndianNumber($total90per * 9 /100) ?></b></td>
                           <td><b>SGST 9% <br><?= formatIndianNumber($total90per * 9 /100) ?></b></td>
                           <td><b>IGST 18%<br>-</b></td>
                     </tr>
                     
                  
                     <tr>
                           <td colspan="3" style="text-align:right;"><b>TOTAL PAYABLE</b></td>
                           <td colspan="9" style="text-align:right;"><b><?= formatIndianNumber($total90per+$total90per * 18 / 100) ?></b></td>
                     </tr>
                     
                   </tbody>
                </table>
               
               <table class="table" style="margin-top:10px;">
        <tr>
                <td colspan="4" rowspan="3" style="border: none;">
                <br>For Approval Rs. <?= formatIndianNumber($total90per+$total90per * 18 / 100) ?>
                <br>Recommended  for HLC Commission
               <br> <br> <br>  <br><b>Regional manager (RBO)</b>
                </td>
                <td colspan="4" style="border: none;">
                  <br>For Approval Rs <?= formatIndianNumber($total90per+$total90per * 18 / 100) ?> recommended
<br><br><br><br><br><b>Manager/Chief Manager</b> 
                </td>
                
                 
        <td colspan="4" style="text-align: right; border: none;">
           <table style="width: 100%; border: none;">
                <tr>
                    <td style="width: 40%; text-align: center; border: none;">
                        <img src="<?= base_url() ?>assets/site_img/Rubber_Stamp_MBPL_circle.png" style="height: 50px;">
                    </td>
                    <td style="width: 60%; border: none;">
                        <br><b>For, Mortgagebuddy Private Limited</b>
                        <br><img src="<?= base_url() ?>assets/site_img/Sign_bhushan.png" style="height: 30px;">
                        <br><b>Authorised Signatory</b>
                    </td>
                </tr>
            </table>
             
        </td>
                    
            </tr>
    </table>
             </div>
             </div>
            
      </main>
  </div>
  <!--end wrapper-->
 
