<?php
// invoice_gst_fixed_full.php
defined('BASEPATH') OR exit('No direct script access allowed');

// ------------------ Helpers / business logic ------------------
function customRound($value) {
    return ($value - floor($value) >= 0.5) ? round($value) : $value;
}

// RR policy cutoff helper — from 2025-10-02 inclusive the new policy applies
function rrNewPolicyApplies($disbDate) {
    try {
        return (new DateTime($disbDate)) >= new DateTime('2025-10-02');
    } catch (Exception $e) {
        return false;
    }
}

function calculateTotalCommission($user_data, $commissionRate) {
    $CI = &get_instance();
    $totalCommission = 0;
    $loan_type_id = $user_data->loan_type_id;

    if ($loan_type_id == 5) {
        $financial_year = $CI->session->userdata('financial_year');
        $fixed_rr_commission = calculate_rr_commission_multi_year($financial_year, $user_data);

        $premiumCommission = 0;
        if ($user_data->rinnraksha_status == 'Yes' && empty($user_data->applicant_rr_id)) {
            $premiumCommission = ($user_data->rinnraksha_amt ?? 0) * $commissionRate / 100;
        }
        $totalCommission = $fixed_rr_commission + $premiumCommission;
    } else {
        if ($loan_type_id == 4 && ($user_data->sanction_amt ?? 0) <= 1000000) {
            $totalCommission = 2000;
        } else {
            $totalCommission = ($user_data->sanction_amt ?? 0) * $commissionRate / 100;
        }
    }

    return $totalCommission;
}

function calculateRR($user_data, $commissionRate) {
    $CI = &get_instance();
    if ($user_data->loan_type_id == 5) {
        $financial_year = $CI->session->userdata('financial_year');
        return calculate_rr_commission_multi_year($financial_year, $user_data);
    }
    return 0;
}

/**
 * Central helper to get commissionFixed and rr_commision_row for RR entries.
 * Returns array: [commissionFixed, rr_commision_row]
 *
 * Uses calculate_rr_commission_multi_year() as source-of-truth for fixed RR commission.
 * Computes rr_commision_row (10% held back) only for PRE-CUTOFF (old policy).
 */
function getRRFixedCommission($user_data) {
    $commissionFixed = 0.0;
    $rr_commision_row = 0.0;

    if (empty($user_data) || !isset($user_data->loan_type_id)) {
        return [$commissionFixed, $rr_commision_row];
    }

    if ((int)$user_data->loan_type_id !== 5) {
        return [$commissionFixed, $rr_commision_row];
    }

    // Must be primary RR applicant with rinnraksha_status Yes
    if (($user_data->rinnraksha_status ?? '') !== 'Yes' || !empty($user_data->applicant_rr_id)) {
        return [$commissionFixed, $rr_commision_row];
    }

    $CI = &get_instance();

    // Try to find a related rr account (if your previous logic expects that)
    $rr_aact = $CI->db->select("*")
                ->where(['applicant_rr_id' => $user_data->id, 'rinnraksha_status' => 'Yes'])
                ->from('mst_user')->get()->row();

    // Prefer passing the canonical RR record to the existing helper
    $reference_user = ($rr_aact && !empty($rr_aact->id)) ? $rr_aact : $user_data;

    // Use your existing authoritative function to get fixed commission
    $commissionFixed = (float) calculate_rr_commission_multi_year($CI->session->userdata('financial_year'), $reference_user);

    // ---- IMPORTANT CHANGE: no 10% hold ----
    // Return full fixed commission as the extra RR row (if caller decides to render it)
    if ($commissionFixed > 0) {
        $rr_commision_row = $commissionFixed; // previously was commissionFixed - 10%
    }

    return [$commissionFixed, $rr_commision_row];
}

?>

<main class="page-content">
    <div id="invoice">
        <style>
            .table-bordered { border-collapse: collapse; border: 1px solid #CCCCCC; width:100%; }
            .table-bordered th, .table-bordered td { border: 1px solid #CCCCCC; padding: 4px; }
            .text-center { text-align:center; }
        </style>

        <div class="card-body bg-white">
            <table class="table table-invoice table-bordered" id="gstTable">
                <thead>
                    <tr>
                        <td colspan="12" style="font-size:10px;background-color:rgb(217,225,242);border-bottom:0.5pt solid black;height:18pt;padding:3px;text-align:center;">
                            <strong>GST TAX INVOICE</strong>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="4" style="width: 29%;">
                            <p><strong>Name of HLC: MortgageBuddy Private Limited</strong></p>
                            ADDRESS: Office No H 218, 2nd Floor, Tower No 3, Belapur Station Complex, CBD Belapur, Navi Mumbai - 400614, Maharashtra
                        </td>

                        <td colspan="5" rowspan="2" style="width: 41.7%; text-align:center;">
                            <p><img src="https://www.mortgagebuddy.in/myimg/logofinal.png" style="width:2000%;" alt="Logo"/></p>
                            <p style="text-align:center;"><strong>CORPORATE CHANNEL PARTNER OF SBI</strong></p>
                            Office No- 022 46082235<br />
                            Mobile - 8830394993<br />
                            Email - Accounts@mortgagebuddy.in
                        </td>

                        <td colspan="3" rowspan="2" style="width: 29.3%;">
                            <p><strong>TO</strong><br />
                                <strong>STATE BANK OF INDIA</strong><br />
                                City - <?= htmlspecialchars(@$city->city_name ?? '', ENT_QUOTES, 'UTF-8'); ?>, State - <?= htmlspecialchars(@$state->state_name ?? '', ENT_QUOTES, 'UTF-8'); ?><br />
                                GSTIN NO - 27AAACS8577K2ZO<br />
                                RBO - <?= htmlspecialchars(@$rbo->rbo_name ?? '', ENT_QUOTES, 'UTF-8'); ?></p>
                            <br>
                            <strong>Invoice No : <?= htmlspecialchars($invoice_num ?? '', ENT_QUOTES, 'UTF-8'); ?></strong><br>
                            <strong>Invoice Date : <?= date('d-m-Y', strtotime($invoice_date)); ?></strong>
                        </td>
                    </tr>

                    <tr>
                        <td colspan="4" rowspan="6">
                            HLC Code - MUMHLC03147<br />
                            GSTIN NO - 27AAQCM2355K1ZZ<br />
                            PAN NO - AAQCM2355K<br />
                            Bank Account No : 41326113534
                        </td>
                    </tr>

                </thead>

                <tbody>
                    <tr>
                        <td rowspan="2" style="text-align:center" width="3%">Sr. No.</td>
                        <td rowspan="2" style="text-align:center">CBS A/c No</td>
                        <td rowspan="2" style="text-align:center" width="11%">Branch</td>
                        <td rowspan="2" style="text-align:center" width="6.7%">HSN / SAC</td>
                        <td rowspan="2" style="text-align:center">Taxable Value Rs</td>
                        <td colspan="2" style="text-align:center">CGST</td>
                        <td colspan="2" style="text-align:center">SGST</td>
                        <td colspan="2" style="text-align:center">IGST</td>
                        <td rowspan="2" style="text-align:center" width="12.6%">TOTAL</td>
                    </tr>
                    <tr>
                        <td style="text-align:center">Rate</td>
                        <td style="text-align:center">Amount Rs</td>
                        <td style="text-align:center">Rate</td>
                        <td style="text-align:center">Amount Rs</td>
                        <td style="text-align:center">Rate</td>
                        <td style="text-align:center">Amount Rs</td>
                    </tr>

                    <?php
                    // Defaults & accumulators
                    $company_state = 27; // seller default state id
                    $buyer_state_id = isset($state->id) ? (int)$state->id : (int)$company_state;

                    $sum_taxable = 0.0;
                    $sum_cgst = 0.0;
                    $sum_sgst = 0.0;
                    $sum_igst = 0.0;
                    $sum_row_total = 0.0;

                    $sumTotalCommiCol = 0.0;
                    $sumTotalten10_commiCol = 0.0;
                    $sum_fix_commi_rr = 0.0;
                    $sum10_rr_Col = 0.0;

                    if (!empty($invoice_items)) {
                        $totalLoanAmt = 0;

                        foreach ($invoice_items as $key => $row) {
                            $user_data = $this->db->select("*")->from('mst_user')->where(['id' => $row['user_id']])->get()->row();
                            if (!$user_data) continue;
                            $user_branch = $this->db->select("*")->from('branch')->where(['id' => $user_data->branch_id])->get()->row();
                            $type_data = $this->db->select("*")->from('mst_loan_type')->where(['id' => $user_data->loan_type_id])->get()->row();

                            // Base loan amount
                            $loanAmount = $user_data->loan_type_id == 5 ? (float)($user_data->rinnraksha_amt ?? 0) : (float)($user_data->sanction_amt ?? 0);
                            $totalLoanAmt += $loanAmount;

                            // RR flags
                            $isRR = ((int)$user_data->loan_type_id === 5);
                            $isNewRRPolicy = $isRR && rrNewPolicyApplies($user_data->disb_date);

                            // Get commissionFixed and rr_commision_row from centralized helper
                            $commissionFixed = 0.0;
                            $rr_commision_row = 0.0;
                            if ($isRR) {
                                list($commissionFixed, $rr_commision_row) = getRRFixedCommission($user_data);
                            }

                            // If pre-cutoff and commissionFixed > 0 we already want to accumulate fixed and 10% hold totals
                            if ($isRR && !$isNewRRPolicy && $commissionFixed > 0) {
                                // ensure sums consistent (helper doesn't touch globals)
                                $sum_fix_commi_rr += $commissionFixed;
                                $sum10_rr_Col += round($commissionFixed * 10 / 100);
                            }

                            // legacy helper fixed RR (if used elsewhere for display of NEW policy)
                            $commi_rr = calculateRR($user_data, $user_data->sbi_commi);

                            // ---------- Determine main row commission ----------
                            if ($user_data->loan_type_id == 4 && (float)$user_data->sanction_amt >= 100000 && (float)$user_data->sanction_amt < 1000000) {
                                // Flat ₹2,000
                                $total_commi_row = 2000;
                                $displayPercent = '';
                            } else {
                                if ($isRR && $isNewRRPolicy && $commissionFixed > 0) {
                                    // NEW POLICY: main row shows fixed commission (commissionFixed)
                                    $total_commi_row = $commissionFixed;
                                    $displayPercent = 'Fixed';
                                } else {
                                    // OLD behavior or other loan types: use DB sbi_commi %
                                    $effectivePercent = (float)($user_data->sbi_commi ?? 0);
                                    $total_commi_row = $loanAmount * $effectivePercent / 100;
                                    $displayPercent = ($effectivePercent != 0) ? number_format($effectivePercent, 2, '.', '') . '%' : '';
                                }
                            }

                            // If pre-cutoff RR extra row exists, rr_commision_row should be displayed (already derived)
                            // Sum main row
                            $sumTotalCommiCol += $total_commi_row;
                            $ten10_commi_row = $total_commi_row * 10 / 100;
                            $sumTotalten10_commiCol += $ten10_commi_row;

                            // Taxable for the row (main row)
                            $ninty90_comm_row = $total_commi_row;

                            // Determine intra/inter state for tax splitting
                            $buyer_state_id_row = isset($state->id) ? (int)$state->id : (int)$company_state;
                            $is_intra = ($buyer_state_id_row === (int)$company_state);

                            // Per-row tax calc
                            if (!empty($ninty90_comm_row) && is_numeric($ninty90_comm_row)) {
                                if ($is_intra) {
                                    $cgst = ($ninty90_comm_row * 9 / 100);
                                    $sgst = ($ninty90_comm_row * 9 / 100);
                                    $igst = 0;
                                } else {
                                    $cgst = 0;
                                    $sgst = 0;
                                    $igst = ($ninty90_comm_row * 18 / 100);
                                }
                            } else {
                                $cgst = $sgst = $igst = 0;
                            }

                            $cgst_display = round($cgst, 2);
                            $sgst_display = round($sgst, 2);
                            $igst_display = round($igst, 2);

                            $row_tot_new = round($ninty90_comm_row + $cgst_display + $sgst_display + $igst_display);

                            // accumulate totals
                            $sum_taxable += round($ninty90_comm_row);
                            $sum_cgst += $cgst_display;
                            $sum_sgst += $sgst_display;
                            $sum_igst += $igst_display;
                            $sum_row_total += $row_tot_new;

                            // ---------- Render main row ----------
                            ?>
                            <tr>
                                <td style="text-align:center"><?= $key + 1; ?></td>
                                <td>
                                    <?= $row['loan_type_id'] == 5 ? htmlspecialchars($user_data->rr_cbs_acct_no ?? '', ENT_QUOTES, 'UTF-8') : htmlspecialchars($user_data->bank_acct_no ?? '', ENT_QUOTES, 'UTF-8'); ?>
                                </td>
                                <td style="text-align:left;"><?= htmlspecialchars($user_branch->branch_name ?? '', ENT_QUOTES, 'UTF-8'); ?><br>(<?= htmlspecialchars($user_branch->branch_code ?? '', ENT_QUOTES, 'UTF-8'); ?>)</td>
                                <td style="text-align:center;">9971</td>
                                <td class="taxable-value" style="text-align:center;"><?= formatIndianNumber(customRound($ninty90_comm_row)); ?></td>

                                <?php if ($is_intra): ?>
                                    <td style="text-align:center;">9%</td>
                                    <td class="tot_amount1 cgst-amount" style="text-align:center;"><?= formatIndianNumber($cgst_display); ?></td>
                                    <td style="text-align:center;">9%</td>
                                    <td class="sgst-amount" style="text-align:center;"><?= formatIndianNumber($sgst_display); ?></td>
                                    <td style="text-align:center;">-</td>
                                    <td style="text-align:center;">-</td>
                                <?php else: ?>
                                    <td style="text-align:center;">-</td>
                                    <td class="tot_amount1 cgst-amount" style="text-align:center;">-</td>
                                    <td style="text-align:center;">-</td>
                                    <td class="sgst-amount" style="text-align:center;">-</td>
                                    <td style="text-align:center;">18.00%</td>
                                    <td style="text-align:center;"><?= formatIndianNumber($igst_display); ?></td>
                                <?php endif; ?>

                                <td class="row-total-amount" style="text-align:right;"><?= formatIndianNumber($row_tot_new); ?></td>
                            </tr>
                            <?php

                            // ---------- Render extra RR row (ONLY for OLD policy / pre-cutoff) ----------
                            if ($isRR && !$isNewRRPolicy && !empty($rr_commision_row) && is_numeric($rr_commision_row) && $rr_commision_row > 0) {

                                if ($is_intra) {
                                    $cgst_rr = ($rr_commision_row * 9 / 100);
                                    $sgst_rr = ($rr_commision_row * 9 / 100);
                                    $igst_rr = 0;
                                } else {
                                    $cgst_rr = 0;
                                    $sgst_rr = 0;
                                    $igst_rr = ($rr_commision_row * 18 / 100);
                                }

                                $cgst_rr_display = round($cgst_rr, 2);
                                $sgst_rr_display = round($sgst_rr, 2);
                                $igst_rr_display = round($igst_rr, 2);

                                $row_tot_rr = round($rr_commision_row + $cgst_rr_display + $sgst_rr_display + $igst_rr_display);

                                // accumulate rr totals
                                $sum_taxable += round($rr_commision_row);
                                $sum_cgst += $cgst_rr_display;
                                $sum_sgst += $sgst_rr_display;
                                $sum_igst += $igst_rr_display;
                                $sum_row_total += $row_tot_rr;
                                ?>
                                <tr>
                                    <td></td>
                                    <td><?= htmlspecialchars($user_data->rr_cbs_acct_no ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                                    <td><?= htmlspecialchars($user_branch->branch_name ?? '', ENT_QUOTES, 'UTF-8'); ?><br>(<?= htmlspecialchars($user_branch->branch_code ?? '', ENT_QUOTES, 'UTF-8'); ?>)</td>
                                    <td style="text-align:center;">9971</td>
                                    <td class="taxable-value" style="text-align:center;"><?= formatIndianNumber(round($rr_commision_row)); ?></td>

                                    <?php if ($is_intra): ?>
                                        <td style="text-align:center;">9%</td>
                                        <td class="cgst-amount" style="text-align:center;"><?= formatIndianNumber($cgst_rr_display); ?></td>
                                        <td style="text-align:center;">9%</td>
                                        <td class="sgst-amount" style="text-align:center;"><?= formatIndianNumber($sgst_rr_display); ?></td>
                                        <td style="text-align:center;">-</td>
                                        <td style="text-align:center;">-</td>
                                    <?php else: ?>
                                        <td style="text-align:center;">-</td>
                                        <td class="cgst-amount" style="text-align:center;">-</td>
                                        <td style="text-align:center;">-</td>
                                        <td class="sgst-amount" style="text-align:center;">-</td>
                                        <td style="text-align:center;">18.00%</td>
                                        <td style="text-align:center;"><?= formatIndianNumber($igst_rr_display); ?></td>
                                    <?php endif; ?>

                                    <td class="row-total-amount" style="text-align:right;"><?= formatIndianNumber($row_tot_rr); ?></td>
                                </tr>
                                <?php
                            }

                        } // end foreach
                        // compute totals after loop
                        $ninety90_col_sum = customRound($sum_taxable);
                        $final_amt = round($sum_row_total); // total including taxes (rounded rows)
                        $total_gst = $sum_cgst + $sum_sgst + $sum_igst;
                    } // end if invoice_items
                    ?>

                    <!-- spacer row -->
                    <tr>
                        <td colspan="11"></td>
                        <td style="text-align:center;">-</td>
                    </tr>

                    <tr>
                        <td></td>
                        <td><strong>Sub Total</strong></td>
                        <td></td>
                        <td></td>
                        <td class="taxable-value-total text-center"><strong><?= formatIndianNumber(round($ninety90_col_sum)); ?></strong></td>
                        <td></td>
                        <td class="cgst-total-amt text-center"><strong><?= formatIndianNumber(round($sum_cgst,2)); ?></strong></td>
                        <td></td>
                        <td class="sgst-total-amt text-center"><strong><?= formatIndianNumber(round($sum_sgst,2)); ?></strong></td>
                        <td></td>
                        <td class="igst-total-amt text-center"><strong><?= formatIndianNumber(round($sum_igst,2)); ?></strong></td>
                        <td class="total" style="text-align:right;"><strong><?= formatIndianNumber($final_amt); ?></strong></td>
                    </tr>

                    <tr>
                        <td colspan="8" rowspan="2">In Word: <?= @getIndianCurrency($final_amt); ?></td>
                        <td colspan="3" style="background-color:rgb(217,225,242);"><strong>TOTAL GST</strong></td>
                        <td style="background-color:rgb(217,225,242);text-align:right;"><strong><?= formatIndianNumber(round($total_gst,2) ?? 0); ?></strong></td>
                    </tr>

                </tbody>
            </table>

            <table class="table" style="width:100%; border-collapse: collapse;">
                <tr>
                    <td colspan="4" rowspan="3" style="border:none;">
                        <br>For Approval Rs. <?= formatIndianNumber($final_amt ?? 0); ?>
                        <br>Recommended for HLC Commission
                        <br><br><br><br><b>Regional Manager (RBO)</b>
                    </td>
                    <td colspan="4" style="border:none;">
                        <br>For Approval Rs <?= formatIndianNumber($final_amt ?? 0); ?> recommended
                        <br><br><br><br><br><b>Manager/Chief Manager</b>
                    </td>
                    <td colspan="4" style="text-align:right;border:none;">
                        <table style="width:100%;border:none;">
                            <tr>
                                <td style="width:40%;text-align:center;border:none;">
                                    <?php if($signature_id!=3){ ?>
                                        <img src="<?= base_url() ?>assets/site_img/Rubber_Stamp_MBPL_circle.png" style="height:50px;">
                                    <?php } ?>
                                </td>
                                <td style="width:60%;border:none;">
                                    <br><b>For, Mortgagebuddy Private Limited</b>
                                    <br>
                                    <?php if($signature_id==1){ ?>
                                        <img src="<?= base_url() ?>assets/site_img/Sign_bhushan.png" style="height:30px;">
                                    <?php } else { ?><br><br><?php } ?>
                                    <?php if($signature_id==2){ ?>
                                        <img src="<?= base_url() ?>assets/site_img/Hardik_C_signature.png" style="height:40px;">
                                    <?php } else { ?><br><br><?php } ?>
                                    <br><b>Authorised Signatory</b>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>

        </div>
    </div>
</main>

<!-- new page for HLC bill -->
<style>
    .new-page { page-break-before: always; }
</style>

<div class="new-page"></div>

<!-- Start HLC BILL (non-GST page) -->
<table class="table table-invoice table-bordered">
    <thead>
        <tr>
            <td colspan="12" style="font-size:10px;background-color:rgb(217,225,242);border-bottom:0.5pt solid black;height:18pt;padding:3px;text-align:center;">
                <strong>HLC BILL</strong>
            </td>
        </tr>
        <tr>
            <td colspan="4" style="width:29%;">
                <p><strong>Name of HLC: MortgageBuddy Private Limited</strong></p>
                ADDRESS: Office No H 218, 2nd Floor, Tower No 3, Belapur Station Complex, CBD Belapur, Navi Mumbai - 400614, Maharashtra
            </td>

            <td colspan="5" rowspan="2" style="width:41%;">
                <p><img src="https://www.mortgagebuddy.in/myimg/logofinal.png" style="width:2000%; text-align:center;"/></p>
                <p style="text-align:center;"><strong>CORPORATE CHANNEL PARTNER OF SBI</strong></p>
                Office No- 022 46082235<br />
                Mobile - 8830394993<br />
                Email - Accounts@mortgagebuddy.in
            </td>

            <td colspan="3" rowspan="2" style="width:30%;">
                <p><strong>TO</strong><br />
                    <strong>STATE BANK OF INDIA</strong><br />
                    City - <?= htmlspecialchars(@$city->city_name ?? '', ENT_QUOTES, 'UTF-8'); ?>, State - <?= htmlspecialchars(@$state->state_name ?? '', ENT_QUOTES, 'UTF-8'); ?><br />
                    GSTIN NO - 27AAACS8577K2ZO<br />
                    RBO - <?= htmlspecialchars(@$rbo->rbo_name ?? '', ENT_QUOTES, 'UTF-8'); ?></p>
                <br>
                <strong>Invoice No : <?= htmlspecialchars($invoice_num ?? '', ENT_QUOTES, 'UTF-8'); ?></strong><br>
                <strong>Invoice Date : <?= date('d-m-Y', strtotime($invoice_date)); ?></strong>
            </td>
        </tr>
        <tr>
            <td colspan="4" rowspan="6">
                HLC Code - MUMHLC03147<br />
                GSTIN NO - 27AAQCM2355K1ZZ<br />
                PAN NO - AAQCM2355K<br />
                Bank Account No : 41326113534
            </td>
        </tr>
    </thead>

    <tr style="background-color:rgb(217,225,242);font-weight:bold;">
        <th class="text-center" width="3%">Sr. No</th>
        <th class="text-center" width="26%">LOS ID & RLMS<br>Name of Borrower</th>
        <th class="text-center" width="12%">Branch</th>
        <th class="text-center" width="10%">CBS A/c.</th>
        <th class="text-center" width="10%">Type of Loan</th>
        <th class="text-center" width="9%">Date of Disb</th>
        <th class="text-center" width="10%">Loan Amount</th>
        <th class="text-center" width="6%">Slab</th>
        <th class="text-center" width="7%">Comm<br>%</th>
        <th class="text-center" width="7%">Total<br>Comm</th>
    </tr>

    <tbody>
        <?php
        // Reuse sums from GST section (already initialized)
        if (!isset($sumTotalCommiCol)) $sumTotalCommiCol = 0.0;
        if (!isset($sum_fix_commi_rr)) $sum_fix_commi_rr = 0.0;
        if (!isset($sumTotalten10_commiCol)) $sumTotalten10_commiCol = 0.0;
        if (!isset($sum10_rr_Col)) $sum10_rr_Col = 0.0;

        if (!empty($invoice_items)) {
            foreach ($invoice_items as $key => $row) {
                $user_data = $this->db->select("*")->from('mst_user')->where(['id' => $row['user_id']])->get()->row();
                if (!$user_data) continue;
                $user_branch = $this->db->select("*")->from('branch')->where(['id' => $user_data->branch_id])->get()->row();
                $type_data = $this->db->select("*")->from('mst_loan_type')->where(['id' => $user_data->loan_type_id])->get()->row();

                $loanAmount = $user_data->loan_type_id == 5 ? (float)($user_data->rinnraksha_amt ?? 0) : (float)($user_data->sanction_amt ?? 0);

                $isRR = ((int)$user_data->loan_type_id === 5);
                $isNewRRPolicy = $isRR && rrNewPolicyApplies($user_data->disb_date);

                // get commissionFixed and rr_commision_row via helper
                $commissionFixed = 0.0; $rr_commision_row = 0.0;
                if ($isRR) {
                    list($commissionFixed, $rr_commision_row) = getRRFixedCommission($user_data);
                }

                if ($isRR && !$isNewRRPolicy && $commissionFixed > 0) {
                    $sum_fix_commi_rr += $commissionFixed;
                    //$sum10_rr_Col += round($commissionFixed * 10 / 100);
                }

                if ($user_data->loan_type_id == 4 && (float)$user_data->sanction_amt >= 100000 && (float)$user_data->sanction_amt < 1000000) {
                    $total_commi_row = 2000;
                    $displayPercent = '';
                } else {
                    if ($isRR && $isNewRRPolicy && $commissionFixed > 0) {
                        $total_commi_row = $commissionFixed;
                        $displayPercent = 'Fixed';
                    } else {
                        $effectivePercent = (float)($user_data->sbi_commi ?? 0);
                        $total_commi_row = $loanAmount * $effectivePercent / 100;
                        $displayPercent = ($effectivePercent != 0) ? number_format($effectivePercent,2,'.','') . '%' : '';
                    }
                }

                $sumTotalCommiCol += $total_commi_row;
                ?>
                <tr>
                    <td><?= $key + 1 ?></td>
                    <td style="text-align:left;"><?= htmlspecialchars($user_data->los_id ?? '', ENT_QUOTES, 'UTF-8'); ?><br><?= htmlspecialchars($user_data->user_name ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                    <td style="text-align:left;"><?= htmlspecialchars($user_branch->branch_name ?? '', ENT_QUOTES, 'UTF-8'); ?><br>(<?= htmlspecialchars($user_branch->branch_code ?? '', ENT_QUOTES, 'UTF-8'); ?>)</td>
                    <td style="text-align:center;"><?= $row['loan_type_id']==5 ? htmlspecialchars($user_data->rr_cbs_acct_no ?? '', ENT_QUOTES, 'UTF-8') : htmlspecialchars($user_data->bank_acct_no ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><?= htmlspecialchars($type_data->name ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><?= date('d.m.Y', strtotime($user_data->disb_date)); ?></td>
                    <td><?= formatIndianNumber($loanAmount); ?></td>
                    <td><?= htmlspecialchars($user_data->commi_slab ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><?= $displayPercent ?? ''; ?></td>
                    <td><?= formatIndianNumber(round($total_commi_row)); ?></td>
                </tr>

                <?php if ($isRR && !$isNewRRPolicy && !empty($rr_commision_row)) { ?>
                <tr>
                    <td></td>
                    <td style="text-align:left;"><?= htmlspecialchars($user_data->los_id ?? '', ENT_QUOTES, 'UTF-8'); ?><br><span class="text-inverse"><?= htmlspecialchars($user_data->user_name ?? '', ENT_QUOTES, 'UTF-8'); ?></span></td>
                    <td style="text-align:left;"><?= htmlspecialchars($user_branch->branch_name ?? '', ENT_QUOTES, 'UTF-8'); ?><br>(<?= htmlspecialchars($user_branch->branch_code ?? '', ENT_QUOTES, 'UTF-8'); ?>)</td>
                    <td style="text-align:center;"><?= htmlspecialchars($user_data->rr_cbs_acct_no ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                    <td>RR Commission</td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td style="text-align:center;font-weight:bold;">Fixed</td>
                    <td style="text-align:left !important;"><?= formatIndianNumber(round($rr_commision_row)); ?></td>
                </tr>
                <?php } ?>

            <?php } // foreach ?>
        <?php } // if invoice_items ?>

        <?php
            $ninety90_col_sum = customRound($sumTotalCommiCol + $sum_fix_commi_rr);
          //  $ten10_col_sum = $sumTotalten10_commiCol + $sum10_rr_Col;
            $buyer_state_id_bottom = isset($state->id) ? (int)$state->id : (int)$company_state;
            $is_intra_bottom = ($buyer_state_id_bottom === (int)$company_state);

            if ($is_intra_bottom) {
                $cgst_total = ($sum_taxable * 9 / 100);
                $sgst_total = ($sum_taxable * 9 / 100);
                $igst_total = 0;
            } else {
                $cgst_total = 0;
                $sgst_total = 0;
                $igst_total = ($sum_taxable * 18 / 100);
            }

            $final_amt = customRound($sum_taxable + $cgst_total + $sgst_total + $igst_total);
        ?>

        <tr>
            <td colspan="6" rowspan="3"><strong>In Word : <?= @getIndianCurrency($final_amt); ?></strong></td>
            <td colspan="3" style="text-align:right;"><b>Sub Total</b></td>
            <td><b><?= formatIndianNumber(customRound($sum_taxable)); ?></b></td>
        </tr>

        <tr>
            <td colspan="1" style="text-align:right;"><b>Tax Amount Rs</b></td>
            <td><b><?php if($is_intra_bottom){ echo 'CGST 9% <br>'.formatIndianNumber($cgst_total); } else { echo 'CGST 9% <br>-'; } ?></b></td>
            <td><b><?php if($is_intra_bottom){ echo 'SGST 9% <br>'.formatIndianNumber($sgst_total); } else { echo 'SGST 9% <br>-'; } ?></b></td>
            <td><b><?php if(!$is_intra_bottom){ echo 'IGST 18%<br>'.formatIndianNumber($igst_total); } else { echo 'IGST 18%<br>-'; } ?></b></td>
        </tr>

        <tr>
            <td colspan="3" style="text-align:right;"><b>TOTAL PAYABLE</b></td>
            <td><b><?= formatIndianNumber($final_amt); ?></b></td>
        </tr>

    </tbody>
</table>

<table class="table" style="margin-top:10px;">
    <tr>
        <td colspan="4" rowspan="3" style="border:none;">
            <br>For Approval Rs. <?= formatIndianNumber($final_amt); ?>
            <br>Recommended for HLC Commission
            <br><br><br><br><b>Regional manager (RBO)</b>
        </td>
        <td colspan="4" style="border:none;">
            <br>For Approval Rs <?= formatIndianNumber($final_amt); ?> recommended
            <br><br><br><br><br><b>Manager/Chief Manager</b>
        </td>
        <td colspan="4" style="text-align:right;border:none;">
            <table style="width:100%;border:none;">
                <tr>
                    <td style="width:40%;text-align:center;border:none;">
                        <?php if($signature_id!=3){ ?>
                            <img src="<?= base_url() ?>assets/site_img/Rubber_Stamp_MBPL_circle.png" style="height:50px;">
                        <?php } ?>
                    </td>
                    <td style="width:60%;border:none;">
                        <br><b>For, Mortgagebuddy Private Limited</b><br>
                        <?php if($signature_id==1){ ?>
                            <img src="<?= base_url() ?>assets/site_img/Sign_bhushan.png" style="height:30px;">
                        <?php } else { ?><br><br><?php } ?>
                        <?php if($signature_id==2){ ?>
                            <img src="<?= base_url() ?>assets/site_img/Hardik_C_signature.png" style="height:40px;">
                        <?php } else { ?><br><br><?php } ?>
                        <br><b>Authorised Signatory</b>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
</table>

</main>
<!-- EOF -->
