<?php

class Branchconf_model extends CI_Model {

    public function __construct() {
        parent::__construct();
     
        $db_group = $this->session->userdata('db_group') ?? 'default';
        $this->db = $this->load->database($db_group, TRUE);
        date_default_timezone_set('Asia/Kolkata');
        
    }

    public function fetch_invoice_data_branch($start_date, $end_date, $conn_id, $branch_id, $disb_month_year, $state_id, $city_id)
    {
        $this->_get_datatables_query($start_date, $end_date, $conn_id, $branch_id, $disb_month_year, $state_id, $city_id);

        if ($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);
        
        $query = $this->db->get();
        return $query->result_array();
    }

    private function _get_datatables_query($start_date, $end_date, $conn_id, $branch_id, $disb_month_year, $state_id, $city_id)
    {
        $this->db->select('invoices.*, mst_user.user_name, mst_staff.staff_fullname, branch.branch_name, branch.city_id');
        $this->db->from('invoices');
        $this->db->join('mst_user', 'invoices.user_id = mst_user.id');
        $this->db->join('mst_staff', 'invoices.connector_id = mst_staff.staff_id');
        $this->db->join('branch', 'invoices.branch_id = branch.id');

        // Search filter
        if (isset($_POST['search']['value']) && !empty($_POST['search']['value'])) {
            $this->db->group_start();
            $this->db->like('mst_user.user_name', $_POST['search']['value']);
            $this->db->or_like('mst_staff.staff_fullname', $_POST['search']['value']);
            $this->db->or_like('branch.branch_name', $_POST['search']['value']);
            $this->db->or_like('invoices.invoice_number', $_POST['search']['value']);
            $this->db->group_end();
        }

        if (!empty($start_date) && !empty($end_date)) {
            $this->db->where("invoices.add_date >=", $start_date);
            $this->db->where("invoices.add_date <=", date('Y-m-d', strtotime($end_date . ' +1 day')));
        }
        if (!empty($conn_id)) {
            $this->db->where('invoices.connector_id', $conn_id);
        }
        if (!empty($branch_id)) {
            $this->db->where('invoices.branch_id', $branch_id);
        }
       /* if (!empty($city_id)) {
            $this->db->where('branch.city_id', $city_id);
        }*/
        if (!empty($city_id)) {
            if (!is_array($city_id)) {
                $city_id = [$city_id];
            }
            $this->db->where_in('branch.city_id', $city_id);
        }
        if (!empty($disb_month_year)) {
            list($disb_year, $disb_month) = explode('-', $disb_month_year);
            $this->db->where('MONTH(mst_user.disb_date)', $disb_month);
            $this->db->where('YEAR(mst_user.disb_date)', $disb_year);
        }
        $this->db->where('invoices.invoice_type', 'inv_branch');
        $this->db->group_by('invoices.inv_batchno');
        $this->db->order_by('invoices.add_date', 'desc');
    }

    public function count_all()
    {
        $this->db->from('invoices');
        $this->db->where('invoice_type', 'inv_branch');
        $this->db->group_by('invoices.inv_batchno');
        return $this->db->count_all_results();
    }

    public function count_filtered($start_date, $end_date, $conn_id, $branch_id, $disb_month_year, $state_id, $city_id)
    {
        $this->_get_datatables_query($start_date, $end_date, $conn_id, $branch_id, $disb_month_year,$state_id, $city_id);
        $query = $this->db->get();
        return $query->num_rows();
    }
}
?>
