<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Redis_lib {

    protected $redis;

    public function __construct()
    {
        $this->redis = new Redis();

        try {
            $this->redis->connect('/home/mortga35/.redis/redis.sock');
        } catch (RedisException $e) {
            log_message('error', 'Redis connection failed: ' . $e->getMessage());
            show_error('Redis connection failed.');
        }
    }

    public function set($key, $value, $ttl = 0)
    {
        return $ttl > 0 ? $this->redis->setex($key, $ttl, $value) : $this->redis->set($key, $value);
    }

    public function get($key)
    {
        return $this->redis->get($key);
    }

    public function delete($key)
    {
        return $this->redis->del($key);
    }
}
