<?php
defined('BASEPATH') OR exit('No direct script access allowed');

if (!function_exists('load_database_by_year')) {
    function load_database_by_year($financial_year) {
        $CI =& get_instance();
        $CI->config->load('db_years');
        $db_list = $CI->config->item('financial_year_databases');
        if (!isset($db_list[$financial_year])) {
            throw new Exception("Database config not found for year: $financial_year");
        }
        return $CI->load->database($db_list[$financial_year], TRUE);
    }
}

if (!function_exists('load_all_financial_year_dbs')) {
    function load_all_financial_year_dbs() {
        $CI =& get_instance();
        $CI->config->load('db_years');
        return $CI->config->item('financial_year_databases');
    }
}

if (!function_exists('get_all_db_years')) {
    function get_all_db_years(): array {
        $map = load_all_financial_year_dbs();   // ['24-25'=>'fin_24_25', ...]
        return array_keys(is_array($map) ? $map : []);
    }
}

// If you ever need the group map directly:
if (!function_exists('get_all_db_year_map')) {
    function get_all_db_year_map(): array {
        return load_all_financial_year_dbs();   // ['24-25'=>'fin_24_25', ...]
    }
}

if (!function_exists('get_next_financial_year')) {
    function get_next_financial_year($current_year) {
        list($start, $end) = explode('-', $current_year);
        return sprintf('%02d-%02d', $start + 1, $end + 1);
    }
}

if (!function_exists('get_previous_financial_year')) {
    function get_previous_financial_year($current_year) {
        list($start, $end) = explode('-', $current_year);
        return sprintf('%02d-%02d', $start - 1, $end - 1);
    }
}

if (!function_exists('get_financial_year_from_disb_date')) {
    function get_financial_year_from_disb_date($disb_date) {
        $timestamp = strtotime($disb_date);
        $year = (int)date('Y', $timestamp);
        $month = (int)date('m', $timestamp);

        if ($month >= 4) {
            $fy_start = $year;
            $fy_end = $year + 1;
        } else {
            $fy_start = $year - 1;
            $fy_end = $year;
        }

        return sprintf('%02d-%02d', $fy_start % 100, $fy_end % 100);
    }
}



if (!function_exists('find_rr_by_cbs_acct_no_multi_year')) {
    /**
     * Find RR record by CBS account number across all FY DBs (loan_type_id=5).
     * Returns ['year'=>..., 'row'=>object] or null.
     */
    function find_rr_by_cbs_acct_no_multi_year($rr_cbs_acct_no) {
        $years = get_all_db_years();
        foreach ($years as $yr) {
            $db = load_database_by_year($yr);
            $row = $db->select('id, los_id, rr_cbs_acct_no')
                      ->from('mst_user')
                      ->where('loan_type_id', 5)
                      ->where('rr_cbs_acct_no', $rr_cbs_acct_no)
                      ->limit(1)
                      ->get()->row();
            if ($row) return ['year' => $yr, 'row' => $row];
        }
        return null;
    }
}

?>
