<?php
defined('BASEPATH') OR exit('No direct script access allowed');

if (!function_exists('calculateRinnrakshaCommission1')) {
    function calculateRinnrakshaCommission1($sanctionAmt, $commissionRate, $rrStatus, $applicantRRID) {
        $premiumCommission = 0;
        if ($rrStatus == 'Yes' && empty($applicantRRID)) {
            $premiumCommission = (float)$sanctionAmt * (float)$commissionRate / 100;
        }
        return $premiumCommission;
    }
}

if (!function_exists('calculatePremiumAmountCommission1')) {
    function calculatePremiumAmountCommission1($sanctionAmtP) {
        $commissionRR = 0; // Default commission

        if ($sanctionAmtP == 5000000) {
            $commissionRR = 4000; // If amount is exactly 50 lakh, set commission to 5000
        } elseif ($sanctionAmtP >= 100000 && $sanctionAmtP < 5000000) {
            $commissionRR = 4000; // If amount is between 1 lakh and 50 lakh (excluding 50 lakh), commission is 4000
        } elseif ($sanctionAmtP > 5000000 && $sanctionAmtP < 10000000) {
            $commissionRR = 5000; // If amount is between 50 lakh and 1 crore (excluding both), commission is 5000
        } elseif ($sanctionAmtP >= 10000000) {
            $commissionRR = 6000; // If amount is 1 crore or more, commission is 6000
        }

        return $commissionRR; // Return the calculated commission
    }
}


if (!function_exists('calculateTotalCommission1')) {
    function calculateTotalCommission1($db, $user_data, $commissionRate, $loan_type_id, $invoice_no) {
        $totalCommission = 0;
        $sanctionAmt = 0;
        $regularCommission = 0;
        $regularCommissionTopup = 0;

        // Calculate Rinnraksha Commission
        $rinnrakshaCommission = calculateRinnrakshaCommission1($user_data->rinnraksha_amt, $commissionRate, $user_data->rinnraksha_status, $user_data->applicant_rr_id);

        // Fetch RR sanction amount if applicable
        $rr_aact = $db->select("*")->where(['applicant_rr_id' => $user_data->id, 'rinnraksha_status' => 'Yes'])->from('mst_user')->get()->row();
        if ($user_data->rinnraksha_status == 'Yes' && empty($user_data->applicant_rr_id)) {
            $rr_sanction_amt = $db->select("*")->where(['id' => @$rr_aact->id])->from('mst_user')->get()->row();
            $sanctionAmt = @$rr_sanction_amt->sanction_amt;
        }

        // Default commission based on sanction amount
        $premiumAmountCommission = calculatePremiumAmountCommission1($sanctionAmt);
       

        // Override with account-based commission if matched
      if ($user_data->loan_type_id == 5) {
            
           /* $rrCbsAcctNos = [
                '43834971612', '43916591164', '43925342796',
                '43936109245', '43289254253', '43936164069',
                '43958834381', '43986307180', '43977965425',
                '43982487224', '44025488231','43733838473',
                '43969386776','44014640234','43960181234','43954036385',
                '43989889073','43960342181','43960084503','43985460887',
                '44019673059','44019659863','44021891926','43969413043','43881137691','43974032912','43969384984','43960109472','43947800229','43898925311','43939904466',
                '43953595787','43954021153','43930129733'
            ];
           
            $rrCbsAcctNos_6k = ['43967718498'];
            $rrCbsAcctNos_5k = ['43972742119','43969400157','43989937211','43972722125','43978246750','43964092215','43969745647','44024327422'];
            
           
            if (in_array($user_data->rr_cbs_acct_no, $rrCbsAcctNos, true)) {
                $premiumAmountCommission = 4000;
            }
            
            if (in_array($user_data->rr_cbs_acct_no, $rrCbsAcctNos_5k, true)) {
                $premiumAmountCommission = 5000;
            }
            
            if (in_array($user_data->rr_cbs_acct_no, $rrCbsAcctNos_6k, true)) {
                $premiumAmountCommission = 6000;
            }else{
                if(!empty($user_data->applicant_rr_id)){
                $premiumAmountCommission = 4000;
                }
            }
            */
            
            
             $row = $db
                ->select('commission')
                ->from('cbs_comm')
                ->where('applicants', 'mb')
                ->where('cbs_acct_no', $user_data->rr_cbs_acct_no)
                ->get()
                ->row();

            // Normalize to lowercase string (e.g. "4k", "5k", "6k")
            $code = strtolower($row->commission ?? '');

            // Map exact codes to their numeric values
            switch ($code) {
                case '4k':
                    $premiumAmountCommission = 4000;
                    break;
                case '5k':
                    $premiumAmountCommission = 5000;
                    break;
                case '6k':
                    $premiumAmountCommission = 6000;
                    break;
                default:
                    // If they have an applicant_rr_id but no DB match, default to 4k
                    if (!empty($user_data->applicant_rr_id)) {
                        $premiumAmountCommission = 4000;
                    }
                    // otherwise keep the base from calculatePremiumAmountCommission1()
            }
        
            
            
      }
        

        // Add Rinnraksha total
        $totalRinnrakshaCommission = $rinnrakshaCommission + $premiumAmountCommission;

       // Calculate regular commission if not loan type 5 or 4
        if ($loan_type_id != 5 && $loan_type_id != 4) {
            $regularCommission = $user_data->sanction_amt * $commissionRate / 100;
        }
        
        // Special top-up commission for loan type 4 with sanction amount <= 10 lakh
        if ($loan_type_id == 4 && $user_data->sanction_amt <= 1000000) { 
            $regularCommissionTopup = 2000;  
        }elseif($loan_type_id == 4 && $user_data->sanction_amt > 1000000){
            $regularCommission = $user_data->sanction_amt * $commissionRate / 100;
        }

        // Final total
        $totalCommission = $totalRinnrakshaCommission + $regularCommission + $regularCommissionTopup;

        return $totalCommission;
    }
}


//remaining paid balance hlc
if (!function_exists('calculate_hlc_invoice_balance')) {
    function calculate_hlc_invoice_balance($db, $ccm) {
        $data['inv'] = $ccm->get_invoice_data('', '', '', '', '', '', '', '', '', '');
        $total_rmain_bal_hlc = 0;
        
        foreach ($data['inv'] as $key => $row) {
            $hlc_data = $db->select("*")->where(['staff_id' => $row['connector_id']])->from('mst_staff')->get()->row();
            $invoiceNumber = $row['inv_batchno'];

            if ($row['invoice_type'] == 'inv_hlc') { 
                $data['invoice_items'] = $db->select('*')->from('invoices')->where(['inv_batchno' => $invoiceNumber])->get()->result_array();
                $totalLoanAmt = 0;
                $totalCommisionAmt = 0;
                $commission = 0;

                foreach ($data['invoice_items'] as $key => $row) {
                    $user_data = $db->select("*")->from('mst_user')->where(['id' => $row['user_id']])->get()->row();
                    $totalCommission = calculateTotalCommission1($db, $user_data, $row['commission_amt'], $row['loan_type_id']);
                    $totalCommisionAmt += $totalCommission;
                }

                $gstPercentage = empty($hlc_data->gst_no) ? 0 : 18; 
                $gst = $gstPercentage / 100 * $totalCommisionAmt;
                $netPayamt = $totalCommisionAmt;
                $tds = $netPayamt * 5 / 100;
                $grossTotal = $netPayamt + $gst;
                $netTotal = $grossTotal - $tds;

                $data['invoice_log'] = $db->select('*')->from('invoice_log')->where(['invoice_batchno' => $invoiceNumber])->get()->result_array();
                $totalpayamt = 0;

                foreach ($data['invoice_log'] as $key => $val) {
                    $totalpayamt += $val['pay_amt'];
                }

                $tot_paid_amt = $totalpayamt;
                $rmain_bal = $netTotal - $tot_paid_amt;
                $total_rmain_bal_hlc += $rmain_bal;
            }
        }
        
        return $total_rmain_bal_hlc;
    }
}

//paid tds bal sbi
if (!function_exists('calculate_sbi_invoice_balance')) {
    function calculate_sbi_invoice_balance($db, $ccm) {
        $data['inv_sbi'] = $ccm->get_invoice_data_sbi('', '', '', '', '', '', '', '', '', '');
        $total_rmain_bal_sbi = 0;
        $total_pay_amt = 0;
        $total_tds_amt = 0;

        foreach ($data['inv_sbi'] as $key => $row) {
            $hlc_data = $db->select("*")->where(['staff_id' => $row['connector_id']])->from('mst_staff')->get()->row();
            //$user_data = $db->select("*")->where(['id' => $row['user_id']])->from('mst_staff')->get()->row();
            $invoiceNumber = $row['inv_batchno'];
        
            if ($row['invoice_type'] == 'inv_sbi') {
                $data['invoice_items'] = $db->select('*')->from('invoices')->where(['inv_batchno' => $invoiceNumber])->get()->result_array();
                $totalLoanAmt = 0;
                $tot10percent_commi = 0;
                $tot90percent_commi = 0;
                $totcommissionRR = 0;

                foreach ($data['invoice_items'] as $key => $rows) {
                    $totalLoanAmt += $row['loan_amt'];
                    $tot10percent_commi += $rows['10percent_commi'];
                    $tot90percent_commi += $rows['90percent_commi'];
                    $totcommissionRR += $rows['rr_fix_commi'];
                }

                $total90per = round($tot90percent_commi + $totcommissionRR - ($totcommissionRR * 10 / 100)); 
                $netPayamt = $total90per + $total90per * 9 / 100 + $total90per * 9 / 100;

                $data['invoice_log'] = $db->select('*')->from('invoice_log')->where(['invoice_batchno' => $invoiceNumber, 'status' => 'paid'])->get()->result_array();
                
                $totalpayamt = 0;
                $totalTDSamt = 0;
                foreach ($data['invoice_log'] as $key => $val) {
                    $totalpayamt += $val['pay_amt'];
                    $totalTDSamt += $val['tds_amt'];
                }

                $tot_paid_amt = $totalpayamt;
                $TDS_amt = $totalTDSamt;
                $rmain_bal_sbi = $netPayamt - $TDS_amt - $tot_paid_amt;
                
                $total_rmain_bal_sbi += $rmain_bal_sbi;
                $total_pay_amt += $tot_paid_amt;
                $total_tds_amt += $TDS_amt;
            }
        }
        
        return [
            'total_rmain_bal_sbi' => $total_rmain_bal_sbi,
            'total_pay_amt' => $total_pay_amt,
            'total_tds_amt' => $total_tds_amt
        ];
    }
}


//paid tds bal sbi
if (!function_exists('calculate_sbi_invoice_balance_rem')) {
    function calculate_sbi_invoice_balance_rem($db, $ccm) {
        $data['inv_sbi'] = $ccm->get_invoice_data_sbi('', '', '', '', '', '', '', '', '', '');
        $total_rmain_bal_sbi = 0;
        $total_pay_amt = 0;
        $total_tds_amt = 0;

        foreach ($data['inv_sbi'] as $key => $row) {
            $hlc_data = $db->select("*")->where(['staff_id' => $row['connector_id']])->from('mst_staff')->get()->row();
            //$user_data = $db->select("*")->where(['id' => $row['user_id']])->from('mst_staff')->get()->row();
            $invoiceNumber = $row['inv_batchno'];
        
            if ($row['invoice_type'] == 'inv_sbi') {
                $data['invoice_items'] = $db->select('*')->from('invoices')->where(['inv_batchno' => $invoiceNumber])->get()->result_array();
                $totalLoanAmt = 0;
                $tot10percent_commi = 0;
                $tot90percent_commi = 0;
                $totcommissionRR = 0;

                foreach ($data['invoice_items'] as $key => $rows) {
                    $totalLoanAmt += $row['loan_amt'];
                    $tot10percent_commi += $rows['10percent_commi'];
                    $tot90percent_commi += $rows['90percent_commi'];
                    $totcommissionRR += $rows['rr_fix_commi'];
                }

                $total90per = round($tot90percent_commi + $totcommissionRR - ($totcommissionRR * 10 / 100)); 
                $netPayamt = $total90per + $total90per * 9 / 100 + $total90per * 9 / 100;

                $data['invoice_log'] = $db->select('*')->from('invoice_log')->where(['invoice_batchno' => $invoiceNumber])->get()->result_array();
                
                $totalpayamt = 0;
                $totalTDSamt = 0;
                foreach ($data['invoice_log'] as $key => $val) {
                    $totalpayamt += $val['pay_amt'];
                    $totalTDSamt += $val['tds_amt'];
                }

                $tot_paid_amt = $totalpayamt;
                $TDS_amt = $totalTDSamt;
                $rmain_bal_sbi = $netPayamt - $TDS_amt - $tot_paid_amt;
                
                $total_rmain_bal_sbi += $rmain_bal_sbi;
               
            }
        }
        
        return [
            'total_rmain_bal_sbi' => $total_rmain_bal_sbi
        ];
    }
}


 

?>
