<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// Include the Composer autoloader
require_once FCPATH . 'vendor_new/autoload.php';

// Import PhpSpreadsheet classes
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\Cell\DataType;
use PhpOffice\PhpSpreadsheet\Shared\Date;


class Pb_excel extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $db_group = $this->session->userdata('db_group') ?? 'default';
        $this->db = $this->load->database($db_group, TRUE);
        $this->load->model('common_model', 'ccm'); // Load your model
    }

    public function export_excel_pb_invoice_list($inv_batch) {
    // Fetch data in ascending order
    $invoices = $this->ccm->get_invoice_pb_list($inv_batch);

    // Get first invoice number for file naming
    $first_invoice_no = $this->db->select("invoice_number,is_tenper_hold")
                                 ->from('invoices')
                                 ->where(['inv_batchno' => $inv_batch])
                                 ->get()
                                 ->row();

    // Create a new spreadsheet instance
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

    // Set table header
    $headers = [
        'S.N.', 'LOS/RLMS NO', 
        'CBS / ACC NO', 'CUSTOMER NAME', 'LOAN AMOUNT', 
        'ACCOUNT TYPE', 'DATE OF DISBURSEMENT', 'COMMISSION %', 
        'COMMISSION', 'BRANCH', 'BRANCH CODE', 'RBO CODE', 
        'Attachment 1', 'Attachment 2', 'Attachment 3'
    ];

    // Add header row
    $colIndex = 'A';
    foreach ($headers as $header) {
        $sheet->setCellValue($colIndex . '1', $header);
        $sheet->getStyle($colIndex . '1')->getFont()->setBold(true);
        $colIndex++;
    }

    // Write data to the sheet
    $row = 2;
    $serial_number = 1;

    foreach ($invoices as $invoice) {
        // Determine loan amount and commission
        $loan_amount = ($invoice['loan_type_id'] == 5) ? $invoice['rinnraksha_amt'] : $invoice['sanction_amt'];

        // Determine PB Commission Rate
        if ($invoice['loan_type_id'] == 4) {
            $pb_commi = 0.20; // Fixed commission rate for loan_type_id = 4
        } else {
            $pb_commi = !empty($invoice['pb_commi']) ? floatval($invoice['pb_commi']) : 0; // Ensure valid pb_commi
        }
        
        
       

        // Calculate commission
        $commission_rate = $pb_commi / 100;
        $amt_100 = $loan_amount * $commission_rate;

        // Regular invoice row
        $sheet->setCellValue('A' . $row, $serial_number++);
        $sheet->setCellValue('B' . $row, $invoice['los_id']);
         $sheet->getStyle('B' . $row)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER);
        $sheet->setCellValue('C' . $row, ($invoice['loan_type_id'] == 5) ? $invoice['rr_cbs_acct_no'] : $invoice['bank_acct_no']);
        $sheet->setCellValue('D' . $row, $invoice['user_name']);
        $sheet->setCellValue('E' . $row, $loan_amount);
        $sheet->getStyle('E' . $row)->getNumberFormat()->setFormatCode('#,##0');
        $sheet->setCellValue('F' . $row, $invoice['account_type']);
        $sheet->setCellValue('G' . $row, date('d-M-y', strtotime($invoice['disb_date'])));
        $sheet->setCellValue('H' . $row, number_format($pb_commi, 2) . '%');
        $sheet->setCellValue('I' . $row, $amt_100);
        $sheet->getStyle('I' . $row)->getNumberFormat()->setFormatCode('#,##0.00');
        $sheet->setCellValue('J' . $row, $invoice['branch_name']);
        $sheet->setCellValue('K' . $row, $invoice['branch_code']);
         $sheet->getStyle('K' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
        $sheet->setCellValue('L' . $row, $invoice['rbo_name']);

        // Add attachment hyperlinks
        $this->add_attachment_hyperlinks($sheet, $row, $invoice);

        // If RR Commission, add a separate row
        if ($invoice['loan_type_id'] == 5) {
            $row++;  // Move to the next row for RR Commission
            $invoice['commission'] = $this->calculate_rr_commission($invoice);

            $sheet->setCellValue('A' . $row, $serial_number++);
            $sheet->setCellValue('B' . $row, $invoice['los_id']);
             $sheet->getStyle('B' . $row)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER);
            
            $sheet->setCellValue('C' . $row, $invoice['rr_cbs_acct_no']);
            $sheet->setCellValue('D' . $row, $invoice['user_name']);
            $sheet->setCellValue('E' . $row, '');  // No loan amount for RR Commission
            $sheet->setCellValue('F' . $row, 'RR Commission');
            $sheet->setCellValue('G' . $row, date('d-M-y', strtotime($invoice['disb_date'])));
            $sheet->setCellValue('H' . $row, 'Fixed');
            $sheet->setCellValue('I' . $row, $invoice['commission']);
            $sheet->getStyle('I' . $row)->getNumberFormat()->setFormatCode('#,##0.00');
            $sheet->setCellValue('J' . $row, $invoice['branch_name']);
            $sheet->setCellValue('K' . $row, $invoice['branch_code']);
             $sheet->getStyle('K' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
            $sheet->setCellValue('L' . $row, $invoice['rbo_name']);

            // Add attachment hyperlinks
            $this->add_attachment_hyperlinks($sheet, $row, $invoice);
        }

        $row++;
    }

    // Auto-size columns
    foreach (range('A', 'L') as $columnID) {
        $sheet->getColumnDimension($columnID)->setAutoSize(true);
    }

    // Clear output buffer before generating the file
    ob_end_clean();

    // Set headers for the file
    $filename = "PB_LOAN_LIST_" . $first_invoice_no->invoice_number . ".xlsx";
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $filename . '"');
    header('Cache-Control: max-age=0');

    // Generate Excel file
    $writer = new Xlsx($spreadsheet);
    $writer->save('php://output');
    exit;
}

 /*****************************************************************FORMAT 2***************************************************************************/   
    
public function export_excel_pb_invoice_format2($inv_batch) {
          // Fetch data in ascending order
    $invoices = $this->ccm->get_invoice_pb_list($inv_batch);

    // Get first invoice number for file naming
    $first_invoice_no = $this->db->select("invoice_number,is_tenper_hold")
                                 ->from('invoices')
                                 ->where(['inv_batchno' => $inv_batch])
                                 ->get()
                                 ->row();

    // Create a new spreadsheet instance
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->setTitle('Business');

    // Set table header
    $headers = [
        'S.N.', 'LOS/RLMS NO', 
        'CBS / ACC NO', 'CUSTOMER NAME', 'ACCOUNT TYPE', 
        'LOAN AMOUNT', 'DATE OF DISBURSEMENT', 'Branch', 'Branch Code',
        'Conf. Mail Id','Mail Received Date','Renumeration @ %','Remuneration', 
        'Agency Channel Code','Agency Channel Name','Partner Code','Partner Name',
        'Payout %','Payout Amount','Provision Month'
    ];

    // Add header row
    $colIndex = 'A';
    foreach ($headers as $header) {
        $sheet->setCellValue($colIndex . '1', $header);
        $sheet->getStyle($colIndex . '1')->getFont()->setBold(true);
        $colIndex++;
    }

    // Write data to the sheet
    $row = 2;
    $serial_number = 1;

    foreach ($invoices as $invoice) {
        // Determine loan amount and commission
        $loan_amount = ($invoice['loan_type_id'] == 5) ? $invoice['rinnraksha_amt'] : $invoice['sanction_amt'];

        // Determine PB Commission Rate
        /*if ($invoice['loan_type_id'] == 4) {
            $pb_commi = 0.20; // Fixed commission rate for loan_type_id = 4
        } elseif ($invoice['loan_type_id'] == 6) { // LAP case
            if (!empty($invoice['invoice_date']) && strtotime($invoice['invoice_date']) >= strtotime('2025-02-24')) {
                $pb_commi = 0.30; // Apply 0.30% only if invoice_date is 24/02/2025 or later
            } else {
                $pb_commi = !empty($invoice['pb_commi']) ? floatval($invoice['pb_commi']) : 0; // Use existing pb_commi if before 24/02/2025
            }
        } else {
            $pb_commi = !empty($invoice['pb_commi']) ? floatval($invoice['pb_commi']) : 0; // Default behavior
        }*/
        
        if ($invoice['loan_type_id'] == 4) {
                    $pb_commi = 0.20; // Fixed commission rate for loan_type_id = 4
                } elseif ($invoice['loan_type_id'] == 6) { // LAP case
                    if (!empty($invoice['invoice_date']) && strtotime($invoice['invoice_date']) >= strtotime('2025-02-24')) {
                        // Apply new PB commission logic only for invoices on or after 24/02/2025
                        if ($invoice['sanction_amt'] > 5000000) { // Above 50 Lakh
                            $pb_commi = 0.35;
                        } else { // 50 Lakh or below
                            $pb_commi = 0.30;
                        }
                    } else {
                        // Use existing pb_commi for invoices before 24/02/2025
                        $pb_commi = !empty($invoice['pb_commi']) ? floatval($invoice['pb_commi']) : 0;
                    }
                } else {
                    // Default behavior for other loan types
                    $pb_commi = !empty($invoice['pb_commi']) ? floatval($invoice['pb_commi']) : 0;
                }

 

        // Calculate commission
        $special_accounts = [43659801785, 43640311043];

        // 1️⃣ Special Accounts (Loan Type 4): Fixed ₹2000 Commission
        if (in_array($invoice['bank_acct_no'], $special_accounts)) {
                $amt_100 = 2000;
        }else{
                $commission_rate = $pb_commi / 100;
                $amt_100 = $loan_amount * $commission_rate;
        }

        // Regular invoice row
        $sheet->setCellValue('A' . $row, $serial_number++);
        $sheet->setCellValue('B' . $row, $invoice['los_id']);
         $sheet->getStyle('B' . $row)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER);
        $sheet->setCellValue('C' . $row, ($invoice['loan_type_id'] == 5) ? $invoice['rr_cbs_acct_no'] : $invoice['bank_acct_no']);
        $sheet->setCellValue('D' . $row, $invoice['user_name']);
         $sheet->setCellValue('E' . $row, $invoice['account_type']);
        $sheet->setCellValue('F' . $row, $loan_amount);
        $sheet->getStyle('F' . $row)->getNumberFormat()->setFormatCode('#,##0');
       
        $sheet->setCellValue('G' . $row, date('d/m/Y', strtotime($invoice['disb_date'])));
        $sheet->setCellValue('H' . $row, $invoice['branch_name']);
        
        $branch_code = (int)$invoice['branch_code'];

// Set the value as a number
$sheet->setCellValue('I' . $row, $branch_code);

// Apply a custom format to retain leading zeros
$sheet->getStyle('I' . $row)->getNumberFormat()->setFormatCode('00000'); // Adjust '00000' for the desired number of digits

// Align the value to the center
$sheet->getStyle('I' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

        $sheet->setCellValue('J' . $row, 'accounts@mortgagebuddy.in');
        $formattedDate1 = date("j M y", strtotime($invoice['invoice_date'])); // Converts to '8 Oct 24'
        $sheet->setCellValue('K' . $row, $formattedDate1);

        
        $special_accounts = [43659801785, 43640311043];

        // 1️⃣ Special Accounts (Loan Type 4): Fixed ₹2000 Commission
        if (in_array($invoice['bank_acct_no'], $special_accounts)) {
            $ln_amt_remu = 2000;
        } 
        // 2️⃣ Loan Type-Based Commission (ONLY if Not a Special Account)
else {
    if ($invoice['loan_type_id'] == 4) {
        $pb_commi_remu = 0.20; // Loan Type 4 commission
    } elseif ($invoice['loan_type_id'] == 6) {
        $pb_commi_remu = 0.30; // Loan Type 6 commission
    } else {
        $pb_commi_remu = 0.80; // Default commission
    }

    // Calculate commission
    $ln_amt_remu = $loan_amount * $pb_commi_remu / 100;
}

// 3️⃣ Special Invoice Batch Override (Takes Final Priority)
if ($inv_batch === 'inv_pb202501060439MB00030') {
    $pb_commi_remu = 0.95;
    $ln_amt_remu = $loan_amount * $pb_commi_remu / 100;
}
             
        // Set the numeric value (e.g., 0.1 for 10%)
        $sheet->setCellValue('L' . $row, $pb_commi_remu / 100);
        
        // Apply percentage formatting to the cell
        $sheet->getStyle('L' . $row)->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_PERCENTAGE_00);

       // $sheet->setCellValue('L' . $row, number_format($pb_commi_remu, 2) . '%'); // Format and set pb_commi value
        $sheet->setCellValue('M' . $row, $ln_amt_remu); // Set the value of amt_100

        
        $sheet->getStyle('M' . $row)->getNumberFormat()->setFormatCode('#,##0.00');
        $sheet->setCellValue('N' . $row, $invoice['agency_code']);
        $sheet->setCellValue('O' . $row, $invoice['agency_name']);
        $sheet->setCellValue('P' . $row, 'PB524383041022');
        $sheet->setCellValue('Q' . $row, 'MORTGAGEBUDDY PRIVATE LIMITED');
        
       // $sheet->setCellValue('R' . $row, number_format($pb_commi, 2) . '%');
       
         $sheet->setCellValue('R' . $row, $pb_commi / 100);
        // Apply percentage formatting to the cell
        $sheet->getStyle('R' . $row)->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_PERCENTAGE_00);

        
        $sheet->setCellValue('S' . $row, $amt_100);
        $sheet->getStyle('S' . $row)->getNumberFormat()->setFormatCode('#,##0.00');
        $formattedDate = date("M'y", strtotime($invoice['disb_date'])); 
        $sheet->setCellValue('T' . $row, $formattedDate);

        // Add attachment hyperlinks
       // $this->add_attachment_hyperlinks($sheet, $row, $invoice);

        // If RR Commission, add a separate row
        if ($invoice['loan_type_id'] == 5) {
            $row++;  // Move to the next row for RR Commission
            $invoice['commission'] = $this->calculate_rr_commission($invoice);

            $sheet->setCellValue('A' . $row, $serial_number++);
            $sheet->setCellValue('B' . $row, $invoice['los_id']);
            $sheet->getStyle('B' . $row)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER);
            
            $sheet->setCellValue('C' . $row, $invoice['rr_cbs_acct_no']);
            $sheet->setCellValue('D' . $row, $invoice['user_name']);
            $sheet->setCellValue('E' . $row, 'RR Commission');
            $sheet->setCellValue('F' . $row, '');  // No loan amount for RR Commission
            $sheet->setCellValue('G' . $row, date('d/m/Y', strtotime($invoice['disb_date'])));
            $sheet->setCellValue('H' . $row, $invoice['branch_name']);
                  $branch_code = (int)$invoice['branch_code'];
        // Set the value as a number
        $sheet->setCellValue('I' . $row, $branch_code);
        // Apply a custom format to retain leading zeros
        $sheet->getStyle('I' . $row)->getNumberFormat()->setFormatCode('00000'); // Adjust '00000' for the desired number of digits
        
        // Align the value to the center
        $sheet->getStyle('I' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

            $sheet->setCellValue('J' . $row, 'accounts@mortgagebuddy.in');
            
            $dateValue = Date::PHPToExcel(strtotime($invoice['invoice_date']));
            // Write the date to the cell
            $sheet->setCellValue('K' . $row, $dateValue);
            // Apply a custom date format (e.g., '8 Oct 24')
            $sheet->getStyle('K' . $row)->getNumberFormat()->setFormatCode('d MMM yy');
            // Align the value to the center
            $sheet->getStyle('K' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

            $sheet->setCellValue('L' . $row, 'Fixed');
            $sheet->setCellValue('M' . $row, $invoice['commission']);
            $sheet->getStyle('M' . $row)->getNumberFormat()->setFormatCode('#,##0.00');
            
            $sheet->setCellValue('N' . $row, $invoice['agency_code']);
        $sheet->setCellValue('O' . $row, $invoice['agency_name']);
        $sheet->setCellValue('P' . $row, 'PB524383041022');
        $sheet->setCellValue('Q' . $row, 'MORTGAGEBUDDY PRIVATE LIMITED');
        $sheet->setCellValue('R' . $row, 'Fixed');
        $sheet->setCellValue('S' . $row, $invoice['commission']);
        $sheet->getStyle('S' . $row)->getNumberFormat()->setFormatCode('#,##0.00');
        $formattedDate = date("M'y", strtotime($invoice['disb_date'])); 
        $sheet->setCellValue('T' . $row, $formattedDate);
         
         
        }

        $row++;
    }

    // Auto-size columns
    foreach (range('A', 'T') as $columnID) {
        $sheet->getColumnDimension($columnID)->setAutoSize(true);
    }

    // Clear output buffer before generating the file
    ob_end_clean();

    // Set headers for the file
    $filename = "PB_LOAN_LIST_FORMAT_2" . $first_invoice_no->invoice_number . ".xlsx";
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $filename . '"');
    header('Cache-Control: max-age=0');

    // Generate Excel file
    $writer = new Xlsx($spreadsheet);
    $writer->save('php://output');
    exit;
    }

    // RR Commission calculation method
    private function calculate_rr_commission($invoice) {
        $rr_main_account = $this->db->select("*")
            ->where(['applicant_rr_id' => $invoice['user_id'], 'rinnraksha_status' => 'Yes'])
            ->from('mst_user')
            ->get()
            ->row();

            $commission = 0;
             $special_account_rr = [43649502244,43595982432,43658580288]; 
            if (in_array($rr_main_account->rr_cbs_acct_no, $special_account_rr)) {
            $commission = 4000;
            } elseif ($rr_main_account->sanction_amt < 5000000) {  // Changed from < to <=
                $commission = 4000;
            }elseif ($rr_main_account->sanction_amt == 5000000) { // Exactly 50 Lacs
                $commission = 5000;
            } elseif ($rr_main_account->sanction_amt > 5000000 && $rr_main_account->sanction_amt < 10000000) {
                $commission = 5000;
            } elseif ($rr_main_account->sanction_amt >= 10000000) {
                $commission = 6000;
            }
            
            return $commission;

    }

    // Method to add attachment hyperlinks
    private function add_attachment_hyperlinks($sheet, $row, $invoice) {
        // Fetch attachments for the current invoice
        $latest_letter_apprisal = $this->db->select('appraisal_letter')
            ->from('appraisal_letters')
            ->where('user_id', $invoice['user_id'])
            ->where('appraisal_letter IS NOT NULL')
           // ->order_by('id', 'DESC')
            ->limit(1)
            ->get()
            ->row_array();

        $latest_letter_fsl = $this->db->select('final_sanction_letter')
            ->from('appraisal_letters')
            ->where('user_id', $invoice['user_id'])
            ->where('final_sanction_letter IS NOT NULL')
            //->order_by('id', 'DESC')
            ->limit(1)
            ->get()
            ->row_array();

        $latest_letter_pd = $this->db->select('proof_disb')
            ->from('appraisal_letters')
            ->where('user_id', $invoice['user_id'])
            ->where('proof_disb IS NOT NULL')
            //->order_by('id', 'DESC')
            ->limit(1)
            ->get()
            ->row_array();

        // Add hyperlinks to the sheet for each attachment
        if (!empty($latest_letter_apprisal['appraisal_letter'])) {
            $link1 = base_url('assets/uploads/documents/' . $latest_letter_apprisal['appraisal_letter']);
            $sheet->setCellValue('M' . $row, 'Click');
            $sheet->getCell('M' . $row)->getHyperlink()->setUrl($link1);
            $sheet->getStyle('M' . $row)->applyFromArray([
                'font' => ['color' => ['rgb' => '0000FF'], 'underline' => 'single']
            ]);
        }

        if (!empty($latest_letter_fsl['final_sanction_letter'])) {
            $link2 = base_url('assets/uploads/documents/' . $latest_letter_fsl['final_sanction_letter']);
            $sheet->setCellValue('N' . $row, 'Click');
            $sheet->getCell('N' . $row)->getHyperlink()->setUrl($link2);
            $sheet->getStyle('N' . $row)->applyFromArray([
                'font' => ['color' => ['rgb' => '0000FF'], 'underline' => 'single']
            ]);
        }

        if (!empty($latest_letter_pd['proof_disb'])) {
            $link3 = base_url('assets/uploads/documents/' . $latest_letter_pd['proof_disb']);
            $sheet->setCellValue('O' . $row, 'Click');
            $sheet->getCell('O' . $row)->getHyperlink()->setUrl($link3);
            $sheet->getStyle('O' . $row)->applyFromArray([
                'font' => ['color' => ['rgb' => '0000FF'], 'underline' => 'single']
            ]);
        }
    }
}
