<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Payment_advice_hlc extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $db_group = $this->session->userdata('db_group') ?? 'default';
        $this->db = $this->load->database($db_group, TRUE);
        $this->load->library('Payment_advice');
    }
    
    function getIndianCurrency(float $amount) {
        $num = floor($amount);
        $amount_after_decimal = round(($amount - $num) * 100);

        // Check if there is any number after decimal
        $amt_hundred = null;
        $count_length = strlen($num);
        $x = 0;
        $string = array();
        $change_words = array(
            0 => 'Zero', 1 => 'One', 2 => 'Two',
            3 => 'Three', 4 => 'Four', 5 => 'Five', 6 => 'Six',
            7 => 'Seven', 8 => 'Eight', 9 => 'Nine',
            10 => 'Ten', 11 => 'Eleven', 12 => 'Twelve',
            13 => 'Thirteen', 14 => 'Fourteen', 15 => 'Fifteen',
            16 => 'Sixteen', 17 => 'Seventeen', 18 => 'Eighteen',
            19 => 'Nineteen', 20 => 'Twenty', 30 => 'Thirty',
            40 => 'Forty', 50 => 'Fifty', 60 => 'Sixty',
            70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety'
        );
        $here_digits = array('', 'Hundred', 'Thousand', 'Lakh', 'Crore');
        while ($x < $count_length) {
            $get_divider = ($x == 2) ? 10 : 100;
            $amount = floor($num % $get_divider);
            $num = floor($num / $get_divider);
            $x += $get_divider == 10 ? 1 : 2;
            if ($amount) {
                $add_plural = (($counter = count($string)) && $amount > 9) ? 's' : null;
                $amt_hundred = ($counter == 1 && $string[0]) ? ' and ' : null;
                $string[] = ($amount < 21) ? $change_words[$amount] . ' ' . $here_digits[$counter] . $add_plural . ' ' . $amt_hundred : $change_words[floor($amount / 10) * 10] . ' ' . $change_words[$amount % 10] . ' ' . $here_digits[$counter] . $add_plural . ' ' . $amt_hundred;
            } else {
                $string[] = null;
            }
        }
        $implode_to_Rupees = implode('', array_reverse($string));
        $get_paise = ($amount_after_decimal > 0) ? "And " . ($change_words[floor($amount_after_decimal / 10)] . " " . $change_words[$amount_after_decimal % 10]) . ' Paise' : '';
        return ($implode_to_Rupees ? $implode_to_Rupees . ' Rupees ' : '') . $get_paise;
    }

    function formatIndianNumber($number) {
        $rounded_number = round($number, 2);
        $number_str = strval($rounded_number);
        $parts = explode('.', $number_str);
        $integral_part = $parts[0];
        $formatted_integral = '';
        $len = strlen($integral_part);
        $i = $len - 1;
        $count = 0;
        while ($i >= 0) {
            $formatted_integral = $integral_part[$i] . $formatted_integral;
            $count++;
            if (($count == 3 || $count == 5 || $count == 7) && $i != 0) {
                $formatted_integral = ',' . $formatted_integral;
            }
            $i--;
        }
        $formatted_fractional = isset($parts[1]) ? '.' . str_pad($parts[1], 2, '0') : '.00';
        $formatted_number = $formatted_integral . $formatted_fractional;
        return $formatted_number;
    }

    public function generatePDF($invoice_no) {
        $data['invoice_items'] = $this->db
            ->select('*')
            ->from('invoices')
            ->where(['inv_batchno' => $invoice_no])
            ->order_by('id', 'asc')
            ->get()
            ->result_array();

        $firstInvoiceItem = reset($data['invoice_items']);
        $connectorID = isset($firstInvoiceItem['connector_id']) ? $firstInvoiceItem['connector_id'] : null;
        $branchID = isset($firstInvoiceItem['branch_id']) ? $firstInvoiceItem['branch_id'] : null;
        $invoiceDate = isset($firstInvoiceItem['invoice_date']) ? $firstInvoiceItem['invoice_date'] : null;
        $invoiceType = isset($firstInvoiceItem['invoice_type']) ? $firstInvoiceItem['invoice_type'] : null;
        $invoiceNumber = isset($firstInvoiceItem['invoice_number']) ? $firstInvoiceItem['invoice_number'] : null;

        $connector = $this->db->select("*")->from('mst_staff')->where(['staff_id' => $connectorID, 'staff_type' => 1])->get()->row();
        $data['branch'] = $this->db->select("*")->from('branch')->where(['id' => $branchID])->get()->row();
        $paid_invoice = $this->db->select('*')->from('invoice_log')->where(['invoice_batchno' => $invoice_no])->order_by('add_date', 'DESC')->limit(1)->get()->row();
  
        $data['invoice_date'] = $invoiceDate;
        $data['invoice_type'] = $invoiceType;
        $data['invoice_num'] = $invoiceNumber;

        // Create new TCPDF instance
        $pdf = new Payment_advice('P', 'mm', 'A4', true, 'UTF-8', false);
        $inv_no = str_replace('/', '_', $invoiceNumber);

        // Set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Mortgagebuddy');
        $pdf->SetTitle($invoiceNumber);
        $pdf->SetSubject('Invoice');
        $pdf->SetKeywords('Invoice, PDF, Example');
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM); // Set auto page breaks
        $pdf->SetFont('dejavusans', '', 6);
        $pdf->SetCellPaddings(1, 2, 1, 1);
        $pdf->SetMargins(10, 30, 10);
        $pdf->AddPage();
        $pdf->SetMargins(10, 30, 10);

        $totalLoanAmt = 0;
        $totalCommisionAmt = 0;
        $cgst = 0; $sgst = 0; $igst = 0;

        if (!empty($data['invoice_items'])) {
            foreach ($data['invoice_items'] as $key => $row) {
                $user_data = $this->db->select("*")->from('mst_user')->where(['id' => $row['user_id']])->get()->row();
                $type_data = $this->db->select("*")->from('mst_loan_type')->where(['id' => $user_data->loan_type_id])->get()->row();
                $branch = $this->db->select("*")->from('branch')->where(['id' => $user_data->branch_id])->get()->row();

                $totalLoanAmt += $row['loan_amt'];
                $totalCommisionAmt += $row['total_commission'];

                $mbgstcode = 13;
                if ($mbgstcode == $connector->circle_id) {
                    $cgst = empty($connector->gst_no) ? 0 : (9 / 100 * $totalCommisionAmt);
                    $sgst = empty($connector->gst_no) ? 0 : (9 / 100 * $totalCommisionAmt);
                } else {
                    $igst = empty($connector->gst_no) ? 0 : (18 / 100 * $totalCommisionAmt);
                }
            }
        }

        $gstPercentage = empty($connector->gst_no) ? 0 : 18; 
        $gst = $gstPercentage / 100 * $totalCommisionAmt;
        $netPayamt = $totalCommisionAmt + $gst;
        $tds = $totalCommisionAmt * 5 / 100;
        $netPayamtAll = $totalCommisionAmt + $gst - $tds;

        $html = '
            <table width="100%">
                <tr style="text-align:left;">
                    <td>
                        <strong>Beneficiary Details:</strong><br>
                        Name:'. $connector->staff_fullname .'<br>
                        Address:'. $connector->staff_address .'<br>
                        PAN No.:' . $connector->pan_no .'<br>
                        GSTIN No.:' . $connector->gst_no .'<br>
                        Mobile No.:' . $connector->mobile .'<br>
                        E-mail ID:' . $connector->email .'
                    </td>
                    <td>
                        <strong>Doc No:</strong> '.$invoiceNumber.'<br>
                        <strong>Date:</strong> '.date('F d,Y',strtotime($data['invoice_date'])).'
                    </td>
                </tr>
            </table>
            <p>We have initiated your payment of Rs '.$this->formatIndianNumber($paid_invoice->pay_amt).' on date '.date('d-m-Y',strtotime($paid_invoice->payment_date)).' against your invoice no '.$invoiceNumber.'<br>dated '.date('F d,Y',strtotime($paid_invoice->payment_date)).'. Details of payment is as below:</p>';

        // Additional content generation logic...
        $html .= '<style>
    .table-bordered {
        border-collapse: collapse;
       
    }
    .table-bordered th,
    .table-bordered td {
        border: 0.1px solid #00; /* Border color */
        padding: 8px; /* Adjust padding as needed */
    }
</style>
<br><br><br>
<table class="table table-invoice table-bordered">
    <thead>
        <tr style="background-color: #d9e1f2;text-align:center;">
            <th style="width:4%;">Sr. No</th>
            <th style="width:12%;">Los ID</th>
            <th style="width:13%;">Name Of Customer</th>
            <th>Loan Type</th>
            <th>Branch Name</th>
            <th style="width:11%;">CBS A/C No</th>
            <th>Disburs Date</th>
            <th>Sanctioned Loan Amount</th>
            <th>Commission<br> %</th>
            <th>Commission Amount Rs</th>
        </tr>
    </thead>
    <tbody>
';

if (!empty($data['invoice_items'])) {
    $totalLoanAmt = 0;
    $totalCommisionAmt = 0;
    $cgst =0; $sgst =0; $igst =0;
    foreach ($data['invoice_items'] as $key => $row) {
        $user_data = $this->db->select("*")->from('mst_user')->where(['id' => $row['user_id']])->get()->row();
        $type_data = $this->db->select("*")->from('mst_loan_type')->where(['id' => $user_data->loan_type_id])->get()->row();
        $branch = $this->db->select("*")->from('branch')->where(['id' => $user_data->branch_id])->get()->row();

        $totalLoanAmt += $row['loan_amt'];
        $totalCommisionAmt += $row['total_commission'];

        $mbgstcode = 27;
       
        if ($mbgstcode == $connector->state_id) {
            $cgst = empty($connector->gst_no) ? 0 : (9 / 100 * $totalCommisionAmt);
            $sgst = empty($connector->gst_no) ? 0 : (9 / 100 * $totalCommisionAmt);
        } else {
            $igst = empty($connector->gst_no) ? 0 : (18 / 100 * $totalCommisionAmt);
        }

        $rr_aact = $this->db->select("*")->where(['applicant_rr_id' => $row['user_id'], 'rinnraksha_status' => 'Yes'])->from('mst_user')->get()->row();

        $html .= '
        <tr>
            <td style="width:4%;">' . ($key + 1) . '</td>
            <td style="width:12%;">' . $user_data->los_id . '</td>
            <td style="width:13%;">' . $user_data->user_name . '</td>
            <td>' . $type_data->name . '</td>
            <td>' . $branch->branch_name . ' [' . $branch->branch_code . ']</td>
            <td style="width:11%;">' . ($row['loan_type_id'] == 5 ? $user_data->rr_cbs_acct_no : $user_data->bank_acct_no) . '</td>
            <td>' . date('d.m.Y', strtotime($user_data->disb_date)) . '</td>
            <td>' . $this->formatIndianNumber($row['loan_amt']) . '</td>
            <td>' . $row['commission_amt'] . '%</td>
        ';

        if ($user_data->rinnraksha_status == 'Yes' && empty($user_data->applicant_rr_id)) {
            $premiumAmt = $user_data->rinnraksha_amt;
            $premiumCommission = $premiumAmt * $row['commission_amt'] / 100;
            $html .= '<td>' . $this->formatIndianNumber($premiumCommission) . '</td>';
        } else {
            $html .= '<td>' . $this->formatIndianNumber($row['total_commission']) . '</td>';
        }

        $html .= '</tr>';

        if ($row['loan_type_id'] == 5) {
            $html .= '
            <tr>
                <td style="width:4%;"></td>
                <td style="width:12%;">' . $user_data->los_id . '</td>
                <td style="width:13%;">' . $user_data->user_name . '</td>
                <td style="text-align:left;">RR Commission</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            ';

            if ($user_data->rinnraksha_status == 'Yes' && empty($user_data->applicant_rr_id)) {
                $rr_sanction_amt = $this->db->select("*")->where(['id' => $rr_aact->id])->from('mst_user')->get()->row();
                $sanctionAmt = @$rr_sanction_amt->sanction_amt;
                $premiumAmt = $user_data->rinnraksha_amt;
                $premiumCommission = $premiumAmt * $row['commission_amt'] / 100;

                if ($sanctionAmt >= 100000 && $sanctionAmt < 5000000) {
                    $commission = 4000;
                } elseif ($sanctionAmt >= 5000000 && $sanctionAmt < 10000000) {
                    $commission = 5000;
                } elseif ($sanctionAmt >= 10000000) {
                    $commission = 6000;
                } else {
                    $commission = 0;
                }
                $html .= '<td>' . $this->formatIndianNumber($commission) . '</td>';
            } else {
                $html .= '<td>' . $this->formatIndianNumber($row['total_commission']) . '</td>';
            }

            $html .= '</tr>';
        }
        
    }
}

 $gstPercentage = empty($connector->gst_no) ? 0 : 18; 
 $gst = $gstPercentage / 100 * $totalCommisionAmt;
 $netPayamt = $totalCommisionAmt + $gst;
 $tds = $totalCommisionAmt*5/100;
 $netPayamtAll = $totalCommisionAmt + $gst - $tds;
 
 $html .='<tr>
          <td></td>
           <td></td>
           <td></td>
           <td></td>
           <td></td>
           <td></td>
           <td></td>
           <td></td>
           <td>-</td>
           <td>-</td>
        </tr>
        <tr>
           <td colspan="5" rowspan="7">';
          if (@$paid_invoice->status == "paid") {
            $html .= '
                <table style="width:100%;">
                    <tr>
                        <td style="width:40%;">
                            <img src="'.base_url().'assets/site_img/paid-stamp.png" height="100">
                        </td>
                        <td style="width:60%; text-align:left;">
                            <p>Payment Date: '.date('d-m-Y',strtotime($paid_invoice->payment_date)).'</p>
                            <p>Payment Amount: Rs '.$this->formatIndianNumber($paid_invoice->pay_amt).'</p>
                            <p>Ref No/Cheq No: '.$paid_invoice->bank_details.'</p>
                            <p>Remark: '.$paid_invoice->remark.'</p>
                        </td>
                    </tr>
                </table>';
        } else {
            $html .= 'unpaid';
        }

    $html .='</td>
           <td colspan="2" style="text-align:right;"><b>Sub Total</b></td>
            <td><strong>'.$this->formatIndianNumber($totalLoanAmt).'</strong></td>
           <td></td>
           <td><strong>'.$this->formatIndianNumber($totalCommisionAmt).'</strong></td>
        </tr>
        <tr>
           <td colspan="2" style="text-align:right;"><b>Tax Amount - CGST 9%</b></td>
            <td></td>
           <td>-</td>
           <td>'. (empty($cgst) ? '-' : $this->formatIndianNumber($cgst)) . '</td>
        </tr>
        <tr>
          
           <td colspan="2" style="text-align:right;"><b>Tax Amount - SGST 9%</b></td>
            <td></td>
          
           <td>-</td>
            <td>'. (empty($sgst) ? '-' : $this->formatIndianNumber($sgst)) . '</td>
        </tr>
         <tr>
         
           <td colspan="2" style="text-align:right;"><b>Tax Amount - IGST 18%</b></td>
            <td></td>
            <td>-</td>
            <td>'. (empty($igst) ? '-' : $this->formatIndianNumber($igst)) . '</td>
        </tr>
        <tr>
           
           <td colspan="2" style="text-align:right;"><b>Gross Total</b></td>
            <td></td>
           <td></td>
           <td><strong>'. $this->formatIndianNumber($netPayamt).'</strong></td>
        </tr>
        <tr>
           
           <td colspan="2" style="text-align:right;"><b>Less: TDS @ 5%</b></td>
            <td></td>
           <td></td>
           <td><strong>'.$this->formatIndianNumber($tds).'</strong></td>
        </tr>
        <tr>
          
           <td colspan="2" style="text-align:right;"><b>Net Total</b></td>
            <td></td>
           <td></td>
           <td><strong>'.$this->formatIndianNumber($netPayamtAll).'</strong></td>
        </tr>
                    
                   </tbody>
                </table>
 <p>Paid to your bank account:  Account Number '.$connector->bank_acct_no.' IFSC Code '.$connector->bank_ifsc.'								
 </p>
 
<br><br><br><br>
 <table style="width:100%;">
         <tr>
          <td>Thank You!</td>
          </tr>
           <tr>
          <td>This is a computer Generated Advice & does not require signature	</td>
          </tr>
        </table>
';

        $pdf->writeHTML($html, true, false, true, false, '');

        $pdf->Output($invoiceNumber.'.pdf', 'I');
    }
}
?>
