<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// Include the Composer autoloader
require_once FCPATH . 'vendor_new/autoload.php';

// Import PhpSpreadsheet classes
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\Cell\DataType;
use PhpOffice\PhpSpreadsheet\Shared\Date;




class Mb_hlc_paid_excel extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $db_group = $this->session->userdata('db_group') ?? 'default';
        $this->db = $this->load->database($db_group, TRUE);
        $this->load->model('common_model', 'ccm'); // Load your model
    }

    
     public function index() {
         
        $start_date        = $this->input->get('start_date');
        $end_date          = $this->input->get('end_date');
        $branch            = $this->input->get('branch');
        $connector         = $this->input->get('connector');
        $hlc_status        = $this->input->get('hlc_status');
        $state_id          = $this->input->get('state_id');
        $city_id           = $this->input->get('city_id');
        $disb_month        = $this->input->get('month');
        $payment_month_hlc = $this->input->get('payment_month_hlc');
   
        // 2. Build an array of filters
        $filters = [
            'start_date'         => $start_date,
            'end_date'           => $end_date,
            'branch'             => $branch,
            'connector'          => $connector,
            'hlc_status'         => $hlc_status,
            'state_id'           => $state_id,
            'city_id'            => $city_id,
            'disb_month'         => $disb_month,
            'payment_month_hlc'  => $payment_month_hlc
        ];

   
    $invoices = $this->ccm->get_mb_applicant_hlc_paid_list($filters);
    
    // Group the invoices by invoice batch number ($hlc_invoice_batch_no)
    $grouped_invoices = [];
    foreach ($invoices as $invoice) {
        $loan_amount = ($invoice['loan_type_id'] == 5) ? $invoice['rinnraksha_amt'] : $invoice['sanction_amt'];
        $commission_rate = floatval($invoice['pb_commi']) / 100;
        $inv_hlc_data = $this->db->select("*")->from('invoices')->where(['id' => $invoice['invoice_id']])->get()->row();
        
        $hlc_invoice_batch_no = $inv_hlc_data->inv_batchno;
        $created_by = $this->db->select("*")->where(['staff_id' => $invoice['connector_id']])->from('mst_staff')->get()->row();
        
        $inv_branch_data = $this->db->select("*")->from('invoices')->where(['id' => $invoice['branch_invoice_id']])->get()->row();
        $inv_sbi_data = $this->db->select("*")->from('invoices')->where(['id' => $invoice['sbi_invoice_id']])->get()->row();
      
        $admin_created_hlc = $this->db->select("*")->where(['staff_id' => $created_by->created_by])->from('mst_staff')->get()->row();
        $app_created_by = $this->db->select("*")->where(['staff_id' => $invoice['created_by']])->from('mst_staff')->get()->row();

        // Group by invoice batch number
        $grouped_invoices[$hlc_invoice_batch_no]['invoices'][] = array_merge($invoice, [
            'loan_amount'       => $loan_amount,
            'hlc_inv_no'        => @$inv_hlc_data->invoice_number,
            'hlc_inv_batchno'        => $hlc_invoice_batch_no,
            'hlc_invoice_date'  => @$inv_hlc_data->invoice_date,
            'branch_inv_no'     => @$inv_branch_data->invoice_number,
            'sbi_inv_no'        => @$inv_sbi_data->invoice_number,
            'hlc_created_by'    => $admin_created_hlc->staff_fullname,
            'app_created_by'    => @$app_created_by->staff_fullname
        ]);
    }

    // Create a new spreadsheet instance
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

/*    $headers = [
        'Sr.No.(A)', 'Partner Name(B)', 'Name of Borrower(C)', 'Login Code(D)', 'State(D)', 'City(E)',
        'Los Id & RLMS ID(F)', 'CBS A/c NO(G)', 'Branch(H)', 'Branch Code(I)', 'RBO(J)', 'Type of Loan(K)',
        'Sanction Loan Amt(L)', 'Date of disb.(M)', 'Commission(N)', 'Commision Amt(O)', 'Invoice No(P)', 'Invoice Date(Q)',
        'Sub Total(R)', 'Total Gst(S)', 'Gross Total(T)', 'TDS(U)','Net Total(V)','Pay Date(W)','Pay Amt(X)','Payment Sr. No(Y)'
    ];*/
    $headers = [
        'Sr.No.', 'Partner Name', 'Name of Borrower', 'MB/PB', 'State', 'City',
        'Los Id & RLMS ID', 'CBS A/c NO', 'Branch', 'Branch Code', 'RBO', 'Type of Loan',
        'Sanction Loan Amt', 'Date of disb.', 'Commission', 'Commision Amt', 'Invoice No', 'Invoice Date',
        'Sub Total', 'Total Gst', 'Gross Total', 'TDS','Net Total','Pay Date','Balance','Pay Amt','Payment Sr. No','Pay Date2','Pay Amt2','Payment Sr. No2','Pay Date3','Pay Amt3','Payment Sr. No3'
    ];

    $colIndex = 1;
    foreach ($headers as $header) {
        $colLetter = Coordinate::stringFromColumnIndex($colIndex);
        $sheet->setCellValue($colLetter . '1', $header);
        $sheet->getStyle($colLetter . '1')->getFont()->setBold(true);
        $sheet->getStyle($colLetter . '1')->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
        $colIndex++;
    }

    // Write data to the sheet
    $row = 2;
    $serial_number = 1;

    // Loop through each group using the invoice batch number as key
    foreach ($grouped_invoices as $batch_no => $group) {
        $group_sum = 0; // Initialize group sum for column O (Commission Amt)
        
        $rowStart = $row;
        // (Optional) If you want to display a group header with the batch number, uncomment the lines below:
        // $sheet->setCellValue('A' . $row, "Batch No: " . $batch_no);
        // $sheet->getStyle('A' . $row)->getFont()->setBold(true);
        // $row++;

        foreach ($group['invoices'] as $invoice) {
            // Handle RR Commission row if applicable
            if ($invoice['loan_type_id'] == 5) {
                $invoice['is_rr_commission'] = true;
                $invoice['commission'] = $this->calculate_rr_commission($invoice);
            }
            
            
        

            // Regular invoice row
            $sheet->setCellValue('A' . $row, $serial_number++);
            $sheet->setCellValue('B' . $row, $invoice['staff_fullname']);
            $sheet->setCellValue('C' . $row, $invoice['user_name']);
            $sheet->setCellValue('D' . $row, $invoice['login_code']);
            $sheet->setCellValue('E' . $row, $invoice['state_name']);
            $sheet->setCellValue('F' . $row, $invoice['city_name']);
            $sheet->setCellValue('G' . $row, $invoice['los_id']);
            $sheet->setCellValue('H' . $row, ($invoice['loan_type_id'] == 5) ? $invoice['rr_cbs_acct_no'] : $invoice['bank_acct_no']);
            $sheet->getStyle('H' . $row)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER);
            $sheet->setCellValue('I' . $row, $invoice['branch_name']);
            $sheet->setCellValue('J' . $row, $invoice['branch_code']);
            $sheet->setCellValue('K' . $row, $invoice['rbo_name']);
            $sheet->setCellValue('L' . $row, $invoice['account_type']);
            $sheet->setCellValue('M' . $row, $invoice['loan_amount']);
            $sheet->getStyle('M' . $row)->getNumberFormat()->setFormatCode('#,##0');

            $disbDate = isset($invoice['disb_date']) && !empty($invoice['disb_date']) ? strtotime($invoice['disb_date']) : null;
            if ($disbDate) {
                $sheet->setCellValue('N' . $row, date('d-M-y', $disbDate));
            } else {
                $sheet->setCellValue('N' . $row, 'N/A');
            }

            $sheet->setCellValue('O' . $row, ($invoice['loan_type_id'] == 4) ? number_format(0.20, 2).'%' : $invoice['part_payout'].'%');

            // Calculate commission for the invoice row
            $loan_amount = isset($invoice['loan_amount']) ? str_replace(',', '', $invoice['loan_amount']) : '0';
            $loan_amount = is_numeric($loan_amount) ? (float) $loan_amount : 0;
            $part_payout = isset($invoice['part_payout']) ? str_replace(',', '', $invoice['part_payout']) : '0';
            $part_payout = is_numeric($part_payout) ? (float) $part_payout : 0;
            $rate = ($invoice['loan_type_id'] == 4) ? 0.20 / 100 : ($part_payout / 100);
            
            $commission_regular = $loan_amount * $rate;
            $group_sum += $commission_regular;
            
            $sheet->setCellValue('P' . $row, ($loan_amount * $rate));
            $sheet->getStyle('P' . $row)->getNumberFormat()->setFormatCode('#,##0.00');

            $sheet->setCellValue('Q' . $row, ($invoice['applicant_invoice_status'] == 'Generated') ? $invoice['hlc_inv_no'] : 'No');

            $invoiceDate = isset($invoice['hlc_invoice_date']) && !empty($invoice['hlc_invoice_date']) ? strtotime($invoice['hlc_invoice_date']) : null;
            if ($invoiceDate) {
                $sheet->setCellValue('R' . $row, date('d-M-y', $invoiceDate));
            } else {
                $sheet->setCellValue('R' . $row, 'N/A');
            }

            // If RR Commission, add a separate row for the commission details
            
            if (isset($invoice['is_rr_commission'])) {
                $row++;  // Move to next row for RR Commission
                $sheet->setCellValue('A' . $row, $serial_number++);
                $sheet->setCellValue('B' . $row, $invoice['staff_fullname']);
                $sheet->setCellValue('C' . $row, $invoice['user_name']);
                $sheet->setCellValue('D' . $row, $invoice['login_code']);
                $sheet->setCellValue('E' . $row, $invoice['state_name']);
                $sheet->setCellValue('F' . $row, $invoice['city_name']);
                $sheet->setCellValue('G' . $row, $invoice['los_id']);
                $sheet->setCellValue('H' . $row, ($invoice['loan_type_id'] == 5) ? $invoice['rr_cbs_acct_no'] : $invoice['bank_acct_no']);
                $sheet->getStyle('H' . $row)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER);
                $sheet->setCellValue('I' . $row, $invoice['branch_name']);
                $sheet->setCellValue('J' . $row, $invoice['branch_code']);
                $sheet->setCellValue('K' . $row, $invoice['rbo_name']);
                $sheet->setCellValue('L' . $row, 'RR Commission');
                $sheet->setCellValue('M' . $row, '');
                
                $disbDate = isset($invoice['disb_date']) && !empty($invoice['disb_date']) ? strtotime($invoice['disb_date']) : null;
                if ($disbDate) {
                    $sheet->setCellValue('N' . $row, date('d-M-y', $disbDate));
                } else {
                    $sheet->setCellValue('N' . $row, 'N/A');
                }
                
                $sheet->setCellValue('O' . $row, ($invoice['loan_type_id'] == 4) ? number_format(0.20, 2).'%' : $invoice['part_payout'].'%');
                $sheet->setCellValue('P' . $row, $invoice['commission']);
                $sheet->getStyle('O' . $row)->getNumberFormat()->setFormatCode('#,##0.00');
                $group_sum += $invoice['commission'];
                $sheet->setCellValue('Q' . $row, ($invoice['applicant_invoice_status'] == 'Generated') ? $invoice['hlc_inv_no'] : 'No');
                
                $invoiceDate = isset($invoice['hlc_invoice_date']) && !empty($invoice['hlc_invoice_date']) ? strtotime($invoice['hlc_invoice_date']) : null;
                if ($invoiceDate) {
                    $sheet->setCellValue('R' . $row, date('d-M-y', $invoiceDate));
                } else {
                    $sheet->setCellValue('R' . $row, 'N/A');
                }
            }
            $row++;
        }
        
        $mbgstcode = 27;
        if ($mbgstcode == $invoice['conn_state']) {
            $totalGst = empty($invoice['gst_no']) ? 0 : (18 / 100 * $group_sum);
        } else {
            $totalGst = empty($invoice['gst_no']) ? 0 : (18 / 100 * $group_sum);
        }
             $netPayamt = $group_sum;
             $invoiceTimestamp = strtotime($invoice['hlc_invoice_date']);
            
            // Define the threshold date (1st October 2024)
            $thresholdDate = strtotime('2024-10-01');
            
            // Check if the invoice date is on or after 1st October 2024
            if ($invoiceTimestamp >= $thresholdDate) {
                // Apply 2% TDS
                $tdsPer = 2;
                $tds = $netPayamt * 2 / 100;
            } else {
                // Apply 5% TDS
                $tdsPer = 5;
                $tds = $netPayamt * 5 / 100;
            }
             $grossTotal = $netPayamt + $totalGst;
             $netTotal = $grossTotal - $tds;
             
             
             
      $paid_invoices = $this->db->select('*')
    ->from('invoice_log')
    ->where(['invoice_batchno' => $invoice['hlc_inv_batchno']])
    ->order_by('payment_date', 'ASC') // Add ORDER BY clause here
    ->get()
    ->result();


// Count the number of payments
$paymentCount = count($paid_invoices);

// Use the first payment record (if exists) for displaying payment details
$paid_invoice = $paymentCount > 0 ? $paid_invoices[0] : null;

$row--;

    // Now write your group totals  in that same row
    $sheet->setCellValue('S' . $row, $group_sum);
    $sheet->setCellValue('T' . $row, $totalGst);
    $sheet->setCellValue('U' . $row, $grossTotal);
    $sheet->setCellValue('V' . $row, $tds);
    $sheet->setCellValue('W' . $row, $netTotal);

    $colIndex = 24; // 'X'

foreach ($paid_invoices as $index => $p) {

    // Convert numeric column index to Excel column letter
    $dateCol = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex);
    $remBalCol  = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex + 1);
    $amtCol  = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex + 2);
    $srCol   = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex + 3);

    // Write the payment date (or 'N/A' if empty)
    $payDateValue = !empty($p->payment_date)
        ? date('d-M-y', strtotime($p->payment_date))
        : 'N/A';
    $sheet->setCellValue($dateCol . $row, $payDateValue);
    
     $rmain_bal = $netTotal - $p->pay_amt;

// Write the payment amount with 2 decimal places
$sheet->setCellValue($remBalCol . $row, round($rmain_bal, 2));

// Apply number format for 2 decimal places
$sheet->getStyle($remBalCol . $row)
      ->getNumberFormat()
      ->setFormatCode('#,##0.00'); // Ensures 2 decimal places
    
    $sheet->setCellValue($amtCol . $row, $p->pay_amt);

    // If there is more than one payment, optionally highlight the Pay Amt cell
    if ($paymentCount > 1) {
        $sheet->getStyle($amtCol . $row)
              ->getFill()
              ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
              ->getStartColor()->setARGB('FFFF00');
    }

    // Write the payment SR. NO (or ID)
    $sheet->setCellValue($srCol . $row, $p->id);

    // Move to the next set of columns for the next payment
    $colIndex += 3;
}

// Finally, move down one row so the next batch starts on a new line
$row++;
}
    // Clear output buffer before generating the file
    ob_end_clean();

    // Set headers for the file download
    $filename = "MB_APPLICANT_PAID_LIST.xlsx";
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $filename . '"');
    header('Cache-Control: max-age=0');

    // Generate Excel file
    $writer = new Xlsx($spreadsheet);
    $writer->save('php://output');
    exit;
}




  private function add_attachment_hyperlinks($sheet, $row, $invoice) {
        // Fetch attachments for the current invoice
        $latest_letter_apprisal = $this->db->select('appraisal_letter')
            ->from('appraisal_letters')
            ->where('user_id', $invoice['id'])
            ->where('appraisal_letter IS NOT NULL')
            ->order_by('add_date', 'DESC')
            ->limit(1)
            ->get()
            ->row_array();

        $latest_letter_fsl = $this->db->select('final_sanction_letter')
            ->from('appraisal_letters')
            ->where('user_id', $invoice['id'])
            ->where('final_sanction_letter IS NOT NULL')
            ->order_by('add_date', 'DESC')
            ->limit(1)
            ->get()
            ->row_array();

        $latest_letter_pd = $this->db->select('proof_disb')
            ->from('appraisal_letters')
            ->where('user_id', $invoice['id'])
            ->where('proof_disb IS NOT NULL')
            ->order_by('add_date', 'DESC')
            ->limit(1)
            ->get()
            ->row_array();

        // Add hyperlinks to the sheet for each attachment
        if (!empty($latest_letter_apprisal['appraisal_letter'])) {
            $link1 = base_url('assets/uploads/documents/' . $latest_letter_apprisal['appraisal_letter']);
            $sheet->setCellValue('AD' . $row, 'Click');
            $sheet->getCell('AD' . $row)->getHyperlink()->setUrl($link1);
            $sheet->getStyle('AD' . $row)->applyFromArray([
                'font' => ['color' => ['rgb' => '0000FF'], 'underline' => 'single']
            ]);
        }

        if (!empty($latest_letter_fsl['final_sanction_letter'])) {
            $link2 = base_url('assets/uploads/documents/' . $latest_letter_fsl['final_sanction_letter']);
            $sheet->setCellValue('AE' . $row, 'Click');
            $sheet->getCell('AE' . $row)->getHyperlink()->setUrl($link2);
            $sheet->getStyle('AE' . $row)->applyFromArray([
                'font' => ['color' => ['rgb' => '0000FF'], 'underline' => 'single']
            ]);
        }

        if (!empty($latest_letter_pd['proof_disb'])) {
            $link3 = base_url('assets/uploads/documents/' . $latest_letter_pd['proof_disb']);
            $sheet->setCellValue('AF' . $row, 'Click');
            $sheet->getCell('AF' . $row)->getHyperlink()->setUrl($link3);
            $sheet->getStyle('AF' . $row)->applyFromArray([
                'font' => ['color' => ['rgb' => '0000FF'], 'underline' => 'single']
            ]);
        }
    }
    
    // RR Commission calculation method
    private function calculate_rr_commission($invoice) {
    // Fetch the main account details
    $rr_main_account = $this->db->select("*")
        ->where(['applicant_rr_id' => @$invoice['id'], 'rinnraksha_status' => 'Yes'])
        ->from('mst_user')
        ->get()
        ->row();

    $commission = 0; // Initialize the commission

    // Apply commission slabs
    if (@$rr_main_account->sanction_amt < 5000000) { // Below 50 Lacs
        $commission = 4000;
    } elseif (@$rr_main_account->sanction_amt == 5000000) { // Exactly 50 Lacs
        $commission = 5000;
    } elseif (@$rr_main_account->sanction_amt > 5000000 && $rr_main_account->sanction_amt <= 10000000) { // Above 50 Lacs to 1 Cr
        $commission = 5000;
    } elseif (@$rr_main_account->sanction_amt > 10000000) { // Above 1 Cr
        $commission = 6000;
    }

    return $commission; // Return the calculated commission
}

    
    
    
    
    
    function calculatePB($loan_type, $loan_amount) {
    switch ($loan_type) {
       case '6': // LAP
            if ($loan_amount < 5000000) { // Less than Rs 50 Lacs
                return 0.30 * $loan_amount / 100; // 30% commission
            } elseif ($loan_amount == 5000000) { // Exactly Rs 50 Lacs
                return 0.30 * $loan_amount / 100; // 30% commission
            } elseif ($loan_amount > 5000000) { // Greater than Rs 50 Lacs
                return 0.35 * $loan_amount / 100; // 35% commission
            } else {
                return 0; // Default case to avoid null values
            }
        case '5': //RinnRaksha
                return 0.80 * $loan_amount / 100;
        case '1':  //New
        case '2': //Takeover
        case '3':  //Takeover+TopUp
            return 0.80 * $loan_amount / 100;
        case '4':  //Top Up
            return 0.20 * $loan_amount / 100;
        default:
            return null; // If loan type is not recognized
    }
}

function calculatePBPercent($loan_type, $loan_amount) {
    $result = null;

    switch ($loan_type) {
       case '6': // LAP
            if ($loan_amount <= 5000000) { // Up to Rs 50 Lacs
                $result = number_format(0.30, 2); // 30%
            } elseif ($loan_amount > 5000000) { // Above Rs 50 Lacs
                $result = number_format(0.35, 2); // 35%
            } else {
                $result = number_format(0.30, 2); // Default to 30%
            }
            break;
        case '5': // RinnRaksha
            $result = number_format(0.80, 2); // 80%
            break;
        case '1': // New
        case '2': // Takeover
        case '3': // Takeover+TopUp
            $result = number_format(0.80, 2); // 80%
            break;
        case '4': // Top Up
            $result = number_format(0.20, 2); // 20%
            break;
        default:
            $result = null; // Default case if loan type not recognized
    }

    // Log the inputs and calculated percentage
    log_message('info', 'calculatePBPercent - Loan Type: ' . $loan_type . ', Loan Amount: ' . $loan_amount . ', Result: ' . $result);

    return $result; // Return only the percentage
}





}
