<main class="page-content">
    <!--breadcrumb-->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"><?= $title ?></div>
    </div>
    <!--end breadcrumb-->
    <div class="card">
        <div class="card-header py-3">
            <div class="row align-items-center m-0">
                <div class="col-md-4 col-12 me-auto mb-md-0 mb-3">
                    <a href="<?= base_url('admin/racpc_form/') ?>">
                        <button type="button" class="btn btn-outline-primary radius-30">Add RACPC</button>
                    </a>
                </div>
               
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
              <table class="table align-middle table-striped" id="Table">
                <thead>
                    <tr>
                        <th>Sr.No</th>
                        <th>RACPC Name</th>
                        <th>Circle</th>
                        <th>City</th>
                        <th>State</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
            </div>
           
        </div>
    </div>
</main>


<script>
$(document).ready(function() {
    var table = $('#Table').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?= base_url('admin/get_racpc_list') ?>",
            "type": "POST"
        },
        "columns": [
            { "data": 0 }, 
            { "data": 1 }, 
            { "data": 2 }, 
            { "data": 3 }, 
            { "data": 4 }, 
            { "data": 5 }
        ],
        "lengthChange": true,
        "lengthMenu": [[50, 100, 150, 200, -1], [50, 100, 150, 200, "All"]],
        "dom": 'lBfrtip',
        "buttons": [
            { extend: 'copy', text: 'Copy' },
            { extend: 'excel', text: 'Excel' },
            { extend: 'pdf', text: 'PDF' },
            {
                extend: 'print',
                text: 'Print',
                customize: function(win) {
                    $(win.document.body).find('h1').text('Branches');
                }
            }
        ]
    });

    // Move buttons container to a specific location if needed
    table.buttons().container().appendTo('#Table_wrapper .col-md-6:eq(0)');

    // Event delegation for delete button
    $(document).on('click', '.delete', function () {
        var element = $(this);
        var id = element.data('id'); // Use data-id attribute to get the ID
        var action = element.attr('action');
       
        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to delete this account?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    url: base_url + 'Admin/' + action + '/' + id,
                    dataType: 'json',
                    success: function(res) {
                        if (res.success == '1') {
                            notify(res.type, res.message);
                            table.ajax.reload();  // Reload the table data after deletion
                        } else {
                            notify(res.type, res.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log(xhr.responseText);
                        alert('Error occurred while deleting data. Please try again.');
                    }
                });
            }
        });
    });
});

</script>
<style>
    .dataTables_length{
        margin-bottom:13px;
    }
    .dataTables_filter{
        margin-top:12px;
    }
</style>