<main class="page-content">
    <!--breadcrumb-->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"><?= $title ?></div>
    </div>
    <!--end breadcrumb-->
    <div class="card">
        <div class="card-header py-3">
            <div class="row align-items-center m-0">
                <div class="col-md-4 col-12 me-auto mb-md-0 mb-3">
                    <a href="<?= base_url('admin/slab_form/') ?>">
                        <button type="button" class="btn btn-outline-primary radius-30">Add Slab</button>
                    </a>
                </div>
              
            </div>
        </div>
        <div class="card-body">
           <!-- <form id="perPageForm" method="post" action="<?php echo base_url('admin/manage_slab'); ?>">
              <select id="itemsPerPageSelector" name="per_page" onchange="updatePerPage()">
                <option value="">--select--</option>
                <option value="20">20 per page</option>
                <option value="100">100 per page</option>
                <option value="500">500 per page</option>
              </select>
            </form>-->
            <div class="table-responsive">
                <table class="table align-middle table-striped" id="Table">                   
                    <thead>
                        <tr>
                            <th>Sr.No</th>
                            <th>Loan Type</th>  
                            <th>Pay Type</th>  
                            <th>Falt/Percent</th>  
                            <th>From Amt</th>  
                            <th>To Amt</th>
                            <th>Action</th>
                        </tr>
                    <thead>
                    <tbody>
                        <?php
                        if (!empty($slab)) {
                            foreach ($slab as $key => $row) {
                                $loan_type = $this->db->select('*')->from('mst_loan_type')->where('id',$row['loan_type_id'])->get()->row();
                                ?>
                                <tr class='main_block' main_id="<?= $row['id'] ?>">
                                    <td><?= $key + 1 ?></td>
                                    <td class="">
                                        <?= $loan_type->name; ?>    
                                    </td>
                                     <td class="">
                                        <?= $row['pay_type'] ?>    
                                    </td>
                                     <td class="">
                                        <?= $row['amount'] ?> 
                                       
                                    </td>
                                    <td class="">
                                        <?= $row['from_amt'] ?><br>
                                        <?= convertAmountToWords($row['from_amt']) ?>
                                    </td>
                                     <td class="">
                                        <?= $row['to_amt'] ?><br>
                                        <?= convertAmountToWords($row['to_amt']) ?>
                                    </td>
                                   
                                    <!--<td>
                                        <?php if ($row['active'] == 1) { ?>
                                            <a href="javascript:void(0);" >
                                                <span class="badge rounded-pill bg-success commoon_active"  action='active_circle' active='0'>Active</span>
                                            </a>
                                        <?php } else { ?>
                                            <a href="javascript:void(0);" >
                                                <span class="badge rounded-pill bg-danger commoon_active"  action='active_circle' active='1'>Deactive</span>
                                            </a>  <?php } ?>
                                    </td>-->
                                    <td>
                                        <div class="d-flex align-items-center gap-3 fs-6">
                                            <!--<a href="javascript:;" class="text-primary" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="View detail" aria-label="Views"><i class="bi bi-eye-fill"></i></a>-->
                                            <a href="<?= base_url('admin/slab_form/' . $row['id']) ?>" class="text-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Edit info" aria-label="Edit"><i class="bi bi-pencil-fill"></i></a>
                                            <a href="javascript:;" class="text-danger delete" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Delete" aria-label="Delete"  action='delete_slab'><i class="bi bi-trash-fill"></i></a>
                                        </div>
                                    </td>
                                </tr>
                                <?php
                            }
                        } else {
                            ?>
                            <tr><td colspan="5" align="center">Sorry no records available! </td></tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <?//= $pagination ?>
        </div>
    </div>
</main>
<?php
function convertAmountToWords($number) {
    $decimal = round($number - ($no = floor($number)), 2) * 100;
    $hundred = null;
    $digits_length = strlen($no);
    $i = 0;
    $str = array();
    $words = array(0 => '', 1 => 'one', 2 => 'two',
        3 => 'three', 4 => 'four', 5 => 'five', 6 => 'six',
        7 => 'seven', 8 => 'eight', 9 => 'nine',
        10 => 'ten', 11 => 'eleven', 12 => 'twelve',
        13 => 'thirteen', 14 => 'fourteen', 15 => 'fifteen',
        16 => 'sixteen', 17 => 'seventeen', 18 => 'eighteen',
        19 => 'nineteen', 20 => 'twenty', 30 => 'thirty',
        40 => 'forty', 50 => 'fifty', 60 => 'sixty',
        70 => 'seventy', 80 => 'eighty', 90 => 'ninety');
    $digits = array('', 'hundred', 'thousand', 'lakh', 'crore');
    while ($i < $digits_length) {
        $divider = ($i == 2) ? 10 : 100;
        $number = floor($no % $divider);
        $no = floor($no / $divider);
        $i += $divider == 10 ? 1 : 2;
        if ($number) {
            $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
            $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
            $str [] = ($number < 21) ? ucfirst($words[$number]) . ' ' . ucfirst($digits[$counter]) . $plural . ' ' . $hundred : ucfirst($words[floor($number / 10) * 10]) . ' ' . ucfirst($words[$number % 10]) . ' ' . ucfirst($digits[$counter]) . $plural . ' ' . $hundred;
        } else
            $str[] = null;
    }
    $Rupees = implode('', array_reverse($str));
    $paise = ($decimal > 0) ? "." . ($words[$decimal / 10] . " " . $words[$decimal % 10]) . ' Paise' : '';
    return ($Rupees ? $Rupees . ' ' : '') . $paise;
}
?>
<script>
$(document).ready(function() {
    var table = $('#Table').DataTable({
        "lengthChange": true,
        "lengthMenu": [[10, 25, 50, 200, -1], [10, 25, 50, 200, "All"]],
        "buttons": [
            { extend: 'copy', text: 'Copy' },
            { extend: 'excel', text: 'Excel' },
            { extend: 'pdf', text: 'PDF' },
            {
                extend: 'print',
                text: 'Print',
                customize: function(win) {
                    // Change only the heading for print view
                    $(win.document.body).find('h1').text('Circles');
                }
            }
        ]
    });

    table.buttons().container().appendTo('#Table_wrapper .col-md-6:eq(0)');
});
</script>

<style>
    .dataTables_length{
        margin-bottom:13px;
    }
    .dataTables_filter{
        margin-top:12px;
    }
</style>

