<div class="modal fade" id="GenrateInvoiceModal" tabindex="-1" aria-labelledby="GenrateInvoiceModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <!-- <h5 class="modal-title" id="GenrateInvoiceModalLabel">Change Status</h5> --> <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="formgroup">
                    <label for="signature_id">Select Signature</label>
                    <select name="signature_id" class="form-control" id="signature_id"  required>
                        <option value="">--Select--</option>
                        <option value="1">Bhushan Signature</option>
                        <option value="2">Hardik Signature</option>
                        <option value="3">No Signature</option>
                    </select> 
                </div>
                <!--<div class="formgroup">
                    <label for="is_tenper_hold">Is 10% Hold?</label>
                    <select name="is_tenper_hold" class="form-control" id="is_tenper_hold"  required>
                        <option value="">--Select--</option>
                        <option value="Yes">Yes</option>
                        <option value="No">No</option>
                    </select> 
                </div>-->
                
                <!-- Date Validation for Financial Year Change -->
                <?php $financialYear = $this->session->userdata('financial_year'); ?>
                 
                <input type="hidden" name="is_tenper_hold" id="is_tenper_hold" value="Yes">
                <input type="hidden" name="invoice_type" id="invoice_type" value="inv_pb">
                <div class="formgroup mt-3"> <label for="invoice_date">Invoice Date</label> 
                <input type="date" class="form-control" placeholder="dd/mm/yyyy" id="invoice_date" value="<?= date('Y-m-d'); ?>"> </div>
                 <span id="invoice_date_error" class="text-danger" style="display:block;"></span>
            </div>
            <div class="modal-footer"> <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button> <button type="button" class="btn btn-primary" id="applyinvoice">Submit</button> </div>
        </div>
    </div>
</div>


<main class="page-content">
    <div class="card">
        <div class="card-header py-3">
            <div class="row align-items-center">
                <div class="col-md-10">
                    <form id="filterForm">
                        <div class="row">
                            <div class="col-md-2">
                                <label>Start Date:</label>
                                <input type="date" class="form-control" name="start_date" id="start_date">
                            </div>
                            <div class="col-md-2">
                                <label>End Date:</label>
                                <input type="date" class="form-control" name="end_date" id="end_date">
                            </div>
                            <div class="col-md-2">
                                <label>Branch</label>
                                <select class="single-select" name="branch" id="branch">
                                    <option value="">Select Branch</option>
                                    <?php foreach ($branch as $branchItem) { ?>
                                        <option value="<?= $branchItem['id']; ?>"><?= $branchItem['branch_name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                            <?php if($_SESSION['staff_type']==0){ ?> 
                            <div class="col-md-2">
                                <label>HLC</label>
                                <select class="single-select" name="connector" id="connector">
                                    <option value="">Select HLC</option>
                                    <?php foreach ($connector as $connectorItem) { ?>
                                        <option value="<?= $connectorItem['staff_id']; ?>"><?= $connectorItem['staff_fullname']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                            <?php } ?> 
                            <div class="col-md-2">
                                <label>Status</label>
                                <select class="form-control" name="status" id="status">
                                    <option value="">--Select--</option>
                                    <option value="Login Case">Login Case</option>
                                    <option value="Disb Case">Disb Case</option><!--
                                    <option value="Sanction">Sanction</option>
                                    <option value="Reject">Reject</option>-->
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label>Disb Month</label>
                                <input type="month" name="month" class="form-control" id="month">
                            </div>
                            <div class="col-md-2">
                                <br>
                                <button type="submit" class="btn btn-success">Filter</button>
                                <button type="button" id="resetFilter" class="btn btn-secondary">Reset</button>
                            </div>
                        </div>
                    </form>
                </div>
               
            </div>
        </div>
        <div class="card-body">
             <div class="table-responsive">
            <table class="table table-striped" id="invoiceTable">
                    <div class="col-md-12 text-end"> 
                        <button id="GenerateInvoiceButton" class="btn btn-primary btn-sm shadow-sm">
                            <i class="bi bi-receipt-cutoff me-2"></i> Generate Invoice PB
                        </button>
                    </div>

                <thead>
                    <tr>
                        <th><input type="checkbox" id="checkAll"></th>
                        <th>Sr.No</th>
                        <th>HLC Name</th>
                        <th>Applicant Name</th>
                        <th>RLMS No</th>
                        <th>CBS No</th>
                        <th>Branch Name</th>
                        <th>City</th>
                        <th>RBO</th>
                        <th>Loan Type</th>
                        <th>Sanction Loan Amt</th>
                        <th>DISB Date</th>
                        <th>DISB Status</th>
                        <th>Created By</th>
                        <?php if($_SESSION['staff_id']==498 || $_SESSION['staff_id']==13 || $_SESSION['staff_id']==28 || $_SESSION['staff_id']==14 || $_SESSION['staff_id']==538){ ?>
                        <th>Verify</th>
                        <?php } ?>
                        
                        <th>Verify By</th>
                        
                        <?php if($_SESSION['staff_id']==498 || $_SESSION['staff_id']==13 || $_SESSION['staff_id']==28 || $_SESSION['staff_id']==14 || $_SESSION['staff_id']==538){ ?>
                        <th>Approval</th>
                        <?php } ?>
                        <th>Remark</th>
                         <th>Appraisal</th>
                        <th>FSL</th>
                       <th>Proof Disb</th>
                        <th>Add Date</th>
                        <th>Action</th>
                    </tr>
                </thead>
            </table>
            </div>
        </div>
    </div>
</main>

<script>
$(document).ready(function () {
    var table = $('#invoiceTable').DataTable({
        "processing": true,
        "serverSide": true,
        "scrollX": true,     
        "autoWidth": false,   
        "dom": 'Blfrtip',      
        "buttons": [          
            { 
                extend: 'excelHtml5', 
                text: 'Excel',
                exportOptions: {
                    columns: ':visible',
                    format: {
                         body: function (data, row, column, node) {
                            if ($(node).find('input').length) {
                                return $(node).find('input').val();
                            }
                            if ($(node).find('select').length) {
                                return $(node).find('select option:selected').text();
                            }
                            if ($(node).find('.badge').length) {
                                return $(node).find('.badge').text().trim();
                            }
                            return $('<div>').html(data).text();
                        }
                    }
                }
            }
        ],
        "ajax": {
            "url": "<?= base_url('admin/get_invoice_cases_pb_ajax'); ?>",
            "type": "POST",
            "data": function (d) {
                d.start_date = $('#start_date').val();
                d.end_date = $('#end_date').val();
                d.branch = $('#branch').val();
                d.connector = $('#connector').val();
                d.status = $('#status').val();
                d.month = $('#month').val();
            }
        },
        "columns": [
            { "data": "id", "orderable": false, "render": function (data) {
                return '<input type="checkbox" name="selected_rows[]" class="row-checkbox" value="'+data+'">';
            }},
            { "data": "sr_no" },
            { "data": "staff_fullname" },
            { "data": "user_name" },
            { "data": "los_id" },
            { "data": "bank_acct_no" },
            { "data": "branch_name" },
            { "data": "city_name" },
            { "data": "rbo_name" },
            { "data": "user_type" },
            { "data": "sanction_amt" },
            { "data": "disb_date" },
            { "data": "disb_status" },
            { "data": "admin_created_hlc" },
            <?php if($_SESSION['staff_id']==498 || $_SESSION['staff_id']==13 || $_SESSION['staff_id']==28 || $_SESSION['staff_id']==14 || $_SESSION['staff_id']==538){ ?>
            { "data": "verify" },
            <?php } ?>
            { "data": "verified_by" },
            <?php if($_SESSION['staff_id']==498 || $_SESSION['staff_id']==13 || $_SESSION['staff_id']==28 || $_SESSION['staff_id']==14 || $_SESSION['staff_id']==538){ ?>
            { "data": "pb_pending_approve" },
            <?php } ?>
            { "data": "remark" },
            { "data": "appraisal" },
            { "data": "fsl" },
            { "data": "proof_disb" },
            { "data": "add_date" },
            { "data": "action", "orderable": false, "searchable": false }
        ],
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "pageLength": 50
    });

    $("#filterForm").submit(function (e) {
        e.preventDefault();
        table.ajax.reload();
    });

    $("#resetFilter").click(function () {
        $("#filterForm")[0].reset();
        $('.single-select').each(function() {
            $(this).val('').trigger('change');
        });
        table.ajax.reload();
    });

    table.buttons().container().appendTo('#invoiceTable_wrapper .col-md-6:eq(0)');

    table.on('draw', function () {
        restoreSelectedRows();
    });

    $('#invoiceTable tbody').on('change', 'input[name="selected_rows[]"]', function () {
        updateSelectedRows();
    });

    // Initialize selected rows object
    let selectedRows = {};

    function updateSelectedRows() {
        $("tbody input[name='selected_rows[]']").each(function () {
            if ($(this).is(':checked')) {
                selectedRows[$(this).val()] = true;
            } else {
                delete selectedRows[$(this).val()];
            }
        });
    }

    function restoreSelectedRows() {
        $("tbody input[name='selected_rows[]']").each(function () {
            if (selectedRows[$(this).val()]) {
                $(this).prop('checked', true);
            } else {
                $(this).prop('checked', false);
            }
        });
    }

    $("#checkAll").on('change', function () {
        var checkboxes = $("input[name='selected_rows[]']");
        checkboxes.prop('checked', this.checked);
        updateSelectedRows();
    });

    $("#GenerateInvoiceButton").click(function () {
        if (Object.keys(selectedRows).length > 0) {
            $('#GenrateInvoiceModal').modal('show');
        } else {
            alert("Please select at least one row before generating the invoice.");
        }
    });

    $("#applyinvoice").click(function () {
        const inv_type = $("#invoice_type").val();
        const invoice_date = $("#invoice_date").val();
        const signature_id = $("#signature_id").val();
        const is_tenper_hold = $("#is_tenper_hold").val();
        const selectedRowsArray = Object.keys(selectedRows);

        if (!inv_type || !invoice_date || !signature_id) {
            alert("Please complete all fields.");
            return;
        }

        $.ajax({
            type: "POST",
            url: "<?= base_url('admin/generate_invoice_pb'); ?>",
            data: { 
                inv_type: inv_type, 
                invoice_date: invoice_date, 
                signature_id: signature_id, 
                is_tenper_hold: is_tenper_hold, 
                selectedRows: JSON.stringify(selectedRowsArray)
            },
            success: function (response) {
                var data = JSON.parse(response);
                if (data.status === 'success') {
                    alert(data.message);
                    window.location.href = '<?= base_url("admin/manage_invoice_pb") ?>';
                } else {
                    alert("Error: " + data.message);
                }
            }
        });
    });

    $(document).on('change', '.remark-input', function () {
        var userId = $(this).data('id');
        var remark = $(this).val();

        $.ajax({
            type: 'POST',
            url: '<?= base_url('admin/update_remark'); ?>',
            data: { user_id: userId, remark: remark },
            success: function (response) {
                var res = JSON.parse(response);
                if (res.success) {
                    alert("Remark updated successfully.");
                } else {
                    alert("Error updating remark.");
                }
            }
        });
    });

    $(document).on('change', '.commoon_active_pb_approve', function () {
        var element = $(this);
        var nextStatus = element.val();
        var id = element.data('id');
        var action = element.attr('action');

        $.ajax({
            type: 'POST',
            url: "<?= base_url('admin/') ?>" + action + "/" + id + "/" + nextStatus,
            success: function (response) {
                var res = JSON.parse(response);
                if (res.success === '1') {
                    element.removeClass('bg-success bg-warning');
                    if (nextStatus === '1') {
                        element.addClass('bg-success');
                    } else {
                        element.addClass('bg-warning');
                    }
                    alert(res.message);
                } else {
                    alert(res.message);
                }
            }
        });
    });

});

</script>

  <!-- Pass PHP session value to JS -->
 <script>
  /*  const sessionFinancialYear = "<?= $financialYear ?>";

    function validateInvoiceDate() {
        const invoiceDateInput = document.getElementById('invoice_date');
        const selectedDate = new Date(invoiceDateInput.value);
        const errorSpan = document.getElementById('invoice_date_error');

        let cutoffDate;
        let errorMessage = '';

        if (sessionFinancialYear === "24-25") {
            cutoffDate = new Date('2025-04-01');
            if (selectedDate >= cutoffDate) {
                errorMessage = "Invoice date must be before 31 Mar 2025 or change Fin. Year";
            }
        } else if (sessionFinancialYear === "25-26") {
            cutoffDate = new Date('2025-04-01');
            if (selectedDate < cutoffDate) {
                errorMessage = "Invoice date must be after 1 Apr 2025 or change Fin. Year";
            }
        }

        if (errorMessage) {
            errorSpan.textContent = errorMessage;
            invoiceDateInput.value = '';
            return false;
        } else {
            errorSpan.textContent = '';
            return true;
        }
    }

    // Date input change validation
    document.getElementById('invoice_date').addEventListener('change', validateInvoiceDate);

    // Submit button click validation
    document.getElementById('applyinvoice').addEventListener('click', function () {
        if (validateInvoiceDate()) {
            // If valid, proceed with your submission logic
            console.log("Form is valid, you can proceed.");
            // Example: submit the form here if needed
            // document.getElementById('your_form_id').submit();
        } else {
            console.log("Form has errors.");
        }
    });*/
</script>


<style>

    #GenerateInvoiceButton {
    transition: all 0.3s ease-in-out;
}

#GenerateInvoiceButton:hover {
    background-color: #0056b3; /* Slightly darker blue */
    transform: scale(1.05); /* Slight hover zoom effect */
}
</style>
