<div class="modal fade" id="editBrInvoiceDateModal" tabindex="-1" aria-labelledby="editBrInvoiceDateModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="invoiceBrDateForm">
        <div class="modal-header">
          <h5 class="modal-title">Edit Invoice Date</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="invoice_batchno" id="invoice_batchno">
          <label for="invoice_date">Invoice Date</label>
          <input type="date" name="invoice_date" id="invoice_date" class="form-control" required>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Update</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>

<div class="modal fade" id="editBrInvoiceNumModal" tabindex="-1" aria-labelledby="editBrInvoiceNumModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="invoiceBrNumForm">
        <div class="modal-header">
          <h5 class="modal-title">Edit Invoice Number</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="invoice_batchno" id="invoice_batchno_num">
          <label for="invoice_num">Invoice Number</label>
          <input type="text" name="invoice_num" id="invoice_num" class="form-control" required>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Update</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>




<main class="page-content">
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"> <?= $title ?> </div>
    </div>
    <div class="card">
        <div class="card-body">
            <form id="filterForm">
                <div class="row">
                    <div class="col-md-3">
                        <label for="start_date">Start Date:</label>
                        <input class="form-control" type="date" name="start_date" id="start_date">
                    </div>
                    <div class="col-md-3">
                        <label for="end_date">End Date:</label>
                        <input class="form-control" type="date" name="end_date" id="end_date">
                    </div>
                    <div class="col-md-3">
                        <label for="branch">Branch</label>
                        <select class="single-select" id="branch" name="branch">
                            <option value="">Select Branch</option>
                            <?php foreach ($branch as $branchItem) : ?>
                                <option value="<?= $branchItem['id']; ?>"><?= $branchItem['branch_name']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                     <div class="col-md-2 mb-3">
                        <label for="state_id">State</label>
                        <select name="state_id" id="state_id" class="single-select">
                            <option value="">-Select-</option>
                            <?php foreach ($state as $value) { ?>
                                <option value="<?= $value['id']; ?>" <?php echo isset($_POST['state_id']) && $_POST['state_id'] === $value['id'] ? 'selected' : ''; ?>><?= $value['state_name']; ?></option>
                            <?php } ?>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label for="city_id">City</label>
                        <select name="city_id" id="city_id" class="single-select">
                            <option value="">-Select-</option>
                        </select>
                    </div>
                    <?php if ($_SESSION['staff_type'] == 0) { ?>
                    <div class="col-md-3">
                        <label for="connector">HLC</label>
                        <select class="single-select" id="connector" name="connector">
                            <option value="">Select HLC</option>
                            <?php foreach ($connector as $connectorItem) : ?>
                                <option value="<?= $connectorItem['staff_id']; ?>"><?= $connectorItem['staff_fullname']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <?php } ?>
                    <div class="col-md-2 mb-3">
                        <label class="">Month</label>
                        <input type="month" name="month" id="month" class="form-control">
                    </div>
                    <div class="col-md-3">
                        <br>
                        <button type="button" class="btn btn-success" id="filterBtn">Submit</button>
                        <button type="button" class="btn btn-info" id="resetBtn">Reset</button>
                    </div>
                </div>
            </form>
            <hr class="mt-3">
            <div class="table-responsive">
                <table class="table align-middle table-striped" id="Table">
                    <thead>
                        <tr>
                            <th>Sr.No</th>
                            <th>Branch Name</th>
                            <th>City</th>
                            <th>Applicant</th>
                            <th>Inv Number</th>
                             <th>Net Pay Amt</th>
                            <!--<th>Recevied Amt</th>
                            <th>Balance</th> -->
                            <th>Invoice Date</th>
                            <!-- <th>Payment Log</th> -->
                            <th>Created Date</th>
                           <!--  <th>Payment Status</th> -->
                            <th>Edit</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<script>
$(document).ready(function() {
    var table = $('#Table').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?php echo base_url('admin/fetch_invoice_data_branch_conf'); ?>",
            "type": "POST",
            "data": function(d) {
                d.start_date = $('#start_date').val();
                d.end_date = $('#end_date').val();
                d.branch = $('#branch').val();
                d.connector = $('#connector').val();
                d.state_id = $('#state_id').val();
                d.city_id = $('#city_id').val();
                d.month = $('#month').val();
            }
        },
        "columns": [
            { "data": "sr_no" },
            { "data": "branch_name" },
            { "data": "city_name" },
            { "data": "applicant" },
            { "data": "invoice_number" },
            { "data": "net_pay_amt" },
            { "data": "invoice_date" },
            { "data": "created_date" },
            { "data": "edit", "orderable": false } // Edit column not sortable
        ],
        "order": [[0, 'desc']], // Set default order
        "lengthChange": true,
        "lengthMenu": [[100, 200, 300], [100, 200, 300]],
        "pageLength": 100,
        "dom": 'lBfrtip',
        "scrollX": true,
        "fixedColumns": {
          leftColumns: 0,
          rightColumns: 1,
        },
        "buttons": [
            { extend: 'excel', text: 'Excel' }
        ],
        "drawCallback": function(settings) {
      $('[data-bs-toggle="tooltip"]').tooltip();

      // Adjust the height of the fixed columns to match the scrollable columns
      setTimeout(function() {
        var scrollBodyHeight = $('.dataTables_scrollBody').height();
        $('.DTFC_LeftBodyWrapper').height(scrollBodyHeight);
        $('.DTFC_RightBodyWrapper').height(scrollBodyHeight);

        // Adjust the row heights to match
        $('#Table tbody tr').each(function(index) {
          var rowHeight = $(this).height();
          $('.DTFC_LeftBodyWrapper tbody tr').eq(index).height(rowHeight);
          $('.DTFC_RightBodyWrapper tbody tr').eq(index).height(rowHeight);
        });
      }, 10);

     

    }
    });

    table.buttons().container().appendTo('#Table_wrapper .col-md-6:eq(0)');

    $('#filterBtn').on('click', function() {
        table.ajax.reload();
    });

    $('#resetBtn').on('click', function() {
        $('#filterForm')[0].reset();
        table.ajax.reload();
    });

    // Handle delete action with confirmation
    $(document).on('click', '.delete', function () {
        var element = $(this);
        var id = element.attr('data-id'); // Use data-id attribute to get the ID
        var action = element.attr('action');

        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to delete this Invoice?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    url: base_url + 'admin/' + action + '/' + id,
                    dataType: 'json',
                    success: function (res) {
                        if (res.success == '1') {
                            notify(res.type, res.message);
                            table.ajax.reload(null, false);  // Reload the table data without resetting pagination
                        } else {
                            notify(res.type, res.message);
                        }
                    },
                    error: function (xhr, status, error) {
                        console.log(xhr.responseText);
                        alert('Error occurred while deleting data. Please try again.');
                    }
                });
            }
        });
    });
    
     $('#state_id').change(function() {
        var stateId = $(this).val();
        if(stateId !== '') {
            $.ajax({
                url: '<?= base_url('Admin/get_cities') ?>',
                type: 'POST',
                data: { state_id: stateId },
                dataType: 'json',
                success: function(data) {
                    $('#city_id').empty().append('<option value="">-Select-</option>');
                    $.each(data, function(key, value) {
                        $('#city_id').append('<option value="' + value.id + '">' + value.city_name + '</option>');
                    });
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        } else {
            $('#city_id').empty().append('<option value="">-Select-</option>');
        }
    });

    $('#state_id').trigger('change');
    
    $('.dataTables_scrollBody').on('scroll', function() {
    var $scrollBody = $(this);
    var $fixedColumnsRight = $('.DTFC_RightBodyWrapper');
    var scrollLeft = $scrollBody.scrollLeft();
    var scrollWidth = $scrollBody[0].scrollWidth;
    var clientWidth = $scrollBody[0].clientWidth;
    
    var isScrolledToEnd = scrollLeft + clientWidth >= scrollWidth - 1; // -1 to account for rounding issues
    
    if (isScrolledToEnd) {
        $fixedColumnsRight.hide();
    } else {
        $fixedColumnsRight.show();
    }
  });
  
});



$(document).on('click', '.edit-brinvoice-date-btn', function () {
    let invoice = $(this).data('invoice');
    let currentDate = $(this).data('current-date');
    $('#invoice_batchno').val(invoice);
    $('#invoice_date').val(currentDate);
});
$('#invoiceBrDateForm').on('submit', function (e) {
    e.preventDefault();
    $.ajax({
        url: '<?= base_url('admin/update_invoice_date') ?>',
        type: 'POST',
        data: $(this).serialize(),
        success: function (response) {
            let res = JSON.parse(response);
            if (res.success) {
                Swal.fire('Success', res.message, 'success');
                $('#editBrInvoiceDateModal').modal('hide');
                $('#Table').DataTable().ajax.reload(null, false);
            } else {
                Swal.fire('Error', res.message, 'error');
            }
        }
    });
});

  
  $(document).on('click', '.edit-brinvoice-num-btn', function () {
     let invoice = $(this).data('invoice');
    let currentNum = $(this).data('current-num');

    $('#invoice_batchno_num').val(invoice);
    $('#invoice_num').val(currentNum);

    $('#editBrInvoiceNumModal').modal('show');
});
$('#invoiceBrNumForm').on('submit', function (e) {
    e.preventDefault();
  
    $.ajax({
        url: '<?= base_url('admin/update_invoice_number') ?>',
        type: 'POST',
        data: $(this).serialize(),
        success: function (response) {
            let res = JSON.parse(response);
            if (res.success) {
                Swal.fire('Success', res.message, 'success');
                $('#editBrInvoiceNumModal').modal('hide');
                $('#Table').DataTable().ajax.reload(null, false);
            } else {
                Swal.fire('Error', res.message, 'error');
            }
        }
    });
});



</script>

<style>
  .dataTables_length {
      margin-bottom: 13px;
  }
  .dataTables_filter {
      margin-top: 12px;
  }


  .DTFC_RightBodyWrapper table,
  .DTFC_LeftBodyWrapper table {
      width: 100% !important;
  }

  .dataTables_scrollBody {
      overflow: auto;
  }

  .DTFC_LeftBodyLiner,
  .DTFC_RightBodyLiner {
      overflow: hidden !important;
  }

  .DTFC_LeftBodyWrapper,
  .DTFC_RightBodyWrapper {
      top: 0 !important;
  }

  .DTFC_RightBodyWrapper {
      right: 0 !important;
  }

  .DTFC_RightBodyLiner {
      overflow: hidden;
      position: absolute;
      right: 0;
      top: -11px !important;
      background-color: white !important;
  }

  .DTFC_LeftBodyLiner {
      overflow: hidden;
      position: absolute;
      left: 0;
  }

  .dataTables_scrollHeadInner, .dataTables_scrollHead, .dataTables_scrollBody {
      margin-bottom: 0 !important;
  }

  .dataTables_wrapper .dataTables_scroll div.dataTables_scrollBody {
      background: white;
  }


  table.dataTable tr:nth-child(even) {
      background-color: #ffff;
  }

  table.dataTable tr:nth-child(odd) {
      background-color: #ffffff;
  }

  

</style>


<script>
 function deleteApplicantBranchInvoice(invoiceId, userId, applicantName) {
     if (confirm('Are you sure you want to delete this invoice for ' + applicantName + '?')) {
        console.log({ invoice_id: invoiceId, user_id: userId });
        $.ajax({
            url: '<?= base_url("admin/delete_invoice_branch_applicant") ?>',
            type: 'POST',
            dataType: 'json', // Specify the expected data type
            data: {
                invoice_id: invoiceId,
                user_id: userId
            },
            success: function(response) {
                console.log(response);
                if (response.success) {
                    alert(response.message || 'Invoices Applicant deleted successfully!');
                    table.ajax.reload(null, false);
                } else {
                    alert(response.message || 'Cannot delete: SBI Payment status is Paid');
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', status, error);
                alert('Error occurred while processing the request.');
            }
        });
    }
}


</script>


