 
<main class="page-content">


<?php
    $totals = $monthly_totals;
    $total_mb = 0;
    $total_pb = 0;
    $total_sanctions = 0;

    // Get selected financial year (from URL parameter)
    $selected_fy = isset($_GET['fy']) ? $_GET['fy'] : '24-25';
?>
<div class="row">
  
    <div class="card col-md-6">
        <div class="card-body">
               <form method="GET" action="<?= base_url('admin/manage_dash_reports'); ?>" class="mb-3">
            <label for="fy">Select Financial Year:</label>
            <select name="fy" id="fy" class="form-control" onchange="this.form.submit();">
                <option value="24-25" <?= ($selected_fy == '24-25') ? 'selected' : '' ?>>2024-25</option>
                <option value="25-26" <?= ($selected_fy == '25-26') ? 'selected' : '' ?>>2025-26</option>
            </select>
        </form>
            <div class="table-responsive">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Months (FY <?= $selected_fy ?>)</th>
                            <th>MB</th>
                            <th>PB</th>
                            <th>Total Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            $months = [
                                'apr' => 'Apr', 'may' => 'May', 'jun' => 'Jun', 'jul' => 'Jul',
                                'aug' => 'Aug', 'sept' => 'Sep', 'oct' => 'Oct', 'nov' => 'Nov',
                                'dec' => 'Dec', 'jan' => 'Jan', 'feb' => 'Feb', 'mar' => 'Mar'
                            ];

                            foreach ($months as $key => $month) {
                                $mb_total = isset($totals[$key.'_mb']) ? $totals[$key.'_mb'] : 0;
                                $pb_total = isset($totals[$key.'_pb']) ? $totals[$key.'_pb'] : 0;
                                $total_amt = $mb_total + $pb_total;

                                // Only display this month if any of the values are greater than zero
                                if ($mb_total > 0 || $pb_total > 0 || $total_amt > 0) {
                                    // Sum up totals for final row
                                    $total_mb += $mb_total;
                                    $total_pb += $pb_total;
                                    $total_sanctions += $total_amt;

                                    echo "
                                    <tr>
                                        <td>$month</td>
                                        <td>" . formatIndianNumber($mb_total) . "</td>
                                        <td>" . formatIndianNumber($pb_total) . "</td>
                                        <td>" . formatIndianNumber($total_amt) . "</td>
                                    </tr>";
                                }
                            }
                        ?>
                    </tbody>
                    <tfoot style="background: aliceblue;">
                        <tr>
                            <th>Total Sanctions</th>
                            <th><?= formatIndianNumber($total_mb); ?></th>
                            <th><?= formatIndianNumber($total_pb); ?></th>
                            <th><?= formatIndianNumber($total_sanctions); ?></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</div>


<div class="row">
    <div class="card col-md-12">
        <div class="card-body">
        <form method="GET" action="<?= base_url('admin/manage_dash_reports'); ?>" class="mb-3">
            <label for="fy">Select Financial Year:</label>
            <select name="fy" id="fy" class="form-control" onchange="this.form.submit();">
                <option value="24-25" <?= ($selected_fy == '24-25') ? 'selected' : '' ?>>2024-25</option>
                <option value="25-26" <?= ($selected_fy == '25-26') ? 'selected' : '' ?>>2025-26</option>
            </select>
        </form>
            <div class="table-responsive">
                <p><b>Paisabazaar</b></p>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Months (FY <?= $selected_fy ?>)</th>
                            <th>Total Cases</th>
                            <th>Total Sanctioned Amount</th>
                           <!-- <th>Total - Partner Payout Amount (Disb Case)</th>-->
                          <!--  <th>Partner Paid (Disb Case)</th>-->
                          <!--  <th>Partner Outstanding</th>-->
                            <th>PB Remuneration</th>
                           <!-- <th>PB Paid</th>-->
                           <!-- <th>PB Outstanding</th>-->
                            <th>Total of Partner Paid<br> But PB not Paid</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            $total_cases_sum = 0;
                            $total_sanctioned_sum = 0;
                            $total_partner_payout_sum = 0;
                            $total_pb_remunration_sum = 0;
                            $total_partner_paid_sum = 0;
                            $total_pb_paid_sum = 0;
                            $total_partner_paid_but_pb_not_sum = 0;

                            // Define the months for display
                            $months = [
                                'April', 'May', 'June', 'July', 'August', 'September', 
                                'October', 'November', 'December', 'January', 'February', 'March'
                            ];

                            // Loop through the data and display each month
                            foreach ($months as $month) {
                                $case_count = 0;
                                $total_sanctioned = 0;
                                $total_pb_remunration = 0;
                                $total_partner_payout_amt = 0;
                                $total_partner_paid_amt = 0;
                                $total_pb_paid_amt = 0;
                                $total_partner_paid_but_pb_not_amt = 0;

                                // Loop through the monthly data to find matching month
                                foreach ($monthly_data as $data) {
                                    if (strtolower($data->month_name) == strtolower($month)) {
                                        $case_count = $data->total_cases;
                                        $total_sanctioned = $data->total_sanctioned;
                                        $total_pb_remunration = $data->total_pb_remuneration;
                                        $total_partner_payout_amt = $data->total_partner_payout;
                                        $total_partner_paid_amt = $data->total_partner_paid_amt;
                                        $total_pb_paid_amt = $data->total_pb_paid_amt;
                                        $total_partner_paid_but_pb_not_amt = $data->total_partner_paid_but_pb_not;

                                        // Add to overall totals
                                        $total_cases_sum += $case_count;
                                        $total_sanctioned_sum += $total_sanctioned;
                                        $total_pb_remunration_sum += $total_pb_remunration;
                                        $total_partner_payout_sum += $total_partner_payout_amt;
                                        $total_partner_paid_sum += $total_partner_paid_amt;
                                        $total_pb_paid_sum += $total_pb_paid_amt;
                                        $total_partner_paid_but_pb_not_sum += $total_partner_paid_but_pb_not_amt;
                                    }
                                }

                                // Check if all values are zero, skip this month if they are
                                if ($case_count == 0 && 
                                    $total_sanctioned == 0 && 
                                    $total_pb_remunration == 0 && 
                                    $total_partner_payout_amt == 0 && 
                                    $total_partner_paid_amt == 0 && 
                                    $total_pb_paid_amt == 0 && 
                                    $total_partner_paid_but_pb_not_amt == 0) {
                                    continue; // Skip rendering this month's row if all values are zero
                                }
                        ?>
                        <tr>
                            <td><?= $month ?></td>
                            <td><?= $case_count ?></td> <!-- Total cases per month -->
                            <td><?= formatIndianNumber($total_sanctioned) ?></td> <!-- Format the sanctioned amount -->
                           <!-- <td><?= formatIndianNumber($total_partner_payout_amt) ?></td>--> 
                           <!-- <td><?= formatIndianNumber($total_partner_paid_amt) ?></td>--> <!-- Format the partner paid -->
                           <!-- <td><?= formatIndianNumber($total_partner_payout_amt - $total_partner_paid_amt); ?></td>--> <!-- Partner Outstanding -->
                            <td><?= formatIndianNumber($total_pb_remunration); ?></td> 
                           <!-- <td><?= formatIndianNumber($total_pb_paid_amt); ?></td> -->
                            <!--<td><?= formatIndianNumber($total_pb_remunration - $total_pb_paid_amt); ?></td>--> <!-- PB Outstanding -->
                            <td><?= formatIndianNumber($total_partner_paid_but_pb_not_amt); ?></td>
                        </tr>
                        <?php } ?>
                    </tbody>
                    <tfoot style="background: aliceblue;">
                        <tr>
                            <th>Total</th>
                            <th><?= $total_cases_sum ?></th> <!-- Total cases for the year -->
                            <th><?= formatIndianNumber($total_sanctioned_sum) ?></th> <!-- Total sanctioned for the year -->
                           <!-- <th><?= formatIndianNumber($total_partner_payout_sum) ?></th>-->
                           <!-- <th><?= formatIndianNumber($total_partner_paid_sum) ?></th>-->
                           <!-- <th><?= formatIndianNumber($total_partner_payout_sum - $total_partner_paid_sum) ?></th>-->
                            <th><?= formatIndianNumber($total_pb_remunration_sum) ?></th>
                           <!-- <th><?= formatIndianNumber($total_pb_paid_sum) ?></th>-->
                           <!-- <th><?= formatIndianNumber($total_pb_remunration_sum - $total_pb_paid_sum) ?></th>-->
                            <th><?= formatIndianNumber($total_partner_paid_but_pb_not_sum) ?></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</div>



<?php
// Fetch active RBOs from the database
$rbo = $this->db->select("*")->from('mst_rbo')->where('active', 1)->get()->result_array();

// Get session value of financial year
$fy = $this->session->userdata('financial_year');

// Determine the financial year start and end year
if ($fy === '24-25') {
    $financialYearStartYear = 2024;
    $financialYearEndYear = 2025;
} elseif ($fy === '25-26') {
    $financialYearStartYear = 2025;
    $financialYearEndYear = 2026;
} else {
    // Fallback to current date logic
    $currentMonth = date('m');
    $currentYear = date('Y');

    if ($currentMonth >= 4) {
        $financialYearStartYear = $currentYear;
        $financialYearEndYear = $currentYear + 1;
    } else {
        $financialYearStartYear = $currentYear - 1;
        $financialYearEndYear = $currentYear;
    }
}

// Define the months in the financial year (unchanged)
$monthsRbo = [
    'April', 'May', 'June', 'July', 'August', 'September',
    'October', 'November', 'December', 'January', 'February', 'March'
];

// Now you can loop based on $financialYearStartYear and $financialYearEndYear
// For Jan to Mar, use $financialYearEndYear
// For Apr to Dec, use $financialYearStartYear

// Example:
function getRboTotalsMonth($rboId, $year, $month) {
    $CI =& get_instance();
    $query = $CI->db->query("
        SELECT 
            SUM(DISTINCT il.pay_amt) AS total_sbi_paid_amt,
            SUM(DISTINCT il.tds_amt) AS total_tds_amt
        FROM invoice_log il
        JOIN invoices inv ON il.invoice_batchno = inv.inv_batchno
        JOIN mst_user ON inv.user_id = mst_user.id
        JOIN branch ON branch.id = mst_user.branch_id
        LEFT JOIN mst_rbo ON mst_rbo.id = branch.rbo_id
        WHERE il.invoice_type = 'inv_sbi'
          AND il.status IN ('paid', 'partly paid', 'excess paid')
          AND mst_rbo.id = ?
          AND YEAR(mst_user.disb_date) = ?
          AND MONTH(mst_user.disb_date) = ?
    ", [$rboId, $year, $month]);
    return $query->row_array();
}

?>

<?php foreach ($monthsRbo as $monthIndex => $month): ?>
    <?php
    // Adjust numeric month based on the index
    $numericMonth = ($monthIndex >= 9) ? $monthIndex - 8 : $monthIndex + 4;

    // Initialize totals for the month (reset for every month)
    $monthTotalDisbLoanAmt = $monthTotalPartnerPayoutAmt = $monthTotalSbiCommiAmt = 0;
    $monthTotal10PerCommiAmt = $monthTotal90PerCommiAmt = $monthTotalGSTAmt = 0;
    $monthTotalSbiPaidAmt = $monthTotalTDSAmt = $monthTotalSBIOutstanding = 0;

    $rboDataForMonth = []; // Array to store RBO-wise data for the month

    foreach ($rbo as $rboItem):
        $rboId = $rboItem['id'];

        // Fetch totals for this RBO and month using the function
        $totals_mon = getRboTotalsMonth($rboId, $currentYear, $numericMonth);
        $monthlyTdsAmt = $totals_mon['total_tds_amt'] ?? 0;
        $monthlySbiPaidAmt = $totals_mon['total_sbi_paid_amt'] ?? 0;

        $rboTotals = [
            'rbo_name' => $rboItem['rbo_name'],
            'total_disb_loan_amt' => 0,
            'total_partner_payout_rbo' => 0,
            'total_sbi_commi_amt' => 0,
            'total_10_per_commi_amt' => 0,
            'total_90_per_commi_amt' => 0,
            'total_gst_amt' => 0,
            'total_tds_amt' => $monthlyTdsAmt,
            'total_sbi_paid_amt' => $monthlySbiPaidAmt,
            'total_sbi_outstanding' => 0,
        ];

        foreach ($monthly_data_rbo as $item):
            if ($item->month_name == $month && $item->rbo_name == $rboItem['rbo_name']):
                $rboTotals['total_disb_loan_amt'] += $item->total_disb_loan_amt;
                $rboTotals['total_partner_payout_rbo'] += $item->total_partner_payout_rbo;
                $rboTotals['total_sbi_commi_amt'] += $item->total_sbi_commi_amt;
                $rboTotals['total_10_per_commi_amt'] += $item->total_sbi_commi_amt * 0.10;
                $rboTotals['total_90_per_commi_amt'] += $item->total_sbi_commi_amt * 0.90;
                $rboTotals['total_gst_amt'] += ($item->total_sbi_commi_amt * 0.90) * 0.18;
                $rboTotals['total_sbi_outstanding'] += (
                    ($item->total_sbi_commi_amt * 0.90) +  (($item->total_sbi_commi_amt * 0.90) * 0.18) -
                    ($monthlyTdsAmt + $monthlySbiPaidAmt)
                );
            endif;
        endforeach;

        // Skip RBO if all totals are 0
        if (
            $rboTotals['total_disb_loan_amt'] == 0 &&
            $rboTotals['total_partner_payout_rbo'] == 0 &&
            $rboTotals['total_sbi_commi_amt'] == 0 &&
            $rboTotals['total_10_per_commi_amt'] == 0 &&
            $rboTotals['total_90_per_commi_amt'] == 0 &&
            $rboTotals['total_gst_amt'] == 0 &&
            $rboTotals['total_tds_amt'] == 0 &&
            $rboTotals['total_sbi_paid_amt'] == 0 &&
            $rboTotals['total_sbi_outstanding'] == 0
        ) {
            continue; // Skip this RBO
        }

        $rboDataForMonth[] = $rboTotals; // Add RBO data to the array if valid
    endforeach;

    // Skip the month if no RBOs have data
    if (empty($rboDataForMonth)) {
        continue;
    }
    ?>
    <div class="table-responsive mb-4">
        <p><b><?= $month; ?></b></p>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>RBO</th>
                    <th>Disb Loan Amount</th>
                    <th>Partner Payout Amt</th>
                    <th>SBI Comm Amt</th>
                    <th>SBI 10%</th>
                    <th>SBI 90%</th>
                    <th>GST Amount</th>
                   <!-- <th>TDS Amount</th>
                    <th>SBI Paid</th>
                    <th>SBI Outstanding</th>-->
                </tr>
            </thead>
            <tbody>
                <?php foreach ($rboDataForMonth as $data): ?>
                    <tr>
                        <td><?= htmlspecialchars($data['rbo_name'], ENT_QUOTES, 'UTF-8') ?></td>
                        <td><?= formatIndianNumber($data['total_disb_loan_amt']) ?></td>
                        <td><?= formatIndianNumber($data['total_partner_payout_rbo']) ?></td>
                        <td><?= formatIndianNumber($data['total_sbi_commi_amt']) ?></td>
                        <td><?= formatIndianNumber($data['total_10_per_commi_amt']) ?></td>
                        <td><?= formatIndianNumber($data['total_90_per_commi_amt']) ?></td>
                        <td><?= formatIndianNumber($data['total_gst_amt']) ?></td>
                       <!-- <td><?= formatIndianNumber($data['total_tds_amt']) ?></td>
                        <td><?= formatIndianNumber($data['total_sbi_paid_amt']) ?></td>
                        <td><?= formatIndianNumber($data['total_sbi_outstanding']) ?></td>-->
                    </tr>
                <?php endforeach; ?>
            </tbody>
            <tfoot style="background: aliceblue;">
                <tr>
                    <th>Total</th>
                    <th><?= formatIndianNumber(array_sum(array_column($rboDataForMonth, 'total_disb_loan_amt'))) ?></th>
                    <th><?= formatIndianNumber(array_sum(array_column($rboDataForMonth, 'total_partner_payout_rbo'))) ?></th>
                    <th><?= formatIndianNumber(array_sum(array_column($rboDataForMonth, 'total_sbi_commi_amt'))) ?></th>
                    <th><?= formatIndianNumber(array_sum(array_column($rboDataForMonth, 'total_10_per_commi_amt'))) ?></th>
                    <th><?= formatIndianNumber(array_sum(array_column($rboDataForMonth, 'total_90_per_commi_amt'))) ?></th>
                    <th><?= formatIndianNumber(array_sum(array_column($rboDataForMonth, 'total_gst_amt'))) ?></th>
                    <!--<th><?= formatIndianNumber(array_sum(array_column($rboDataForMonth, 'total_tds_amt'))) ?></th>
                    <th><?= formatIndianNumber(array_sum(array_column($rboDataForMonth, 'total_sbi_paid_amt'))) ?></th>
                    <th><?= formatIndianNumber(array_sum(array_column($rboDataForMonth, 'total_sbi_outstanding'))) ?></th>-->
                </tr>
            </tfoot>
        </table>
    </div>
<?php endforeach; ?>








<?php 
// Fetch active RBOs from the database
$rbo = $this->db->select("*")->from('mst_rbo')->where('active', 1)->get()->result_array(); 

$fy = $this->session->userdata('financial_year'); // e.g., '24-25'

// Check if session is set and matches expected format
if ($fy === '24-25') {
    $financialYearStart = '2024-04-01';
    $financialYearEnd = '2025-03-31';
} elseif ($fy === '25-26') {
    $financialYearStart = '2025-04-01';
    $financialYearEnd = '2026-03-31';
} else {
    // Fallback to current financial year based on current date
    $currentMonth = date('m');
    $currentYear = date('Y');

    if ($currentMonth >= 4) {
        $financialYearStart = $currentYear . '-04-01'; // Start of financial year
        $financialYearEnd = ($currentYear + 1) . '-03-31'; // End of financial year
    } else {
        $financialYearStart = ($currentYear - 1) . '-04-01'; // Start of financial year
        $financialYearEnd = $currentYear . '-03-31'; // End of financial year
    }
}

// Initialize total variables for the entire year
$totals = [
    'DisbLoanAmt' => 0,
    'PartnerPayoutAmt' => 0,
    'SbiCommiAmt' => 0,
    '10PerCommiAmt' => 0,
    '90PerCommiAmt' => 0,
    'GSTAmt' => 0,
    'SbiPaidAmt' => 0,
    'TDSAmt' => 0,
    'SBIOutstanding' => 0
];

// Function to fetch total_sbi_paid_amt and total_tds_amt for a specific RBO
function getRboTotals($rboId, $financialYearStart, $financialYearEnd) {
    $CI =& get_instance();
    $query = $CI->db->query("
        SELECT 
            SUM(DISTINCT il.pay_amt) AS total_sbi_paid_amt,
            SUM(DISTINCT il.tds_amt) AS total_tds_amt
        FROM invoice_log il
        JOIN invoices inv ON il.invoice_batchno = inv.inv_batchno
        JOIN mst_user ON inv.user_id = mst_user.id
        JOIN branch ON branch.id = mst_user.branch_id
        LEFT JOIN mst_rbo ON mst_rbo.id = branch.rbo_id
        WHERE il.invoice_type = 'inv_sbi'
          AND il.status IN ('paid', 'partly paid', 'excess paid')
          AND mst_rbo.id = ?
          AND mst_user.disb_date BETWEEN ? AND ?
    ", [$rboId, $financialYearStart, $financialYearEnd]);
    return $query->row_array();
}

?>

<div class="row">
    <div class="card col-md-12">
        <div class="card-body">
            <p><b>RBO Data for the Financial Year <?= $financialYearStart; ?> - <?= $financialYearEnd; ?></b></p>
            <div class="table-responsive">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>RBO</th>
                            <th>Disb Loan Amount</th>
                            <th>Partner Payout Amt</th>
                            <th>SBI Comm Amt</th>
                            <th>SBI 10 %</th>
                            <th>SBI 90%</th>
                            <th>GST Amount</th>
                            <th>TDS Amount</th>
                            <th>SBI Paid</th>
                            <th>SBI Outstanding</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($monthly_data_rbo)): ?>
                            <?php foreach ($rbo as $rbo_item): 
                                // Initialize totals for each RBO
                                $rboTotals = array_fill_keys(array_keys($totals), 0);

                                // Fetch total_sbi_paid_amt and total_tds_amt dynamically
                                $sbiTdsData = getRboTotals($rbo_item['id'], $financialYearStart, $financialYearEnd);
                                $rboTotals['SbiPaidAmt'] = $sbiTdsData['total_sbi_paid_amt'] ?? 0;
                                $rboTotals['TDSAmt'] = $sbiTdsData['total_tds_amt'] ?? 0;

                                // Loop through monthly data and sum up values for each RBO
                                foreach ($monthly_data_rbo as $item):
                                    if ($item->rbo_name == $rbo_item['rbo_name']): 
                                        $rboTotals['DisbLoanAmt'] += $item->total_disb_loan_amt;
                                        $rboTotals['PartnerPayoutAmt'] += $item->total_partner_payout_rbo; 
                                        $rboTotals['SbiCommiAmt'] += $item->total_sbi_commi_amt; 
                                        $rboTotals['10PerCommiAmt'] += $item->total_sbi_commi_amt * 0.10; 
                                        $rboTotals['90PerCommiAmt'] += $item->total_sbi_commi_amt * 0.90; 
                                        $rboTotals['GSTAmt'] += ($item->total_sbi_commi_amt * 0.90) * 0.18;

                                      
                                       
                                    endif;
                                endforeach;

                                // Check if all totals are 0 for the current RBO
                                if (array_sum($rboTotals) > 0): 
                                    // Add RBO totals to the overall yearly totals
                                    foreach ($rboTotals as $key => $value) {
                                        $totals[$key] += $value;
                                    }
                            ?>
                            <tr>
                                <td><?= htmlspecialchars($rbo_item['rbo_name'], ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= formatIndianNumber($rboTotals['DisbLoanAmt']) ?></td>
                                <td><?= formatIndianNumber($rboTotals['PartnerPayoutAmt']) ?></td>
                                <td><?= formatIndianNumber($rboTotals['SbiCommiAmt']) ?></td>
                                <td><?= formatIndianNumber($rboTotals['10PerCommiAmt']) ?></td>
                                <td><?= formatIndianNumber($rboTotals['90PerCommiAmt']) ?></td>
                                <td><?= formatIndianNumber($rboTotals['GSTAmt']) ?></td>
                                <td><?= formatIndianNumber($rboTotals['TDSAmt']) ?></td>
                                <td><?= formatIndianNumber($rboTotals['SbiPaidAmt']) ?></td>
                                 <?php
                                        $outstanding = ($rboTotals['90PerCommiAmt'] + $rboTotals['GSTAmt']) - ($rboTotals['TDSAmt'] + $rboTotals['SbiPaidAmt']);
                                        $totals['SBIOutstanding'] += $outstanding; // Add to overall total
                                    ?>
                                    <td><?= formatIndianNumber($outstanding) ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="10" class="text-center">No data available for this year.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                    <tfoot style="background: aliceblue;">
    <tr>
        <th>Total</th>
        <th><?= formatIndianNumber($totals['DisbLoanAmt']) ?></th>
        <th><?= formatIndianNumber($totals['PartnerPayoutAmt']) ?></th>
        <th><?= formatIndianNumber($totals['SbiCommiAmt']) ?></th>
        <th><?= formatIndianNumber($totals['10PerCommiAmt']) ?></th>
        <th><?= formatIndianNumber($totals['90PerCommiAmt']) ?></th>
        <th><?= formatIndianNumber($totals['GSTAmt']) ?></th>
        <th><?= formatIndianNumber($totals['TDSAmt']) ?></th>
        <th><?= formatIndianNumber($totals['SbiPaidAmt']) ?></th>
        <th><?= formatIndianNumber($totals['SBIOutstanding']) ?></th> <!-- Corrected Total -->
    </tr>
</tfoot>
                </table>
            </div>
        </div>
    </div>
</div>



    
          </main>

         
         
      