<main class="page-content">
    <!--breadcrumb-->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"><?= $title ?></div>
    </div>
    <!--end breadcrumb-->
    <div class="row">
        <div class="col-xl-12 mx-auto">
            <div class="card">
                <div class="card-body">
                    <form id="forms" method="post" action="<?= base_url('admin/submit_tds_certificate') ?>" enctype="multipart/form-data">
                        <input type="hidden" name="id" value="<?= (isset($tds)) ? $tds->id : '' ?>">
                        <div id="form-rows">
                            <div class="row form-row">
                                
                        <?php if (isset($tds_files) && !empty($tds_files)) { ?>
                            <!-- Display Existing Uploaded Files -->
                            <div class="mb-3">
                                <h5>Uploaded Files for Partner</h5>
                                <ul>
                                    <?php foreach ($tds_files as $file) { ?>
                                        <li>
                                            <a href="<?= base_url('assets/uploads/tds/' . $file['tds_file']) ?>" target="_blank">
                                                View TDS - <?= $file['quarter'] ?>
                                            </a>
                                            <span>(Uploaded on: <?= date('d M Y', strtotime($file['add_date'])) ?>)</span>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </div>
                        <?php } ?>
                        
                                <?php if ($_SESSION['staff_type']=='0') { ?>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label">Partner <span style="color:red">*</span></label>
                                    <select name="connector_id[]" class="form-control" required>
                                        <option value="">-Select-</option>
                                        <?php  foreach ($connector as  $value) { ?>
                                            <option value="<?= $value['staff_id']; ?>" <?php if(@$value['staff_id']==@$tds->connector_id) echo 'selected';?>><?=$value['staff_fullname'];?></option>
                                        <?php } ?>
                                    </select>
                                    <span class="error"></span>
                                </div>
                                <?php } ?>
                               <!-- <div class="mb-3 col-md-3">
                                    <label class="form-label">Month</label>
                                    <input type="month" class="form-control inputs" name="month[]" value="<?= (isset($tds)) ? $tds->month : '' ?>" required>
                                    <span class="error"></span>
                                </div>-->
                                <div class="col-md-3 mb-3">
                                    <label class="form-label">Quarter <span style="color:red">*</span></label>
                                    <select name="quarter[]" class="form-control" required>
                                        <option value="">-Select-</option>
                                            <option value="Quarter 1" <?php if(@$tds->quarter == "Quarter 1") echo 'selected'; ?>>Quarter 1</option>
                                            <option value="Quarter 2" <?php if(@$tds->quarter == "Quarter 2") echo 'selected'; ?>>Quarter 2</option>
                                            <option value="Quarter 3" <?php if(@$tds->quarter == "Quarter 3") echo 'selected'; ?>>Quarter 3</option>
                                            <option value="Quarter 4" <?php if(@$tds->quarter == "Quarter 4") echo 'selected'; ?>>Quarter 4</option>

                                       
                                    </select>
                                    <span class="error"></span>
                                </div>
                                <div class="mb-3 col-md-3">
                                    <label class="form-label">TDS Certificate</label>
                                    <input type="file" class="form-control inputs" name="tds_file[]" accept=".jpg,.png,.jpeg,.pdf" <?php if (empty($tds)){ echo 'required'; } ?>>
                                    <span class="error"></span>
                                    <?php if (isset($tds) && $tds->tds_file != '') { ?>
                                        <a href="<?= base_url() . 'assets/uploads/tds/' . $tds->tds_file ?>" target="_blank" class="btn btn-primary">View TDS</a>
                                    <?php } ?>
                                </div>
                                
                                
                                <?php if (empty($tds)){ ?>
                                <div class="mb-3 col-md-3">
                                    <br>
                                    <button type="button" class="btn btn-danger remove-row">Remove</button>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                        <?php if (empty($tds)){ ?>
                            <div class="mb-3">
                                <button type="button" class="btn btn-info" id="add-row">Add Row</button>
                            </div>
                        <?php } ?>
                        <div class="mb-3">
                            <button type="button" class="btn btn-primary px-5 radius-30" onclick="go_back()">Back</button>
                            <input type="submit" class="btn btn-primary px-5 radius-30" id="btnSubmit" value="Submit">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</main>

<script>
   $(document).ready(function() {
    $('#add-row').click(function() {
        var newRow = `
        <div class="row form-row">
            <?php if ($_SESSION['staff_type'] == '0') { ?>
            <div class="col-md-3 mb-3">
                <label class="form-label">Partner <span style="color:red">*</span></label>
                <select name="connector_id[]" class="form-control" required>
                    <option value="">-Select-</option>
                    <?php foreach ($connector as $value) { ?>
                        <option value="<?= $value['staff_id']; ?>"><?= $value['staff_fullname']; ?></option>
                    <?php } ?>
                </select>
                <span class="error"></span>
            </div>
            <?php } ?>
           
            <div class="col-md-3 mb-3">
                <label class="form-label">Quarter <span style="color:red">*</span></label>
                <select name="quarter[]" class="form-control" required>
                    <option value="">-Select-</option>
                    <option value="Quarter 1">Quarter 1</option>
                    <option value="Quarter 2">Quarter 2</option>
                    <option value="Quarter 3">Quarter 3</option>
                    <option value="Quarter 4">Quarter 4</option>
                </select>
                <span class="error"></span>
            </div>
            <div class="mb-3 col-md-3">
                <label class="form-label">TDS Certificate</label>
                <input type="file" class="form-control inputs" name="tds_file[]" accept=".jpg,.png,.jpeg,.pdf" required>
                <span class="error"></span>
            </div>
            <div class="mb-3 col-md-3">
                <br>
                <button type="button" class="btn btn-danger remove-row">Remove</button>
            </div>
        </div>`;
        $('#form-rows').append(newRow);
    });

    $(document).on('click', '.remove-row', function() {
        $(this).closest('.form-row').remove();
    });
});

</script>