<main class="page-content">
    <!--breadcrumb-->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"><?= $title ?></div>
    </div>
    <!--end breadcrumb-->
    <div class="row">
        <div class="col-xl-12 mx-auto">
            <div class="card">
                <div class="card-body">
                    <form id="forms" method="post" action="<?= base_url('admin/submit_pending_rr') ?>">
                        <div class="row">
                           <div class="mb-3 col-md-3">
                                <label class="form-label">Los Id / RLMS <span style="color:red">*</span></label>
                                <input 
                                    type="text" 
                                    class="form-control inputs" 
                                    placeholder="Los Id / RLMS" 
                                    name="los_id" 
                                    required
                                    inputmode="numeric"
                                    maxlength="15"
                                    pattern="^\d{14,15}$"
                                    oninvalid="this.setCustomValidity('Los Id / RLMS must be 14 or 15 digits only')"
                                    onchange="this.setCustomValidity('')"
                                >
                                <span class="error"></span>
                            </div>

                            
                             <script>
                                document.getElementById("los_id").addEventListener("input", function() {
                                    // allow only digits
                                    this.value = this.value.replace(/\D/g, '');
                                    // enforce max length
                                    if (this.value.length > 15) {
                                        this.value = this.value.slice(0, 15);
                                    }
                                
                                    if (this.value.length > 0 && this.value.length < 15) {
                                        this.setCustomValidity("Los Id / RLMS must be exactly 15 digits");
                                        document.getElementById("los-error").textContent = "Must be 15 digits";
                                    } else {
                                        this.setCustomValidity("");
                                        document.getElementById("los-error").textContent = "";
                                    }
                                });
                            </script>
                            <div class="mb-3 col-md-3">
                                <label class="form-label">Applicant Name <span style="color:red">*</span></label>
                                <input type="text" class="form-control inputs" placeholder="" 
                                        name="user_name" readonly>
                                <span class="error"></span>
                            </div>
                            <input type="hidden" name="rinnraksha_status" value="Yes">
                            <div id="rinnraksha_amt_div" class="col-md-3 mb-3">
                                <label class="form-label">RinnRaksha Premium Amt <span style="color:red">*</span></label>
                                <input type="number" name="rinnraksha_amt" id="rinnraksha_amt" class="form-control" required>
                                <span class="error"></span>
                            </div>
                            <div id="rinnraksha_cbs_div" class="col-md-3 mb-3">
                                <label class="form-label">RinnRaksha CBS Acct. No <span style="color:red">*</span></label>
                                <input 
                                type="text" 
                                name="rr_cbs_acct_no" 
                                id="rr_cbs_acct_no" 
                                class="form-control" 
                                required 
                                inputmode="numeric"
                                autocomplete="off"
                                maxlength="11"
                                pattern="^[1-9][0-9]{10}$"
                                oninvalid="this.setCustomValidity('RinnRaksha CBS Account No. must be exactly 11 digits and cannot start with 0')"
                                onchange="this.setCustomValidity('')">
                                <span class="error"></span>
                            </div>
                            
                            <script>
                                function attachCbsValidator(inputId, errorSpanId, label) {
                                  const input = document.getElementById(inputId);
                                  const errEl = document.getElementById(errorSpanId);
                                
                                  if (!input) return;
                                
                                  // sanitize & validate while typing
                                  input.addEventListener('input', function () {
                                    // keep digits only
                                    let v = this.value.replace(/\D/g, '');
                                
                                    // enforce max length (works even if some browsers ignore maxlength)
                                    if (v.length > 11) v = v.slice(0, 11);
                                
                                    this.value = v;
                                
                                    // set messages
                                    if (v.startsWith('0')) {
                                      this.setCustomValidity(`${label} cannot start with 0`);
                                      if (errEl) errEl.textContent = `${label} cannot start with 0`;
                                    } else if (v.length > 0 && v.length < 11) {
                                      this.setCustomValidity(`${label} must be exactly 11 digits`);
                                      if (errEl) errEl.textContent = `${label} must be exactly 11 digits`;
                                    } else if (v.length === 11) {
                                      this.setCustomValidity('');
                                      if (errEl) errEl.textContent = '';
                                    } else {
                                      // empty while typing
                                      this.setCustomValidity('');
                                      if (errEl) errEl.textContent = '';
                                    }
                                  });
                                
                                  // on blur, show message immediately if invalid
                                  input.addEventListener('blur', function () {
                                    if (!this.checkValidity()) this.reportValidity();
                                  });
                                }
                                
                                // attach to both fields
                                attachCbsValidator('bank_acct_no', 'bank-acct-error', 'CBS Account No.');
                                attachCbsValidator('rr_cbs_acct_no', 'rr-account-error', 'RinnRaksha CBS Account No.');
                                </script>
                                                            
                            <?php $financialYear = $this->session->userdata('financial_year'); ?>
                        <div class="mb-3 col-md-3">
                            <label class="form-label">Disb Date <span style="color:red">*</span></label>
                            <input type="date" class="form-control inputs" placeholder="Disb Date" required
                                name="disb_date"
                                id="disb_date"
                                max="<?= date('Y-m-d') ?>">
                            <span class="error text-danger" id="disb_date_error"></span>
                        </div>
                        
                        <!-- Pass PHP session value to JS -->
                        <script>
                            const sessionFinancialYear = "<?= $financialYear ?>";
                        
                            document.getElementById('disb_date').addEventListener('change', function () {
                                const selectedDate = new Date(this.value);
                                const errorSpan = document.getElementById('disb_date_error');
                        
                                let cutoffDate;
                                let errorMessage = '';
                        
                                if (sessionFinancialYear === "24-25") {
                                    cutoffDate = new Date('2025-04-01');
                                    if (selectedDate >= cutoffDate) {
                                        errorMessage = "Please login by Fin. Year 25-26.";
                                    }
                                } else if (sessionFinancialYear === "25-26") {
                                    cutoffDate = new Date('2025-04-01');
                                    if (selectedDate < cutoffDate) {
                                        errorMessage = "Please login by Fin. Year 24-25.";
                                    }
                                }
                        
                                if (errorMessage) {
                                    errorSpan.textContent = errorMessage;
                                    this.value = '';
                                } else {
                                    errorSpan.textContent = '';
                                }
                            });
                        </script>
                            <!--<div class="mb-3 col-md-3">
                                <label class="form-label">Disb Date <span style="color:red">*</span></label>
                                <input type="date" class="form-control inputs" placeholder="Disb Date" required
                                    name="disb_date" max="<?= date('Y-m-d') ?>">
                                <span class="error"></span>
                            </div>-->
                            
                            <div class="mb-3 col-md-3">
                                <label class="form-label">Proof Of Disbursement</label>
                                <input type="file" class="form-control inputs" name="proof_disb" accept=".jpg,.png,.jpeg,.pdf" required> 
                                <span class="error"></span>
                           </div>
                        
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Status <span style="color:red">*</span></label>
                                <div>
                                    <select name="status" class="form-control" required>
                                        <option value="">-Select-</option>
                                        <!--<option value="Login Case">Login Case</option>-->
                                      <!--  <option value="Sanction">Sanction</option>-->
                                        <option value="Disb Case" selected>Disb Case</option>
                                       <!-- <option value="Reject">Reject</option>-->
                                    </select>
                                </div>
                            </div>
                            <div class="mb-3">
                                <button type="button" class="btn btn-back px-5 radius-30" onclick="go_back()">Back</button>
                                <input type="submit" class="btn btn-primary px-5 radius-30" id="btnSubmit" value="Submit">
                            </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
</div>
<!--end row-->
</main>



<script type="text/javascript">
$(document).ready(function(){
    $('input[name="los_id"]').on('change', function(){
        var los_id = $(this).val();
        if(los_id){
            $.ajax({
                url: '<?= base_url("admin/get_details_applicant") ?>',
                type: 'POST',
                data: {los_id: los_id},
                dataType: 'json',
                success: function(response){
                    if(response.error){
                        alert(response.error);
                        $('input[name="user_name"]').val('');
                        $('input[name="los_id"]').val('');
                    } else if(response.user_name){
                        $('input[name="user_name"]').val(response.user_name);
                    } else {
                        $('input[name="user_name"]').val('');
                        $('input[name="los_id"]').val('');
                        alert('No details found for this LOS ID.');
                        
                    }
                }
            });
        } else {
            $('input[name="user_name"]').val('');
        }
    });
    
     $('input[name="rr_cbs_acct_no"]').on('change', function(){
        var rr_cbs_acct_no = $(this).val();
        if(rr_cbs_acct_no){
            $.ajax({
                url: '<?= base_url("admin/check_duplicate_rr_cbs_acct_no") ?>',
                type: 'POST',
                data: {rr_cbs_acct_no: rr_cbs_acct_no},
                dataType: 'json',
                success: function(response){
                    if(response.error){
                        alert(response.error);
                        $('input[name="rr_cbs_acct_no"]').val('');
                    }
                }
            });
        }
    });
    
});
</script>
