<?php

function getIndianCurrency(float $amount) {
    $amount_after_decimal = round($amount - ($num = floor($amount)), 2) * 100;

    // Check if there is any number after decimal
    $amt_hundred = null;
    $count_length = strlen($num);
    $x = 0;
    $string = array();
    $change_words = array(
        0 => 'Zero', 1 => 'One', 2 => 'Two',
        3 => 'Three', 4 => 'Four', 5 => 'Five', 6 => 'Six',
        7 => 'Seven', 8 => 'Eight', 9 => 'Nine',
        10 => 'Ten', 11 => 'Eleven', 12 => 'Twelve',
        13 => 'Thirteen', 14 => 'Fourteen', 15 => 'Fifteen',
        16 => 'Sixteen', 17 => 'Seventeen', 18 => 'Eighteen',
        19 => 'Nineteen', 20 => 'Twenty', 30 => 'Thirty',
        40 => 'Fourty', 50 => 'Fifty', 60 => 'Sixty',
        70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety'
    );
    $here_digits = array('', 'Hundred', 'Thousand', 'Lakh', 'Crore');
    while ($x < $count_length) {
        $get_divider = ($x == 2) ? 10 : 100;
        $amount = floor($num % $get_divider);
        $num = floor($num / $get_divider);
        $x += $get_divider == 10 ? 1 : 2;
        if ($amount) {
            $add_plural = (($counter = count($string)) && $amount > 9) ? 's' : null;
            $amt_hundred = ($counter == 1 && $string[0]) ? ' and ' : null;
            $string[] = ($amount < 21) ? $change_words[$amount] . ' ' . $here_digits[$counter] . $add_plural . '
       ' . $amt_hundred : $change_words[floor($amount / 10) * 10] . ' ' . $change_words[$amount % 10] . '
       ' . $here_digits[$counter] . $add_plural . ' ' . $amt_hundred;
        } else $string[] = null;
    }
    $implode_to_Rupees = implode('', array_reverse($string));
    $get_paise = ($amount_after_decimal > 0) ? "And " . ($change_words[intval($amount_after_decimal / 10)] . "
   " . $change_words[$amount_after_decimal % 10]) . ' Paise' : '';
    return ($implode_to_Rupees ? $implode_to_Rupees . ' Rupees ' : '') . $get_paise;
}


function formatIndianNumber($number) {
  // Round up the number to two decimal places
    $rounded_number = round($number, 2);

    // Convert the rounded number to string
    $number_str = strval($rounded_number);

    // Split the number into integral and fractional parts
    $parts = explode('.', $number_str);

    // Format the integral part
    $integral_part = $parts[0];
    $formatted_integral = '';

    // Format the integral part with commas after every two digits if the number has six or more digits
    $len = strlen($integral_part);
    $i = $len - 1;
    $count = 0;
    while ($i >= 0) {
        $formatted_integral = $integral_part[$i] . $formatted_integral;
        $count++;
        if (($count == 3 || $count == 5 || $count == 7) && $i != 0) {
            $formatted_integral = ',' . $formatted_integral;
        }
        $i--;
    }

    // Format the fractional part
    $formatted_fractional = isset($parts[1]) ? '.' . str_pad($parts[1], 2, '0') : '.00';

    // Combine the formatted integral part with the formatted fractional part
    $formatted_number = $formatted_integral . $formatted_fractional;

    return $formatted_number;
}


/*function formatIndianNumber($number) {
    // Convert number to string
    $number_str = strval($number);

    // Split the number into integral and fractional parts
    $parts = explode('.', $number_str);

    // Format the integral part
    $integral_part = $parts[0];
    $formatted_integral = '';

    // Format the integral part with commas after every three digits then every two digits
    $len = strlen($integral_part);
    $i = $len - 1;
    $count = 0;
    while ($i >= 0) {
        $formatted_integral = $integral_part[$i] . $formatted_integral;
        $count++;
        if ($count == 2 && $i != 0) {
            $formatted_integral = ',' . $formatted_integral;
            $count = 0;
        }
        if ($count == 3 && $i != 0) {
            $formatted_integral = ',' . $formatted_integral;
            $count = 0;
        }
        $i--;
    }

    // Check if the fractional part is .00 and remove it if true
    $formatted_fractional = (isset($parts[1]) && $parts[1] !== '00') ? '.' . $parts[1] : '';

    // Combine the formatted integral part with the fractional part (if exists and not .00)
    $formatted_number = $formatted_integral . $formatted_fractional;

    return $formatted_number;
}
*/
?>

       <!--start content-->
          <main class="page-content">            
          <div class="card border shadow-none">
          <div class="card-header py-3">
                  <div class="row g-3">                   
                    <div class="col-12 col-lg-12 text-md-end">
                        <?php if($invoice_type=='inv_hlc'){?>
                        <h1>Invoice for HLC</h1>
                        <?php }else{ ?>
                         <h1>Invoice for SBI</h1>
                         <?php } ?>
                      <a href="<?php echo base_url() ?>admin/manage_invoice" class="btn btn-sm btn-info me-2"><i class="bi bi-arrow-return-left"></i> Back</a> 
                      <a href="<?= base_url("Invoice_pdf_hlc/generatePDF/$invoice_batchno") ?>" target="_BLANK" class="btn btn-sm btn-danger me-2"><i class="bi bi-file-earmark-pdf-fill"></i> Export as PDF</a>
                      <a href="javascript:;" onclick="printInvoice()" class="btn btn-sm btn-secondary"><i class="bi bi-printer-fill"></i> Print</a>
                    </div>
                  </div>
             </div>
             <div id="invoice">
            <div class="card-header py-3" style="background:#D9E1F2;">
                  <div class="row align-items-center g-3">
                       <?php if($invoice_type=='inv_hlc'){?>
                         <div class="col-12 col-lg-12 text-center">
                        <!--  <h5 class="mb-0"><img src="<?php echo base_url() ?>assets/site_img/morgage_buddy_logo.jpeg" class="img-fluid" width="200"> </h5>-->
                        <h3> TAX INVOICE</h3>
                        </div>   
                       <?php } ?>
                  </div>
             </div>
        
             <div class="card-header py-2 bg-light">
               <div class="row row-cols-1 row-cols-lg-3" style="font-size: 11px !important;">
                 <?php if($invoice_type=='inv_hlc'){?>
                 <div class="col-4">
                  <div class="">
                    <small>From</small>
                    <address class="m-t-5 m-b-5">
                       <strong class="text-inverse">Name: <?= $connector->staff_fullname; ?></strong><br>
                       <strong>Address:</strong><?= $connector->staff_address; ?> <?= $connector->pincode; ?><br>
                        <strong>PAN No.:</strong><?= $connector->pan_no; ?>  <br>     
                       <strong>GSTIN No.:</strong><?= $connector->gst_no; ?> <br> 
                       <strong>Mobile No : </strong><?= $connector->mobile; ?><br>
                      <!-- <strong>Account No. of HLC :</strong><?= $connector->bank_acct_no; ?><br>
                       <strong>IFSC code:</strong><?= $connector->bank_ifsc; ?><br>-->
                           
                       <strong>E-mail ID :</strong><?= $connector->email; ?><br>
                    </address>
                   </div>
                 </div>
                 <div class="col-4">
                  <div class="">
                    <small>To</small>
                    <address class="m-t-5 m-b-5">
                       <strong class="text-inverse">MORTGAGEBUDDY PRIVATE LIMITED</strong><br>
                       <strong>GSTIN NO:</strong> -27AAQCM2355K1ZZ<br>
                       <strong>HSN Code: </strong><br>
                       <!--<strong>Date:</strong><?= date('d/m/Y',strtotime($invoice_date))?><br>-->
                    </address>
                   </div>
                </div>
                <?php } ?>
           
                
                <div class="col-4">
                  <div class="">
                    <div class=""><b><?= date('F d,Y',strtotime($invoice_date))?></b></div>
                    <div class="invoice-detail">
                       <strong>Invoice No:</strong> #<?= $invoice_num; ?><br>                      
                    </div>
                  </div>
                </div>
               </div>
             </div>
            <div class="card-body">
              <div class="">
                  <style>
                      .table-bordered {
                        border-collapse: collapse;
                        border: 1px solid black; /* Border color */
                    }
                    
                    .table-bordered th,
                    .table-bordered td {
                        border: 1px solid black; /* Border color */
                        padding: 8px; /* Adjust padding as needed */
                    }
                  </style>
                <table class="table table-invoice table-bordered" style="font-size:11px !important;">
                   <thead style="background: #d9e1f2;">
                      <tr>
                         <th width="5%">Sr. No</th>
                         <th width="5%">Los ID</th>
                         <th width="10%">Name Of Customer</th>
                         <th class="text-center" width="5%">Loan Type</th>
                         <th class="text-center" width="6%">Branch Name</th>
                         <th class="text-right" width="8%">CBS A/C No</th>
                         <th class="text-right" width="8%">Disburs Date</th>
                         <th class="text-right" width="9%">Sanctioned <br>Loan Amount</th>
                         <th class="text-right" width="5%">Commision<br> %</th>
                         <th class="text-right" width="9%">Commision <br> Amount Rs</th>
                        
                      </tr>
                   </thead>
                   <tbody>
                   <?php
                     if (!empty($invoice_items)) {
                        $totalLoanAmt = 0;
                        $totalCommisionAmt = 0;
                        
                        foreach ($invoice_items as $key => $row) { 
                           $user_data = $this->db->select("*")->from('mst_user')->where(['id' =>$row['user_id']])->get()->row();
                           $type_data = $this->db->select("*")->from('mst_loan_type')->where(['id' =>$user_data->loan_type_id])->get()->row();
                           $totalLoanAmt += $row['loan_amt'];
                           $totalCommisionAmt += $row['total_commission'];
                           
                            $mbgstcode = 13;
                           if($mbgstcode==$connector->circle_id){
                            $cgst = empty($connector->gst_no) ? 0 : (9/100*$totalCommisionAmt);
                            $sgst = empty($connector->gst_no) ? 0 : (9/100*$totalCommisionAmt);
                           }else{
                            $igst = empty($connector->gst_no) ? 0 : (18/100*$totalCommisionAmt);
                          }
                        
                           $rr_aact = $this->db->select("*")->where(['applicant_rr_id' => $row['user_id'], 'rinnraksha_status' => 'Yes'])->from('mst_user')->get()->row();
                           ?>
                      <tr>
                         <td>                           
                         <?= $key + 1 ?>
                         </td>
                         <td class="text-right"><?= $user_data->los_id; ?></td>
                         <td class="text-right"> <?= $user_data->user_name; ?>
                         
                        </td>                         
                         <td>
                            <?= $type_data->name; ?>
                         </td>
                         <td>
                            <?= $branch->branch_name; ?>[<?= $branch->branch_code; ?>]
                         </td>
                         <td>
                             <?php if($row['loan_type_id']==5){ ?>
                              <span class="text-inverse"><?= $user_data->rr_cbs_acct_no; ?></span>
                              <?php } else{ ?>
                              <span class="text-inverse"><?= $user_data->bank_acct_no; ?></span>
                              <?php } ?>
                         </td>
                         <td>
                            <span class="text-inverse"><?= date('d.m.Y',strtotime($user_data->disb_date)); ?></span>
                         </td>
                         <td>
                            <span class="text-inverse"><?= formatIndianNumber($row['loan_amt']); ?></span>
                         </td>                        
                                            
                         <td>
                            <span class="text-inverse"><?= $user_data->part_payout; ?>%</span>
                         </td>
                        <?php
                        if ($user_data->rinnraksha_status == 'Yes' && empty($user_data->applicant_rr_id)) { 
                            $premiumAmt = $user_data->rinnraksha_amt;
                            $premiumCommission = $premiumAmt * $user_data->part_payout /100;
                            // Output the commission
                            echo '<td><span class="text-inverse">' . formatIndianNumber($premiumCommission) . '</span></td>';
                        } else {
                            // If condition fails, default to total commission
                            echo '<td><span class="text-inverse">' .  formatIndianNumber($row['total_commission']) . '</span></td>';
                        }
                        ?>
                    <?php if($row['loan_type_id']==5){ ?>
                       <tr>
                           
                           <td></td>
                           <td><?= $user_data->los_id; ?></td>
                           <td><?= $user_data->user_name; ?></td>
                           <td style="text-align:left;">RR Commission</td>
                           <td></td>
                           <td></td> 
                           <td></td>
                           <td></td>
                           <td></td>
                           <?php
                                    if ($user_data->rinnraksha_status == 'Yes' && empty($user_data->applicant_rr_id)) { 
                                        // Calculate commission based on different conditions
                                        @$rr_sanction_amt = $this->db->select("*")->where(['id' => $rr_aact->id])->from('mst_user')->get()->row();
                                        $sanctionAmt = @$rr_sanction_amt->sanction_amt;
                                        $premiumAmt = $user_data->rinnraksha_amt;
                                    //    $premiumCommission = $premiumAmt * $connector->conn_commision/100;
                                        $premiumCommission = $premiumAmt * $user_data->part_payout/100;
                                        
                                        if ($sanctionAmt >= 100000 && $sanctionAmt < 5000000) {
                                            $commission = 4000;
                                        } elseif ($sanctionAmt >= 5000000 && $sanctionAmt < 10000000) {
                                            $commission = 5000;
                                        } elseif ($sanctionAmt >= 10000000) {
                                            $commission = 6000;
                                        } else {
                                            $commission = 0;
                                        }
                                        // Output the commission
                                        echo '<td><span class="text-inverse">' . formatIndianNumber($commission) . '</span></td>';
                                    } else {
                                        // If condition fails, default to total commission
                                        echo '<td><span class="text-inverse total-commision">' .  formatIndianNumber($row['total_commission']) . '</span></td>';
                                    }
                                    ?>
                           
                     </tr>
                     <?php } ?> 
                      </tr>
                   <?php  }

                  } ?>   
                  
                 
                 
                     <tr>
                         <td></td>
                           <td></td>
                           <td></td>
                           <td></td>
                           <td></td>
                           <td></td>
                           <td></td>
                           <td></td>
                           <td>-</td>
                           <td>-</td>
                     </tr>
                     <tr>
                           <td></td>
                           <td></td>
                           <td colspan="5" style="text-align:right;"><b>Sub Total</b></strong></td>
                           <td><strong><?= formatIndianNumber($totalLoanAmt); ?></strong></td> 
                           <td></td>
                           <td class="text-right"><strong><?= formatIndianNumber($totalCommisionAmt); ?></strong></td>
                     </tr>
                     <tr>
                         <td></td>
                           <td></td>
                           <td colspan="5" style="text-align:right;"><b>Tax Amount - CGST 9%</b></strong></td>
                            <td class="text-right"></td>
                            <td class="text-right">-</td>
                            
                           <td class="text-right"><?php if(empty($cgst)){ echo '-'; }else{ echo formatIndianNumber($cgst); } ?></td>
                     </tr>
                      <tr>
                          <td></td>
                           <td></td>
                           <td colspan="5" style="text-align:right;"><b>Tax Amount - SGST 9%</b></strong></td>
                           <td></td> 
                           <td>-</td>
                          
                           <td class="text-right"><?php if(empty($sgst)){ echo '-'; }else{ echo formatIndianNumber($sgst); } ?></td>
                     </tr>
                     <tr>
                           <td></td>
                           <td></td>
                           <td colspan="5" style="text-align:right;"><b>Tax Amount - IGST 18%</b></strong></td>
                           <td></td> 
                           <td><?php if(empty($igst)){ echo '-'; } ?></td>
                           <td class="text-right"><?php if(empty($igst)){ echo '-'; }else{ echo formatIndianNumber($igst); } ?></td>
                     </tr>
                     <tr>  
                            <td></td>
                           <td></td>
                           <td colspan="5" style="text-align:right;"><b>Gross Total</b></strong></td>
                           <td></td> 
                           <td></td>
                           <?php 
                                $gstPercentage = empty($connector->gst_no) ? 0 : 18; // Check if GST number is empty
                                $gst = $gstPercentage / 100 * $totalCommisionAmt;
                                 ?>
                           <?php $netPayamt = $totalCommisionAmt + $gst; ?>
                           <td><strong><?= formatIndianNumber($netPayamt); ?></strong></td>
                     </tr>
                     <tr>
                           <td></td>
                           <td></td>
                           <td colspan="5" style="text-align:right;"><b>Less: TDS @ 5%</b></strong></td>
                           <td></td> 
                           <td></td>
                           <?php 
                               $tds = $totalCommisionAmt*5/100;
                                 ?>
                          
                           <td><strong><?= formatIndianNumber($tds); ?></strong></td>
                     </tr>
                     <tr>
                          <td></td>
                           <td></td>
                           <td colspan="5" style="text-align:right;"><b>Net Total</b></strong></td>
                           <td></td> 
                           <td></td>
                           <?php 
                                $gstPercentage = empty($connector->gst_no) ? 0 : 18; // Check if GST number is empty
                                $gst = $gstPercentage / 100 * $totalCommisionAmt;
                                 ?>
                           <?php $netPayamt = $totalCommisionAmt + $gst - $tds; ?>
                          
                           <td><strong><?= formatIndianNumber($netPayamt); ?></strong></td>
                     </tr>
                    
                   </tbody>
                </table>
                <p>I confrim that above housing proposal has been disbursed from mentioned branch on MortgageBuddy Private Limited HLC code(MUMHLC03147).</p>
             </div>

              <div class="row  align-items-center mt-5">
               <div class="col-7 col-auto p-4">
                  <?php $amountInWords = getIndianCurrency($netPayamt) ?>
                  <p class="mb-0"><strong><?= "Rs.(In words): " . ucfirst($amountInWords) . " only" ?></strong></p>
                  
               </div>
              
               <div class="col-2 col-auto p-4">
                  
               </div>
               
               <div class="col-3 col-auto p-4">
                   <!--<img src="<?php echo base_url() ?>assets/site_img/authority_signature.jpeg" width="150">-->
                 <p class="mb-0">Signature</p>
                 
               </div>
             </div><!--end row-->
             <div class="row">
             <div class="col-6 col-auto p-4">
                       
                       <strong>Type of Account :</strong><?= $connector->bank_acct_type; ?><br>
                       <strong>Account No. :</strong><?= $connector->bank_acct_no; ?><br>
                       <strong>IFSC code:</strong><?= $connector->bank_ifsc; ?><br>
                      
                    </div>
             </div>
             
             </div>

     

           

            <div class="card-footer py-3" style="background:#D9E1F2">
                <p class="text-center mb-2">
                   THANK YOU !
                </p>
                <!--<p class="text-center d-flex align-items-center gap-3 justify-content-center mb-0">
                   <span class=""><i class="bi bi-globe"></i> www.mortgagaebuddy.in</span>
                   <span class=""><i class="bi bi-telephone-fill"></i> T:+91-096099 39393</span>
                   <span class=""><i class="bi bi-envelope-fill"></i> admin@mortgagaebuddy.in</span>
                </p>-->
            </div>
            
             </div>
             
           </div>

            </div>
          </main>
       <!--end page main-->



  </div>
  <!--end wrapper-->
 

  <script defer>
  function printInvoice() {
    var printContent = document.getElementById('invoice').outerHTML;
    var printWindow = window.open('', '_blank');
    
    // Include Bootstrap CSS
    printWindow.document.write('<link href="https://www.mortgagebuddy.in/online/admin_assets/css/bootstrap.min.css" rel="stylesheet">');
    printWindow.document.write('<link href="https://www.mortgagebuddy.in/online/admin_assets/css/bootstrap-extended.css" rel="stylesheet">');
    printWindow.document.write('<link href="https://www.mortgagebuddy.in/online/admin_assets/css/style.css" rel="stylesheet">');
    printWindow.document.write('<link href="https://www.mortgagebuddy.in/online/admin_assets/css/invoice_style.css" rel="stylesheet">');
  
   
    printWindow.document.write('<html><head><title>Invoice</title></head><body>');
    printWindow.document.write(printContent);
    printWindow.document.write('</body></html>');
  
    printWindow.document.close();
    printWindow.print();
    printWindow.onafterprint = function() {
      printWindow.close();
    };
  }
</script>
<!-- Add these script tags in the head section -->
<style>
   .table-invoice th{
    font-size: 13px !important;
 }
 
 table {
      width: 100%;
      max-width: 100%;     
      }
      th, td {
          border: 1px solid black;
         
      }
 
 
</style>


