<main class="page-content">
    <!--breadcrumb-->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"><?= $title ?></div>
    </div>
    <!--end breadcrumb-->
    <div class="row">
        <div class="col-xl-12 mx-auto">
            <div class="card">
                <div class="card-body">
                    <form id="forms" method="post" action="<?= base_url('admin/submit_split_partners') ?>">
                        <input type="hidden" name="e_id" value="<?= (isset($SplitPartners)) ? $SplitPartners->id : '' ?>">
                        <div class="row">
                       
                            <div class="mb-3 col-md-3">
                                <label class="form-label">Full Name <span style="color:red">*</span></label>
                                <input type="text" class="form-control inputs" placeholder="Name" 
                                       name="e_fullname" required value="<?= (isset($SplitPartners)) ? $SplitPartners->staff_fullname : '' ?>">
                                <span class="error"></span>
                            </div>                            
                           
                            <div class="mb-3 col-md-3">
                                <label class="form-label">Mobile <span style="color:red">*</span></label>
                                <input type="tel" class="form-control inputs" placeholder="Mobile Number" 
                                       name="mobile" required pattern="[0-9]{10}" title="Please enter a 10-digit mobile number" value="<?= (isset($SplitPartners)) ? $SplitPartners->mobile : '' ?>">
                                <span class="error"></span>
                            </div>
                           <!-- <div class="mb-3 col-md-3">
                                <label class="form-label">Email <span style="color:red">*</span></label>
                                <input type="email" class="form-control inputs lowercase-email" placeholder="Email Id" 
                                       name="email" required value="<?= (isset($Connectors)) ? $Connectors->email : '' ?>">
                                <span class="error"></span>
                            </div>-->
                            <div class="mb-3 col-md-3">
                                <label class="form-label">Date of Birth</label>
                                <input type="date" class="form-control inputs" placeholder="Date of birth" required
                                       id="dob" name="dob" max="" value="<?= (isset($SplitPartners)) ? $SplitPartners->dob : '' ?>">
                                <span class="error" id="dob-error" style="color: red;"></span>
                            </div>
                            <div class="mb-3 col-md-4">
                                <label class="form-label">Address</label>
                                <textarea type="text" class="form-control inputs" placeholder="Address" 
                                          name="e_address"><?= (isset($SplitPartners)) ? $SplitPartners->staff_address : '' ?></textarea>
                                <span class="error"></span>
                            </div>
                            <div class="mb-3 col-md-3">
                                <label class="form-label">Pincode</label>
                                <input type="number" class="form-control inputs" placeholder="Pincode" 
                                       name="pincode" required value="<?= (isset($SplitPartners)) ? $SplitPartners->pincode : '' ?>" required>
                                <span class="error"></span>
                                <span class="error" id="pincodeError"></span>
                            </div>
                            <!--
                             <div class="col-md-3 mb-3">
                                    <?php if (isset($Connectors)) { ?>
                                        <input type="hidden" class="circleSelect" name="circle_id" value="<?= $Connectors->circle_id ?>">
                                    <?php } else { ?>
                                        <label class="form-label">Circle</label>
                                        <select id="circleSelect" name="circle_id" class="form-control" required>
                                            <option value="">-Select-</option>
                                            <?php foreach($circle as $val) { ?>
                                                <option value="<?= $val['id']; ?>" data-ccode="<?= $val['c_code']; ?>" <?php if(@$Connectors->circle_id==$val['id']) echo 'selected';?>><?= $val['c_name']; ?>(<?= $val['c_code']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    <?php } ?>
                                    <span class="error"></span>
                                </div>-->
                            <!-- <div class="col-md-3 mb-3">
                            <label class="form-label">State <span style="color:red">*</span></label>
                            <select name="state_id" class="single-select stateSelect" id="stateSelect" required>
                                <option value="">-Select-</option>
                               <?php  foreach ($state as  $value) { ?>
                                   <option value="<?= $value['id']; ?>" <?php if(@$value['id']==@$Connectors->state_id) echo 'selected';?>><?=$value['state_name'];?></option>
                              <?php } ?>                           
                            </select>                               
                            <span class="error"></span>
                        </div>     
                            <div class="col-md-3 mb-3">
                                    <label class="form-label">City <span style="color:red">*</span></label>
                                    <select name="city_id" class="single-select" id="citySelect" required>
                                        <option value="">-Select-</option>
                                    </select>
                                    <span class="error"></span>
                            </div> -->
                           <!-- <div class="mb-3 col-md-3">
                                <label class="form-label">HLC Code <span style="color:red">*</span></label>
                                <input type="text" class="form-control inputs" placeholder="HLC Code" 
                                      id="hlc_code_input" name="hlc_code" required readonly value="<?= (isset($Connectors)) ? $Connectors->hlc_code : '' ?>">
                                <span class="error"></span>
                            </div>
                            
                            <div class="mb-3 col-md-3">
                                <label class="form-label">Password <span style="color:red">*</span></label>
                                <input type="password" class="form-control inputs" placeholder="Password" 
                                       name="e_password" required value="<?= (isset($Connectors)) ? $Connectors->staff_password : '' ?>">
                                <span class="error"></span>
                            </div>
                   -->
                          
                            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                                <div class="breadcrumb-title pe-3">Documents</div>
                            </div>
                            <hr>
                            <div class="mb-3 col-md-3">
                                    <label class="form-label">Photo <span style="color:red"> </span></label>
                                    <input type="file" class="form-control inputs" name="pass_photo" accept=".jpg,.png,.jpeg">  
                                    <span class='error'></span>
                                        <?php if (isset($SplitPartners) && $SplitPartners->pass_photo != '') { ?>
                                            <a href="<?= base_url() . 'assets/uploads/documents/' . $SplitPartners->pass_photo ?>" target="_blank">
                                               <img width="100" height="100" src="<?= base_url() . 'assets/uploads/documents/' . $SplitPartners->pass_photo ?>">
                                            </a>
                                        <?php } ?>
                                       
                            </div>
                            <div class="mb-3 col-md-3">
                                <label class="form-label">PAN Number <span style="color:red">*</span></label>
                                <input type="text" class="form-control inputs" placeholder="PAN No." 
                                required name="pan_no"  oninput="this.value = this.value.toUpperCase()" value="<?= (isset($SplitPartners)) ? $SplitPartners->pan_no : '' ?>">
                                <span class="error"></span>
                            </div>
                            <div class="mb-3 col-md-3">
                                <label class="form-label">PAN File</label>
                                <input type="file" class="form-control inputs" name="pan_file" accept=".jpg,.png,.jpeg,.pdf"> 
                                <span class="error"></span>
                                <?php if (isset($SplitPartners) && $SplitPartners->pan_file != '') { ?>
                                    <a href="<?= base_url() . 'assets/uploads/documents/' . $SplitPartners->pan_file ?>" target="_blank" class="btn btn-primary">
                                        View PAN File
                                    </a>
                                <?php } ?>
                            </div>

                            <div class="mb-3 col-md-3">
                                <label class="form-label">GST Number</label>
                                <input type="text" class="form-control inputs" placeholder="GST No." 
                                       name="gst_no"  value="<?= (isset($SplitPartners)) ? $SplitPartners->gst_no : '' ?>">
                                <span class="error"></span>
                            </div>
                           <div class="mb-3 col-md-3">
                                <label class="form-label">GST Certificate</label>
                                <input type="file" class="form-control inputs" name="gst_file" accept=".jpg,.png,.jpeg,.pdf"> 
                                <span class="error"></span>
                                <?php if (isset($SplitPartners) && $SplitPartners->gst_file != '') { ?>
                                    <a href="<?= base_url() . 'assets/uploads/documents/' . $SplitPartners->gst_file ?>" target="_blank" class="btn btn-sm btn-primary">
                                        View GST Certificate
                                    </a>
                                <?php } ?>
                            </div>

                           <div class="mb-3 col-md-3">
                                <label class="form-label">Aadhar File</label>
                                <input type="file" class="form-control inputs" name="adhar_file" accept=".jpg,.png,.jpeg,.pdf"> 
                                <span class="error"></span>
                                <?php if (isset($SplitPartners) && $SplitPartners->adhar_file != '') { ?>
                                    <a href="<?= base_url() . 'assets/uploads/documents/' . $SplitPartners->adhar_file ?>" target="_blank" class="btn btn-sm btn-primary">
                                        View Aadhar File
                                    </a>
                                <?php } ?>
                            </div>
                            <div class="mb-3 col-md-3">
                                <label class="form-label">Aadhar 2nd page</label>
                                <input type="file" class="form-control inputs" name="adhar_file_2" accept=".jpg,.png,.jpeg,.pdf"> 
                                <span class="error"></span>
                                <?php if (isset($SplitPartners) && $SplitPartners->adhar_file_2 != '') { ?>
                                    <a href="<?= base_url() . 'assets/uploads/documents/' . $SplitPartners->adhar_file_2 ?>" target="_blank" class="btn btn-sm btn-primary">
                                        View Aadhar File
                                    </a>
                                <?php } ?>
                            </div>
                            <div class="mb-3 col-md-3">
                                <label class="form-label">Agreement Copy</label>
                                <input type="file" class="form-control inputs" name="agreement_file" accept=".pdf,.jpg,.png,.jpeg"> 
                                <span class="error"></span>
                                <?php if (isset($SplitPartners) && $SplitPartners->agreement_file != '') { ?>
                                    <a href="<?= base_url() . 'assets/uploads/documents/' . $SplitPartners->agreement_file ?>" target="_blank" class="btn btn-sm btn-primary">
                                        View Agreement Copy
                                    </a>
                                <?php } ?>
                            </div>

                            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                                <div class="breadcrumb-title pe-3">Bank Details</div>
                            </div>
                            <hr>
                            <div class="mb-3 col-md-3">
                                <label class="form-label">Bank Name <span style="color:red">*</span></label>
                                <input type="text" class="form-control inputs" placeholder="Bank Name" 
                                required name="bank_name"  value="<?= (isset($SplitPartners)) ? $SplitPartners->bank_name : '' ?>">
                                <span class="error"></span>
                            </div>      
                            <div class="mb-3 col-md-3">
                                <label class="form-label">Bank IFSC <span style="color:red">*</span></label>
                                <input type="text" class="form-control inputs" placeholder="Bank IFSC" 
                                       name="bank_ifsc"  required value="<?= (isset($SplitPartners)) ? $SplitPartners->bank_ifsc : '' ?>">
                                <span class="error"></span>
                            </div>      
                            <div class="mb-3 col-md-3">
                                <label class="form-label">Bank Acct. No. <span style="color:red">*</span></label>
                                <input type="number" class="form-control inputs" placeholder="Account Number" 
                                       name="bank_acct_no"  required value="<?= (isset($SplitPartners)) ? $SplitPartners->bank_acct_no : '' ?>">
                                <span class="error"></span>
                            </div> 
                        <div class="col-md-3 mb-3">
                            <label class="form-label">Account Type <span style="color:red">*</span></label>
                            <select name="bank_acct_type" class="form-control" required>
                                <option value="">-Select-</option>                             
                                <option value="Saving" <?php if(@$SplitPartners->bank_acct_type=='Saving') echo 'selected';?>>Saving Ac</option>
                                <option value="Current" <?php if(@$SplitPartners->bank_acct_type=='Current') echo 'selected';?>>Current Ac</option>                                                       
                            </select>
                            <span class="error"></span>
                        </div> 
                           <div class="mb-3 col-md-3">
                            <label class="form-label">Cheque Details File</label>
                            <input type="file" class="form-control inputs" name="bank_details_file" accept=".jpg,.png,.jpeg,.pdf"> 
                            <span class="error"></span>
                            <?php if (isset($SplitPartners) && $SplitPartners->bank_details_file != '') { ?>
                                <a href="<?= base_url() . 'assets/uploads/documents/' . $SplitPartners->bank_details_file ?>" target="_blank" class="btn btn-sm btn-primary">
                                    View Cheque Details File
                                </a>
                            <?php } ?>
                        </div>
                        
                        <!--  <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                            <div class="breadcrumb-title pe-3">Incentive Commission %</div>
                        </div>
                        <hr>
                        
                        <div class="row">
                            <!-- Slab 1 -->
                         <!--   <div class="col-md-2">
                                <label class="form-label">Slab 1 Amt<span style="color:red">*</span></label>
                                <input type="number" class="form-control inputs" placeholder="Slab 1" 
                                       name="slab_one"  value="<?= (isset($Connectors) && is_numeric($Connectors->slab_one)) ? (fmod($Connectors->slab_one, 1) == 0 ? intval($Connectors->slab_one) : $Connectors->slab_one) : '' ?>">
                                <span class="error"></span>
                            </div>  
                            <div class="col-md-2">
                                <label class="form-label">Slab 1 Commi %<span style="color:red">*</span></label>
                                <input type="number" class="form-control inputs" placeholder="Slab 1 Commi" 
                                       name="slab_one_commi"  value="<?= (isset($Connectors)) ? $Connectors->slab_one_commi : '' ?>" step="0.01">
                                <span class="error"></span>
                            </div>  
                        
                            <!-- Slab 2 -->
                         <!--   <div class="col-md-2">
                                <label class="form-label">Slab 2 Amt<span style="color:red">*</span></label>
                                <input type="number" class="form-control inputs" placeholder="Slab 2" 
                                       name="slab_two"  value="<?= (isset($Connectors) && is_numeric($Connectors->slab_two)) ? (fmod($Connectors->slab_two, 1) == 0 ? intval($Connectors->slab_two) : $Connectors->slab_two) : '' ?>" >
                                <span class="error"></span>
                            </div> 
                            <div class="col-md-2">
                                <label class="form-label">Slab 2 Commi %<span style="color:red">*</span></label>
                                <input type="number" class="form-control inputs" placeholder="Slab 2 Commi" 
                                       name="slab_two_commi" value="<?= (isset($Connectors)) ? $Connectors->slab_two_commi : '' ?>" step="0.01">
                                <span class="error"></span>
                            </div>  
                        
                            <!-- Slab 3 -->
                         <!--   <div class="col-md-2">
                                <label class="form-label">Slab 3 Amt<span style="color:red">*</span></label>
                                <input type="number" class="form-control inputs" placeholder="Slab 3" 
                                       name="slab_three"  value="<?= (isset($Connectors) && is_numeric($Connectors->slab_three)) ? (fmod($Connectors->slab_three, 1) == 0 ? intval($Connectors->slab_three) : $Connectors->slab_three) : '' ?>">
                                <span class="error"></span>
                            </div>  
                            <div class="col-md-2">
                                <label class="form-label">Slab 3 Commi %<span style="color:red">*</span></label>
                                <input type="number" class="form-control inputs" placeholder="Slab 3 Commi" 
                                       name="slab_three_commi" value="<?= (isset($Connectors)) ? $Connectors->slab_three_commi : '' ?>" step="0.01">
                                <span class="error"></span>
                            </div>  
                        </div>-->

                        
                         <div class="mb-3 col-md-4">
                                <label class="form-label">Remark</label>
                                <textarea type="text" class="form-control inputs" placeholder="Remark" 
                                          name="remark"><?= (isset($SplitPartners)) ? $SplitPartners->remark : '' ?></textarea>
                                <span class="error"></span>
                            </div>

                            <!-- Tag Label -->
                        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3 d-none" id="tag-title"> 
                            <div class="breadcrumb-title pe-3">Tag</div>
                        </div>
                        <!-- Divider -->
                        <hr id="tag-hr">
                        
                        <div class="col-md-3 mb-3">
                            <label class="form-label">Partner*</label>
                            <select name="partnerSelect_id" class="single-select partnerSelect" id="partnerSelect" required>
                                <option value="">-Select-</option>
                               <?php  foreach ($Partners as $par) { ?>
                                   <option value="<?= $par['staff_id']; ?>" <?php if(@$par['staff_id']==@$SplitPartners->connector_id ) echo 'selected';?>> <?=$par['staff_fullname'];?></option>
                              <?php } ?>                           
                            </select>                               
                            <span class="error"></span>
                        </div> 
                        
                 

                        </div>
                      
                    <div class="mb-3">
                                <button type="button" class="btn btn-primary px-5 radius-30" onclick="go_back()">Back</button>
                                <input type="submit" class="btn btn-primary px-5 radius-30" id="btnSubmit" value="Submit">
                            </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
</div>
<!--end row-->
</main>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        var mobileNumberInput = document.querySelector('input[name="mobile"]');
        var panNumberInput = document.querySelector('input[name="pan_no"]');
        var fullNameInput = document.querySelector('input[name="e_fullname"]');
       // var gstNumberInput = document.querySelector('input[name="gst_no"]');
        var commissionInput = document.querySelector('input[name="conn_commision"]');
        var pincodeInput = document.querySelector('input[name="pincode"]');

        function removeRequiredAttribute(input) {
            input.removeAttribute("required");
        }
        
        function setCustomValidityForPincode(input) {
        var pincode = input.value.trim();
        var pincodePattern = /^\d{6}$/;

        if (!pincodePattern.test(pincode)) {
            input.setCustomValidity("Please enter a valid 6-digit pincode");
        } else {
            input.setCustomValidity("");
        }
    }


        function setCustomValidityForMobile(input) {
            if (input.validity.patternMismatch) {
                input.setCustomValidity("Please enter a 10-digit mobile number");
            } else {
                input.setCustomValidity("");
            }
        }

        function setCustomValidityForPan(input) {
            var panPattern = /^[A-Za-z]{5}\d{4}[A-Za-z]$/;

            if (!panPattern.test(input.value)) {
                input.setCustomValidity("Please enter a valid PAN number");
            } else {
                input.setCustomValidity("");
            }
        }

        function setCustomValidityForFullName(input) {
            var fullNamePattern = /^[A-Za-z\s]+$/;

            if (!fullNamePattern.test(input.value)) {
                input.setCustomValidity("Please enter a valid full name");
            } else {
                input.setCustomValidity("");
                input.value = capitalizeWords(input.value);
            }
        }

  
function capitalizeWords(str) {
    return str.toLowerCase().replace(/(?:^|\s)\S/g, function(a) {
        return a.toUpperCase();
    });
}
        function setCustomValidityForCommission(input) {
    var commission = parseFloat(input.value);
    if (isNaN(commission) || commission < 0 || commission > 0.90 || input.value.split('.')[1]?.length > 2) {
        input.setCustomValidity("Commission percentage should be between 0 and 0.90 and have at most two decimal places");
    } else {
        input.setCustomValidity("");
    }
}


        // Remove "required" attribute for gstNumberInput and commissionInput
        //removeRequiredAttribute(gstNumberInput);
        removeRequiredAttribute(commissionInput);

        mobileNumberInput.addEventListener("input", function (event) {
            setCustomValidityForMobile(mobileNumberInput);
        });

        panNumberInput.addEventListener("input", function (event) {
            setCustomValidityForPan(panNumberInput);
        });

        fullNameInput.addEventListener("input", function (event) {
            setCustomValidityForFullName(fullNameInput);
        });

       

        commissionInput.addEventListener("input", function (event) {
            setCustomValidityForCommission(commissionInput);
        });
        
        pincodeInput.addEventListener("input", function () {
        setCustomValidityForPincode(pincodeInput);
    });
    
    });
</script>

<script>
    $(document).ready(function() {
        $('.lowercase-email').on('input', function() {
            var currentValue = $(this).val();
            $(this).val(currentValue.toLowerCase());
        });
    });
</script>

<script>
$(document).ready(function() {
    $('#circleSelect').on('change', function() {
        var selectedOption = $(this).find(':selected');
        var cCode = selectedOption.data('ccode');
        var staffId = $('input[name="e_id"]').val(); // Get the staff ID
        
        if (staffId === '') {
            // In add mode: Generate new HLC code
            generateNewHLC(cCode);
        } else {
            // In edit mode: Use the staff ID to generate HLC code
            $('#hlc_code_input').val('MB' + pad(cCode, 3) + pad(staffId, 3));
        }
    });

    // Function to generate new HLC code
    function generateNewHLC(cCode) {
        // Make AJAX request to fetch last inserted ID (serial number)
        $.ajax({
            url: "<?= base_url('admin/get_last_serial_number_hlc'); ?>",
            method: "POST",
            dataType: "json",
            success: function(response) {
                if (response.success) {
                    var serialNumber = response.serial_number;

                    // Generate the HLC code based on c_code and serial number
                    var hlcCode = generateHLCCode(cCode, serialNumber);

                    // Update the HLC code input field
                    $('#hlc_code_input').val(hlcCode);
                } else {
                    alert('Failed to fetch serial number from the database.');
                }
            },
            error: function(xhr, status, error) {
                console.error(xhr.responseText);
                alert('AJAX Error: ' + xhr.responseText);
            }
        });
    }

    // Function to generate HLC code
    function generateHLCCode(cCode, serialNumber) {
        var prefix = "MB";
        var nextThreeDigits = pad(cCode, 3);
        var lastThreeDigits = pad(serialNumber % 1000, 3); // Get last 3 digits
        var hlcCode = prefix + nextThreeDigits + lastThreeDigits;
        return hlcCode;
    }

    // Helper function to pad numbers with leading zeros
    function pad(num, size) {
        var s = num + "";
        while (s.length < size) s = "0" + s;
        return s;
    }
});
</script>

<script>
$(document).ready(function(){
    $('.stateSelect').change(function(){
        var state_id = $(this).val();
        if(state_id !== '') {
            $.ajax({
                url: '<?= base_url('admin/get_cities') ?>',
                type: 'POST',
                data: {state_id: state_id},
                dataType: 'json',
                success: function(data) {
                    $('#citySelect').empty().append('<option value="">-Select-</option>');
                    $.each(data, function(key, value) {
                        $('#citySelect').append('<option value="' + value.id + '">' + value.city_name + '</option>');
                    });

                    // Get the customer's city ID
                    var customerCityId = <?= (isset($Connectors) && $Connectors->city_id !== null) ? $Connectors->city_id : 'null' ?>;
                    
                    // Set the selected city in the dropdown
                    if (customerCityId !== null) {
                        $('#citySelect').val(customerCityId);
                    } else {
                        // If city ID is empty, fetch cities based on circle
                        $('#citySelect').trigger('change');
                    }
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        } else {
            $('#citySelect').empty().append('<option value="">-Select-</option>');
        }
    });

    // Trigger change event on page load if state is already selected
    $('.stateSelect').trigger('change');
});



$(document).ready(function() {
    // Set the max attribute to today's date
    var today = new Date().toISOString().split('T')[0];
    $('#dob1').attr('max', today);

    $('#dob1').on('change', function() {
        var dob = $(this).val();
        validateDOB(dob);
    });

    function validateDOB(dob) {
        console.log("DOB entered:", dob); // Debugging

        if (dob === '') {
            $('#dob-error').text('');
            return true; // No validation needed if the field is empty
        }

        var dobDate = new Date(dob);
        var today = new Date();
        var age = today.getFullYear() - dobDate.getFullYear();
        var monthDifference = today.getMonth() - dobDate.getMonth();
        var dayDifference = today.getDate() - dobDate.getDate();

        // Check if the birthday has occurred this year
        if (monthDifference < 0 || (monthDifference === 0 && dayDifference < 0)) {
            age--;
        }

        //console.log("Calculated age:", age); // Debugging

        if (dobDate > today) {
            $('#dob-error').text('Date of Birth cannot be in the future.');
           // alert("Error: Date of Birth cannot be in the future."); // Debugging
            $('#dob').val("");
            return false;
        } else if (age < 18) {
            $('#dob-error').text('You must be at least 18 years old.');
            //alert("Error: You must be at least 18 years old."); // Debugging
             $('#dob1').val("");
            return false;
        } else {
            $('#dob-error').text('');
            return true;
        }
    }

    // Form submission validation
    $('#forms').on('submit', function(e) {
        var dob = $('#dob1').val();
        if (!validateDOB(dob)) {
            e.preventDefault(); // Prevent form submission if validation fails
        }
    });
});


</script>


<script>
$(document).ready(function () {
    const dropdowns = ['#salesSelect', '#asmSelect', '#zonalSelect', '#rsmSelect', '#aggrSelect'];

    function disableOthers(exceptId) {
        dropdowns.forEach(function(id) {
            if (id !== exceptId) {
                $(id).prop('disabled', true);
            }
        });
    }

    function enableAll() {
        dropdowns.forEach(function(id) {
            $(id).prop('disabled', false);
        });
    }

    // Only Sales Coordinator should trigger disabling
    $('#salesSelect').on('change', function () {
        if ($(this).val() !== "") {
            disableOthers('#salesSelect');
        } else {
            enableAll();
        }
    });

    // On page load, if Sales Coordinator is selected, disable others
    if ($('#salesSelect').val() !== "") {
        disableOthers('#salesSelect');
    }
});
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const userTypeSelect = document.querySelector('select[name="part_user_type"]');
        const directorContainer = document.getElementById('partner-director-container');
        const addButtonWrap = document.getElementById('add-partner-btn');
        const title = document.getElementById('partner-director-title');
        const titleLabel = document.getElementById('partner-director-title-label');
        const hrLine = document.getElementById('partner-director-hr');

        function showElement(el) {
            el.classList.remove('d-none');
        }

        function hideElement(el) {
            el.classList.add('d-none');
        }

        function togglePartnerDirectorBlock() {
            if (userTypeSelect.value === 'Multi') {
                showElement(directorContainer);
                showElement(addButtonWrap);
                showElement(title);
                showElement(titleLabel);
                showElement(hrLine);
            } else {
                hideElement(directorContainer);
                hideElement(addButtonWrap);
                hideElement(title);
                hideElement(titleLabel);
                hideElement(hrLine);
            }
        }

        togglePartnerDirectorBlock(); // Initial load
        userTypeSelect.addEventListener('change', togglePartnerDirectorBlock); // On change
    });
</script>


<script>
function deletePartner(button) {
    const partnerId = button.getAttribute('data-id');

    if (!confirm("Are you sure you want to delete this partner?")) return;

    fetch("<?= base_url('admin/delete_partner') ?>", {
        method: "POST",
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "X-Requested-With": "XMLHttpRequest"
        },
        body: `id=${partnerId}`
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            // Remove the row visually
            const row = button.closest('.partner-director-entry');
            if (row) row.remove();
        } else {
            alert("Failed to delete partner.");
        }
    })
    .catch(err => {
        console.error(err);
        alert("Error deleting partner.");
    });
}
</script>


<script>
    let directorCount = <?= isset($Partners) ? count($Partners) : 0 ?>;
    const maxDirectors = <?= !empty($Partners) ? 4 : 3 ?>;
    //const maxDirectors = 4;

    document.addEventListener('DOMContentLoaded', function () {
        const addBtn = document.getElementById('add-partner-director');
        const container = document.getElementById('partner-director-container');
        const template = document.getElementById('partner-director-template');

        if (addBtn && container && template) {
            addBtn.addEventListener('click', function () {
                if (directorCount >= maxDirectors) {
                    alert("You can add only 4 Partner Directors.");
                    return;
                }

                const clone = template.cloneNode(true);
                clone.classList.remove('d-none');
                clone.removeAttribute('id');
                container.appendChild(clone);
                directorCount++;
            });
        }
    });

    function go_back() {
        window.history.back();
    }
</script>

