<?php

class Paisabazar_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        
        $db_group = $this->session->userdata('db_group') ?? 'default';
        $this->db = $this->load->database($db_group, TRUE);
        date_default_timezone_set('Asia/Kolkata');
    }

    /**
     * Apply filters using a single $filters associative array.
     * Expected keys (all optional): search, start_date, end_date, status, conn_id, branch_id,
     * applicant_invoice_status, sbi_genrated, hlc_invoice_status, hlc_paid_status, city_id,
     * pb_payment_status, disb_month_year, pb_generated, branch_generated, partner_generated,
     * rbo, created_by_part, team_leader, circle, non_verified
     */
    private function apply_filters(array $filters = []) {
        $search = $filters['search'] ?? '';
        $start_date = $filters['start_date'] ?? '';
        //$end_date = $filters['end_date'] ?? '';
       // $status = $filters['status'] ?? '';
        $conn_id = $filters['conn_id'] ?? '';
        $branch_id = $filters['branch_id'] ?? '';
        $applicant_invoice_status = $filters['applicant_invoice_status'] ?? '';
        $sbi_genrated = $filters['sbi_genrated'] ?? '';
        $hlc_invoice_status = $filters['hlc_invoice_status'] ?? '';
        $hlc_paid_status = $filters['hlc_paid_status'] ?? '';
        $city_id = $filters['city_id'] ?? '';
        $pb_payment_status = $filters['pb_payment_status'] ?? '';
        $disb_month_year = $filters['disb_month_year'] ?? '';
        $pb_generated = $filters['pb_generated'] ?? '';
        $branch_generated = $filters['branch_generated'] ?? '';
        $partner_generated = $filters['partner_generated'] ?? '';
        $rbo = $filters['rbo'] ?? '';
        $created_by_part = $filters['created_by_part'] ?? '';
        $team_leader = $filters['team_leader'] ?? '';
        $circle = $filters['circle'] ?? '';
        $non_verified = $filters['non_verified'] ?? '';

        // add_date filter (month-year)
        if (!empty($start_date) && strpos($start_date, '-') !== false) {
            list($start_year, $start_month) = explode('-', $start_date);
            $this->db->where('MONTH(mst_user.add_date)', $start_month);
            $this->db->where('YEAR(mst_user.add_date)', $start_year);
        }

        // status
        /*if (!empty($status)) {
            $this->db->where('mst_user.status', $status);
        }*/

        // connector / branch
        if (!empty($conn_id)) {
            $this->db->where('mst_user.connector_id', $conn_id);
        }
        if (!empty($branch_id)) {
            $this->db->where('mst_user.branch_id', $branch_id);
        }

        // applicant_invoice_status (original code used IS NULL if present)
        if (!empty($applicant_invoice_status)) {
            // original behavior used: $this->db->where('mst_user.applicant_invoice_status IS NULL');
            $aist = trim($applicant_invoice_status);
            if (strcasecmp($aist, 'No') === 0) {
                $this->db->group_start();
                $this->db->where('mst_user.applicant_invoice_status IS NULL', null, false);
                $this->db->or_where("mst_user.applicant_invoice_status = ''", null, false);
                $this->db->group_end();
            } elseif (strcasecmp($aist, 'Generated') === 0 || strcasecmp($aist, 'Yes') === 0) {
                $this->db->where('mst_user.applicant_invoice_status', 'Generated');
            } else {
                $this->db->where('mst_user.applicant_invoice_status', $aist);
            }
        }

        // pb_genrated flag (sbi_genrated param name in original signature was confusing)
        if (!empty($sbi_genrated)) {
            $this->db->where('mst_user.pb_genrated', $sbi_genrated);
        }

        // hlc_invoice_status
        if (!empty($hlc_invoice_status)) {
            $this->db->where('mst_user.applicant_invoice_status', $hlc_invoice_status);
        }

        // city (support array)
        if (!empty($city_id)) {
            if (is_array($city_id)) {
                $this->db->where_in('branch.city_id', $city_id);
            } else {
                $this->db->where('branch.city_id', $city_id);
            }
        }

        // hlc_paid_status (supports array with 'unpaid')
        if (!empty($hlc_paid_status)) {
            $this->db->group_start();
            if (is_array($hlc_paid_status) && in_array('unpaid', $hlc_paid_status)) {
                $this->db->or_where('mst_user.hlc_payment_status IS NULL', null, false);
                // original had `$this->db->where('mst_user.disb_status', 'yes');` — keep that behaviour only when unpaid included
                $this->db->where('mst_user.disb_status', 'yes');
            }
            $other_hlc_statuses = is_array($hlc_paid_status) ? array_diff($hlc_paid_status, ['unpaid']) : [];
            if (!empty($other_hlc_statuses)) {
                $this->db->or_where_in('mst_user.hlc_payment_status', $other_hlc_statuses);
            }
            $this->db->group_end();
        }

        // pb_payment_status (supports array with 'unpaid')
        if (!empty($pb_payment_status)) {
            $this->db->group_start();
            if (is_array($pb_payment_status) && in_array('unpaid', $pb_payment_status)) {
                $this->db->or_where('mst_user.pb_payment_status IS NULL', null, false);
                $this->db->where('mst_user.pb_genrated', 'Yes'); // original enforced pb_genrated when unpaid
            }
            $other_statuses = is_array($pb_payment_status) ? array_diff($pb_payment_status, ['unpaid']) : [];
            if (!empty($other_statuses)) {
                $this->db->or_where_in('mst_user.pb_payment_status', $other_statuses);
            }
            $this->db->group_end();
        }

        // disb month-year
        if (!empty($disb_month_year) && strpos($disb_month_year, '-') !== false) {
            list($disb_year, $disb_month) = explode('-', $disb_month_year);
            $this->db->where('MONTH(mst_user.disb_date)', $disb_month);
            $this->db->where('YEAR(mst_user.disb_date)', $disb_year);
        }

        // pb_generated flag
        if (!empty($pb_generated)) {
            $this->db->where('mst_user.pb_genrated', $pb_generated);
        }

        // branch_generated: support 'No' => NULL/empty
        if (isset($branch_generated) && $branch_generated !== '') {
            $bg = trim($branch_generated);
            if (strcasecmp($bg, 'No') === 0) {
                $this->db->group_start();
                $this->db->where('mst_user.branch_genrated IS NULL', null, false);
                $this->db->or_where("mst_user.branch_genrated = ''", null, false);
                $this->db->group_end();
            } else {
                $this->db->where('mst_user.branch_genrated', $bg);
            }
        }

        // partner_generated: 'No' => NULL/empty, 'Generated' or 'Yes' => Generated (original logic)
        if (isset($partner_generated) && $partner_generated !== '') {
            $pg = trim($partner_generated);
            if (strcasecmp($pg, 'No') === 0) {
                $this->db->group_start();
                $this->db->where('mst_user.applicant_invoice_status IS NULL', null, false);
                $this->db->or_where("mst_user.applicant_invoice_status = ''", null, false);
                $this->db->group_end();
            } elseif (strcasecmp($pg, 'Generated') === 0 || strcasecmp($pg, 'Yes') === 0) {
                $this->db->where('mst_user.applicant_invoice_status', 'Generated');
            } else {
                $this->db->where('mst_user.applicant_invoice_status', $pg);
            }
        }

        // rbo
        if (!empty($rbo)) {
            $this->db->where('branch.rbo_id', $rbo);
        }

        // created_by partial/fullname
        if (!empty($created_by_part)) {
            $this->db->where('created_by_staff.staff_fullname', $created_by_part);
        }

        // team leader
        if (!empty($team_leader)) {
            $this->db->where('created_by_staff.team_leader', $team_leader);
        }

        // circle
        if (!empty($circle)) {
            $this->db->where('branch.circle_id', $circle);
        }

         $staff_type = $this->session->userdata('staff_type');
          if ($staff_type != 1) {
        // non_verified handling: if '1' -> include verified(1), non-verified(0) and NULL; else only verified(1)
        if (isset($non_verified) && (string)$non_verified === '1') {
            $this->db->group_start();
            $this->db->where('mst_user.is_verify', 1);
            $this->db->or_where('mst_user.is_verify', 0);
            $this->db->or_where('mst_user.is_verify IS NULL', null, false);
            $this->db->group_end();
        } else {
            // default: only verified
            $this->db->where('mst_user.is_verify', 1);
        }
        
          }
        
        
        // Search (many columns)
        if (!empty($search)) {
            $this->db->group_start();
            $this->db->like('mst_user.user_name', $search);
            $this->db->or_like('mst_user.los_id', $search);
            $this->db->or_like('mst_user.bank_acct_no', $search);
            $this->db->or_like('mst_user.user_phone', $search);
            $this->db->or_like('mst_user.user_email', $search);
            $this->db->or_like('mst_user.user_address', $search);
            $this->db->or_like('mst_user.applicant_rr_id', $search);
            $this->db->or_like('mst_user.rr_cbs_acct_no', $search);
            $this->db->or_like('mst_user.sanction_amt', $search);
            $this->db->or_like('mst_user.status', $search);
            $this->db->or_like('mst_user.disb_status', $search);
            $this->db->or_like('mst_user.hlc_payment_status', $search);
            $this->db->or_like('mst_user.pb_payment_status', $search);
            $this->db->or_like('mst_user.login_code', $search);
            $this->db->or_like('branch.branch_name', $search);
            $this->db->or_like('branch.branch_code', $search);
            $this->db->or_like('mst_city.city_name', $search);
            $this->db->or_like('mst_city.agency_code', $search);
            $this->db->or_like('mst_city.agency_name', $search);
            $this->db->or_like('mst_rbo.rbo_name', $search);
            $this->db->or_like('mst_loan_type.name', $search);
            $this->db->or_like('mst_staff.staff_fullname', $search);
            $this->db->or_like('mst_staff.hlc_code', $search);
            $this->db->or_like('created_by_staff.staff_fullname', $search);
            $this->db->group_end();
        }

        // staff_type == 1 restrict connector_id
        if ($staff_type == 1) {
            $current_staff_id = $this->session->userdata('staff_id');
            $this->db->where('mst_user.connector_id', $current_staff_id);
        }
    }

    /**
     * Get Paisabazar applicants using a single $filters array.
     * $filters: keys as documented in apply_filters, plus 'limit' and 'offset'
     */
    public function get_applicant_data(array $filters = []) {
        $search = $filters['search'] ?? '';
        $limit = isset($filters['limit']) ? $filters['limit'] : -1;
        $offset = $filters['offset'] ?? '';

        $this->db->select('mst_user.*, mst_staff.staff_fullname, mst_loan_type.name as user_type, branch.branch_name, branch.branch_code,  mst_state.state_name,mst_city.city_name, mst_rbo.rbo_name, created_by_staff.staff_fullname as created_by_fullname, created_by_staff.team_leader');
        
        $this->db->from('mst_user');
        $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
        $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
        $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
        $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
        $this->db->join('mst_state', 'branch.state_id = mst_state.id', 'left');
        $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
        $this->db->join('mst_staff as created_by_staff', 'mst_staff.created_by = created_by_staff.staff_id', 'left');

        // Paisabazaar specific
        $this->db->where('mst_user.login_code', 'PaisaBazaar');
        $this->db->where('mst_user.is_archive', 'No');

        
        // apply all filters (pass the whole filters array)
        $this->apply_filters($filters);

        if ($limit != -1) {
            if ($limit !== '' && $offset !== '') {
                $this->db->limit($limit, $offset);
            } elseif ($limit !== '') {
                $this->db->limit($limit);
            }
        }

        $this->db->order_by('mst_user.add_date', 'desc');
        $query = $this->db->get();
        return $query->result_array();
    }

    /**
     * Count Paisabazar applicants using $filters array
     */
    public function count_applicant_data(array $filters = []) {
        $this->db->select('COUNT(*) as total');
        $this->db->from('mst_user');
        $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
        $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
        $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
        $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
        $this->db->join('mst_state', 'branch.state_id = mst_state.id', 'left');
        $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
        $this->db->join('mst_staff as created_by_staff', 'mst_staff.created_by = created_by_staff.staff_id', 'left');

        $this->db->where('mst_user.login_code', 'PaisaBazaar');
        $this->db->where('mst_user.is_archive', 'No');

        // staff_type pre-filter
        $staff_type = $this->session->userdata('staff_type');
       

        // apply filters
        $this->apply_filters($filters);

        // restrict for staff_type == 1
        if ($staff_type == 1) {
            $current_staff_id = $this->session->userdata('staff_id');
            $this->db->where('mst_user.connector_id', $current_staff_id);
        }

        $query = $this->db->get();
        return (int)$query->row()->total;
    }


public function get_applicant_data_pb($start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset, $applicant_invoice_status, $pb_genrated, $hlc_paid_status, $city_id, $branch_genrated, $disb_month_year) {
    $this->db->select('
        mst_user.*, 
        mst_staff.staff_fullname, 
        mst_loan_type.name as user_type,
        branch.branch_name, branch.city_id, 
        mst_city.city_name, 
        mst_rbo.rbo_name,
        created_by_staff.staff_fullname as admin_created_hlc
    ');
    $this->db->from('mst_user');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id', 'left');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id', 'left');
    $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
    $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
    $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
    $this->db->join('mst_staff as created_by_staff', 'mst_staff.created_by = created_by_staff.staff_id', 'left'); 

    if (!empty($start_date) && !empty($end_date)) {
        $this->db->where("mst_user.add_date >= ", $start_date);
        $this->db->where("mst_user.add_date <= ", date('Y-m-d', strtotime($end_date . ' +1 day')));
    }

    if (!empty($status)) $this->db->where('mst_user.status', $status);
    if (!empty($conn_id)) $this->db->where('mst_user.connector_id', $conn_id);
    if (!empty($branch_id)) $this->db->where('mst_user.branch_id', $branch_id);
    if (!empty($pb_genrated)) $this->db->where('mst_user.pb_genrated', $pb_genrated);
    if (!empty($branch_genrated)) $this->db->where('mst_user.branch_genrated', $branch_genrated);
    if (!empty($city_id)) $this->db->where('branch.city_id', $city_id);
    
    if (!empty($disb_month_year)) {
        list($disb_year, $disb_month) = explode('-', $disb_month_year);
        $this->db->where('MONTH(mst_user.disb_date)', $disb_month);
        $this->db->where('YEAR(mst_user.disb_date)', $disb_year);
    }

    if (!empty($hlc_paid_status)) {
        if ($hlc_paid_status === 'unpaid') {
            $this->db->where('mst_user.hlc_payment_status IS NULL', null, false);
            $this->db->where('mst_user.disb_status', 'yes');
        } else {
            $this->db->where('mst_user.hlc_payment_status', $hlc_paid_status);
        }
    }

    $this->db->where('mst_user.is_verify', 1);
    $this->db->where('mst_user.pb_pending_approve', 1);
    $this->db->where('mst_user.login_code', 'PaisaBazaar');
    $this->db->where('mst_user.is_archive', 'No');

    if ($this->session->userdata('staff_type') == 1) {
        $this->db->where('mst_user.connector_id', $this->session->userdata('staff_id'));
    }

    $this->db->order_by('mst_user.add_date', 'desc');

    if ($limit != '' && $offset != '') {
        $this->db->limit($limit, $offset);
    } elseif ($limit != '') {
        $this->db->limit($limit);
    }

    $query = $this->db->get();
    return $query->num_rows() > 0 ? $query->result_array() : [];
}

    
    
}
?>
