<?php



class Common_model extends CI_Model {



    public function __construct() {

        parent::__construct();
        
        $db_group = $this->session->userdata('db_group') ?? 'default';
        $this->db = $this->load->database($db_group, TRUE);
        date_default_timezone_set('Asia/Kolkata');

    }



    public function get_all_selected_by_condition($table, $where = '', $group_by = '', $group_by_value = '') {

        $this->db->where('active!=', '2');

        if ($where != '') {

            $this->db->where($where);

        }

        if ($group_by != '') {

            $this->db->group_by($group_by, $group_by_value);

        }

        return $this->db->get($table)->result_array();

        $this->db->last_query();

        die;

    }

public function get_cities_by_state($state_id) {
        $this->db->select('id, city_name');
        $this->db->where('state_id', $state_id);
        $this->db->where('active', 1);
        $query = $this->db->get('mst_city');
        return $query->result();
    }
    
    /*public function get_cities_by_circle($circle_id) {
        $this->db->select('id, city_name');
        $this->db->where('circle_id', $circle_id);
        $this->db->where('active', 1);
        $query = $this->db->get('mst_city');
        return $query->result();
    }*/
    
    

  
/*public function get_cities_with_states() {
    // Perform a JOIN query to get city data along with state data
    $this->db->select('mst_city.*, mst_state.state_name');
    $this->db->from('mst_city');
    $this->db->join('mst_state', 'mst_state.id = mst_city.state_id', 'left');
    $query = $this->db->get();

    if ($query->num_rows() > 0) {
        // If there are results, return the data as an array
        return $query->result_array();
    } else {
        // If no results found, return an empty array
        return array();
    }
}*/

public function get_cities_with_states() {
    // Perform JOIN queries to get state name, created_by name, and modified_by name
    $this->db->select('
        mst_city.*, 
        mst_state.state_name, 
        creator.staff_fullname AS created_by_name, 
        modifier.staff_fullname AS modified_by_name
    ');
    $this->db->from('mst_city');
    $this->db->join('mst_state', 'mst_state.id = mst_city.state_id', 'left');
    $this->db->join('mst_staff AS creator', 'creator.staff_id = mst_city.created_by', 'left');
    $this->db->join('mst_staff AS modifier', 'modifier.staff_id = mst_city.modified_by', 'left');
    $query = $this->db->get();

    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return array();
    }
}
    public function get_all_selected_by_condition2($table, $where = '', $group_by = '', $group_by_value = '') {

//        $this->db->where('active!=', '2');

        if ($where != '') {

            $this->db->where($where);

        }

        if ($group_by != '') {

            $this->db->group_by($group_by, $group_by_value);

        }

        return $this->db->get($table)->result_array();

        $this->db->last_query();

        die;

    }



    public function get_single_row($table, $where = '') {

        $this->db->where('active!=', '2');

        if ($where != '') {

            $this->db->where($where);

        }

        return $this->db->get($table)->row();

//        echo $this->db->last_query(); die;

    }



    public function get_single_row2($table, $where = '') {

        $this->db->where('active=', '1');

        if ($where != '') {

            $this->db->where($where);

        }

        return $this->db->get($table)->row();

//        echo $this->db->last_query(); die;

    }



    public function get_single_row3($table, $where = '') {

        if ($where != '') {

            $this->db->where($where);

        }

        return $this->db->get($table)->row();

//        echo $this->db->last_query(); die;

    }

   

    public function get_row_count($table, $where = '') {

        $this->db->where('active!=', '2');

        if ($where != '') {

            $this->db->where($where);

        }

        return $this->db->get($table)->num_rows();

//        echo $this->db->last_query(); die;

    }

      

    function get_single_column($table, $where, $column_name) {

        if ($where != '') {

            $this->db->where($where);

        }

        return $this->db->get($table)->row()->$column_name;

//        echo $this->db->last_query(); die;

    }

    

   



    function get_all_count($table, $grp_colmn = '', $grp_val = '', $search_column = '', $where = '', $wherein_id = '', $where_in = '') {

        $query = '';

        $query .= " select * from " . $table;

        $query .= " where active!=2 ";

        if ($where != '')

            $query .= $where;

        if ($where_in != '') {

            $query .= " and " . $wherein_id . " IN (" . $where_in . ") ";

        }

        if ($this->input->get('search_val') != '')

            $query .= ' and ' . $search_column . " like '%" . $this->input->get('search_val') . "%'";

        if ($grp_colmn != '')

            $query .= ' order by ' . $grp_colmn;

        if ($grp_val != '')

            $query .= '  ' . $grp_val;

        return $this->db->query($query)->num_rows();

    }

// ðŸ†• Add joins as a parameter
public function get_all_data_with_join($table, $limit = 0, $order_by = '', $group_by = '', $select_fields = ['*'], $where = '', $where_in_col = '', $where_in_values = [], $joins = [] ) {
    $this->db->select($select_fields);
    $this->db->from($table);

    // ðŸ†• Apply joins
    if (!empty($joins)) {
        foreach ($joins as $join) {
            $join_table = $join[0];
            $join_condition = $join[1];
            $join_type = isset($join[2]) ? $join[2] : 'inner';
            $this->db->join($join_table, $join_condition, $join_type);
        }
    }

    // Optional where
    if (!empty($where)) {
        $this->db->where($where);
    }

    // Optional where_in
    if (!empty($where_in_col) && !empty($where_in_values)) {
        $this->db->where_in($where_in_col, $where_in_values);
    }

    // Optional group_by
    if (!empty($group_by)) {
        $this->db->group_by($group_by);
    }

    // Optional order_by
    if (!empty($order_by)) {
        $this->db->order_by($order_by);
    }

    // Optional limit
    if (!empty($limit)) {
        $this->db->limit($limit);
    }

    $query = $this->db->get();
    return $query->result_array();
}

    function get_all_data($table, $limit = '', $grp_colmn = '', $grp_val = '', $search_column = '', $where = '', $wherein_id = '', $where_in = '') {

        $query = '';

        $query .= " select * from " . $table;

        $query .= " where active!=2 ";

        if ($where != '')

            $query .= $where;

        if ($where_in != '') {

            $query .= " and " . $wherein_id . " IN (" . $where_in . ") ";

        }

        if ($this->input->get('search_val') != '')

            $query .= ' and ' . $search_column . " like '%" . $this->input->get('search_val') . "%'";

        if ($grp_colmn != '')

            $query .= ' order by ' . $grp_colmn;

        if ($grp_val != '')

            $query .= '  ' . $grp_val;


        if ($limit != '')

            $query .= ' limit ' . $limit;

        if ($this->input->get('per_page') != '')

            $query .= ' offset ' . $this->input->get('per_page');



        return $this->db->query($query)->result_array();

//        echo $this->db->last_query(); die;

    }
    



    function get_applicant_data($start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset,$applicant_invoice_status,$sbi_genrated,$hlc_invoice_status,$hlc_paid_status,$city_id,$disb_month_year) {
    $this->db->select('mst_user.*, mst_staff.staff_fullname,mst_loan_type.name as user_type');
    $this->db->from('mst_user');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
    
   // $this->db->where('mst_user.disb_status', 'yes');
   
   $this->db->where('mst_user.disb_date IS NOT NULL', null, false);
    
    if (!empty($start_date) && !empty($end_date)) {
        $this->db->where("mst_user.add_date >= '$start_date'");
        $this->db->where("mst_user.add_date <= DATE_ADD('$end_date', INTERVAL 1 DAY)", null, false);
        $this->db->order_by('mst_user.add_date', 'asc');
    }
    if (!empty($start_date)) {
        $formatted_start_date = date('Y-m-d', strtotime($start_date));
        $this->db->where("mst_user.add_date >= '$formatted_start_date'");
    }

    if (!empty($status)) {
        $this->db->where('status', $status);
    }
    if (!empty($conn_id)) {
        $this->db->where('connector_id', $conn_id);
    }
    if (!empty($branch_id)) {
        $this->db->where('branch_id', $branch_id);
    }
    if (!empty($applicant_invoice_status)) {
        $this->db->where('mst_user.applicant_invoice_status IS NULL');
    }
    if (!empty($sbi_genrated)) {
        $this->db->where('mst_user.sbi_genrated', $sbi_genrated);
    }
    if (!empty($hlc_invoice_status)) {
        $this->db->where('mst_user.applicant_invoice_status', $hlc_invoice_status);
    }
    if (!empty($city_id)) {
        $this->db->where('mst_user.city_id', $city_id);
    }
    
    
     if (!empty($disb_month_year)) {
        list($disb_year, $disb_month) = explode('-', $disb_month_year); // Adjusted the order
        $this->db->where('MONTH(mst_user.disb_date)', $disb_month);
        $this->db->where('YEAR(mst_user.disb_date)', $disb_year);
    }
    
    // HLC Paid status filtering
    if (!empty($hlc_paid_status)) {
        if ($hlc_paid_status === 'unpaid') {
            $this->db->where('mst_user.hlc_payment_status', NULL,true);
            $this->db->where('mst_user.disb_status','yes');
        } else {
            $this->db->where('mst_user.hlc_payment_status', $hlc_paid_status);
        }
       
    }

    // Check staff_type from the session
    $staff_type = $this->session->userdata('staff_type');
    if ($staff_type == 1) {
        // If staff_type is 1, limit the data to the current staff
        $current_staff_id = $this->session->userdata('staff_id');
        $this->db->where('mst_user.connector_id', $current_staff_id);
    }
    
     // Additional condition for PaisaBazaar login_code with is_verify = 1
   // $this->db->group_start(); // Start grouping of conditions
   // $this->db->where('mst_user.login_code !=', 'PaisaBazaar'); // Exclude PaisaBazaar by default
    //$this->db->or_group_start(); // Start nested group
   // $this->db->where('mst_user.login_code', 'PaisaBazaar');
    $this->db->where('mst_user.is_verify', 1); 
    $this->db->where('mst_user.is_archive', 'No'); 
  //  $this->db->group_end(); // End nested group
 //   $this->db->group_end(); // End grouping of conditions
    
    $this->db->order_by('mst_user.add_date', 'desc');

    // Apply pagination
    if ($limit != '' && $offset != '') {
        $this->db->limit($limit, $offset);
    } elseif ($limit != '') {
        $this->db->limit($limit);
    }
      
    $query = $this->db->get();
    //echo $this->db->last_query(); die;
    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return array();
    }
}


/*function get_applicant_data_rbo($start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset,$applicant_invoice_status,$sbi_genrated,$hlc_invoice_status,$hlc_paid_status,$city_id,$branch_genrated,$disb_month_year) {
    $this->db->select('mst_user.*, mst_staff.staff_fullname,mst_loan_type.name as user_type');
    $this->db->from('mst_user');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
    
    if (!empty($start_date) && !empty($end_date)) {
        $this->db->where("mst_user.add_date >= '$start_date'");
        $this->db->where("mst_user.add_date <= DATE_ADD('$end_date', INTERVAL 1 DAY)", null, false);
        $this->db->order_by('mst_user.add_date', 'asc');
    }
    if (!empty($start_date)) {
        $formatted_start_date = date('Y-m-d', strtotime($start_date));
        $this->db->where("mst_user.add_date >= '$formatted_start_date'");
    }

    if (!empty($status)) {
        $this->db->where('status', $status);
    }
    if (!empty($conn_id)) {
        $this->db->where('connector_id', $conn_id);
    }
    if (!empty($branch_id)) {
        $this->db->where('branch_id', $branch_id);
    }
    if (!empty($applicant_invoice_status)) {
        $this->db->where('mst_user.applicant_invoice_status IS NULL');
    }
    if (!empty($sbi_genrated)) {
        $this->db->where('mst_user.sbi_genrated', $sbi_genrated);
    }
    if (!empty($hlc_invoice_status)) {
        $this->db->where('mst_user.applicant_invoice_status', $hlc_invoice_status);
    }
    if (!empty($branch_genrated)) {
        $this->db->where('mst_user.branch_genrated', $branch_genrated);
    }
    if (!empty($city_id)) {
        $this->db->where('mst_user.city_id', $city_id);
    }
    
    if (!empty($disb_month_year)) {
        list($disb_year, $disb_month) = explode('-', $disb_month_year); // Adjusted the order
        $this->db->where('MONTH(mst_user.disb_date)', $disb_month);
        $this->db->where('YEAR(mst_user.disb_date)', $disb_year);
    }
    
    // HLC Paid status filtering
    if (!empty($hlc_paid_status)) {
        if ($hlc_paid_status === 'unpaid') {
            $this->db->where('mst_user.hlc_payment_status', NULL,true);
            $this->db->where('mst_user.disb_status','yes');
        } else {
            $this->db->where('mst_user.hlc_payment_status', $hlc_paid_status);
        }
       
    }

    // Check staff_type from the session
    $staff_type = $this->session->userdata('staff_type');
    if ($staff_type == 1) {
        // If staff_type is 1, limit the data to the current staff
        $current_staff_id = $this->session->userdata('staff_id');
        $this->db->where('mst_user.connector_id', $current_staff_id);
    }
    
    $this->db->order_by('mst_user.add_date', 'desc');

    // Apply pagination
    if ($limit != '' && $offset != '') {
        $this->db->limit($limit, $offset);
    } elseif ($limit != '') {
        $this->db->limit($limit);
    }
      
    $query = $this->db->get();
    //echo $this->db->last_query(); die;
    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return array();
    }
}*/


function get_applicant_data_rbo($start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset, $sbi_genrated, $hlc_invoice_status, $hlc_paid_status, $city_id, $branch_genrated, $disb_month_year, $rbo) {
    $this->db->select('mst_user.*, mst_staff.staff_fullname, mst_loan_type.name as user_type, branch.rbo_id');
    $this->db->from('mst_user');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
    $this->db->join('branch', 'mst_user.branch_id = branch.id'); // Join with the branch table

    // Apply filters based on the input parameters
    if (!empty($start_date) && !empty($end_date)) {
        $this->db->where("mst_user.add_date >= '$start_date'");
        $this->db->where("mst_user.add_date <= DATE_ADD('$end_date', INTERVAL 1 DAY)", null, false);
        $this->db->order_by('mst_user.add_date', 'asc');
    }
    if (!empty($start_date)) {
        $formatted_start_date = date('Y-m-d', strtotime($start_date));
        $this->db->where("mst_user.add_date >= '$formatted_start_date'");
    }
    if (!empty($status)) {
        $this->db->where('status', $status);
    }
    if (!empty($conn_id)) {
        $this->db->where('connector_id', $conn_id);
    }
    if (!empty($branch_id)) {
        $this->db->where('mst_user.branch_id', $branch_id);
    }
 
    if (!empty($sbi_genrated)) {
        $this->db->where('mst_user.sbi_genrated', $sbi_genrated);
    }
    if (!empty($hlc_invoice_status)) {
        $this->db->where('mst_user.applicant_invoice_status', $hlc_invoice_status);
    }
    if (!empty($branch_genrated)) {
        $this->db->where('mst_user.branch_genrated', $branch_genrated);
    }
    if (!empty($city_id)) {
        $this->db->where('mst_user.city_id', $city_id);
    }
    if (!empty($disb_month_year)) {
        list($disb_year, $disb_month) = explode('-', $disb_month_year);
        $this->db->where('MONTH(mst_user.disb_date)', $disb_month);
        $this->db->where('YEAR(mst_user.disb_date)', $disb_year);
    }
    if (!empty($hlc_paid_status)) {
        if ($hlc_paid_status === 'unpaid') {
            $this->db->where('mst_user.hlc_payment_status', NULL, true);
            $this->db->where('mst_user.disb_status', 'yes');
        } else {
            $this->db->where('mst_user.hlc_payment_status', $hlc_paid_status);
        }
    }

    // Filter by RBO if provided
    if (!empty($rbo)) {
        $this->db->where('branch.rbo_id', $rbo);
    }

    // Check staff_type from the session
    $staff_type = $this->session->userdata('staff_type');
    if ($staff_type == 1) {
        $current_staff_id = $this->session->userdata('staff_id');
        $this->db->where('mst_user.connector_id', $current_staff_id);
    }
    
    $this->db->where('mst_user.is_archive', 'No');   
    $this->db->order_by('mst_user.add_date', 'desc');

    // Apply pagination
    if ($limit != '' && $offset != '') {
        $this->db->limit($limit, $offset);
    } elseif ($limit != '') {
        $this->db->limit($limit);
    }

    $query = $this->db->get();
    //echo $this->db->last_query(); die;
    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return array();
    }
}


function get_applicant_data_branch($start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset,$applicant_invoice_status,$branch_genrated,$hlc_invoice_status,$disb_month_year,$rbo,$city_id) {
    $this->db->select('mst_user.*, mst_staff.staff_fullname,mst_loan_type.name as user_type, branch.rbo_id');
    $this->db->from('mst_user');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
    $this->db->join('branch', 'mst_user.branch_id = branch.id'); // Join with the branch table
    
    if (!empty($start_date) && !empty($end_date)) {
        $this->db->where("mst_user.add_date >= '$start_date'");
        $this->db->where("mst_user.add_date <= DATE_ADD('$end_date', INTERVAL 1 DAY)", null, false);
        $this->db->order_by('mst_user.add_date', 'asc');
    }
    if (!empty($start_date)) {
        $formatted_start_date = date('Y-m-d', strtotime($start_date));
        $this->db->where("mst_user.add_date >= '$formatted_start_date'");
    }

    if (!empty($status)) {
        $this->db->where('status', $status);
    }
    if (!empty($conn_id)) {
        $this->db->where('connector_id', $conn_id);
    }
    if (!empty($branch_id)) {
        $this->db->where('branch_id', $branch_id);
    }
    
    if (!empty($city_id)) {
        $this->db->where('branch.city_id', $city_id);
    }
    
    if (!empty($applicant_invoice_status)) {
        $this->db->where('mst_user.applicant_invoice_status IS NULL');
    }
   
        $this->db->where('mst_user.branch_genrated IS NULL');
        $this->db->where('mst_user.sbi_genrated','No');
        //$this->db->where('mst_user.is_verify',1);
   
    if (!empty($hlc_invoice_status)) {
        $this->db->where('mst_user.applicant_invoice_status', $hlc_invoice_status);
    }
    
     if (!empty($disb_month_year)) {
        list($disb_year, $disb_month) = explode('-', $disb_month_year); // Adjusted the order
        $this->db->where('MONTH(mst_user.disb_date)', $disb_month);
        $this->db->where('YEAR(mst_user.disb_date)', $disb_year);
    }
    
    if (!empty($rbo)) {
        $this->db->where('branch.rbo_id', $rbo);
    }
    
    $this->db->where('mst_user.login_code !=', 'PaisaBazaar');
    $this->db->order_by('mst_user.add_date', 'desc');
    $this->db->where('mst_user.is_archive', 'No'); 
    
    $query = $this->db->get();
    //echo $this->db->last_query(); die;
    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return array();
    }
}

    function get_invoice_cases_data($start_date, $end_date, $status,$conn_id,$branch_id) {
        $this->db->select('mst_user.*, mst_staff.staff_fullname');
        $this->db->from('mst_user');
        $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
        $this->db->where('mst_user.invoice_id', null);
    
        if (!empty($start_date) && !empty($end_date)) {          
            $this->db->where("mst_user.add_date >= '$start_date'");
            $this->db->where("mst_user.add_date <= DATE_ADD('$end_date', INTERVAL 1 DAY)", null, false);
            $this->db->order_by('mst_user.add_date', 'asc');
        }
        if (!empty($start_date)) {
            $formatted_start_date = date('Y-m-d', strtotime($start_date));
            $this->db->where("mst_user.add_date >= '$formatted_start_date'");
        }        

        if (!empty($status)) {
            $this->db->where('status', $status);
        }
        if (!empty($conn_id)) {
            $this->db->where('connector_id', $conn_id);
        }
        if (!empty($branch_id)) {
            $this->db->where('branch_id', $branch_id);
        }
    
        // Check staff_type from the session
        $staff_type = $this->session->userdata('staff_type');
        if ($staff_type == 1) {
            // If staff_type is 1, limit the data to the current staff
            $current_staff_id = $this->session->userdata('staff_id');
            $this->db->where('mst_user.connector_id', $current_staff_id);
        }
        $this->db->order_by('mst_user.add_date', 'desc');
        $query = $this->db->get();
    
        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return array();
        }
    }
    function get_invoice_data($start_date, $end_date, $inv_type,$conn_id,$branch_id,$limit,$offset,$hlc_paid_status,$city_id,$disb_month_year) {
        $this->db->select('invoices.*, mst_user.disb_date,mst_user.user_name, mst_staff.staff_fullname, branch.branch_name');
        $this->db->from('invoices');
        $this->db->join('mst_user', 'invoices.user_id = mst_user.id');
        $this->db->join('mst_staff', 'invoices.connector_id = mst_staff.staff_id');
        $this->db->join('branch', 'invoices.branch_id = branch.id');

    
        if (!empty($start_date) && !empty($end_date)) {          
            $this->db->where("invoices.add_date >= '$start_date'");
            $this->db->where("invoices.add_date <= DATE_ADD('$end_date', INTERVAL 1 DAY)", null, false);
            $this->db->order_by('invoices.add_date', 'asc');
        }
        if (!empty($start_date)) {
            $formatted_start_date = date('Y-m-d', strtotime($start_date));
            $this->db->where("invoices.add_date >= '$formatted_start_date'");
        }        
        if($_SESSION['staff_type']==1){
          $this->db->where('invoices.invoice_type', 'inv_hlc');
        }
        if($_SESSION['staff_type']==0){
        if (!empty($inv_type)) {
            $this->db->where('invoices.invoice_type', $inv_type);
        }
        }
        if (!empty($conn_id)) {
            $this->db->where('invoices.connector_id', $conn_id);
        }
        if (!empty($branch_id)) {
            $this->db->where('invoices.branch_id', $branch_id);            
        }
        if (!empty($city_id)) {
            $this->db->where('branch.city_id', $city_id);            
        }
        
         if (!empty($disb_month_year)) {
        list($disb_year, $disb_month) = explode('-', $disb_month_year); // Adjusted the order
        $this->db->where('MONTH(mst_user.disb_date)', $disb_month);
        $this->db->where('YEAR(mst_user.disb_date)', $disb_year);
    }
    
        if (!empty($hlc_paid_status)) {
             if ($hlc_paid_status === 'unpaid') {
                $this->db->where('invoices.hlc_status', NULL);
            }else{
                $this->db->where('invoices.hlc_status', $hlc_paid_status);            
            }
        }
    
        // Check staff_type from the session
        $staff_type = $this->session->userdata('staff_type');
        if ($staff_type == 1) {
            // If staff_type is 1, limit the data to the current staff
            $current_staff_id = $this->session->userdata('staff_id');
            $this->db->where('invoices.connector_id', $current_staff_id);
        }
        $this->db->group_by('invoices.inv_batchno');
        $this->db->order_by('invoices.add_date', 'desc');
        // Apply pagination
    if ($limit != '' && $offset != '') {
        $this->db->limit($limit, $offset);
    } elseif ($limit != '') {
        $this->db->limit($limit);
    }
    
  
        $query = $this->db->get();
      //echo $this->db->last_query(); die;
        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return array();
        }
    }
    
    
    function get_invoice_data_sbi($start_date, $end_date, $inv_type,$conn_id,$branch_id,$limit,$offset,$sbi_paid_status,$city_id,$disb_month_year) {
        $this->db->select('invoices.*, mst_user.disb_date,mst_user.user_name, mst_staff.staff_fullname, branch.branch_name');
        $this->db->from('invoices');
        $this->db->join('mst_user', 'invoices.user_id = mst_user.id');
        $this->db->join('mst_staff', 'invoices.connector_id = mst_staff.staff_id');
        $this->db->join('branch', 'invoices.branch_id = branch.id');

    
        if (!empty($start_date) && !empty($end_date)) {          
            $this->db->where("invoices.add_date >= '$start_date'");
            $this->db->where("invoices.add_date <= DATE_ADD('$end_date', INTERVAL 1 DAY)", null, false);
            $this->db->order_by('invoices.add_date', 'asc');
        }
        if (!empty($start_date)) {
            $formatted_start_date = date('Y-m-d', strtotime($start_date));
            $this->db->where("invoices.add_date >= '$formatted_start_date'");
        }        
        if($_SESSION['staff_type']==1){
          $this->db->where('invoices.invoice_type', 'inv_hlc');
        }
        if($_SESSION['staff_type']==0){
        if (!empty($inv_type)) {
            $this->db->where('invoices.invoice_type', $inv_type);
        }
        }
        if (!empty($conn_id)) {
            $this->db->where('invoices.connector_id', $conn_id);
        }
        if (!empty($branch_id)) {
            $this->db->where('invoices.branch_id', $branch_id);            
        }
        if (!empty($city_id)) {
            $this->db->where('branch.city_id', $city_id);            
        }
        if (!empty($sbi_paid_status)) {
             if ($sbi_paid_status === 'unpaid') {
                $this->db->where('invoices.sbi_status', NULL);
            }else{
                $this->db->where('invoices.sbi_status', $sbi_paid_status);            
            }
        }
    
      if (!empty($disb_month_year)) {
        list($disb_year, $disb_month) = explode('-', $disb_month_year); // Adjusted the order
        $this->db->where('MONTH(mst_user.disb_date)', $disb_month);
        $this->db->where('YEAR(mst_user.disb_date)', $disb_year);
    }
        // Check staff_type from the session
        $staff_type = $this->session->userdata('staff_type');
        if ($staff_type == 1) {
            // If staff_type is 1, limit the data to the current staff
            $current_staff_id = $this->session->userdata('staff_id');
            $this->db->where('invoices.connector_id', $current_staff_id);
        }
        
       
        $this->db->group_by('invoices.inv_batchno');
        $this->db->order_by('invoices.add_date', 'desc');
        // Apply pagination
    if ($limit != '' && $offset != '') {
        $this->db->limit($limit, $offset);
    } elseif ($limit != '') {
        $this->db->limit($limit);
    }
    
  
        $query = $this->db->get();
      //echo $this->db->last_query(); die;
        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return array();
        }
    }
   function get_invoice_data_branch($start_date, $end_date,$conn_id,$branch_id,$hlc_paid_status,$disb_month_year) {
        $this->db->select('invoices.*, mst_user.user_name,mst_user.disb_date, mst_staff.staff_fullname, branch.branch_name');
        $this->db->from('invoices');
        $this->db->join('mst_user', 'invoices.user_id = mst_user.id');
        $this->db->join('mst_staff', 'invoices.connector_id = mst_staff.staff_id');
        $this->db->join('branch', 'invoices.branch_id = branch.id');

    
        if (!empty($start_date) && !empty($end_date)) {          
            $this->db->where("invoices.add_date >= '$start_date'");
            $this->db->where("invoices.add_date <= DATE_ADD('$end_date', INTERVAL 1 DAY)", null, false);
            $this->db->order_by('invoices.add_date', 'asc');
        }
        if (!empty($start_date)) {
            $formatted_start_date = date('Y-m-d', strtotime($start_date));
            $this->db->where("invoices.add_date >= '$formatted_start_date'");
        }        
       
          $this->db->where('invoices.invoice_type', 'inv_branch');
       
       
        if (!empty($conn_id)) {
            $this->db->where('invoices.connector_id', $conn_id);
        }
        if (!empty($branch_id)) {
            $this->db->where('invoices.branch_id', $branch_id);            
        }
        if (!empty($hlc_paid_status)) {
             if ($hlc_paid_status === 'unpaid') {
                $this->db->where('invoices.hlc_status', NULL);
            }else{
                $this->db->where('invoices.hlc_status', $hlc_paid_status);            
            }
        }
        
        
         if (!empty($disb_month_year)) {
            list($disb_year, $disb_month) = explode('-', $disb_month_year); // Adjusted the order
            $this->db->where('MONTH(mst_user.disb_date)', $disb_month);
            $this->db->where('YEAR(mst_user.disb_date)', $disb_year);
        }
    
        $this->db->group_by('invoices.inv_batchno');
        $this->db->order_by('invoices.add_date', 'desc');
    
        $query = $this->db->get();
        
      // echo $this->db->last_query(); die;
        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return array();
        }
    } 
    
    function get_all_count_applicant($table, $order_by_column, $order_by_direction, $count_column, $start_date = null, $end_date = null, $status = null) {
        $this->db->from($table);
    
        // Apply additional filters
        if (!empty($start_date) && !empty($end_date)) {
            $this->db->where("add_date >= '$start_date'");
            $this->db->where("add_date <= DATE_ADD('$end_date', INTERVAL 1 DAY)", null, false);
        }
        if (!empty($start_date)) {
            $formatted_start_date = date('Y-m-d', strtotime($start_date));
            $this->db->where("mst_user.add_date >= '$formatted_start_date'");
        }
        
    
        if (!empty($status)) {
            $this->db->where('status', $status);
        }

        if (!empty($conn_id)) {
            $this->db->where('connector_id', $conn_id);
        }
        if (!empty($branch_id)) {
            $this->db->where('branch_id', $branch_id);
        }
    
        $this->db->order_by($order_by_column, $order_by_direction);
        return $this->db->count_all_results();
    }

    function get_all_count_invoice($table, $order_by_column, $order_by_direction, $count_column, $start_date = null, $end_date = null, $status = null) {
        $this->db->from($table);
    
        // Apply additional filters
        if (!empty($start_date) && !empty($end_date)) {
            $this->db->where("add_date >= '$start_date'");
            $this->db->where("add_date <= DATE_ADD('$end_date', INTERVAL 1 DAY)", null, false);
        }
        if (!empty($start_date)) {
            $formatted_start_date = date('Y-m-d', strtotime($start_date));
            $this->db->where("invoices.add_date >= '$formatted_start_date'");
        }
        
    
        if (!empty($status)) {
            $this->db->where('invoice_type', $status);
        }

        if (!empty($conn_id)) {
            $this->db->where('connector_id', $conn_id);
        }
        if (!empty($branch_id)) {
            $this->db->where('branch_id', $branch_id);
        }
        $this->db->group_by('invoices.inv_batchno');
        $this->db->order_by($order_by_column, $order_by_direction);
        return $this->db->count_all_results();
    }
    function check_value($table, $col, $val) {

        $query = '';

        $query .= ' select * from ' . $table . ' where ' . $col . "='" . $val . "'";

        return $this->db->query($query)->row();

    }



    function autosearch($val, $where = '') {

        $query = '';

        $query .= ' select c_title,c_url from master_coupons';

        $query .= " where  active=1 and c_title  LIKE '%" . $val . "%'";

        if ($where != '')

            $query .= $where;

        $query .= " limit 10";

        return $this->db->query($query)->result_array();

    }



    function autosearch_deal($val, $where = '') {

        $query = '';

        $query .= ' select d_title,d_url from master_deals';

        $query .= " where  active=1 and d_title  LIKE '%" . $val . "%'";

        if ($where != '')

            $query .= $where;

        $query .= " limit 10";

        return $this->db->query($query)->result_array();

    }


//hlc total invoice and total paid amt
public function getTotalPaidForHLC()
{
    // Check if the user is logged in
    if (!isset($_SESSION['staff_id'])) {
        // User is not logged in, return default values
        return array('total_paid_invoices' => 0, 'total_paid_amount' => 0);
    }

    // Initialize the query builder
    $this->db->select('COUNT(*) as total_paid_invoices, SUM(pay_amt) as total_paid_amount')
             ->from('invoice_log')
             ->where('status', 'paid')
             ->where('invoice_type', 'inv_hlc');

    // Apply condition based on user type
    if ($_SESSION['staff_type'] != 0) {
        // If the user is a connector, limit to their specific staff_id
        $this->db->where('connector_id', $_SESSION['staff_id']);
    }

    // Execute the query and retrieve the result
    $query = $this->db->get();

    // Return the result or default values if no data found
    return $query->num_rows() > 0 ? $query->row_array() : array('total_paid_invoices' => 0, 'total_paid_amount' => 0);
}



public function get_unpaid_hlc_invoices_count() {
    $this->db->select('inv_batchno, COUNT(*) as unpaid_count');
    $this->db->from('invoices');

    // Check user type
    if ($_SESSION['staff_type'] == 0) {
        // Admin sees all unpaid HLC invoices
        $this->db->where('invoice_type', 'inv_hlc');
        $this->db->where('hlc_status', null);
    } else {
        // Other users only see their own unpaid HLC invoices
        $this->db->where('invoice_type', 'inv_hlc');
        $this->db->where('connector_id', $_SESSION['staff_id']); // Assuming user ID is connector_id
        $this->db->where('hlc_status', null);
    }

    $this->db->group_by('inv_batchno');
    
    $query = $this->db->get();
    
    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return array(); // Return empty array if no results
    }
}



//SBI total invoice and total receve amt
public function getTotalPaidForSBI()
{
    $query = $this->db->select('COUNT(*) as total_paid_invoices, SUM(pay_amt) as total_paid_amount')
                      ->from('invoice_log')
                      ->where('status', 'paid')
                      ->where('invoice_type', 'inv_sbi')
                      ->get();
    // Check if query executed successfully
    if ($query->num_rows() > 0) {
        // Return the result as an array
        return $query->row_array();
    } else {
        // No data found, return empty array or handle error as needed
        return array('total_paid_invoices' => 0, 'total_paid_amount' => 0);
    }
}
   

  
public function get_sbi_invoices_count_for_month() {
    $current_month = date('m');
    $current_year = date('Y');

    $this->db->select('COUNT(*) as sbi_count, i.inv_batchno');
    $this->db->from('invoices i');
    $this->db->join('invoice_log pi', 'pi.invoice_batchno = i.inv_batchno', 'left'); // Joining on inv_batchno
    $this->db->where('MONTH(i.invoice_date)', $current_month);
    $this->db->where('YEAR(i.invoice_date)', $current_year);
    $this->db->where('pi.invoice_type', 'inv_sbi');

    $this->db->group_by('i.inv_batchno');
    
    $query = $this->db->get();
    
    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return array(); // Return empty array if no results
    }
}

public function get_rbo_invoice_dashboard_data() {
$this->db
    ->select('invoices.*, mst_user.sbi_genrated,mst_user.sbi_commi')
    ->from('invoices')
    ->join('mst_user', 'mst_user.id = invoices.user_id')
    ->where('invoices.invoice_type', 'inv_sbi')
    ->where('mst_user.sbi_genrated', 'Yes')
    ->group_by('invoices.inv_batchno')
    ->get()
    ->result_array(); 
}

public function get_sbi_payment_received() {
    // Get the current month and year
    $currentMonth = date('m');
    $currentYear = date('Y');

    // Query to get the total payment received for inv_sbi invoices in the current month
    $this->db->select_sum('i.pay_amt', 'total_payment');
    $this->db->from('invoices pi');
    $this->db->join('invoice_log i', 'i.invoice_batchno = pi.inv_batchno');
    $this->db->where('pi.invoice_type', 'inv_sbi');
    $this->db->where('MONTH(i.payment_date)', $currentMonth);
    $this->db->where('YEAR(i.payment_date)', $currentYear);
    $this->db->where('i.status', 'paid');
    $this->db->group_by('i.invoice_batchno');

    $query = $this->db->get();
    $result = $query->row();

    $totalPayment = $result->total_payment ?? 0;

    // Return the total payment received
    return $totalPayment;
}


public function get_received_invoice_sbi($start_date, $end_date, $branch_id) {
    $this->db->select('i.*, b.branch_name,b.branch_code,il.pay_amt,il.payment_date,il.tds_amt,il.net_pay as nettot'); // Selecting all columns from both tables and branch name
    $this->db->from('invoices i');
    $this->db->join('invoice_log il', 'il.invoice_batchno = i.inv_batchno');
    $this->db->join('branch b', 'b.id = i.branch_id'); // Joining branch table
    
    $this->db->where('i.invoice_type', 'inv_sbi');

    if (!empty($start_date) && !empty($end_date)) {
        $this->db->where("i.invoice_date >= '$start_date'");
        $this->db->where("i.invoice_date <= DATE_ADD('$end_date', INTERVAL 1 DAY)", null, false);
    } elseif (!empty($start_date)) {
        $formatted_start_date = date('Y-m-d', strtotime($start_date));
        $this->db->where("i.invoice_date >= '$formatted_start_date'");
    }
     $this->db->where('i.sbi_status', 'paid');

    if (!empty($branch_id)) {
        $this->db->where('i.branch_id', $branch_id);
    }

    $this->db->group_by('i.inv_batchno');
    $query = $this->db->get();
    
    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return array(); // Return empty array if no results
    }
}


/*public function get_paid_invoice_hlc($start_date, $end_date, $connector_id){
    $this->db->select('i.*, s.staff_fullname, s.gst_no, s.circle_id, s.state_id as state_part, st.state_name AS state_name, ci.city_name AS city_name, il.payment_date, il.pay_amt, il.bank_details as ref_no, il.remark, il.net_pay AS nettot');
    $this->db->from('invoices i');
    $this->db->join('mst_staff s', 's.staff_id = i.connector_id', 'inner');
    $this->db->join('mst_state st', 'st.id = s.state_id', 'left');
    $this->db->join('mst_city ci', 'ci.id = s.city_id', 'left');
    $this->db->join('invoice_log il', 'il.invoice_batchno = i.inv_batchno');

  
    $this->db->where('i.hlc_status', 'paid');
    $this->db->where('il.invoice_type', 'inv_hlc');
    

    if ($this->session->userdata('staff_type') != 0) {
        $this->db->where('i.connector_id', $this->session->userdata('staff_id'));
    }

    if (!empty($start_date) && !empty($end_date)) {
        $this->db->where("i.invoice_date >=", $start_date);
        $this->db->where("i.invoice_date <=", date('Y-m-d', strtotime($end_date . ' +1 day')));
    } elseif (!empty($start_date)) {
        $this->db->where("i.invoice_date >=", date('Y-m-d', strtotime($start_date)));
    }

    if (!empty($connector_id)) {
        $this->db->where('i.connector_id', $connector_id);
    }
    
     
  //  $this->db->order_by('il.payment_date', 'DESC');

    $query = $this->db->get();
    return $query->num_rows() ? $query->result_array() : [];
}
*/


/*public function get_paid_invoice_hlc($start_date, $end_date, $connector_id) {
    $this->db->select("
        s.staff_fullname,
        s.gst_no,
        s.circle_id,
        s.state_id as state_part,
        st.state_name AS state_name,
        ci.city_name  AS city_name,
        il.payment_date,
        il.invoice_batchno,
        il.pay_amt,
        il.bank_details as ref_no,
        il.remark,
        il.net_pay AS nettot
    ");
    $this->db->from('invoice_log il');
    $this->db->join('mst_staff s', 's.staff_id = il.connector_id', 'inner');
    $this->db->join('mst_state st', 'st.id = s.state_id', 'left');  // Staff state
    $this->db->join('mst_city ci', 'ci.id = s.city_id', 'left');   // Staff city
   
    $this->db->where('il.invoice_type', 'inv_hlc');
    $this->db->where_in('il.status', ['paid', 'excess paid', 'partly paid']);

    if ($this->session->userdata('staff_type') != 0) {
        $this->db->where('il.connector_id', $this->session->userdata('staff_id'));
    }

    if (!empty($start_date) && !empty($end_date)) {
        $this->db->where("i.invoice_date >=", $start_date);
        $this->db->where("i.invoice_date <=", date('Y-m-d', strtotime($end_date . ' +1 day')));
    } elseif (!empty($start_date)) {
        $this->db->where("i.invoice_date >=", date('Y-m-d', strtotime($start_date)));
    }

    if (!empty($connector_id)) {
        $this->db->where('il.connector_id', $connector_id);
    }
    $this->db->order_by('il.invoice_batchno', 'ASC');
    $this->db->limit(20);

   
    $query = $this->db->get();
    return $query->num_rows() ? $query->result_array() : [];
}*/

public function get_paid_invoice_hlc_paginated($start, $length, $start_date, $end_date, $connector_id) {
    $this->db->select("il.*, s.staff_fullname, s.gst_no, s.state_id as state_part, st.state_name, ci.city_name");
    $this->db->from("invoice_log il");
    $this->db->join("mst_staff s", "s.staff_id = il.connector_id");
    $this->db->join("mst_state st", "st.id = s.state_id", "left");
    $this->db->join("mst_city ci", "ci.id = s.city_id", "left");
    $this->db->where("il.invoice_type", "inv_hlc");
    $this->db->where_in("il.status", ['paid', 'partly paid', 'excess paid']);

    if ($start_date) $this->db->where("il.payment_date >=", $start_date);
    if ($end_date) $this->db->where("il.payment_date <=", date('Y-m-d', strtotime($end_date . ' +1 day')));
    if ($connector_id) $this->db->where("il.connector_id", $connector_id);

    if ($length != -1) {
        $this->db->limit($length, $start);
    }
    if ($this->session->userdata('staff_type') != 0) {
        $this->db->where('il.connector_id', $this->session->userdata('staff_id'));
    }
    $this->db->order_by("il.invoice_batchno", "ASC");

    $results = $this->db->get()->result_array();
    $output = [];
    $sr = $start + 1;

    foreach ($results as $row) {
        $batch_no = $row['invoice_batchno'];

        // Cache per batch
        $invoice_items = $this->db->get_where('invoices', ['inv_batchno' => $batch_no])->result_array();
        $invoice_no = $this->db->get_where('invoices', ['inv_batchno' => $batch_no])->row();

        $totalCommissionAmt = 0;
        foreach ($invoice_items as $item) {
            $user = $this->db->get_where('mst_user', ['id' => $item['user_id']])->row();
            $commission = calculateTotalCommission1($this->db, $user, $user->part_payout, $user->loan_type_id, $batch_no);
            if ($user->loan_type_id == 4 && $user->sanction_amt <= 100000) {
                $commission = 2000;
            }
            $totalCommissionAmt += $commission;
        }

        $gstPercent = empty($row['gst_no']) ? 0 : 18;
        $gst = $totalCommissionAmt * $gstPercent / 100;
        $cgst = $sgst = $igst = 0;
        $company_state = 27;

        if ($row['state_part'] != $company_state) {
            $igst = $gst;
        } else {
            $cgst = $gst / 2;
            $sgst = $gst / 2;
        }

        $invoiceTimestamp = strtotime($invoice_no->invoice_date ?? '');
        $tdsPer = ($invoiceTimestamp >= strtotime('2024-10-01')) ? 2 : 5;
        $tds = $totalCommissionAmt * $tdsPer / 100;
        $grossTotal = $totalCommissionAmt + $cgst + $sgst + $igst;
        $netTotal = $grossTotal - $tds;

        $paidAmt = $this->db->select_sum('pay_amt')->where('invoice_batchno', $batch_no)->get('invoice_log')->row()->pay_amt ?? 0;
        $balance = $netTotal - $paidAmt;

        $output[] = [
            "sr_no" => $sr++,
            "staff_fullname" => $row['staff_fullname'],
            "state_name" => $row['state_name'],
            "city_name" => $row['city_name'],
            "invoice_number" => $invoice_no->invoice_number ?? '',
            "invoice_date" => date('d.m.Y', strtotime($invoice_no->invoice_date ?? '')),
            "subtotal" => number_format($totalCommissionAmt, 2),
            "cgst" => number_format($cgst, 2),
            "sgst" => number_format($sgst, 2),
            "igst" => number_format($igst, 2),
            "gross_total" => number_format($grossTotal, 2),
            "tds" => number_format($tds, 2),
            "net_total" => number_format($netTotal, 2),
            "payment_date" => date('d.m.Y', strtotime($row['payment_date'])),
            "pay_amt" => number_format($row['pay_amt'], 2),
            "balance" => number_format($balance, 2),
            "ref_no" => $row['bank_details'],
            "remark" => $row['remark'],
            "action" => '<a href="' . base_url("Invoice_pdf_hlc/generatePDF/$batch_no") . '" target="_blank"><i class="bi bi-file-earmark-pdf-fill text-danger"></i></a>'
        ];
    }

    return $output;
}

public function count_paid_invoice_hlc($start_date, $end_date, $connector_id) {
    $this->db->from("invoice_log il");
    $this->db->join("mst_staff s", "s.staff_id = il.connector_id");
    $this->db->where("il.invoice_type", "inv_hlc");
    $this->db->where_in("il.status", ['paid', 'partly paid', 'excess paid']);
    if ($start_date) $this->db->where("il.payment_date >=", $start_date);
    if ($end_date) $this->db->where("il.payment_date <=", date('Y-m-d', strtotime($end_date . ' +1 day')));
    if ($connector_id) $this->db->where("il.connector_id", $connector_id);
    if ($this->session->userdata('staff_type') != 0) {
        $this->db->where('il.connector_id', $this->session->userdata('staff_id'));
    }

    return $this->db->count_all_results();
}






  public function get_user_details_by_los_id($los_id) {
        $this->db->select('*');
        $this->db->from('mst_user');  
        $this->db->where('los_id', $los_id);
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return null;
        }
    }
    
    
public function get_user_details_by_los_id_multi_year($los_id){
    $CI =& get_instance();
    $CI->load->helper('multiyeardb');
    $db_list = load_all_financial_year_dbs();

    foreach ($db_list as $year => $db_group) {
        $db_instance = $CI->load->database($db_group, TRUE);
        $query = $db_instance->select('*')
            ->from('mst_user')
            ->where('los_id', $los_id)
            ->get();

        if ($query->num_rows() > 0) {
            $data = $query->row();

            // calculate financial year from disb_date
            $disb_date = $data->disb_date;
            $calculated_year = get_financial_year_from_disb_date($disb_date);
            $data->financial_year = $calculated_year;

            return $data;
        }
    }
    return null;
}




    
    public function is_duplicate_rr_cbs_acct_no($rr_cbs_acct_no) {
        $this->db->from('mst_user');  // Adjust table name accordingly
        $this->db->where('rr_cbs_acct_no', $rr_cbs_acct_no);
        $this->db->or_where('bank_acct_no', $rr_cbs_acct_no);
        $query = $this->db->get();

        return $query->num_rows() > 0;
    }




 function get_split_payment_data($conn_id) {
    $this->db->select('split_payment.*, mst_staff.staff_fullname');
    $this->db->from('split_payment');
    $this->db->join('mst_staff', 'split_payment.connector_id = mst_staff.staff_id');
   

    if (!empty($conn_id)) {
        $this->db->where('connector_id', $conn_id);
    }

    // Check staff_type from the session
    $staff_type = $this->session->userdata('staff_type');
    if ($staff_type == 1) {
        // If staff_type is 1, limit the data to the current staff
        $current_staff_id = $this->session->userdata('staff_id');
        $this->db->where('split_payment.connector_id', $current_staff_id);
    }
    
    $this->db->order_by('split_payment.add_date', 'desc');

    $query = $this->db->get();
    //echo $this->db->last_query(); die;
    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return array();
    }
}

public function get_roles_with_permissions() {
    
// Step 1: Fetch all staff with menu_assign
$this->db->select('staff_id, staff_fullname, role_id, menu_assign');
$this->db->from('mst_staff');
$this->db->where('staff_type', 0);
$this->db->order_by('staff_id');
$staff_list = $this->db->get()->result();

$roles = [];

foreach ($staff_list as $staff) {
    // Step 2: Conditional join logic
    $this->db->select('mst_menus.menu_name, mst_menus.id as menu_id, role.role_name, menu_permissions.mainrole_id');
    $this->db->from('menu_permissions');
    $this->db->join('mst_menus', 'menu_permissions.menu_id = mst_menus.id', 'left');
    $this->db->join('role', 'role.id = ' . (int)$staff->role_id, 'left');

    // rolewise=1 assign menu to staff members otherwise 0 means manual user role assign
    if ($staff->menu_assign == 1) {
        $this->db->where('menu_permissions.mainrole_id', $staff->role_id);
    } else {
        $this->db->where('menu_permissions.role_id', $staff->staff_id);
    }

    $menus = $this->db->get()->result();

    // Step 3: Build result object
    $roles[$staff->staff_id] = (object)[
        'staff_id'       => $staff->staff_id,
        'staff_fullname' => $staff->staff_fullname,
        'menu_assign'    => $staff->menu_assign,
        'role_name'      => $menus[0]->role_name ?? '',      // fallback if no menu
        'mainrole_id'    => $menus[0]->mainrole_id ?? null,  // fallback if no menu
        'permissions'    => []
    ];

    foreach ($menus as $menu) {
        if (!empty($menu->menu_name)) {
            $roles[$staff->staff_id]->permissions[] = (object)[
                'menu_name' => $menu->menu_name,
                'menu_id'   => $menu->menu_id
            ];
        }
    }
}

return $roles;
}

/*public function get_roles_with_permissions() {
    $this->db->select('mst_staff.staff_id, mst_staff.staff_fullname, mst_menus.menu_name, mst_menus.id as menu_id, role.role_name');
    $this->db->from('mst_staff');
    $this->db->join('menu_permissions', 'mst_staff.staff_id = menu_permissions.role_id', 'left');
    $this->db->join('mst_menus', 'menu_permissions.menu_id = mst_menus.id', 'left');
    $this->db->join('role', 'mst_staff.role_id = role.id', 'left');
    $this->db->where('mst_staff.staff_type', 0);
    $this->db->order_by('mst_staff.staff_id');
    $query = $this->db->get();
    
    $roles = [];
    foreach ($query->result() as $row) {
        if (!isset($roles[$row->staff_id])) {
            $roles[$row->staff_id] = (object)[
                'staff_fullname' => $row->staff_fullname,
                'role_name' => $row->role_name,
                'staff_id' => $row->staff_id,
                'permissions' => []
            ];
        }
        if (!empty($row->menu_name)) {
            $roles[$row->staff_id]->permissions[] = (object)['menu_name' => $row->menu_name, 'menu_id' => $row->menu_id];
        }
    }

    return $roles;
}*/

public function get_main_roles_with_permissions($mainrole_id = '') {
    $this->db->select('role.id as mainrole_id, role.role_name, mst_menus.id as menu_id, mst_menus.menu_name');
    $this->db->from('role');
    $this->db->join('menu_permissions', 'menu_permissions.mainrole_id = role.id', 'left');
    $this->db->join('mst_menus', 'menu_permissions.menu_id = mst_menus.id', 'left');
    $this->db->order_by('role.id');
    $query = $this->db->get();
   

    $roles = [];
    foreach ($query->result() as $row) {
        if (!isset($roles[$row->mainrole_id])) {
            $roles[$row->mainrole_id] = (object)[
                'mainrole_id' => $row->mainrole_id,
                'role_name' => $row->role_name,
                'permissions' => []
            ];
        }
        if (!empty($row->menu_name)) {
            $roles[$row->mainrole_id]->permissions[] = (object)[
                'menu_name' => $row->menu_name,
                'menu_id' => $row->menu_id
            ];
        }
    }

    return $roles;
}

/*public function get_main_roles_with_permissions() {
    $this->db->select('role.id as mainrole_id, role.role_name, mst_menus.id as menu_id, mst_menus.menu_name');
    $this->db->from('role');
    $this->db->join('menu_role_permissions', 'menu_role_permissions.mainrole_id = role.id', 'left');
    $this->db->join('mst_menus', 'menu_role_permissions.menu_id = mst_menus.id', 'left');
    $this->db->order_by('role.id');
    $query = $this->db->get();

    $roles = [];
    foreach ($query->result() as $row) {
        if (!isset($roles[$row->mainrole_id])) {
            $roles[$row->mainrole_id] = (object)[
                'mainrole_id' => $row->mainrole_id,
                'role_name' => $row->role_name,
                'permissions' => []
            ];
        }
        if (!empty($row->menu_name)) {
            $roles[$row->mainrole_id]->permissions[] = (object)[
                'menu_name' => $row->menu_name,
                'menu_id' => $row->menu_id
            ];
        }
    }

    return $roles;
}*/

public function get_permissions_by_user($user_id,$role) {
    // Userwise menu access
    if($role['menu_assign'] == 0) {
            $this->db->select('mst_menus.menu_name');
            $this->db->from('menu_permissions');
            $this->db->join('mst_menus', 'menu_permissions.menu_id = mst_menus.id');
            $this->db->where('menu_permissions.role_id', $user_id);
            $query = $this->db->get();
            return array_column($query->result_array(), 'menu_name');
        }
    // Main Rolewise menu access    
    else if($role['menu_assign'] == 1){
            $this->db->select('mst_menus.menu_name');
            $this->db->from('menu_permissions');
            $this->db->join('mst_menus', 'menu_permissions.menu_id = mst_menus.id');
            $this->db->where('menu_permissions.mainrole_id', $role['mainrole_id']);
            $query = $this->db->get();
            return array_column($query->result_array(), 'menu_name');
        }
    }

/*public function get_permissions_by_user_BKP($user_id) {
        $this->db->select('mst_menus.menu_name');
        $this->db->from('menu_permissions');
        $this->db->join('mst_menus', 'menu_permissions.menu_id = mst_menus.id');
        $this->db->where('menu_permissions.role_id', $user_id);
        $query = $this->db->get();
        return array_column($query->result_array(), 'menu_name');
    }
*/


public function get_invoice_rbo_list($inv_batch) {
    // Subquery to get the branch CNF (invoice_number) using branch_invoice_id
    $this->db->select('invoices.inv_batchno,
                      invoices.invoice_number,
                      invoices.user_id,
                      invoices.invoice_type,
                      invoices.invoice_date,
                      invoices.commission_amt,
                      branch.branch_name, 
                      branch.branch_code,
                      mst_user.user_name,
                      mst_user.disb_date,
                      mst_user.sanction_amt,
                      mst_user.rinnraksha_amt,
                      mst_user.bank_acct_no,
                      mst_user.rr_cbs_acct_no,
                      mst_user.los_id,
                      mst_user.loan_type_id,
                      mst_user.branch_id,
                      mst_user.commi_slab,
                      mst_user.sbi_commi,
                      (SELECT inv.invoice_number FROM invoices inv WHERE inv.id = mst_user.branch_invoice_id) as branch_cnf,
                      mst_loan_type.name as account_type');
    $this->db->from('invoices');
    $this->db->join('mst_user', 'invoices.user_id = mst_user.id', 'left');
    $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id', 'left');
    $this->db->where('invoices.inv_batchno', $inv_batch);
    $query = $this->db->get();
    
    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return array();
    }
}



public function get_invoice_pb_list($inv_batch) {
    
    $this->db->select('invoices.inv_batchno,
                      invoices.invoice_number,
                      invoices.user_id,
                      invoices.invoice_type,
                      invoices.invoice_date,
                      invoices.commission_amt,
                      branch.branch_name, 
                      branch.branch_code,
                      mst_user.user_name,
                      mst_user.disb_date,
                      mst_user.sanction_amt,
                      mst_user.rinnraksha_amt,
                      mst_user.bank_acct_no,
                      mst_user.rr_cbs_acct_no,
                      mst_user.los_id,
                      mst_user.loan_type_id,
                      mst_user.login_code,
                      mst_user.branch_id,
                      mst_user.commi_slab,
                      mst_user.sbi_commi,
                      mst_user.pb_commi,
                      mst_rbo.rbo_name,
                      mst_loan_type.name as account_type,
                      mst_city.agency_code,  
                      mst_city.agency_name,  
                      mst_city.city_name');  

    $this->db->from('invoices');
    $this->db->join('mst_user', 'invoices.user_id = mst_user.id', 'left');
    $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
    $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id', 'left');
    $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');  // Join mst_city based on branch.city_id

    $this->db->where('invoices.inv_batchno', $inv_batch);
    $this->db->order_by('mst_user.disb_date', 'ASC');
    $query = $this->db->get();
    
    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return array();
    }
}


public function get_invoice_pb_applicant_list($filters = []) {
    $this->db->select('branch.branch_name, 
                      branch.branch_code,
                      mst_user.user_name,
                      mst_user.disb_date,
                      mst_user.sanction_amt,
                      mst_user.rinnraksha_amt,
                      mst_user.bank_acct_no,
                      mst_user.rr_cbs_acct_no,
                      mst_user.los_id,
                      mst_user.status,
                      mst_user.loan_type_id,
                      mst_user.branch_id,
                      mst_user.commi_slab,
                      mst_user.sbi_commi,
                      mst_user.pb_commi,
                      mst_user.sbi_pb_invoice_no,
                      mst_user.sbi_pb_payment_status,
                      mst_user.invoice_id,
                      mst_user.id,
                      mst_user.hlc_payment_status,
                      mst_user.part_payout,
                      mst_user.pb_payment_status,
                      mst_user.add_date,
                      mst_user.connector_id,
                      mst_user.verify_by,
                      mst_user.is_verify,
                      mst_user.pb_genrated,
                      mst_user.pb_invoice_id,
                      mst_user.applicant_invoice_status,
                      mst_user.login_code,
                      mst_rbo.rbo_name,
                      mst_loan_type.name as account_type,
                      mst_city.city_name,
                      mst_city.agency_code,
                      mst_city.agency_name,
                      mst_state.state_name,
                      mst_staff.staff_fullname, 
                      mst_staff.conn_commision, 
                      mst_staff.hlc_code'); // Add more fields as needed

    $this->db->from('mst_user');
    $this->db->join('branch', 'mst_user.branch_id = branch.id','left');
    $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
    $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
    $this->db->join('mst_state', 'mst_city.state_id = mst_state.id');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');  // Join with mst_staff table

    $this->db->where('mst_user.login_code', 'PaisaBazaar');
    $this->db->where('mst_user.is_archive', 'No');
    
    if (!empty($filters['start_date'])) {
        $this->db->where('mst_user.disb_date >=', $filters['start_date']);
    }
    if (!empty($filters['end_date'])) {
        $this->db->where('mst_user.disb_date <=', $filters['end_date']);
    }

    // Example: Branch
    if (!empty($filters['branch'])) {
        $this->db->where('mst_user.branch_id', $filters['branch']);
    }

    // Example: Connector
    if (!empty($filters['connector'])) {
        $this->db->where('mst_user.connector_id', $filters['connector']);
    }

    // Example: Payment status (if you want to override the default statuses)
    if (!empty($filters['hlc_status'])) {
        // If you need multiple statuses, use where_in(); if single, do a normal where:
        $this->db->where('mst_user.hlc_payment_status', $filters['hlc_status']);
    }

    // Example: State or city
    if (!empty($filters['state_id'])) {
        $this->db->where('mst_state.id', $filters['state_id']);
    }
    if (!empty($filters['city_id'])) {
        $this->db->where('mst_city.id', $filters['city_id']);
    }

    // Example: Disb month
    // "YYYY-MM" -> from the 1st to the last day of that month
    if (!empty($filters['disb_month'])) {
        $firstOfMonth = $filters['disb_month'] . '-01';
        $lastOfMonth = date('Y-m-t', strtotime($firstOfMonth));
        $this->db->where('mst_user.disb_date >=', $firstOfMonth);
        $this->db->where('mst_user.disb_date <=', $lastOfMonth);
    }
    
    $query = $this->db->get();
    
    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return array();
    }
}



/*public function get_monthly_case_counts() {
    // Calculate the financial year range dynamically
    $currentMonth = date('m');
    $currentYear = date('Y');

    if ($currentMonth >= 4) {
        $financialYearStart = $currentYear . '-04-01'; // Start of financial year
        $financialYearEnd = ($currentYear + 1) . '-03-31'; // End of financial year
    } else {
        $financialYearStart = ($currentYear - 1) . '-04-01'; // Start of financial year
        $financialYearEnd = $currentYear . '-03-31'; // End of financial year
    }

    // Building the query with conditional logic for totals
    $this->db->select("
        MONTHNAME(mst_user.disb_date) AS month_name, 
        COUNT(mst_user.id) AS total_cases, 
        SUM(IF(mst_user.loan_type_id = 5, mst_user.rinnraksha_amt, mst_user.sanction_amt)) AS total_sanctioned,
        SUM(
            IF(
                mst_user.loan_type_id = 4,
                (IF(mst_user.loan_type_id = 5, mst_user.rinnraksha_amt, mst_user.sanction_amt)) * (0.20 / 100),
                (IF(mst_user.loan_type_id = 5, mst_user.rinnraksha_amt, mst_user.sanction_amt)) * (mst_user.part_payout / 100)
            )
        ) AS total_partner_payout,
        SUM(
            IF(mst_user.loan_type_id = 5, 
                (mst_user.rinnraksha_amt * 0.95 / 100),
                (mst_user.sanction_amt * 0.95 / 100) 
            )
        ) AS total_pb_remuneration,
        SUM(
            IF(mst_user.hlc_payment_status IS NOT NULL, 
                IF(mst_user.loan_type_id = 5, 
                    mst_user.rinnraksha_amt, 
                    mst_user.sanction_amt
                ) * (mst_user.part_payout / 100), 
                0
            )
        ) AS total_partner_paid_amt,
        SUM(
            IF(mst_user.pb_payment_status = 'paid', 
                IF(mst_user.loan_type_id = 5, 
                    mst_user.rinnraksha_amt, 
                    mst_user.sanction_amt
                ) * ( 0.95 / 100), 
                0
            )
        ) AS total_pb_paid_amt,
        SUM(
            IF(
                mst_user.hlc_payment_status = 'paid' AND mst_user.pb_payment_status IS NULL,
                IF(mst_user.loan_type_id = 5, 
                    mst_user.rinnraksha_amt, 
                    mst_user.sanction_amt
                ) * ( 0.95 / 100), 
                0
            )
        ) AS total_partner_paid_but_pb_not
    ");
    $this->db->from('mst_user');
    $this->db->join('mst_staff', 'mst_staff.staff_id = mst_user.connector_id', 'left');  // Joining with mst_staff
    $this->db->where('mst_user.disb_date >=', $financialYearStart);
    $this->db->where('mst_user.disb_date <=', $financialYearEnd);
    $this->db->where('mst_user.login_code', 'PaisaBazaar');
    $this->db->where('mst_user.status', 'Disb Case');
    $this->db->where('mst_user.is_archive', 'No');
    $this->db->where('mst_user.disb_date IS NOT NULL', null, false); // Filtering for PaisaBazaar
    $this->db->group_by('MONTH(mst_user.disb_date)');
    $this->db->order_by('MONTH(mst_user.disb_date)', 'ASC');
    
    $query = $this->db->get(); // Execute the query
    return $query->result();   // Return the result set
}*/



public function get_monthly_case_counts($financialYearStart, $financialYearEnd) {
    // Building the query with conditional logic for totals
    $this->db->select("
        MONTHNAME(mst_user.disb_date) AS month_name, 
        COUNT(mst_user.id) AS total_cases, 
        SUM(IF(mst_user.loan_type_id = 5, mst_user.rinnraksha_amt, mst_user.sanction_amt)) AS total_sanctioned,
        SUM(
            IF(
                mst_user.loan_type_id = 4,
                (IF(mst_user.loan_type_id = 5, mst_user.rinnraksha_amt, mst_user.sanction_amt)) * (0.20 / 100),
                (IF(mst_user.loan_type_id = 5, mst_user.rinnraksha_amt, mst_user.sanction_amt)) * (mst_user.part_payout / 100)
            )
        ) AS total_partner_payout,
        SUM(
            IF(mst_user.loan_type_id = 5, 
                (mst_user.rinnraksha_amt * 0.95 / 100),
                (mst_user.sanction_amt * 0.95 / 100) 
            )
        ) AS total_pb_remuneration,
        SUM(
            IF(mst_user.hlc_payment_status IS NOT NULL, 
                IF(mst_user.loan_type_id = 5, 
                    mst_user.rinnraksha_amt, 
                    mst_user.sanction_amt
                ) * (mst_user.part_payout / 100), 
                0
            )
        ) AS total_partner_paid_amt,
        SUM(
    IF(
        mst_user.pb_payment_status IN ('paid', 'partly paid'),
        IF(
            mst_user.loan_type_id = 5,
            mst_user.rinnraksha_amt * (0.95 / 100),
            mst_user.sanction_amt * (0.95 / 100)
        ),
        0
    )
) AS total_pb_paid_amt,

        SUM(
            IF(
                mst_user.hlc_payment_status = 'paid' AND mst_user.pb_payment_status IS NULL,
                IF(mst_user.loan_type_id = 5, 
                    mst_user.rinnraksha_amt, 
                    mst_user.sanction_amt
                ) * ( 0.95 / 100), 
                0
            )
        ) AS total_partner_paid_but_pb_not
    ");
    $this->db->from('mst_user');
    $this->db->join('mst_staff', 'mst_staff.staff_id = mst_user.connector_id', 'left');
    $this->db->where('mst_user.disb_date >=', $financialYearStart);
    $this->db->where('mst_user.disb_date <=', $financialYearEnd);
    $this->db->where('mst_user.login_code', 'PaisaBazaar');
    $this->db->where('mst_user.status', 'Disb Case');
    $this->db->where('mst_user.is_archive', 'No');
    $this->db->where('mst_user.disb_date IS NOT NULL', null, false);
    $this->db->group_by('MONTH(mst_user.disb_date)');
    $this->db->order_by('MONTH(mst_user.disb_date)', 'ASC');

    $query = $this->db->get();
    return $query->result();
}




/*public function get_monthly_rbo_cases_data() {
    $this->db->select("
        mst_rbo.rbo_name, 
        MONTHNAME(mst_user.disb_date) AS month_name, 
        SUM(IF(mst_user.loan_type_id = 5, mst_user.rinnraksha_amt, mst_user.sanction_amt)
        )
        AS total_disb_loan_amt,
        SUM(
            IF(mst_user.loan_type_id = 5, 
                mst_user.rinnraksha_amt, 
                mst_user.sanction_amt
            ) * (mst_staff.conn_commision / 100)
        ) AS total_partner_payout_rbo,
        SUM(
            IF(mst_user.loan_type_id = 5, 
                mst_user.rinnraksha_amt, 
                mst_user.sanction_amt
            ) * (mst_user.sbi_commi / 100)
        ) AS total_sbi_commi_amt,
        SUM(
            IF(
                mst_user.sbi_payment_status = 'paid', 
                IF(mst_user.loan_type_id = 5, 
                    mst_user.rinnraksha_amt, 
                    mst_user.sanction_amt
                ) * (mst_user.sbi_commi / 100) * 0.9, 
                0
            )
        ) AS total_sbi_paid_amt
    ");
    $this->db->from('mst_user');
    $this->db->join('branch', 'branch.id = mst_user.branch_id'); 
    $this->db->join('mst_rbo', 'mst_rbo.id = branch.rbo_id'); 
    $this->db->join('mst_staff', 'mst_staff.staff_id = mst_user.connector_id', 'left'); 
    $this->db->where('YEAR(mst_user.disb_date)', 'YEAR(CURDATE())', FALSE);
    $this->db->where('mst_user.login_code', 'Mortgagebuddy');  
    $this->db->group_by('mst_rbo.id, MONTH(mst_user.disb_date)');
    $this->db->order_by('MONTH(mst_user.disb_date)', 'ASC');
    
    $query = $this->db->get(); // Execute the query
    return $query->result();   // Return the result set
}*/



public function get_rbo_cases_data_monthly() {
    $this->db->select("
        mst_rbo.rbo_name, 
        MONTHNAME(mst_user.disb_date) AS month_name, 
        SUM(
            IF(mst_user.loan_type_id = 5, mst_user.rinnraksha_amt, mst_user.sanction_amt)
        ) AS total_disb_loan_amt,
        SUM(
            IF(
                mst_user.loan_type_id = 4,
                (IF(mst_user.loan_type_id = 5, mst_user.rinnraksha_amt, mst_user.sanction_amt)) * (0.20 / 100),
                (IF(mst_user.loan_type_id = 5, mst_user.rinnraksha_amt, mst_user.sanction_amt)) * (mst_user.part_payout / 100)
            )
        ) AS total_partner_payout_rbo,
        SUM(
            IF(
                mst_user.loan_type_id = 5,
                mst_user.rinnraksha_amt,
                mst_user.sanction_amt
            ) * (mst_user.sbi_commi / 100)
        ) AS total_sbi_commi_amt,
        SUM(
            IF(
                mst_user.sbi_payment_status IN ('paid', 'partly paid', 'excess paid'),
                IF(mst_user.loan_type_id = 5, 
                    mst_user.rinnraksha_amt, 
                    mst_user.sanction_amt
                ) * (mst_user.sbi_commi / 100) * 0.9, 
                0
            )
        ) AS total_sbi_paid_amt
    ");
    $this->db->from('mst_user');
    $this->db->join('branch', 'branch.id = mst_user.branch_id'); 
    $this->db->join('mst_rbo', 'mst_rbo.id = branch.rbo_id'); 
    $this->db->join('mst_staff', 'mst_staff.staff_id = mst_user.connector_id', 'left'); 
    $this->db->where('YEAR(mst_user.disb_date)', 'YEAR(CURDATE())', FALSE);
    $this->db->where('mst_user.is_archive', 'No');
    $this->db->where('mst_user.login_code', 'Mortgagebuddy');  
    $this->db->group_by('mst_rbo.id, MONTH(mst_user.disb_date)');
    $this->db->order_by('MONTH(mst_user.disb_date)', 'ASC');
    
    $query = $this->db->get(); // Execute the query
    return $query->result();   // Return the result set
}



public function get_monthly_rbo_cases_data() {
    // Get financial year from session
    $fy = $this->session->userdata('financial_year'); // e.g., '24-25'

    // Default to current financial year if session not set
    if (!$fy) {
        $currentMonth = date('m');
        $currentYear = date('Y');

        if ($currentMonth >= 4) {
            $financialYearStart = $currentYear . '-04-01';
            $financialYearEnd = ($currentYear + 1) . '-03-31';
        } else {
            $financialYearStart = ($currentYear - 1) . '-04-01';
            $financialYearEnd = $currentYear . '-03-31';
        }
    } else {
        // Set based on session value
        if ($fy == '24-25') {
            $financialYearStart = '2024-04-01';
            $financialYearEnd = '2025-03-31';
        } elseif ($fy == '25-26') {
            $financialYearStart = '2025-04-01';
            $financialYearEnd = '2026-03-31';
        } else {
            // Default fallback
            $financialYearStart = '2024-04-01';
            $financialYearEnd = '2025-03-31';
        }
    }

    // Query as before
    $this->db->select("
        mst_rbo.rbo_name, 
        MONTHNAME(mst_user.disb_date) AS month_name, 
        SUM(
            IF(mst_user.loan_type_id = 5, mst_user.rinnraksha_amt, mst_user.sanction_amt)
        ) AS total_disb_loan_amt,
        SUM(
            IF(
                mst_user.loan_type_id = 4,
                (IF(mst_user.loan_type_id = 5, mst_user.rinnraksha_amt, mst_user.sanction_amt)) * (0.20 / 100),
                (IF(mst_user.loan_type_id = 5, mst_user.rinnraksha_amt, mst_user.sanction_amt)) * (mst_user.part_payout / 100)
            )
        ) AS total_partner_payout_rbo,
        SUM(
            IF(
                mst_user.loan_type_id = 5,
                mst_user.rinnraksha_amt,
                mst_user.sanction_amt
            ) * (mst_user.sbi_commi / 100)
        ) AS total_sbi_commi_amt
    ");
    $this->db->from('mst_user');
    $this->db->join('branch', 'branch.id = mst_user.branch_id');
    $this->db->join('mst_rbo', 'mst_rbo.id = branch.rbo_id');
    $this->db->join('mst_staff', 'mst_staff.staff_id = mst_user.connector_id');
    $this->db->where('mst_user.disb_date IS NOT NULL', null, false);
    //$this->db->where('mst_user.status', 'Disb Case');
    $this->db->where('mst_user.is_archive', 'No');
    $this->db->where('mst_user.disb_date >=', $financialYearStart);
    $this->db->where('mst_user.disb_date <=', $financialYearEnd);
    $this->db->where('mst_user.login_code', 'Mortgagebuddy');
    $this->db->group_by(['mst_rbo.id', 'MONTH(mst_user.disb_date)']);
    $this->db->order_by('MONTH(mst_user.disb_date)', 'ASC');

    return $this->db->get()->result();
}




/*public function get_monthly_rbo_cases_data() {
    // Determine the financial year start and end
    $currentMonth = date('m');
    $currentYear = date('Y');

    if ($currentMonth >= 4) {
        $financialYearStart = $currentYear . '-04-01';
        $financialYearEnd = ($currentYear + 1) . '-03-31';
    } else {
        $financialYearStart = ($currentYear - 1) . '-04-01';
        $financialYearEnd = $currentYear . '-03-31';
    }

    // Build the query
    $this->db->select("
        mst_rbo.rbo_name, 
        MONTHNAME(mst_user.disb_date) AS month_name, 
        SUM(
            IF(mst_user.loan_type_id = 5, mst_user.rinnraksha_amt, mst_user.sanction_amt)
        ) AS total_disb_loan_amt,
        SUM(
            IF(
                mst_user.loan_type_id = 4,
                (IF(mst_user.loan_type_id = 5, mst_user.rinnraksha_amt, mst_user.sanction_amt)) * (0.20 / 100),
                (IF(mst_user.loan_type_id = 5, mst_user.rinnraksha_amt, mst_user.sanction_amt)) * (mst_user.part_payout / 100)
            )
        ) AS total_partner_payout_rbo,
        SUM(
            IF(
                mst_user.loan_type_id = 5,
                mst_user.rinnraksha_amt,
                mst_user.sanction_amt
            ) * (mst_user.sbi_commi / 100)
        ) AS total_sbi_commi_amt
    ");
    $this->db->from('mst_user');
    $this->db->join('branch', 'branch.id = mst_user.branch_id');
    $this->db->join('mst_rbo', 'mst_rbo.id = branch.rbo_id');
    $this->db->join('mst_staff', 'mst_staff.staff_id = mst_user.connector_id');
    $this->db->where('mst_user.disb_date IS NOT NULL', null, false);
    $this->db->where('mst_user.status', 'Disb Case');
    $this->db->where('mst_user.is_archive', 'No');
    $this->db->where('mst_user.disb_date >=', $financialYearStart);
    $this->db->where('mst_user.disb_date <=', $financialYearEnd);
    $this->db->where('mst_user.login_code', 'Mortgagebuddy');
    $this->db->group_by(['mst_rbo.id', 'MONTH(mst_user.disb_date)']);
    $this->db->order_by('MONTH(mst_user.disb_date)', 'ASC');
    
    $query = $this->db->get(); // Execute the query
    return $query->result();   // Return the result set
}
*/



public function get_invoice_mb_applicant_list() {
    $this->db->select('branch.branch_name, 
                      branch.branch_code,
                      mst_user.user_name,
                      mst_user.disb_date,
                      mst_user.sanction_amt,
                      mst_user.created_by,
                      mst_user.branch_invoice_id,
                      mst_user.sbi_invoice_id,
                      mst_user.branch_genrated,
                      mst_user.sbi_genrated,
                      mst_user.sbi_payment_status,
                      mst_user.rinnraksha_amt,
                      mst_user.bank_acct_no,
                      mst_user.rr_cbs_acct_no,
                      mst_user.los_id,
                      mst_user.status,
                      mst_user.loan_type_id,
                      mst_user.branch_id,
                      mst_user.commi_slab,
                      mst_user.sbi_commi,
                      mst_user.pb_commi,
                      mst_user.sbi_pb_invoice_no,
                      mst_user.sbi_pb_payment_status,
                      mst_user.invoice_id,
                      mst_user.id,
                      mst_user.hlc_payment_status,
                      mst_user.part_payout,
                      mst_user.pb_payment_status,
                      mst_user.add_date,
                      mst_user.connector_id,
                      mst_user.verify_by,
                      mst_user.is_verify,
                      mst_user.pb_genrated,
                      mst_user.pb_invoice_id,
                      mst_user.applicant_invoice_status,
                      mst_user.login_code,
                      mst_rbo.rbo_name,
                      mst_loan_type.name as account_type,
                      mst_city.city_name,
                      mst_city.agency_code,
                      mst_city.agency_name,
                      mst_state.state_name,
                      mst_staff.staff_fullname, 
                      mst_staff.conn_commision, 
                      mst_staff.hlc_code'); // Add more fields as needed

    $this->db->from('mst_user');
    $this->db->join('branch', 'mst_user.branch_id = branch.id','left');
    $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
    $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
    $this->db->join('mst_state', 'mst_city.state_id = mst_state.id');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');  // Join with mst_staff table

    $this->db->where('mst_user.login_code', 'Mortgagebuddy');
    $this->db->where('mst_user.is_archive', 'No');
    $query = $this->db->get();
    
    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return array();
    }
}





/*public function get_mb_applicant_hlc_paid_list() {
    $this->db->select('branch.branch_name, 
                      branch.branch_code,
                      mst_user.user_name,
                      mst_user.disb_date,
                      mst_user.sanction_amt,
                      mst_user.created_by,
                      mst_user.branch_invoice_id,
                      mst_user.sbi_invoice_id,
                      mst_user.branch_genrated,
                      mst_user.sbi_genrated,
                      mst_user.sbi_payment_status,
                      mst_user.rinnraksha_amt,
                      mst_user.bank_acct_no,
                      mst_user.rr_cbs_acct_no,
                      mst_user.los_id,
                      mst_user.status,
                      mst_user.loan_type_id,
                      mst_user.branch_id,
                      mst_user.commi_slab,
                      mst_user.sbi_commi,
                      mst_user.pb_commi,
                      mst_user.sbi_pb_invoice_no,
                      mst_user.sbi_pb_payment_status,
                      mst_user.invoice_id,
                      mst_user.id,
                      mst_user.hlc_payment_status,
                      mst_user.part_payout,
                      mst_user.pb_payment_status,
                      mst_user.add_date,
                      mst_user.connector_id,
                      mst_user.verify_by,
                      mst_user.is_verify,
                      mst_user.pb_genrated,
                      mst_user.pb_invoice_id,
                      mst_user.applicant_invoice_status,
                      mst_user.login_code,
                      mst_rbo.rbo_name,
                      mst_loan_type.name as account_type,
                      mst_city.city_name,
                      mst_city.agency_code,
                      mst_city.agency_name,
                      mst_state.state_name,
                      mst_staff.staff_fullname, 
                      mst_staff.state_id as conn_state, 
                      mst_staff.gst_no, 
                      mst_staff.conn_commision, 
                      mst_staff.hlc_code'); 

    $this->db->from('mst_user');
    $this->db->join('branch', 'mst_user.branch_id = branch.id','left');
    $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
    $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
    $this->db->join('mst_state', 'mst_city.state_id = mst_state.id');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id'); 

    $this->db->where('mst_user.login_code', 'Mortgagebuddy');
    $this->db->where_in('mst_user.hlc_payment_status', ['paid', 'excess paid', 'partly paid']);
    $this->db->where('mst_user.is_archive', 'No');
    //$this->db->limit(100);
    $query = $this->db->get();
    
    if ($query->num_rows() > 0) {
        return $query->result_array();
    } else {
        return array();
    }
}
*/

/*public function get_mb_applicant_hlc_paid_list($filters = [])
{
    $this->db->select('
        branch.branch_name, 
        branch.branch_code,
        mst_user.user_name,
        mst_user.disb_date,
        mst_user.sanction_amt,
        mst_user.created_by,
        mst_user.branch_invoice_id,
        mst_user.sbi_invoice_id,
        mst_user.branch_genrated,
        mst_user.sbi_genrated,
        mst_user.sbi_payment_status,
        mst_user.rinnraksha_amt,
        mst_user.bank_acct_no,
        mst_user.rr_cbs_acct_no,
        mst_user.los_id,
        mst_user.status,
        mst_user.loan_type_id,
        mst_user.branch_id,
        mst_user.commi_slab,
        mst_user.sbi_commi,
        mst_user.pb_commi,
        mst_user.sbi_pb_invoice_no,
        mst_user.sbi_pb_payment_status,
        mst_user.invoice_id,
        mst_user.id,
        mst_user.hlc_payment_status,
        mst_user.part_payout,
        mst_user.pb_payment_status,
        mst_user.add_date,
        mst_user.connector_id,
        mst_user.verify_by,
        mst_user.is_verify,
        mst_user.pb_genrated,
        mst_user.pb_invoice_id,
        mst_user.applicant_invoice_status,
        mst_user.login_code,
        mst_rbo.rbo_name,
        mst_loan_type.name as account_type,
        mst_city.city_name,
        mst_city.agency_code,
        mst_city.agency_name,
        mst_state.state_name,
        mst_staff.staff_fullname,
        mst_staff.state_id as conn_state,
        mst_staff.gst_no,
        mst_staff.conn_commision,
        mst_staff.hlc_code
    ');
    $this->db->from('mst_user');
    $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
    $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
    $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
    $this->db->join('mst_state', 'mst_city.state_id = mst_state.id');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');

    // Already present conditions:
    //$this->db->where('mst_user.login_code', 'Mortgagebuddy');
    $this->db->where_in('mst_user.hlc_payment_status', ['paid', 'excess paid', 'partly paid']);
    $this->db->where('mst_user.is_archive', 'No');

    // Now apply optional filters if present:
    // Example: Start date & End date (assuming these are for disb_date)
    if (!empty($filters['start_date'])) {
        $this->db->where('mst_user.disb_date >=', $filters['start_date']);
    }
    if (!empty($filters['end_date'])) {
        $this->db->where('mst_user.disb_date <=', $filters['end_date']);
    }

    // Example: Branch
    if (!empty($filters['branch'])) {
        $this->db->where('mst_user.branch_id', $filters['branch']);
    }

    // Example: Connector
    if (!empty($filters['connector'])) {
        $this->db->where('mst_user.connector_id', $filters['connector']);
    }

    // Example: Payment status (if you want to override the default statuses)
    if (!empty($filters['hlc_status'])) {
    if (is_array($filters['hlc_status'])) {
        $this->db->where_in('mst_user.hlc_payment_status', $filters['hlc_status']);
    } else {
        $this->db->where('mst_user.hlc_payment_status', $filters['hlc_status']);
    }
}

    // Example: State or city
    if (!empty($filters['state_id'])) {
        $this->db->where('mst_state.id', $filters['state_id']);
    }
    if (!empty($filters['city_id'])) {
        $this->db->where('mst_city.id', $filters['city_id']);
    }

    // Example: Disb month
    // "YYYY-MM" -> from the 1st to the last day of that month
    if (!empty($filters['disb_month'])) {
        $firstOfMonth = $filters['disb_month'] . '-01';
        $lastOfMonth = date('Y-m-t', strtotime($firstOfMonth));
        $this->db->where('mst_user.disb_date >=', $firstOfMonth);
        $this->db->where('mst_user.disb_date <=', $lastOfMonth);
    }

    if (!empty($filters['payment_month_hlc'])) {
    // Join invoice_log with invoices using the appropriate key (here assumed to be the batch number)
    $this->db->join('invoices', 'invoices.id = mst_user.invoice_id', 'left');
    $this->db->join('invoice_log', 'invoice_log.invoice_batchno = invoices.inv_batchno', 'left');

    // Build date range for the selected month
    $firstPayMonth = $filters['payment_month_hlc'] . '-01';
    $lastPayMonth  = date('Y-m-t', strtotime($firstPayMonth));

    // Apply the where conditions based on the payment_date from invoice_log
    $this->db->where('invoice_log.payment_date >=', $firstPayMonth);
    $this->db->where('invoice_log.payment_date <=', $lastPayMonth);
    $this->db->order_by('invoice_log.payment_date', 'asc');
}


    $query = $this->db->get();
    return $query->result_array();
}*/



public function get_mb_applicant_hlc_paid_list($filters = [])
{
    $this->db->select('
        branch.branch_name, 
        branch.branch_code,
        mst_user.user_name,
        mst_user.disb_date,
        mst_user.sanction_amt,
        mst_user.created_by,
        mst_user.branch_invoice_id,
        mst_user.sbi_invoice_id,
        mst_user.branch_genrated,
        mst_user.sbi_genrated,
        mst_user.sbi_payment_status,
        mst_user.rinnraksha_amt,
        mst_user.bank_acct_no,
        mst_user.rr_cbs_acct_no,
        mst_user.los_id,
        mst_user.status,
        mst_user.loan_type_id,
        mst_user.branch_id,
        mst_user.commi_slab,
        mst_user.sbi_commi,
        mst_user.pb_commi,
        mst_user.sbi_pb_invoice_no,
        mst_user.sbi_pb_payment_status,
        mst_user.invoice_id,
        mst_user.id,
        mst_user.hlc_payment_status,
        mst_user.part_payout,
        mst_user.pb_payment_status,
        mst_user.add_date,
        mst_user.connector_id,
        mst_user.verify_by,
        mst_user.is_verify,
        mst_user.pb_genrated,
        mst_user.pb_invoice_id,
        mst_user.applicant_invoice_status,
        mst_user.login_code,
        mst_rbo.rbo_name,
        mst_loan_type.name as account_type,
        mst_city.city_name,
        mst_city.agency_code,
        mst_city.agency_name,
        mst_state.state_name,
        mst_staff.staff_fullname,
        mst_staff.state_id as conn_state,
        mst_staff.gst_no,
        mst_staff.conn_commision,
        mst_staff.hlc_code
    ');
    $this->db->from('mst_user');
    $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
    $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
    $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
    $this->db->join('mst_state', 'mst_city.state_id = mst_state.id');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');

    // ✅ HLC Payment Status filter (default + override)
    if (empty($filters['hlc_status'])) {
        $this->db->where_in('mst_user.hlc_payment_status', ['paid', 'excess paid', 'partly paid']);
    } else {
        if (is_array($filters['hlc_status'])) {
            $this->db->where_in('mst_user.hlc_payment_status', $filters['hlc_status']);
        } else {
            $this->db->where('mst_user.hlc_payment_status', $filters['hlc_status']);
        }
    }

    // Common condition
    $this->db->where('mst_user.is_archive', 'No');

    // Optional filters
    if (!empty($filters['start_date'])) {
        $this->db->where('mst_user.disb_date >=', $filters['start_date']);
    }
    if (!empty($filters['end_date'])) {
        $this->db->where('mst_user.disb_date <=', $filters['end_date']);
    }

    if (!empty($filters['branch'])) {
        $this->db->where('mst_user.branch_id', $filters['branch']);
    }

    if (!empty($filters['connector'])) {
        $this->db->where('mst_user.connector_id', $filters['connector']);
    }

    if (!empty($filters['state_id'])) {
        $this->db->where('mst_state.id', $filters['state_id']);
    }
    if (!empty($filters['city_id'])) {
        $this->db->where('mst_city.id', $filters['city_id']);
    }

    if (!empty($filters['disb_month'])) {
        $firstOfMonth = $filters['disb_month'] . '-01';
        $lastOfMonth = date('Y-m-t', strtotime($firstOfMonth));
        $this->db->where('mst_user.disb_date >=', $firstOfMonth);
        $this->db->where('mst_user.disb_date <=', $lastOfMonth);
    }

    if (!empty($filters['payment_month_hlc'])) {
        $this->db->join('invoices', 'invoices.id = mst_user.invoice_id', 'left');
        $this->db->join('invoice_log', 'invoice_log.invoice_batchno = invoices.inv_batchno', 'left');

        $firstPayMonth = $filters['payment_month_hlc'] . '-01';
        $lastPayMonth  = date('Y-m-t', strtotime($firstPayMonth));

        $this->db->where('invoice_log.payment_date >=', $firstPayMonth);
        $this->db->where('invoice_log.payment_date <=', $lastPayMonth);
        $this->db->order_by('invoice_log.payment_date', 'asc');
    }

    $query = $this->db->get();
    return $query->result_array();
}


public function get_applicant_rows_for_export(array $applicantIds, array $filters = [])
{
    if (empty($applicantIds)) return [];

    $this->db->select('
        branch.branch_name, 
        branch.branch_code,
        mst_user.user_name,
        mst_user.disb_date,
        mst_user.sanction_amt,
        mst_user.rinnraksha_amt,
       
        mst_user.los_id,
        mst_user.status,
        mst_user.loan_type_id,
        mst_user.branch_id,
        mst_user.commi_slab,
        mst_user.sbi_commi,
        mst_user.pb_commi,
        mst_user.sbi_pb_invoice_no,
        mst_user.sbi_pb_payment_status,
        mst_user.invoice_id,
        mst_user.id,
        mst_user.hlc_payment_status,
        mst_user.part_payout,
        mst_user.pb_payment_status,
        mst_user.add_date,
        mst_user.connector_id,
        mst_user.verify_by,
        mst_user.is_verify,
        mst_user.pb_genrated,
        mst_user.pb_invoice_id,
        mst_user.applicant_invoice_status,
        mst_user.pbsbi_branch_annx_download_key,
        mst_user.pb_branch_annx_no,
        mst_user.pb_branch_annx_date,
        mst_user.login_code,
        mst_user.pb_to_sbi_remuneration,
        mst_user.sbi_pb_invoice_no,
        mst_user.pb_sbi_invoice_date,
        mst_rbo.rbo_name,
        mst_loan_type.name AS account_type,
        mst_city.city_name,
        mst_city.agency_code,
        mst_city.agency_name,
        mst_state.state_name,
        mst_staff.staff_fullname, 
        mst_staff.conn_commision, 
        mst_staff.hlc_code
    ');
    
    $this->db->select(
    'IF(mst_user.loan_type_id = 5, mst_user.rr_cbs_acct_no, mst_user.bank_acct_no) AS account_no',
    FALSE
   );
   
   $this->db->select(
    'IF(mst_user.loan_type_id = 5, mst_user.rinnraksha_amt, mst_user.sanction_amt) AS loan_limit',
    FALSE
   );
    $this->db->from('mst_user');
    $this->db->join('branch', 'mst_user.branch_id = branch.id','left');
    $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
    $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
    $this->db->join('mst_state', 'mst_city.state_id = mst_state.id');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id','left');

    // Base constraints
    $this->db->where('mst_user.login_code', 'PaisaBazaar');
    $this->db->where('mst_user.is_archive', 'No');

    // Only the requested applicants (per-applicant, no clubbing)
    $this->db->where_in('mst_user.id', $applicantIds);

    // === Optional filters (same as your function) ===
    if (!empty($filters['start_date'])) {
        $this->db->where('mst_user.disb_date >=', $filters['start_date']);
    }
    if (!empty($filters['end_date'])) {
        $this->db->where('mst_user.disb_date <=', $filters['end_date']);
    }
    if (!empty($filters['branch'])) {
        $this->db->where('mst_user.branch_id', $filters['branch']);
    }
    if (!empty($filters['connector'])) {
        $this->db->where('mst_user.connector_id', $filters['connector']);
    }
    if (!empty($filters['hlc_status'])) {
        $this->db->where('mst_user.hlc_payment_status', $filters['hlc_status']);
    }
    if (!empty($filters['state_id'])) {
        $this->db->where('mst_state.id', $filters['state_id']);
    }
    if (!empty($filters['city_id'])) {
        $this->db->where('branch.city_id', $filters['city_id']);
    }
    if (!empty($filters['disb_month'])) {
        $firstOfMonth = $filters['disb_month'] . '-01';
        $lastOfMonth  = date('Y-m-t', strtotime($firstOfMonth));
        $this->db->where('mst_user.disb_date >=', $firstOfMonth);
        $this->db->where('mst_user.disb_date <=', $lastOfMonth);
    }

    
    $this->db->order_by('mst_user.id','ASC');

    $q = $this->db->get();
    return ($q->num_rows() > 0) ? $q->result() : [];
}


    public function mark_downloaded_by_pb_invoice_applicants(array $applicantIds, $batch_key, $user_id = null)
{
    if (empty($applicantIds)) return false;

    $data = [
        'pbsbi_branch_annx_invoice_download_status' => 1,
        'pbsbi_branch_annx_invoice_download_date'   => date('Y-m-d H:i:s'),
        'pbsbi_branch_annx_invoice_download_by'     => (int)$user_id,
        'pbsbi_branch_annx_invoice_download_key'    => $batch_key,
    ];
    $this->db->where_in('id', $applicantIds)->update('mst_user', $data);
    return ($this->db->affected_rows() > 0);
}


 
 
}


?>