<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

// Function to capitalize the first letter of each word in a string
if (!function_exists('capitalize_first_letter_of_each_word')) {
    function capitalize_first_letter_of_each_word($input_string) {
        // Split the input string into words
        $words = explode(' ', $input_string);

        // Initialize an empty array to store capitalized words
        $capitalized_words = [];

        // Capitalize the first letter of each word
        foreach ($words as $word) {
            $capitalized_words[] = ucfirst(strtolower($word)); // Ensure each word is lowercase before capitalizing first letter
        }

        // Combine the words back into a single string
        $capitalized_string = implode(' ', $capitalized_words);

        return $capitalized_string;
    }
}

function capitalize_first_letter_of_each_word2($string) {
    $words = explode(' ', strtolower($string));
    $words = array_map('ucwords', $words);

    $result = [];
    $line = '';
    foreach ($words as $index => $word) {
        if (($index + 1) % 3 == 0) {
            $line .= $word . ' <br>';
            $result[] = $line;
            $line = '';
        } else {
            $line .= $word . ' ';
        }
    }
    $result[] = $line;
    return implode('', $result);
}


function capitalize_first_three_words($string) {
    $words = explode(' ', $string);
    $first_three_words = array_slice($words, 0, 3);
    $capitalized_words = array_map('ucfirst', $first_three_words);
    return implode(' ', $capitalized_words);
}

function capitalize_first_five_words($string) {
    $words = explode(' ', $string);
    $first_three_words = array_slice($words, 0, 5);
    $capitalized_words = array_map('ucfirst', $first_three_words);
    return implode(' ', $capitalized_words);
}
?>
