<?php


class Partner_paid_invoices extends CI_Controller {
  

    public function __construct() {

        parent::__construct(); 
        
        $db_group = $this->session->userdata('db_group') ?? 'default';
        $this->db = $this->load->database($db_group, TRUE);
        $this->load->library('user_agent');
        $this->load->library('form_validation');
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('common_model', 'ccm');
        $this->load->model('Partner_paid_model');
        
        // Check if user is logged in
            if (!isset($_SESSION['staff_id']) || !isset($_SESSION['staff_type'])) {
                redirect('admin_login');
            } else {
                 $this->admin_profile = $this->db->where('staff_id', $_SESSION['staff_id'])->get('mst_staff')->row();
                
                // Fetch ROLE wise menu permissions for the logged-in user
                    $role['menu_assign'] = $this->admin_profile->menu_assign;
                    $role['mainrole_id'] = $this->admin_profile->role_id;
                    $this->menu_permission = $this->ccm->get_permissions_by_user($_SESSION['staff_id'],$role);
            }
              //print_r($_SESSION);

    }


  public function manage_partner_paid_invoices() {
  
    $data['current_page'] = 'manage_partner_paid_invoices';

    $data['title'] = 'List Invoices';

    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
    $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();

    $data['viewfile'] = "admin/manage_invoice/manage_partner_paid_invoices";
    $this->load->view('admin/layout', $data);

}

public function fetch_invoice_data_paid_partner() {
    
    $staffType = $this->session->userdata('staff_type');
    $disabled = $staffType == 1 ? 'disabled' : '';
    

    // Get parameters for server-side processing
    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $branch_id = $this->input->post('branch');
    $conn_id = $this->input->post('connector');
    
    $state_id = $this->input->post('state_id');
    $city_id = $this->input->post('city_id');
    $disb_month_year = $this->input->post('month');
    
    $hlc_paid_status = $this->input->post('hlc_status');
     $payment_month_hlc = $this->input->post('payment_month_hlc');
   
    $limit = $this->input->post('length');
    $offset = $this->input->post('start');
    $search = $this->input->post('search')['value'];

    // Fetch data
    $invoices = $this->Partner_paid_model->get_invoice_data($start_date, $end_date, $conn_id, $branch_id, $limit, $offset, $city_id, $disb_month_year, $hlc_paid_status,$payment_month_hlc, $search);

    // Get total records
    $totalRecords = $this->Partner_paid_model->count_all_invoices($start_date, $end_date, $conn_id, $branch_id, $city_id, $disb_month_year,$hlc_paid_status, $payment_month_hlc, $search);
    
    // Prepare response
    $data = array();
    $sr_no = $offset + 1;
    foreach ($invoices as $invoice) {
        $invoiceNumber = $invoice['inv_batchno'];

        // Fetch additional data
        $applicant_log = $this->db->select('invoices.inv_batchno, mst_user.user_name, mst_user.id, mst_user.login_code')
            ->from('invoices')
            ->join('mst_user', 'invoices.user_id = mst_user.id')
            ->where(['inv_batchno' => $invoiceNumber])
            ->get()
            ->result_array();
        
            $paid_log = $this->db->select('*')->from('invoice_log')->where(['invoice_batchno' => $invoiceNumber])->order_by('payment_date', 'DESC')->get()->result_array();
      
            $invoice_items = $this->db->select('*')->from('invoices')->where(['inv_batchno' => $invoiceNumber])->get()->result_array();
    
            // Calculate net pay amount
            $totalCommisionAmt = 0;
            foreach ($invoice_items as $item) {
                $user_data = $this->db->select("*")->from('mst_user')->where(['id' => $item['user_id']])->get()->row();
                $totalCommission = calculateTotalCommission1($this->db, $user_data, $user_data->part_payout, $item['loan_type_id'],$invoiceNumber);
                 if ($user_data->loan_type_id == 4 && $user_data->sanction_amt >= 100000 && $user_data->sanction_amt < 1000000) {
                      $totalCommission = 2000;
                    } 
                $totalCommisionAmt += $totalCommission;
            }
    
            $hlc_data = $this->db->select('*')->from('mst_staff')->where(['staff_id' => $invoice['connector_id']])->get()->row();
             $created_by = $this->db->select('*')->where(['staff_id' => $invoice['created_by']])->from('mst_staff')->get()->row();
            $gstPercentage = empty($hlc_data->gst_no) ? 0 : 18; 
            $gst = $gstPercentage / 100 * $totalCommisionAmt;
            $netPayamt = $totalCommisionAmt;
            
            $invoiceTimestamp = strtotime($invoice['invoice_date']);
            // Define the threshold date (1st October 2024)
            $thresholdDate = strtotime('2024-10-01');
            // Check if the invoice date is on or after 1st October 2024
            if ($invoiceTimestamp >= $thresholdDate) {
                // Apply 2% TDS
                $tdsPer = 2;
                $tds = $netPayamt * 2 / 100;
            } else {
                // Apply 5% TDS
                $tdsPer = 5;
                $tds = $netPayamt * 5 / 100;
            }

           
            $grossTotal = $netPayamt + $gst;
            $netTotal = $grossTotal - $tds;
    
            // Calculate total paid amount and balance
            $totalpayamt = 0;
            foreach ($paid_log as $val) {
                $totalpayamt += $val['pay_amt'];
            }
            $tot_paid_amt = $totalpayamt;
            $rmain_bal = $netTotal - $tot_paid_amt;

      

        // Payment status
        $payment = $this->db->select("*")->where(['invoice_batchno' => $invoiceNumber, 'invoice_type' => 'inv_hlc'])->from('invoice_log')->order_by('add_date', 'DESC')->get()->row();
        $statusP = isset($payment) && isset($payment->status) ? $payment->status : "unpaid";

        // Define the badge color based on payment status
        if ($statusP == "unpaid") {
            $badge_class = "badge bg-danger";
        } elseif ($statusP == "paid") {
            $badge_class = "badge bg-success";
        } elseif ($statusP == "excess paid") {
            $badge_class = "badge bg-warning";
        } elseif ($statusP == "partly paid") {
            $badge_class = "badge bg-info";
        }

        $applicant_names = '';
        foreach ($applicant_log as $sr => $val) {
            $link = ($val['login_code'] === 'PaisaBazaar') 
                ? base_url('admin/pb_user_form/' . $val['id']) 
                : base_url('admin/applicant_form/' . $val['id']);
            
            $applicant_names .= ($sr + 1) . ') <a href="' . $link . '" target="_blank">' . $val['user_name'] . '</a><br>';
        }
        
        
        $allowed_staff_ids = [14, 13, 538, 889];
        $session_staff_id = $this->session->userdata('staff_id');
        
        $invoice_date_html = '
            <span class="editable-invoice-date" 
                  data-invoice="' . $invoice['inv_batchno'] . '" 
                  data-current-date="' . $invoice['invoice_date'] . '">
                ' . date('d.m.Y', strtotime($invoice['invoice_date'])) . '
            </span>';
        
        if (in_array($session_staff_id, $allowed_staff_ids)) {
            $invoice_date_html .= '
                <i class="bi bi-pencil-square edit-invoice-date-btn" 
                   style="cursor: pointer; margin-left: 6px;" 
                   title="Edit Invoice Date"
                   data-invoice="' . $invoice['inv_batchno'] . '" 
                   data-current-date="' . $invoice['invoice_date'] . '" 
                   data-bs-toggle="modal" 
                   data-bs-target="#editInvoiceDateModal">
                </i>';
        }

         $invoice_num_html = '<a href="'.base_url("Invoice_pdf_hlc/generatePDF/{$invoice['inv_batchno']}").'" target="_BLANK">'.$invoice['invoice_number'].'</a>';
        
         if (in_array($session_staff_id, $allowed_staff_ids = [14])) {
            $invoice_num_html .= '
                <i class="bi bi-pencil-square edit-invoice-num-btn" 
                   style="cursor: pointer; margin-left: 6px;" 
                   title="Edit Invoice Number"
                   data-invoice="' . $invoice['inv_batchno'] . '" 
                   data-current-num="' . $invoice['invoice_number'] . '" 
                   data-bs-toggle="modal" 
                   data-bs-target="#editInvoiceNumModal">
                </i>';
        }


        $data[] = array(
            "sr_no" => $sr_no++,
            "hlc_name" => capitalize_first_three_words($invoice['staff_fullname']),
            "city" => $invoice['hlc_city_name'],
            "applicant" => $applicant_names,
            "inv_number" => $invoice_num_html,
            "net_pay_amt" => formatIndianNumber($netTotal),
            "paid_amt" => formatIndianNumber($tot_paid_amt),
            "tds" => formatIndianNumber($tds),
            "balance" => number_format($rmain_bal, 2),
             "invoice_date" => $invoice_date_html,
            "payment_log" => $this->format_payment_log_hlc(json_encode($paid_log), $invoice['inv_batchno']),
            "created_date" => date('d.m.Y', strtotime($invoice['add_date'])),
            "payment_status" => "<span class='$badge_class'>$statusP</span>",
            
            "created_by" => $created_by->staff_fullname,
            "edit" => $this->generate_edit_buttons_hlc($invoice['inv_batchno'], $netTotal, $rmain_bal, $invoice['invoice_number'])
        );
    }

    $response = array(
        "draw" => intval($this->input->post('draw')),
        "recordsTotal" => $totalRecords,
        "recordsFiltered" => $totalRecords,
        "data" => $data
    );

    echo json_encode($response);
}

private function format_payment_log_hlc($payment_log, $invoice_batchno) {
    $log_entries = json_decode($payment_log, true); // Decode JSON into an array
    if (empty($log_entries)) {
        return "No payment logs available.";
    }

    $formatted_log = '';
    foreach ($log_entries as $entry) {
        // Ensure values are not null
        $payment_date = !empty($entry['payment_date']) ? $entry['payment_date'] : '';
        $pay_amt = !empty($entry['pay_amt']) ? $entry['pay_amt'] : '';
        $bank_details = !empty($entry['bank_details']) ? $entry['bank_details'] : '';
        $remark = !empty($entry['remark']) ? $entry['remark'] : '';
        $payment_id = !empty($entry['id']) ? $entry['id'] : '';

        $formatted_log .= 'Pay Date: ' . date('d.m.Y', strtotime($payment_date)) . '<br>';
        $formatted_log .= 'Pay Amt: ' . $pay_amt . '<br>';
        $formatted_log .= 'Ref No/Cheq No: ' . $bank_details . '<br>';
        $formatted_log .= 'Remark: ' . $remark . '<br>';

        // Show the Edit button only for staff_id = 14
        if ($this->session->userdata('staff_id') == 14 || $this->session->userdata('staff_id') == 13) {
            $formatted_log .= '<a href="javascript:void(0);" 
                class="text-primary edit-payment-log" 
                data-invoice="' . htmlspecialchars($invoice_batchno, ENT_QUOTES, 'UTF-8') . '" 
                data-invoice_no_id="' . htmlspecialchars($payment_id, ENT_QUOTES, 'UTF-8') . '" 
                data-payment_date="' . htmlspecialchars($payment_date, ENT_QUOTES, 'UTF-8') . '" 
                data-pay_amt="' . htmlspecialchars($pay_amt, ENT_QUOTES, 'UTF-8') . '" 
                data-bank_details="' . htmlspecialchars($bank_details, ENT_QUOTES, 'UTF-8') . '" 
                data-remark="' . htmlspecialchars($remark, ENT_QUOTES, 'UTF-8') . '" 
                data-bs-toggle="modal" 
                data-bs-target="#editPaymentModal"
                title="Edit">
                <i class="bi bi-pencil-square"></i>
            </a>';
        }

        $formatted_log .= '<br><br>'; // Add space for readability
    }

    return $formatted_log;
}


private function format_payment_log_hlc_pay_date($payment_log) {
    $log_entries = json_decode($payment_log, true); // Assuming the log is stored as a JSON-encoded string
    if (empty($log_entries)) {
        return "";
    }

    $formatted_log = '';
    foreach ($log_entries as $entry) {
        $formatted_log .= 'Pay Date: ' . date('d.m.Y', strtotime($entry['payment_date'])) . '<br>';
    }

    return $formatted_log;
}

private function generate_edit_buttons_hlc($invoiceNumber, $netTotal, $rmain_bal, $invoiceNumberLabel) {
    $edit_buttons = "<div class='d-flex align-items-center gap-3 action-buttons'>";
    /*if ($_SESSION['staff_id'] == 14 || $_SESSION['staff_id'] == 13 || $_SESSION['staff_id'] == 1 || $_SESSION['staff_id'] == 538 || $_SESSION['staff_id'] == 889) {
        $edit_buttons .= "<a href='javascript:;' class='text-primary edit-status' data-bs-toggle='tooltip' data-bs-placement='bottom' title='Payment Status' aria-label='Views' onclick='openInvoiceModal(\"$invoiceNumber\",\"$netTotal\",\"$rmain_bal\",\"$invoiceNumberLabel\")'>
        <img src='".base_url()."assets/site_img/payment.png' height='17' width='17'>
        </a>";
    }
    
    if ($_SESSION['staff_id'] == 14 || $_SESSION['staff_id'] == 13) {
        $edit_buttons .= "<a href='javascript:;' class='text-primary' data-bs-toggle='tooltip' data-bs-placement='bottom' title='Delete Payment' aria-label='Views' onclick='DeletePaymentLog(\"$invoiceNumber\")'>
        <img src='".base_url()."assets/site_img/payment_delete.png' height='18' width='18'>
        </a>";
    }*/
    
    $edit_buttons .= "<a href='".base_url("Invoice_pdf_hlc/generatePDF/$invoiceNumber")."' target='_BLANK' class='text-danger' data-bs-toggle='tooltip' data-bs-placement='bottom' title='View Invoice' aria-label='Views'>
    <i class='bi bi-file-earmark-pdf-fill'></i>
    </a>";
    if ($this->admin_profile->is_right_delete == 'yes') {
        $edit_buttons .= "<a href='javascript:;' class='text-danger delete' data-bs-toggle='tooltip' data-bs-placement='bottom' title='Delete Invoice' aria-label='Delete' data-id='$invoiceNumber' action='delete_invoice_hlc'>
        <i class='bi bi-trash-fill'></i>
        </a>";
    }
    $edit_buttons .= "</div>";
    return $edit_buttons;
}

  



}



?>